/*
 * Decompiled with CFR 0.152.
 */
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;

public class DisplayTest {
    public void executeTest() throws LWJGLException {
        this.currentTest();
        this.queryModesTest();
        this.setDisplayModeTest();
        this.setDisplayConfigurationTest();
    }

    private void currentTest() {
        System.out.println("==== Test Current ====");
        System.out.println("Info about current:");
        System.out.println("Graphics card: " + Display.getAdapter() + ", version: " + Display.getVersion());
        System.out.println("Resolution: " + Display.getDisplayMode().getWidth() + "x" + Display.getDisplayMode().getHeight() + "x" + Display.getDisplayMode().getBitsPerPixel() + "@" + Display.getDisplayMode().getFrequency() + "Hz");
        System.out.println("---- Test Current ----");
    }

    private void queryModesTest() throws LWJGLException {
        DisplayMode[] modes = null;
        System.out.println("==== Test query ====");
        System.out.println("Retrieving available displaymodes");
        modes = Display.getAvailableDisplayModes();
        if (modes == null) {
            System.out.println("FATAL: unable to find any modes!");
            System.exit(-1);
        }
        System.out.println("Found " + modes.length + " modes");
        System.out.println("The first 5 are:");
        int i = 0;
        while (i < modes.length) {
            System.out.println(modes[i]);
            if (i == 5) break;
            ++i;
        }
        System.out.println("---- Test query ----");
    }

    private void setDisplayModeTest() throws LWJGLException {
        DisplayMode mode = null;
        DisplayMode[] modes = null;
        System.out.println("==== Test setDisplayMode ====");
        System.out.println("Retrieving available displaymodes");
        modes = Display.getAvailableDisplayModes();
        if (modes == null) {
            System.out.println("FATAL: unable to find any modes!");
            System.exit(-1);
        }
        System.out.print("Looking for 640x480...");
        DisplayMode[] displayModeArray = modes;
        int n = modes.length;
        int n2 = 0;
        while (n2 < n) {
            DisplayMode mode1 = displayModeArray[n2];
            if (mode1.getWidth() == 640 && mode1.getHeight() == 480) {
                mode = mode1;
                System.out.println("found!");
                break;
            }
            ++n2;
        }
        if (mode == null) {
            System.out.println("error\nFATAL: Unable to find basic mode.");
            System.exit(-1);
        }
        System.out.print("Changing to mode...");
        try {
            Display.setDisplayMode(mode);
            Display.setFullscreen((boolean)true);
            Display.create();
        }
        catch (Exception e) {
            System.out.println("error\nFATAL: Error setting mode");
            System.exit(-1);
        }
        System.out.println("done");
        System.out.println("Resolution: " + Display.getDisplayMode().getWidth() + "x" + Display.getDisplayMode().getHeight() + "x" + Display.getDisplayMode().getBitsPerPixel() + "@" + Display.getDisplayMode().getFrequency() + "Hz");
        this.pause(5000L);
        System.out.print("Resetting mode...");
        try {
            Display.setFullscreen((boolean)false);
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
        System.out.println("done");
        System.out.println("---- Test setDisplayMode ----");
    }

    private void setDisplayConfigurationTest() {
        System.out.println("==== Test setDisplayConfigurationTest ====");
        System.out.println("Testing normal setting");
        this.changeConfig(1.0f, 0.0f, 1.0f);
        System.out.println("Testing gamma settings");
        this.changeConfig(5.0f, 0.0f, 1.0f);
        this.changeConfig(0.5f, 0.0f, 1.0f);
        System.out.println("Testing brightness settings");
        this.changeConfig(1.0f, -1.0f, 1.0f);
        this.changeConfig(1.0f, -0.5f, 1.0f);
        this.changeConfig(1.0f, 0.5f, 1.0f);
        this.changeConfig(1.0f, 1.0f, 1.0f);
        System.out.println("Testing contrast settings");
        this.changeConfig(1.0f, 0.0f, 0.0f);
        this.changeConfig(1.0f, 0.0f, 0.5f);
        this.changeConfig(1.0f, 0.0f, 10000.0f);
        System.out.print("resetting...");
        try {
            Display.setFullscreen((boolean)false);
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
        System.out.println("done");
        System.out.println("---- Test setDisplayConfigurationTest ----");
    }

    private void changeConfig(float gamma, float brightness, float contrast) {
        try {
            Display.setDisplayConfiguration((float)gamma, (float)brightness, (float)contrast);
            System.out.println("Configuration changed, gamma = " + gamma + " brightness = " + brightness + " contrast = " + contrast);
        }
        catch (Exception e) {
            System.out.println("Failed on: gamma = " + gamma + " brightness = " + brightness + " contrast = " + contrast);
        }
        this.pause(3000L);
    }

    private void pause(long time) {
        int SLEEP_DELAY = 100;
        int i = 0;
        while ((long)i < time) {
            try {
                Display.processMessages();
                Thread.sleep(SLEEP_DELAY);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            i += SLEEP_DELAY;
        }
    }

    public static void main(String[] args) throws LWJGLException {
        new DisplayTest().executeTest();
        System.exit(0);
    }
}

