/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.openal.AL;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;

public class IconGeneratorTest {
    double m_double = 0.0;
    BigDecimal m_BigDecimal = new BigDecimal(0.0);

    public void start() {
        this.initGL(800, 600);
        this.init();
        while (true) {
            this.update();
            GL11.glClear((int)16384);
            this.render();
            Display.update();
            Display.sync((int)100);
            if (!Display.isCloseRequested()) continue;
            Display.destroy();
            AL.destroy();
            System.exit(0);
        }
    }

    public static ByteBuffer[] loadIcon(String filepath) {
        BufferedImage image = null;
        try {
            image = ImageIO.read(new File(filepath));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ByteBuffer[] buffers = new ByteBuffer[]{IconGeneratorTest.loadIconInstance(image, 128), IconGeneratorTest.loadIconInstance(image, 32), IconGeneratorTest.loadIconInstance(image, 16)};
        return buffers;
    }

    private static ByteBuffer loadIconInstance(BufferedImage image, int dimension) {
        double r2;
        BufferedImage scaledIcon = new BufferedImage(dimension, dimension, 2);
        Graphics2D g = scaledIcon.createGraphics();
        double ratio = 1.0;
        ratio = image.getWidth() > scaledIcon.getWidth() ? (double)scaledIcon.getWidth() / (double)image.getWidth() : (double)(scaledIcon.getWidth() / image.getWidth());
        if (image.getHeight() > scaledIcon.getHeight()) {
            r2 = (double)scaledIcon.getHeight() / (double)image.getHeight();
            if (r2 < ratio) {
                ratio = r2;
            }
        } else {
            r2 = scaledIcon.getHeight() / image.getHeight();
            if (r2 < ratio) {
                ratio = r2;
            }
        }
        double width = (double)image.getWidth() * ratio;
        double height = (double)image.getHeight() * ratio;
        g.drawImage(image, (int)(((double)scaledIcon.getWidth() - width) / 2.0), (int)(((double)scaledIcon.getHeight() - height) / 2.0), (int)width, (int)height, null);
        g.dispose();
        byte[] imageBuffer = new byte[dimension * dimension * 4];
        int counter = 0;
        int i = 0;
        while (i < dimension) {
            int j = 0;
            while (j < dimension) {
                int colorSpace = scaledIcon.getRGB(j, i);
                imageBuffer[counter + 0] = (byte)(colorSpace << 8 >> 24);
                imageBuffer[counter + 1] = (byte)(colorSpace << 16 >> 24);
                imageBuffer[counter + 2] = (byte)(colorSpace << 24 >> 24);
                imageBuffer[counter + 3] = (byte)(colorSpace >> 24);
                counter += 4;
                ++j;
            }
            ++i;
        }
        return ByteBuffer.wrap(imageBuffer);
    }

    private void initGL(int width, int height) {
        ByteBuffer[] bb = null;
        bb = IconGeneratorTest.loadIcon("C:/Data/TEST/OST-BTmavatar16.png");
        OutputStreamWriter out = null;
        try {
            out = new OutputStreamWriter((OutputStream)new FileOutputStream("C:/Data/TEST/OST-BTmavatar16.txt"), "UTF-8");
            out.write("static byte [][] iconArray = new byte[][]\n");
            out.write("{");
            int i = 0;
            while (i < 3) {
                byte[] array = bb[i].array();
                out.write("\t{ ");
                int len = array.length;
                int a = 0;
                while (a < len) {
                    out.write(Byte.toString(array[a]));
                    if (a < len - 1) {
                        out.write(", ");
                    }
                    ++a;
                }
                out.write(" },\n");
                ++i;
            }
            out.write("};");
            ((Writer)out).close();
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            if (bb != null) {
                Display.setIcon((ByteBuffer[])bb);
            }
            Display.setDisplayMode((DisplayMode)new DisplayMode(width, height));
            Display.create();
            Display.setVSyncEnabled((boolean)true);
        }
        catch (LWJGLException e) {
            e.printStackTrace();
            System.exit(0);
        }
        GL11.glEnable((int)3553);
        GL11.glShadeModel((int)7425);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)2896);
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glClearDepth((double)1.0);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glViewport((int)0, (int)0, (int)width, (int)height);
        GL11.glMatrixMode((int)5888);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)width, (double)height, (double)0.0, (double)1.0, (double)-1.0);
        GL11.glMatrixMode((int)5888);
    }

    public void init() {
    }

    public void update() {
        while (Keyboard.next()) {
            if (!Keyboard.getEventKeyState()) continue;
            if (Keyboard.getEventKey() == 200) {
                this.m_double += 0.1;
                this.m_BigDecimal = this.m_BigDecimal.add(new BigDecimal(0.1));
                this._printVar();
            } else if (Keyboard.getEventKey() == 208) {
                this.m_double -= 0.1;
                this.m_BigDecimal = this.m_BigDecimal.add(new BigDecimal(-0.1));
                this._printVar();
            }
            Keyboard.getEventKey();
            if (Keyboard.getEventKey() != 203) {
                Keyboard.getEventKey();
            }
            Keyboard.getEventKey();
            Keyboard.getEventKey();
            Keyboard.getEventKey();
            Keyboard.getEventKey();
            Keyboard.getEventKey();
            Keyboard.getEventKey();
        }
    }

    private void _printVar() {
        System.out.println("double: " + Double.toString(this.m_double));
        System.out.println("BigDecimal: " + this.m_BigDecimal.floatValue());
    }

    public void render() {
    }

    public static void main(String[] argv) {
        IconGeneratorTest testExample = new IconGeneratorTest();
        testExample.start();
    }
}

