/*
 * Decompiled with CFR 0.152.
 */
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.AppGameContainer;
import org.newdawn.slick.BasicGame;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.opengl.pbuffer.GraphicsFactory;

public class ImageGraphicsTest
extends BasicGame {
    private Image target;
    private Image cut;
    private Graphics gTarget;
    private float ang;
    private String using = "none";
    static final int frameWidth = 40;
    static final int frameHeight = 30;

    public ImageGraphicsTest() {
        super("Image Graphics Test");
    }

    @Override
    public void init(GameContainer container) throws SlickException {
        this.target = new Image(400, 300);
        this.cut = new Image(100, 100);
        this.gTarget = this.target.getGraphics();
        if (GraphicsFactory.usingFBO()) {
            this.using = "FBO (Frame Buffer Objects)";
        } else if (GraphicsFactory.usingPBuffer()) {
            this.using = "Pbuffer (Pixel Buffers)";
        }
    }

    @Override
    public void render(GameContainer container, Graphics g) throws SlickException {
        this.gTarget.clear();
        GL11.glDisable((int)3553);
        GL11.glBegin((int)7);
        GL11.glColor3f((float)1.0f, (float)0.0f, (float)1.0f);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)10.0f, (float)10.0f);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex2f((float)40.0f, (float)10.0f);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex2f((float)40.0f, (float)30.0f);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex2f((float)10.0f, (float)30.0f);
        GL11.glEnd();
        this.gTarget.flush();
        g.setColor(Color.red);
        g.fillRect(250.0f, 50.0f, 200.0f, 200.0f);
        this.target.draw(300.0f, 100.0f);
        this.target.draw(300.0f, 410.0f, 200.0f, 150.0f);
        this.target.draw(505.0f, 410.0f, 100.0f, 75.0f);
        g.setColor(Color.white);
        g.setColor(Color.green);
        g.drawRect(300.0f, 100.0f, this.target.getWidth(), this.target.getHeight());
        g.drawRect(300.0f, 410.0f, this.target.getWidth() / 2, this.target.getHeight() / 2);
        g.drawRect(505.0f, 410.0f, this.target.getWidth() / 4, this.target.getHeight() / 4);
        g.setColor(Color.white);
        g.drawString("Using: " + this.using, 10.0f, 580.0f);
        g.setColor(Color.red);
        g.fillRect(10.0f, 120.0f, 200.0f, 5.0f);
        int xp = (int)(60.0 + Math.sin(this.ang / 60.0f) * 50.0);
        g.copyArea(this.cut, xp, 50);
        this.cut.draw(30.0f, 250.0f);
        g.setColor(Color.white);
        g.drawRect(30.0f, 250.0f, this.cut.getWidth(), this.cut.getHeight());
        g.setColor(Color.gray);
        g.drawRect(xp, 50.0f, this.cut.getWidth(), this.cut.getHeight());
        g.setColor(Color.blue);
    }

    @Override
    public void update(GameContainer container, int delta) {
        this.ang += (float)delta * 0.1f;
    }

    public static void main(String[] argv) {
        try {
            GraphicsFactory.setUseFBO(true);
            AppGameContainer container = new AppGameContainer(new ImageGraphicsTest());
            container.setDisplayMode(800, 600, false);
            container.start();
        }
        catch (SlickException e) {
            e.printStackTrace();
        }
    }
}

