/*
 * Decompiled with CFR 0.152.
 */
package Microsoft.Xna.Framework.Audio;

import Microsoft.Xna.Framework.Audio.AudioCategory;
import Microsoft.Xna.Framework.Audio.SoundBank;
import Microsoft.Xna.Framework.Audio.Variable;
import Microsoft.Xna.Framework.Audio.WaveBank;
import Microsoft.Xna.Framework.Content.ContentManager;
import Microsoft.Xna.Framework.Game;
import java.util.ArrayList;
import java.util.HashMap;
import org.newdawn.slick.openal.SoundStore;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import precompiler.MACRO;

public class AudioEngine {
    protected static final long SleepTime = 16L;
    Thread m_streamTickerThread = null;
    Runnable m_runnable = null;
    boolean m_bLoop = true;
    public static float GlobalPitchDebug = 1.0f;
    WaveBank m_waveBank = null;
    SoundBank m_soundBank = null;
    String m_settingFilename;
    String m_xmlSettingFilename;
    HashMap<String, AudioCategory> m_audioCatagoriesByName = new HashMap();
    ArrayList<AudioCategory> m_audioCatagoriesById = new ArrayList();
    HashMap<String, Variable> m_variableByName = new HashMap();
    ArrayList<Variable> m_variableById = new ArrayList();

    protected WaveBank waveBank() {
        return this.m_waveBank;
    }

    protected SoundBank soundBank() {
        return this.m_soundBank;
    }

    public AudioEngine(String settingsFile) {
        this.m_settingFilename = settingsFile;
        this.m_xmlSettingFilename = settingsFile.replace(String.valueOf(ContentManager.RootDirectory()) + "/", "");
        this._init();
        Game.Instance().addAudioEngine(this);
        if (MACRO.USE_THREAD_FOR_SOUND_UPDATE) {
            this.m_runnable = new Runnable(){

                @Override
                public void run() {
                    while (AudioEngine.this.m_bLoop) {
                        try {
                            SoundStore.get().poll(0);
                            Thread.sleep(16L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
            };
            this.m_streamTickerThread = new Thread(this.m_runnable);
            this.m_streamTickerThread.start();
        }
    }

    protected void _init() {
        try {
            Document xmlDoc = Game.Instance().Content().LoadXDocument(this.m_xmlSettingFilename, false);
            if (xmlDoc != null) {
                Element elem = null;
                NodeList categoryNodeList = xmlDoc.getElementsByTagName("Category");
                int categoryId = 0;
                while (categoryId < categoryNodeList.getLength()) {
                    elem = (Element)categoryNodeList.item(categoryId);
                    AudioCategory audioCat = new AudioCategory(elem.getAttribute("name"));
                    this.m_audioCatagoriesByName.put(audioCat.Name(), audioCat);
                    this.m_audioCatagoriesById.add(audioCat);
                    ++categoryId;
                }
                NodeList variableNodeList = xmlDoc.getElementsByTagName("Variable");
                int variableId = 0;
                while (variableId < variableNodeList.getLength()) {
                    elem = (Element)variableNodeList.item(variableId);
                    Variable variable = new Variable(elem.getAttribute("name"), Float.parseFloat(elem.getAttribute("value")), Float.parseFloat(elem.getAttribute("min")), Float.parseFloat(elem.getAttribute("max")));
                    this.m_variableByName.put(variable.name(), variable);
                    this.m_variableById.add(variable);
                    ++variableId;
                }
                NodeList rpcNodeList = xmlDoc.getElementsByTagName("RPC");
                int rpcId = 0;
                while (rpcId < rpcNodeList.getLength()) {
                    elem = (Element)rpcNodeList.item(rpcId);
                    ++rpcId;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public AudioCategory GetCategory(String name) {
        return this.m_audioCatagoriesByName.get(name);
    }

    public void Deinit() {
        if (MACRO.USE_THREAD_FOR_SOUND_UPDATE && this.m_streamTickerThread != null) {
            try {
                this.m_bLoop = false;
                this.m_streamTickerThread.join(16L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.m_streamTickerThread = null;
        }
        SoundStore.get().deinit();
    }

    public void Update() {
        if (!MACRO.USE_THREAD_FOR_SOUND_UPDATE) {
            SoundStore.get().poll(0);
        }
    }

    protected void addSoundBank(SoundBank soundBank) {
        if (this.m_soundBank != null) {
            throw new AssertionError();
        }
        this.m_soundBank = soundBank;
    }

    protected void addWaveBank(WaveBank waveBank) {
        if (this.m_waveBank != null) {
            throw new AssertionError();
        }
        this.m_waveBank = waveBank;
    }
}

