/*
 * Decompiled with CFR 0.152.
 */
package Microsoft.Xna.Framework.Audio;

import Microsoft.Xna.Framework.MathHelper;

public class AudioUtil {
    public static float XactPitchToOalPitch(float _xactPicth) {
        return (float)Math.exp(5.8E-4 * (double)_xactPicth);
    }

    public static float XactVolumeToOalVolume(float _xactVolume) {
        if (_xactVolume < -1200.0f) {
            return MathHelper.Lerp(0.0f, 0.21f, (_xactVolume + 9600.0f) / 8400.0f);
        }
        if (_xactVolume >= -1200.0f && _xactVolume <= -500.0f) {
            return MathHelper.Lerp(0.21f, 0.5f, (_xactVolume + 1200.0f) / 700.0f);
        }
        if (_xactVolume >= -500.0f && _xactVolume <= 100.0f) {
            return MathHelper.Lerp(0.5f, 1.0f, (_xactVolume + 500.0f) / 600.0f);
        }
        return 1.0f;
    }
}

