/*
 * Decompiled with CFR 0.152.
 */
package Microsoft.Xna.Framework.Audio;

import Microsoft.Xna.Framework.Audio.AudioEmitter;
import Microsoft.Xna.Framework.Audio.AudioListener;
import Microsoft.Xna.Framework.Audio.AudioStopOptions;
import Microsoft.Xna.Framework.Audio.ParameterAffectedByRPC;
import Microsoft.Xna.Framework.Audio.Sound;
import java.util.HashMap;

public class Cue {
    protected String m_name;
    protected Sound m_sound;
    protected boolean m_instanciated = false;
    static final HashMap<String, ParameterAffectedByRPC> AffectedParameter = new HashMap<String, ParameterAffectedByRPC>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("MyVolume", ParameterAffectedByRPC.VolumeAffectedByRPC);
            this.put("MyPitch", ParameterAffectedByRPC.PitchAffectedByRPC);
            this.put("Pan", ParameterAffectedByRPC.PanAffectedByRPC);
        }
    };

    protected Cue(Cue cue) {
        this.m_name = cue.Name();
        this.m_sound = cue.duplicateSound();
        this.m_instanciated = true;
    }

    protected Cue(String _name, Sound _sound) {
        this.m_name = _name;
        this.m_sound = _sound;
        this.m_instanciated = false;
    }

    private Sound duplicateSound() {
        return this.m_sound.instanciate();
    }

    public boolean IsCreated() {
        return false;
    }

    public boolean IsDisposed() {
        return false;
    }

    public boolean IsPaused() {
        return false;
    }

    public boolean IsPlaying() {
        return this.m_sound.isPlaying();
    }

    public boolean IsPrepared() {
        return false;
    }

    public boolean IsPreparing() {
        return false;
    }

    public boolean IsStopped() {
        return false;
    }

    public boolean IsStopping() {
        return false;
    }

    public String Name() {
        return this.m_name;
    }

    public void Apply3D(AudioListener listener, AudioEmitter emitter) {
    }

    public void Dispose() {
    }

    public float GetVariable(String name) {
        return 0.0f;
    }

    public void Pause() {
    }

    public void Play() {
        this.m_sound.play();
    }

    public void Resume() {
    }

    public void SetVariable(String name, float value) {
        switch (AffectedParameter.get(name)) {
            case VolumeAffectedByRPC: {
                this.m_sound.changeVolume(value);
                break;
            }
            case PitchAffectedByRPC: {
                break;
            }
        }
    }

    public void Stop(AudioStopOptions options) {
        this.m_sound.stop();
    }
}

