/*
 * Decompiled with CFR 0.152.
 */
package Microsoft.Xna.Framework.Audio;

import Microsoft.Xna.Framework.Audio.AudioUtil;
import Microsoft.Xna.Framework.Audio.SoundBank;
import Microsoft.Xna.Framework.Audio.Track;

public class Sound {
    SoundBank m_soundBank;
    Track[] m_tracks = null;
    boolean m_bPlayingPredict = false;
    boolean m_bInstance = false;
    String m_name;
    boolean m_bLoop = false;
    float m_pitch;
    float m_volume = 1.0f;
    float m_volumeMultiplier = 1.0f;

    public SoundBank soundBank() {
        return this.m_soundBank;
    }

    protected void loop(boolean value) {
        this.m_bLoop = value;
    }

    protected void name(String value) {
        this.m_name = value;
    }

    protected void pitch(float value) {
        this.m_pitch = value;
    }

    protected void pitchFromXactCurve(float value) {
        this.m_pitch = AudioUtil.XactPitchToOalPitch(value);
    }

    protected void volume(float value) {
        this.m_volume = value * this.m_volumeMultiplier;
    }

    protected void volumeFromXactCurve(float value) {
        this.m_volume = this.m_volumeMultiplier = AudioUtil.XactVolumeToOalVolume(value);
    }

    public Sound(SoundBank _soundBank) {
        this.m_soundBank = _soundBank;
    }

    public Sound instanciate() {
        return null;
    }

    public boolean isPlaying() {
        if (this.m_bLoop) {
            return this.m_bPlayingPredict;
        }
        Track[] trackArray = this.m_tracks;
        int n = this.m_tracks.length;
        int n2 = 0;
        while (n2 < n) {
            Track track = trackArray[n2];
            if (track.idPlay() > -1 && track.isPlaying()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void play() {
        this.m_bPlayingPredict = true;
        int i = 0;
        while (i < this.m_tracks.length) {
            this.m_tracks[i].updateVariables();
            ++i;
        }
        Track[] trackArray = this.m_tracks;
        int n = this.m_tracks.length;
        int n2 = 0;
        while (n2 < n) {
            Track track = trackArray[n2];
            if (track.idPlay() > -1) {
                track.play(this.m_volume, this.m_bLoop);
            }
            ++n2;
        }
    }

    public void stop() {
        this.m_bPlayingPredict = false;
        Track[] trackArray = this.m_tracks;
        int n = this.m_tracks.length;
        int n2 = 0;
        while (n2 < n) {
            Track track = trackArray[n2];
            if (track.idPlay() > -1) {
                track.stop();
            }
            ++n2;
        }
    }

    protected void setTrackNum(int len) {
        this.m_tracks = new Track[len];
    }

    protected void setTrack(Track track, int slot) {
        this.m_tracks[slot] = track;
    }

    protected void changeVolume(float volume) {
        this.volume(volume);
        Track[] trackArray = this.m_tracks;
        int n = this.m_tracks.length;
        int n2 = 0;
        while (n2 < n) {
            Track track = trackArray[n2];
            if (track.idPlay() > -1) {
                track.changeVolume(this.m_volume);
            }
            ++n2;
        }
    }

    protected void changePitch(float pitch) {
        this.pitch(pitch);
        Track[] trackArray = this.m_tracks;
        int n = this.m_tracks.length;
        int n2 = 0;
        while (n2 < n) {
            Track track = trackArray[n2];
            if (track.idPlay() > -1) {
                track.changePitch(this.m_pitch);
            }
            ++n2;
        }
    }

    protected void changeLoop(boolean loop) {
        this.loop(loop);
        Track[] trackArray = this.m_tracks;
        int n = this.m_tracks.length;
        int n2 = 0;
        while (n2 < n) {
            Track track = trackArray[n2];
            if (track.idPlay() > -1) {
                track.changeLoop(loop);
            }
            ++n2;
        }
    }
}

