/*
 * Decompiled with CFR 0.152.
 */
package Microsoft.Xna.Framework.Audio;

import Microsoft.Xna.Framework.Audio.AudioEmitter;
import Microsoft.Xna.Framework.Audio.AudioEngine;
import Microsoft.Xna.Framework.Audio.AudioListener;
import Microsoft.Xna.Framework.Audio.Cue;
import Microsoft.Xna.Framework.Audio.Sound;
import Microsoft.Xna.Framework.Audio.Track;
import Microsoft.Xna.Framework.Content.ContentManager;
import Microsoft.Xna.Framework.Game;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SoundBank {
    AudioEngine m_audioEngine;
    String m_filename;
    String m_xmlFilename;
    Sound[] m_sounds;
    HashMap<String, Cue> m_Cues = new HashMap();

    protected AudioEngine audioEngine() {
        return this.m_audioEngine;
    }

    public SoundBank(AudioEngine audioEngine, String filename) {
        this.m_audioEngine = audioEngine;
        this.m_filename = filename;
        this.m_xmlFilename = this.m_filename.replace(String.valueOf(ContentManager.RootDirectory()) + "/", "");
        audioEngine.addSoundBank(this);
        this._init();
    }

    protected void _init() {
        Document xmlDoc = Game.Instance().Content().LoadXDocument(this.m_xmlFilename, false);
        if (xmlDoc != null) {
            Element elem = null;
            Element elemTrack = null;
            Element elemTrackEntry = null;
            NodeList soundsNodeList = xmlDoc.getElementsByTagName("Sound");
            this.m_sounds = new Sound[soundsNodeList.getLength()];
            int idSound = 0;
            while (idSound < this.m_sounds.length) {
                elem = (Element)soundsNodeList.item(idSound);
                Sound sound = new Sound(this);
                sound.name(elem.getAttribute("name"));
                sound.pitchFromXactCurve(Float.parseFloat(elem.getAttribute("pitch")));
                sound.volumeFromXactCurve(Float.parseFloat(elem.getAttribute("volume")));
                String var1 = elem.getAttribute("loop");
                if (var1 != null && var1.length() > 0) {
                    sound.loop(true);
                }
                NodeList trackNodeList = elem.getElementsByTagName("Track");
                sound.setTrackNum(trackNodeList.getLength());
                int idTrack = 0;
                while (idTrack < trackNodeList.getLength()) {
                    elemTrack = (Element)trackNodeList.item(idTrack);
                    Track track = new Track(sound);
                    sound.setTrack(track, idTrack);
                    var1 = elemTrack.getAttribute("varType");
                    if (var1 != null && var1.length() > 0) {
                        track.setVarType(var1);
                    }
                    var1 = elemTrack.getAttribute("pitchVarMax");
                    String var2 = elemTrack.getAttribute("pitchVarMin");
                    if (var1 != null && var1.length() > 0 && var2 != null && var2.length() > 0) {
                        track.setVarPitchMinMax(var2, var1);
                    }
                    if ((var1 = elemTrack.getAttribute("loop")) != null && var1.length() > 0) {
                        track.loop(true);
                    }
                    NodeList trackEntryNodeList = elemTrack.getElementsByTagName("Entry");
                    track.setTrackLen(trackEntryNodeList.getLength());
                    int idTrackEntry = 0;
                    while (idTrackEntry < trackEntryNodeList.getLength()) {
                        elemTrackEntry = (Element)trackEntryNodeList.item(idTrackEntry);
                        track.setTrackSoundId(idTrackEntry, Integer.parseInt(elemTrackEntry.getAttribute("idSound")));
                        ++idTrackEntry;
                    }
                    ++idTrack;
                }
                this.m_sounds[idSound] = sound;
                ++idSound;
            }
            NodeList cueNodeList = xmlDoc.getElementsByTagName("Cue");
            int idCue = 0;
            while (idCue < cueNodeList.getLength()) {
                elem = (Element)cueNodeList.item(idCue);
                String name = elem.getAttribute("name");
                int soundId = Integer.parseInt(elem.getAttribute("soundId"));
                Cue cue = new Cue(name, this.m_sounds[soundId]);
                this.m_Cues.put(name, cue);
                ++idCue;
            }
        }
    }

    public void PlayCue(String embeddedSound) {
        this.GetCue(embeddedSound).Play();
    }

    public void PlayCue(String embeddedSound, AudioListener audioListener, AudioEmitter audioEmitter) {
        this.GetCue(embeddedSound).Play();
    }

    public Cue GetCue(String embeddedSound) {
        Cue refCue = this.m_Cues.get(embeddedSound);
        return refCue;
    }
}

