/*
 * Decompiled with CFR 0.152.
 */
package Microsoft.Xna.Framework.Audio;

import Microsoft.Xna.Framework.Audio.AudioUtil;
import Microsoft.Xna.Framework.Audio.Sound;
import Microsoft.Xna.Framework.Audio.VariationPlaylist;
import java.util.Random;
import org.newdawn.slick.openal.Audio;

public class Track {
    Sound m_ownerSound;
    static final int MaxRandom = 10;
    static Random m_RandomGenerator = new Random();
    VariationPlaylist m_variation = null;
    boolean m_pitchVar = false;
    float m_pitchVarMin = 1.0f;
    float m_pitchVarMax = 1.0f;
    float m_pitch = 1.0f;
    boolean m_bLoop = false;
    int m_idPlay = -1;
    int[] m_soundIds = null;
    Audio[] m_sounds = null;

    protected float pitch() {
        return this.m_pitch;
    }

    protected void loop(boolean value) {
        this.m_bLoop = value;
    }

    protected int idPlay() {
        if (this.m_idPlay < 0) {
            return -1;
        }
        return this.m_soundIds[this.m_idPlay];
    }

    protected void setTrackLen(int _len) {
        this.m_soundIds = new int[_len];
        this.m_sounds = new Audio[_len];
    }

    protected void setTrackSoundId(int _slot, int _id) {
        this.m_soundIds[_slot] = _id;
        this.m_sounds[_slot] = this.m_ownerSound.soundBank().audioEngine().waveBank().bankAudio(_id).duplicate();
    }

    protected Track(Sound owner) {
        this.m_ownerSound = owner;
    }

    protected boolean isPlaying() {
        return this.m_sounds[this.m_idPlay].isPlaying();
    }

    protected void play(float _volume, boolean _bLoop) {
        this.m_sounds[this.m_idPlay].playAsSoundEffect(this.pitch(), _volume, _bLoop && this.m_bLoop);
    }

    public void changeVolume(float _volume) {
        this.m_sounds[this.m_idPlay].changeVolume(_volume);
    }

    public void changePitch(float _pitch) {
        this.m_sounds[this.m_idPlay].changePitch(_pitch);
    }

    public void stop() {
        this.m_sounds[this.m_idPlay].stop();
    }

    public void changeLoop(boolean _loop) {
        this.m_sounds[this.m_idPlay].changeLoop(_loop);
    }

    protected void updateVariables() {
        if (this.m_variation != null) {
            switch (this.m_variation) {
                case Ordered: {
                    this.m_idPlay = (this.m_idPlay + 1) % this.m_soundIds.length;
                    break;
                }
                case OrderedFromRandom: {
                    this.m_idPlay = (this.m_idPlay + 1) % this.m_soundIds.length;
                    break;
                }
                case Random: {
                    this.m_idPlay = m_RandomGenerator.nextInt(this.m_soundIds.length);
                    break;
                }
                case RandomNoImmediateRepeats: {
                    int idPlay;
                    int count = 0;
                    while ((idPlay = m_RandomGenerator.nextInt(this.m_soundIds.length)) == this.m_idPlay && ++count != 10) {
                    }
                    this.m_idPlay = idPlay;
                    break;
                }
                case Shuffle: {
                    this.m_idPlay = m_RandomGenerator.nextInt(this.m_soundIds.length);
                }
            }
        } else {
            this.m_idPlay = 0;
        }
        if (this.m_pitchVar) {
            float t = m_RandomGenerator.nextFloat();
            this.m_pitch = (1.0f - t) * this.m_pitchVarMin + t * this.m_pitchVarMax;
        }
    }

    public void setVarType(String varType) {
        int var = Integer.parseInt(varType);
        this.m_variation = VariationPlaylist.values()[var];
    }

    public void setVarPitchMinMax(String min, String max) {
        this.m_pitchVarMin = AudioUtil.XactPitchToOalPitch(Float.parseFloat(min));
        this.m_pitchVarMax = AudioUtil.XactPitchToOalPitch(Float.parseFloat(max));
        this.m_pitchVar = true;
    }
}

