/*
 * Decompiled with CFR 0.152.
 */
package Microsoft.Xna.Framework.Audio;

import Microsoft.Xna.Framework.Audio.AudioEngine;
import Microsoft.Xna.Framework.Content.ContentManager;
import Microsoft.Xna.Framework.Game;
import java.util.HashMap;
import org.newdawn.slick.openal.Audio;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WaveBank {
    boolean m_bFilenameIsDir = true;
    String m_filenameOrPath;
    String m_xmlFilename;
    AudioEngine m_audioEngine;
    public static final int StreamSizeThreshold = 150;
    HashMap<String, Audio> m_bankByName;
    Audio[] m_bankById;

    protected Audio bankAudio(int id) {
        return this.m_bankById[id];
    }

    public WaveBank(AudioEngine audioEngine, String filename) {
        this.m_audioEngine = audioEngine;
        this.m_filenameOrPath = filename;
        if (this.m_bFilenameIsDir) {
            this.m_filenameOrPath = String.valueOf(this.m_filenameOrPath) + "/";
        }
        this.m_xmlFilename = this.m_filenameOrPath;
        this.m_xmlFilename = this.m_xmlFilename.replace(String.valueOf(ContentManager.RootDirectory()) + "/", "");
        this._init();
        audioEngine.addWaveBank(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void _init() {
        if (!this.m_bFilenameIsDir) throw new AssertionError();
        Document xmlDoc = Game.Instance().Content().LoadXDocument(String.valueOf(this.m_xmlFilename) + "BankIndex");
        if (xmlDoc == null) throw new AssertionError();
        NodeList entryNodeList = xmlDoc.getElementsByTagName("Entry");
        int entryNum = entryNodeList.getLength();
        this.m_bankByName = new HashMap(entryNum);
        this.m_bankById = new Audio[entryNum];
        ContentManager contentMgr = Game.Instance().Content();
        int id = 0;
        while (id < entryNum) {
            Element entryElem = (Element)entryNodeList.item(id);
            String oggId = entryElem.getAttribute("name");
            String oggFilename = String.valueOf(this.m_filenameOrPath) + oggId + ".ogg";
            int size = Integer.parseInt(entryElem.getAttribute("size"));
            try {
                Audio ogg = size > 150 ? contentMgr.LoadAudio(oggFilename, true) : contentMgr.LoadAudio(oggFilename, false);
                this.m_bankByName.put(oggId, ogg);
                this.m_bankById[id] = ogg;
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++id;
        }
    }
}

