/*
 * Decompiled with CFR 0.152.
 */
package Microsoft.Xna.Framework;

public class Color
implements Cloneable {
    public static final Color _Black = new Color(0, 0, 0, 255);
    public static final Color _White = new Color(255, 255, 255, 255);
    public static final Color _Gray = new Color(128, 128, 128, 255);
    public static final Color _YellowLigh = new Color(255, 255, 250, 255);
    public static final Color _Yellow = new Color(255, 255, 0, 255);
    public static final Color _Blue = new Color(0, 0, 255, 255);
    public static final Color _Beige = new Color(245, 245, 220, 255);
    public static final Color _LightPink = new Color(255, 182, 193, 255);
    public static final Color _Red = new Color(255, 0, 0, 255);
    public static final Color _DarkGray = new Color(169, 169, 169, 255);
    public static final Color _Green = new Color(0, 128, 0, 255);
    public static final Color _BlueViolet = new Color(138, 43, 226, 255);
    public static final Color _Pink = new Color(255, 192, 203, 255);
    public static final Color _DarkGreen = new Color(0, 100, 0, 255);
    public static final Color _DarkRed = new Color(139, 0, 0, 255);
    public static final Color _RoyalBlue = new Color(65, 105, 225, 255);
    public static final Color _YellowSub = new Color(255, 204, 0, 255);
    protected static float OneOver255 = 0.003921569f;
    public int R;
    public int G;
    public int B;
    public int A;

    public static final Color YellowLigh() {
        return _YellowLigh.clone();
    }

    public static final Color YellowSub() {
        return _YellowSub.clone();
    }

    public static final Color Black() {
        return _Black.clone();
    }

    public static final Color White() {
        return _White.clone();
    }

    public static final Color Gray() {
        return _Gray.clone();
    }

    public static final Color Yellow() {
        return _Yellow.clone();
    }

    public static final Color Blue() {
        return _Blue.clone();
    }

    public static final Color Beige() {
        return _Beige.clone();
    }

    public static final Color LightPink() {
        return _LightPink.clone();
    }

    public static final Color Red() {
        return _Red.clone();
    }

    public static final Color DarkGray() {
        return _DarkGray.clone();
    }

    public static final Color Green() {
        return _Green.clone();
    }

    public static final Color BlueViolet() {
        return _BlueViolet.clone();
    }

    public static final Color Pink() {
        return _Pink.clone();
    }

    public static final Color DarkGreen() {
        return _DarkGreen.clone();
    }

    public static final Color DarkRed() {
        return _DarkRed.clone();
    }

    public static final Color RoyalBlue() {
        return _RoyalBlue.clone();
    }

    public Color(int r, int g, int b, int a) {
        this.R = r;
        this.G = g;
        this.B = b;
        this.A = a;
    }

    public Color(int r, int g, int b) {
        this.R = r;
        this.G = g;
        this.B = b;
        this.A = 255;
    }

    public Color(float r, float g, float b) {
        this.R = (int)(r * 255.0f);
        this.G = (int)(g * 255.0f);
        this.B = (int)(b * 255.0f);
        this.A = 255;
    }

    public Color(float r, float g, float b, float a) {
        this.R = (int)(r * 255.0f);
        this.G = (int)(g * 255.0f);
        this.B = (int)(b * 255.0f);
        this.A = (int)(a * 255.0f);
    }

    public void change(float r, float g, float b) {
        this.R = (int)(r * 255.0f);
        this.G = (int)(g * 255.0f);
        this.B = (int)(b * 255.0f);
    }

    public void copy(Color other) {
        this.R = other.R;
        this.G = other.G;
        this.B = other.B;
        this.A = other.A;
    }

    public Color clone() {
        try {
            return (Color)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isSameColor(Color _other) {
        return this.R == _other.R && this.G == _other.G && this.B == _other.B && this.A == _other.A;
    }

    public void multiply(Color _other) {
        this.R = (int)((float)this.R * OneOver255 * (float)_other.R * OneOver255 * 255.0f);
        this.G = (int)((float)this.G * OneOver255 * (float)_other.G * OneOver255 * 255.0f);
        this.B = (int)((float)this.B * OneOver255 * (float)_other.B * OneOver255 * 255.0f);
        this.A = (int)((float)this.A * OneOver255 * (float)_other.A * OneOver255 * 255.0f);
    }
}

