/*
 * Decompiled with CFR 0.152.
 */
package Microsoft.Xna.Framework.Content;

import Microsoft.Xna.Framework.Audio.SoundEffect;
import Microsoft.Xna.Framework.Content.XDocument;
import Microsoft.Xna.Framework.Graphics.Effect;
import Microsoft.Xna.Framework.Graphics.GraphicsDevice;
import Microsoft.Xna.Framework.Graphics.SpriteFont;
import Microsoft.Xna.Framework.Graphics.Texture2D;
import SSS.API.GameAPIManager;
import SSS.Managers.FileManager;
import SSS.bigfile.BigFile;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.newdawn.slick.openal.Audio;
import org.newdawn.slick.openal.AudioLoader;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.opengl.TextureLoader;
import org.newdawn.slick.util.ResourceLoader;
import org.w3c.dom.Document;
import precompiler.MACRO;

public class ContentManager {
    protected static String RootDirectory = "Content";
    boolean m_textureDeferredLoading = false;
    Stack<String> m_deferredTextureAssetList = new Stack();
    BigFile m_bigFile = null;
    HashMap<String, Texture2D> m_textures = new HashMap(20);
    HashMap<String, Texture2D> m_userTextures = new HashMap(20);
    GraphicsDevice m_graphicDevice;

    public static String RootDirectory() {
        return RootDirectory;
    }

    public void RootDirectory(String value) {
        RootDirectory = value;
    }

    public ContentManager(GraphicsDevice gd) {
        this.m_graphicDevice = gd;
        if (MACRO.USE_BF) {
            this.m_bigFile = new BigFile("", MACRO.BF_NAME, MACRO.USE_BF_COMPRESSED);
            try {
                this.m_bigFile.load();
            }
            catch (Exception e) {
                e.printStackTrace();
                MACRO.USE_BF = false;
                this.m_bigFile = null;
            }
        }
    }

    public SpriteFont LoadSpriteFont(String assetName) {
        String filename = String.valueOf(RootDirectory) + "/" + assetName + ".ttf";
        if (MACRO.USE_BF) {
            ByteArrayInputStream bis = this.m_bigFile.getResourceStream(filename);
            SpriteFont res = new SpriteFont(filename, bis);
            try {
                bis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return res;
        }
        return new SpriteFont(filename, null);
    }

    public Audio LoadAudio(String filename, boolean streamed) {
        Audio ogg = null;
        try {
            if (streamed) {
                ogg = AudioLoader.getStreamingAudio("OGG", ResourceLoader.getResource(filename), null);
            } else if (MACRO.USE_BF) {
                ByteArrayInputStream bis = this.m_bigFile.getResourceStream(filename);
                ogg = AudioLoader.getAudio("OGG", bis);
            } else {
                ogg = AudioLoader.getAudio("OGG", ResourceLoader.getResourceAsStream(filename));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ogg;
    }

    public void DefferedTextureLoadingActivate() {
        this.m_textureDeferredLoading = true;
    }

    public boolean DefferedLoadingDone() {
        if (this.m_textureDeferredLoading) {
            if (this.m_deferredTextureAssetList.size() > 0) {
                String assetName = this.m_deferredTextureAssetList.pop();
                Texture2D tex2d = this.m_textures.get(assetName);
                Texture texture = null;
                try {
                    if (MACRO.USE_BF) {
                        ByteArrayInputStream bis = this.m_bigFile.getResourceStream(String.valueOf(RootDirectory) + "/" + assetName + ".png");
                        texture = TextureLoader.getTexture("PNG", bis);
                        bis.close();
                    } else {
                        texture = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream(String.valueOf(RootDirectory) + "/" + assetName + ".png"));
                    }
                    tex2d.setData(texture, assetName);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (this.m_deferredTextureAssetList.size() == 0) {
                this.m_textureDeferredLoading = false;
                return true;
            }
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Texture2D LoadTexture2D(String assetName) {
        Texture2D tex2d = null;
        if (this.m_textures.containsKey(assetName)) {
            tex2d = this.m_textures.get(assetName);
        } else {
            try {
                Texture texture;
                int height;
                int width;
                block24: {
                    String filename = String.valueOf(RootDirectory) + "/" + assetName + ".png";
                    width = 0;
                    height = 0;
                    texture = null;
                    if (this.m_textureDeferredLoading) {
                        ImageInputStream in = null;
                        if (MACRO.USE_BF) {
                            ByteArrayInputStream bis = this.m_bigFile.getResourceStream(filename);
                            in = ImageIO.createImageInputStream(bis);
                            bis.close();
                        } else {
                            in = ImageIO.createImageInputStream(ResourceLoader.getResourceAsStream(filename));
                        }
                        try {
                            Iterator<ImageReader> readers = ImageIO.getImageReaders(in);
                            if (!readers.hasNext()) break block24;
                            ImageReader reader = readers.next();
                            try {
                                reader.setInput(in);
                                width = reader.getWidth(0);
                                height = reader.getHeight(0);
                                break block24;
                            }
                            finally {
                                reader.dispose();
                            }
                        }
                        finally {
                            if (in != null) {
                                in.close();
                            }
                        }
                    }
                    if (MACRO.USE_BF) {
                        ByteArrayInputStream bis = this.m_bigFile.getResourceStream(filename);
                        if (bis == null) {
                            System.out.println("ERROR LOADING TEXTURE: " + filename);
                            if (this.m_textures.size() > 0) {
                                tex2d = this.m_textures.entrySet().iterator().next().getValue();
                                tex2d.increaseRefCount();
                                return tex2d;
                            }
                            texture = null;
                        } else {
                            texture = TextureLoader.getTexture("PNG", bis);
                            bis.close();
                        }
                    } else {
                        texture = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream(filename));
                    }
                    if (texture != null) {
                        width = texture.getImageWidth();
                        height = texture.getImageHeight();
                    } else {
                        width = 2;
                        height = 2;
                    }
                }
                tex2d = new Texture2D(this.m_graphicDevice, width, height);
                if (texture != null) {
                    tex2d.setData(texture, assetName);
                } else {
                    this.m_deferredTextureAssetList.push(assetName);
                }
                this.m_textures.put(assetName, tex2d);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        tex2d.increaseRefCount();
        return tex2d;
    }

    public Texture2D LoadTexture2D(String assetName, String folderOrArchiveName) {
        boolean storeInLibrary;
        Texture2D tex2d;
        block19: {
            ByteArrayInputStream bis = null;
            int width = 0;
            int height = 0;
            Texture texture = null;
            tex2d = null;
            storeInLibrary = false;
            if (folderOrArchiveName.endsWith(".btm")) {
                storeInLibrary = true;
                if (this.m_userTextures.containsKey(folderOrArchiveName) && (tex2d = this.m_userTextures.get(folderOrArchiveName)) != null) {
                    tex2d.increaseRefCount();
                    return tex2d;
                }
                bis = FileManager.Instance().getZipArchiveStreamItem(folderOrArchiveName, String.valueOf(assetName) + ".png", null);
            } else {
                bis = FileManager.Instance().getStreamItem(String.valueOf(folderOrArchiveName) + "/" + assetName + ".png");
            }
            if (bis == null) {
                return null;
            }
            try {
                try {
                    texture = TextureLoader.getTexture("PNG", bis);
                    width = texture.getImageWidth();
                    height = texture.getImageHeight();
                    tex2d = new Texture2D(this.m_graphicDevice, width, height);
                    tex2d.setData(texture, assetName);
                    tex2d = new Texture2D(this.m_graphicDevice, width, height);
                    tex2d.setData(texture, assetName);
                    tex2d.increaseRefCount();
                }
                catch (Exception e) {
                    tex2d = null;
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (Exception exception) {}
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (tex2d != null && storeInLibrary) {
            this.m_userTextures.put(folderOrArchiveName, tex2d);
        }
        return tex2d;
    }

    public Effect LoadEffect(String assetName) {
        return null;
    }

    public SoundEffect LoadSoundEffect(String assetName) {
        return null;
    }

    public Document LoadXDocument(String assetName, boolean addExtension) {
        String asset = String.valueOf(RootDirectory) + "/" + assetName;
        if (addExtension) {
            asset = String.valueOf(asset) + ".xml";
        }
        if (MACRO.USE_BF) {
            try {
                ByteArrayInputStream bis = this.m_bigFile.getResourceStream(asset);
                Document res = XDocument.Instance().loadDocument(bis);
                bis.close();
                return res;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return XDocument.Instance().loadDocument(ResourceLoader.getResourceAsStream(asset));
    }

    public Document LoadXDocument(String assetName) {
        return this.LoadXDocument(assetName, true);
    }

    public Document LoadXDocumentOutOfContent(String assetName) {
        return XDocument.Instance().loadDocument(ResourceLoader.getResourceAsStream(String.valueOf(assetName) + ".xml"));
    }

    public void WriteXDocumentOutOfContent(String assetName, Document document, boolean _cloudBackup) {
        String content;
        OutputStream os = ResourceLoader.getResourceAsOutputStream(String.valueOf(assetName) + ".xml");
        if (os != null && (content = XDocument.Instance().getStringContentFromDoc(document)) != null && content.length() > 0) {
            try {
                os.write(content.getBytes());
                os.close();
                if (_cloudBackup) {
                    String filenameCloud = String.valueOf(assetName.substring(assetName.lastIndexOf(47) + 1, assetName.length())) + ".xml";
                    GameAPIManager.GameAPI().CloudFileWrite(filenameCloud, content.getBytes());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void WriteXDocumentOutOfContent(String assetName, Document document) {
        this.WriteXDocumentOutOfContent(assetName, document, false);
    }

    public Document CreateXDocument(String _xmlContent) {
        return XDocument.Parse(_xmlContent);
    }
}

