/*
 * Decompiled with CFR 0.152.
 */
package Microsoft.Xna.Framework.Content;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.newdawn.slick.util.ResourceLoader;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlLoader {
    protected static XmlLoader m_Instance = null;
    DocumentBuilderFactory m_documentBuilderFactory = DocumentBuilderFactory.newInstance();
    DocumentBuilder m_documentBuilder = null;

    protected XmlLoader() {
        try {
            this.m_documentBuilder = this.m_documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public static XmlLoader Instance() {
        if (m_Instance == null) {
            m_Instance = new XmlLoader();
        }
        return m_Instance;
    }

    public Document createEmptyDocument() {
        return this.m_documentBuilder.newDocument();
    }

    public Document loadDocument(InputStream is) {
        try {
            Document doc = this.m_documentBuilder.parse(is);
            return doc;
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Document loadDocument(String filename) {
        try {
            Document doc = this.m_documentBuilder.parse(ResourceLoader.getResourceAsStream(filename));
            return doc;
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Document loadDocumentWithContent(String xmlContent) {
        try {
            Document doc = this.m_documentBuilder.parse(new InputSource(new StringReader(xmlContent)));
            return doc;
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public String getStringContentFromDoc(Document doc) {
        try {
            Transformer serializer = TransformerFactory.newInstance().newTransformer();
            StringWriter stw = new StringWriter();
            serializer.setOutputProperty("encoding", "ISO-8859-1");
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            serializer.transform(new DOMSource(doc), new StreamResult(stw));
            return stw.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

