/*
 * Decompiled with CFR 0.152.
 */
package Microsoft.Xna.Framework;

import Microsoft.Xna.Framework.Audio.AudioEngine;
import Microsoft.Xna.Framework.Content.ContentManager;
import Microsoft.Xna.Framework.GameComponent;
import Microsoft.Xna.Framework.GameTime;
import Microsoft.Xna.Framework.Graphics.GraphicsDevice;
import Microsoft.Xna.Framework.GraphicsDeviceManager;
import java.util.ArrayList;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Timer;

public class Game {
    protected boolean m_bExit = false;
    protected GameTime m_gameTime = new GameTime();
    protected Timer m_timer = new Timer();
    protected float m_lastTime = 0.0f;
    protected float m_time = 0.0f;
    protected float m_deltaTime = 0.0f;
    protected boolean m_bLimitFrameRate = false;
    protected int m_maxFrameRate = 60;
    protected float m_maxFrameTime = 0.016666668f;
    protected static Game m_Instance = null;
    protected AudioEngine m_audioEngine = null;
    protected ArrayList<GameComponent> m_components = new ArrayList();
    protected ContentManager MyContent;
    protected GraphicsDevice MyGraphicsDevice = new GraphicsDevice();
    GraphicsDeviceManager m_graphicsDeviceManager = null;

    public static Game Instance() {
        return m_Instance;
    }

    public void FrameRateLimit(boolean _bLimitFramerate, int _maxFramerate) {
        this.m_bLimitFrameRate = _bLimitFramerate;
        this.m_maxFrameRate = _maxFramerate;
        this.m_maxFrameTime = 1.0f / (float)this.m_maxFrameRate;
    }

    public Game() {
        this.MyContent = new ContentManager(this.MyGraphicsDevice);
        if (m_Instance == null) {
            m_Instance = this;
        }
    }

    public ArrayList<GameComponent> Components() {
        return this.m_components;
    }

    public ContentManager Content() {
        return this.MyContent;
    }

    public void Content(ContentManager value) {
        this.MyContent = value;
    }

    public GraphicsDevice GraphicsDevice() {
        return this.MyGraphicsDevice;
    }

    public void addAudioEngine(AudioEngine engine) {
        this.m_audioEngine = engine;
    }

    protected boolean BeginDraw() {
        return true;
    }

    protected void BeginRun() {
    }

    public void Dispose() {
    }

    protected void Dispose(boolean disposing) {
    }

    protected void Draw(GameTime gameTime) {
        for (GameComponent gcomp : this.m_components) {
            gcomp.Draw(gameTime);
        }
    }

    protected void EndDraw() {
    }

    protected void EndRun() {
    }

    public void Exit() {
        this.m_bExit = true;
    }

    protected void Initialize() {
        for (GameComponent gcomp : this.m_components) {
            gcomp.Initialize();
        }
        this.LoadContent();
    }

    protected void LoadContent() {
        for (GameComponent gcomp : this.m_components) {
            gcomp.LoadContent();
        }
    }

    protected void OnActivated(Object sender, Object args) {
    }

    protected void OnDeactivated(Object sender, Object args) {
    }

    protected void OnExiting(Object sender, Object args) {
    }

    public void ResetElapsedTime() {
    }

    public void Run() {
        this.Initialize();
        while (!this.m_bExit) {
            Timer.tick();
            this.m_lastTime = this.m_time;
            this.m_time = this.m_timer.getTime();
            this.m_deltaTime = this.m_time - this.m_lastTime;
            if (this.m_bLimitFrameRate && this.m_deltaTime > this.m_maxFrameTime) {
                this.m_deltaTime = this.m_maxFrameTime;
            }
            this.m_gameTime.TotalGameTime.TotalMilliseconds = 0.0;
            this.m_gameTime.ElapsedGameTime.TotalSeconds = this.m_deltaTime;
            this.Update(this.m_gameTime);
            GL11.glClear((int)16384);
            this.Draw(this.m_gameTime);
            Display.update();
            if (this.m_bLimitFrameRate) {
                Display.sync((int)this.m_maxFrameRate);
            }
            if (!Display.isCloseRequested()) continue;
            this.m_bExit = true;
        }
        if (this.m_audioEngine != null) {
            this.m_audioEngine.Deinit();
        }
        this.UnloadContent();
        this.OnExiting(null, null);
        Display.destroy();
        this.Exit();
    }

    public void RunOneFrame() {
    }

    protected boolean ShowMissingRequirementMessage(Exception exception) {
        return true;
    }

    public void SuppressDraw() {
    }

    public void Tick() {
    }

    protected void UnloadContent() {
    }

    protected void Update(GameTime gameTime) {
        for (GameComponent gcomp : this.m_components) {
            gcomp.Update(gameTime);
        }
    }

    protected void setGraphicDeviceManager(GraphicsDeviceManager graphicsDeviceManager) {
        this.m_graphicsDeviceManager = graphicsDeviceManager;
    }

    public GraphicsDeviceManager getGraphicDeviceManager() {
        return this.m_graphicsDeviceManager;
    }
}

