/*
 * Decompiled with CFR 0.152.
 */
package Microsoft.Xna.Framework.Graphics;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Graphics.DisplayMode;
import Microsoft.Xna.Framework.Graphics.RenderTarget2D;
import Microsoft.Xna.Framework.Graphics.Viewport;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.opengl.TextureImpl;
import org.newdawn.slick.opengl.pbuffer.GraphicsFactory;

public class GraphicsDevice {
    RenderTarget2D m_lastRenderTarget = null;
    DisplayMode m_displayMode = null;
    DisplayMode m_nativeDisplayMode = null;
    protected Viewport viewport;

    public GraphicsDevice() {
        GraphicsFactory.setUseFBO(true);
        this.viewport = new Viewport(0, 0, 0, 0);
        this.m_displayMode = new DisplayMode(false);
        this.m_nativeDisplayMode = new DisplayMode(true);
    }

    public Viewport Viewport() {
        return this.viewport;
    }

    public void Viewport(Viewport value) {
        this.viewport = value;
    }

    public void Clear(Color color) {
        GL11.glClearColor((float)((float)color.R / 255.0f), (float)((float)color.G / 255.0f), (float)((float)color.B / 255.0f), (float)((float)color.A / 255.0f));
    }

    public void SetRenderTarget(RenderTarget2D backRender) {
        if (this.m_lastRenderTarget != null && backRender != this.m_lastRenderTarget) {
            this.m_lastRenderTarget.set(false);
        }
        if (backRender != null && backRender != this.m_lastRenderTarget) {
            backRender.set(true);
        }
        if (backRender == null) {
            TextureImpl.unbind();
        }
        this.m_lastRenderTarget = backRender;
    }

    public void OrthogonalProjection(float x, float y, float width, float height) {
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)x, (double)(x + width), (double)(y + height), (double)y, (double)1.0, (double)-1.0);
        GL11.glMatrixMode((int)5888);
    }

    public void ScissorRectangle(int x, int y, int width, int height) {
        GL11.glEnable((int)3089);
        GL11.glScissor((int)x, (int)y, (int)width, (int)height);
    }

    public DisplayMode DisplayMode() {
        return this.m_displayMode;
    }

    public DisplayMode NativeDisplayMode() {
        return this.m_nativeDisplayMode;
    }
}

