/*
 * Decompiled with CFR 0.152.
 */
package Microsoft.Xna.Framework.Graphics;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Graphics.BlendState;
import Microsoft.Xna.Framework.Graphics.DepthStencilState;
import Microsoft.Xna.Framework.Graphics.Effect;
import Microsoft.Xna.Framework.Graphics.GraphicsDevice;
import Microsoft.Xna.Framework.Graphics.RasterizerState;
import Microsoft.Xna.Framework.Graphics.SamplerState;
import Microsoft.Xna.Framework.Graphics.SpriteEffects;
import Microsoft.Xna.Framework.Graphics.SpriteFont;
import Microsoft.Xna.Framework.Graphics.SpriteSortMode;
import Microsoft.Xna.Framework.Graphics.Texture2D;
import Microsoft.Xna.Framework.Matrix;
import Microsoft.Xna.Framework.Rectangle;
import Microsoft.Xna.Framework.Vector2;
import org.flixel.FlxG;
import org.lwjgl.opengl.GL11;

public class SpriteBatch {
    public GraphicsDevice GraphicsDevice;
    Vector2 m_v1 = new Vector2();
    Vector2 m_v2 = new Vector2();
    Vector2 m_v3 = new Vector2();
    Vector2 m_v4 = new Vector2();
    Vector2 m_translation = new Vector2();
    float uMin;
    float vMin;
    float uMax;
    float vMax;
    float uvTmp;
    float texCorrectionU = 1.0f;
    float texCorrectionV = 1.0f;
    float cT;
    float sT;
    float rx;
    float ry;
    float w;
    float h;
    protected int m_textureIdHelper = -100;
    protected boolean m_bTextureEnabled = false;
    final float one_over_255 = 0.003921569f;
    protected Vector2 helperPosition = new Vector2(0.0f);
    protected Vector2 helperScale = Vector2.One();

    public SpriteBatch(GraphicsDevice graphicsDevice) {
        this.GraphicsDevice = graphicsDevice;
    }

    public void Begin() {
    }

    public void Begin(SpriteSortMode sortMode, BlendState blendState) {
    }

    public void Begin(SpriteSortMode sortMode, BlendState blendState, SamplerState samplerState, DepthStencilState depthStencilState, RasterizerState rasterizerState) {
    }

    public void Begin(SpriteSortMode sortMode, BlendState blendState, SamplerState samplerState, DepthStencilState depthStencilState, RasterizerState rasterizerState, Effect effect) {
    }

    public void Begin(SpriteSortMode sortMode, BlendState blendState, SamplerState samplerState, DepthStencilState depthStencilState, RasterizerState rasterizerState, Effect effect, Matrix transformMatrix) {
    }

    protected void Dispose(boolean disposing) {
    }

    public void Draw(Texture2D texture, Rectangle destinationRectangle, Color color) {
        this._bindTexture(texture);
        this.texCorrectionU = 1.0f * (float)texture.TexImpl().getTextureWidth() / (float)texture.Width();
        this.texCorrectionV = 1.0f * (float)texture.TexImpl().getTextureHeight() / (float)texture.Height();
        this.uMin = (float)destinationRectangle.X / (1.0f * (float)texture.Width());
        this.vMin = (float)destinationRectangle.Y / (1.0f * (float)texture.Height());
        this.uMax = (float)(destinationRectangle.X + destinationRectangle.Width) / (1.0f * (float)texture.Width() * this.texCorrectionU);
        this.vMax = (float)(destinationRectangle.Y + destinationRectangle.Height) / (1.0f * (float)texture.Height() * this.texCorrectionV);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)this.uMin, (float)this.vMin);
        GL11.glVertex2f((float)destinationRectangle.X, (float)destinationRectangle.Y);
        GL11.glTexCoord2f((float)this.uMax, (float)this.vMin);
        GL11.glVertex2f((float)(destinationRectangle.X + destinationRectangle.Width), (float)destinationRectangle.Y);
        GL11.glTexCoord2f((float)this.uMax, (float)this.vMax);
        GL11.glVertex2f((float)(destinationRectangle.X + destinationRectangle.Width), (float)(destinationRectangle.Y + destinationRectangle.Height));
        GL11.glTexCoord2f((float)this.uMin, (float)this.vMax);
        GL11.glVertex2f((float)destinationRectangle.X, (float)(destinationRectangle.Y + destinationRectangle.Height));
        GL11.glEnd();
    }

    public void Draw(Texture2D texture, Vector2 position, Color color) {
        this._bindTexture(texture);
        this.w = texture.Width();
        this.h = texture.Height();
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)position.X, (float)position.Y);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex2f((float)(position.X + this.w), (float)position.Y);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex2f((float)(position.X + this.w), (float)(position.Y + this.h));
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex2f((float)position.X, (float)(position.Y + this.h));
        GL11.glEnd();
    }

    public void Draw(Texture2D texture, Rectangle destinationRectangle, Rectangle sourceRectangle, Color color) {
        this._bindTexture(texture);
        this.uMin = (float)sourceRectangle.X / (1.0f * (float)texture.Width());
        this.vMin = (float)sourceRectangle.Y / (1.0f * (float)texture.Height());
        this.uMax = (float)(sourceRectangle.X + sourceRectangle.Width) / (1.0f * (float)texture.Width());
        this.vMax = (float)(sourceRectangle.Y + sourceRectangle.Height) / (1.0f * (float)texture.Height());
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)this.uMin, (float)this.vMin);
        GL11.glVertex2f((float)destinationRectangle.X, (float)destinationRectangle.Y);
        GL11.glTexCoord2f((float)this.uMax, (float)this.vMin);
        GL11.glVertex2f((float)(destinationRectangle.X + destinationRectangle.Width), (float)destinationRectangle.Y);
        GL11.glTexCoord2f((float)this.uMax, (float)this.vMax);
        GL11.glVertex2f((float)(destinationRectangle.X + destinationRectangle.Width), (float)(destinationRectangle.Y + destinationRectangle.Height));
        GL11.glTexCoord2f((float)this.uMin, (float)this.vMax);
        GL11.glVertex2f((float)destinationRectangle.X, (float)(destinationRectangle.Y + destinationRectangle.Height));
        GL11.glEnd();
    }

    public void Draw(Texture2D texture, Vector2 position, Rectangle sourceRectangle, Color color) {
        this._bindTexture(texture);
        this.uMin = (float)sourceRectangle.X / (1.0f * (float)texture.Width());
        this.vMin = (float)sourceRectangle.Y / (1.0f * (float)texture.Height());
        this.uMax = (float)(sourceRectangle.X + sourceRectangle.Width) / (1.0f * (float)texture.Width());
        this.vMax = (float)(sourceRectangle.Y + sourceRectangle.Height) / (1.0f * (float)texture.Height());
        this.w = sourceRectangle.Width;
        this.h = sourceRectangle.Height;
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)this.uMin, (float)this.vMin);
        GL11.glVertex2f((float)position.X, (float)position.Y);
        GL11.glTexCoord2f((float)this.uMax, (float)this.vMin);
        GL11.glVertex2f((float)(position.X + this.w), (float)position.Y);
        GL11.glTexCoord2f((float)this.uMax, (float)this.vMax);
        GL11.glVertex2f((float)(position.X + this.w), (float)(position.Y + this.h));
        GL11.glTexCoord2f((float)this.uMin, (float)this.vMax);
        GL11.glVertex2f((float)position.X, (float)(position.Y + this.h));
        GL11.glEnd();
    }

    public void Draw(Texture2D texture, Rectangle destinationRectangle, Rectangle sourceRectangle, Color color, float rotation, Vector2 origin, SpriteEffects effects, float layerDepth) {
        if (sourceRectangle.Width < 2 && sourceRectangle.Height < 2) {
            this.helperScale.X = 1.0f;
            this.helperScale.Y = 1.0f;
            this.helperPosition.X = destinationRectangle.X;
            this.helperPosition.Y = destinationRectangle.Y;
            this._genericDraw(texture, this.helperPosition, destinationRectangle, color, rotation, origin, this.helperScale, effects, layerDepth);
        } else {
            this.helperScale.X = 1.0f * (float)destinationRectangle.Width / (float)sourceRectangle.Width;
            this.helperScale.Y = 1.0f * (float)destinationRectangle.Height / (float)sourceRectangle.Height;
            this.helperPosition.X = destinationRectangle.X;
            this.helperPosition.Y = destinationRectangle.Y;
            this._genericDraw(texture, this.helperPosition, sourceRectangle, color, rotation, origin, this.helperScale, effects, layerDepth);
        }
    }

    public void Draw(Texture2D texture, Vector2 position, Rectangle sourceRectangle, Color color, float rotation, Vector2 origin, float scale, SpriteEffects effects, float layerDepth) {
        this.helperScale.X = scale;
        this.helperScale.Y = scale;
        this._genericDraw(texture, position, sourceRectangle, color, rotation, origin, this.helperScale, effects, layerDepth);
    }

    protected void _bindTexture(Texture2D _texture) {
        if (_texture == null) {
            this.m_textureIdHelper = -111;
            if (this.m_bTextureEnabled) {
                this.m_bTextureEnabled = false;
                GL11.glDisable((int)3553);
            }
        } else if (this.m_textureIdHelper != _texture.id()) {
            if (!this.m_bTextureEnabled) {
                this.m_bTextureEnabled = true;
                GL11.glEnable((int)3553);
            }
            this.m_textureIdHelper = _texture.id();
            _texture.bind();
        }
    }

    protected void _genericDraw(Texture2D texture, Vector2 position, Rectangle sourceRectangle, Color color, float rotation, Vector2 origin, Vector2 scale, SpriteEffects effects, float layerDepth) {
        this._bindTexture(texture);
        this.texCorrectionU = 1.0f * (float)texture.TexImpl().getTextureWidth() / (float)texture.Width();
        this.texCorrectionV = 1.0f * (float)texture.TexImpl().getTextureHeight() / (float)texture.Height();
        this.uMin = (float)sourceRectangle.X / (1.0f * (float)texture.Width());
        this.vMin = (float)sourceRectangle.Y / (1.0f * (float)texture.Height());
        this.uMax = (float)(sourceRectangle.X + sourceRectangle.Width) / (1.0f * (float)texture.Width() * this.texCorrectionU);
        this.vMax = (float)(sourceRectangle.Y + sourceRectangle.Height) / (1.0f * (float)texture.Height() * this.texCorrectionV);
        if (effects != SpriteEffects.None) {
            if (effects == SpriteEffects.FlipVertically) {
                this.uvTmp = this.vMin;
                this.vMin = this.vMax;
                this.vMax = this.uvTmp;
            } else if (effects == SpriteEffects.FlipHorizontally) {
                this.uvTmp = this.uMin;
                this.uMin = this.uMax;
                this.uMax = this.uvTmp;
            }
        }
        this.m_translation.X = position.X;
        this.m_translation.Y = position.Y;
        this.m_v1.X = -origin.X;
        this.m_v1.Y = -origin.Y;
        this.m_v2.X = this.m_v1.X + (float)sourceRectangle.Width;
        this.m_v2.Y = this.m_v1.Y;
        this.m_v3.X = this.m_v2.X;
        this.m_v3.Y = this.m_v1.Y + (float)sourceRectangle.Height;
        this.m_v4.X = this.m_v1.X;
        this.m_v4.Y = this.m_v3.Y;
        if (scale.X != 1.0f || scale.Y != 1.0f) {
            this.m_v1.X *= scale.X;
            this.m_v1.Y *= scale.Y;
            this.m_v2.X *= scale.X;
            this.m_v2.Y *= scale.Y;
            this.m_v3.X *= scale.X;
            this.m_v3.Y *= scale.Y;
            this.m_v4.X *= scale.X;
            this.m_v4.Y *= scale.Y;
        }
        if (rotation != 0.0f) {
            this.cT = (float)Math.cos(rotation);
            this.sT = (float)Math.sin(rotation);
            this.rx = this.cT * this.m_v1.X - this.sT * this.m_v1.Y;
            this.ry = this.sT * this.m_v1.X + this.cT * this.m_v1.Y;
            this.m_v1.X = this.rx;
            this.m_v1.Y = this.ry;
            this.rx = this.cT * this.m_v2.X - this.sT * this.m_v2.Y;
            this.ry = this.sT * this.m_v2.X + this.cT * this.m_v2.Y;
            this.m_v2.X = this.rx;
            this.m_v2.Y = this.ry;
            this.rx = this.cT * this.m_v3.X - this.sT * this.m_v3.Y;
            this.ry = this.sT * this.m_v3.X + this.cT * this.m_v3.Y;
            this.m_v3.X = this.rx;
            this.m_v3.Y = this.ry;
            this.rx = this.cT * this.m_v4.X - this.sT * this.m_v4.Y;
            this.ry = this.sT * this.m_v4.X + this.cT * this.m_v4.Y;
            this.m_v4.X = this.rx;
            this.m_v4.Y = this.ry;
        }
        this.m_v1.X += this.m_translation.X;
        this.m_v1.Y += this.m_translation.Y;
        this.m_v2.X += this.m_translation.X;
        this.m_v2.Y += this.m_translation.Y;
        this.m_v3.X += this.m_translation.X;
        this.m_v3.Y += this.m_translation.Y;
        this.m_v4.X += this.m_translation.X;
        this.m_v4.Y += this.m_translation.Y;
        GL11.glColor4f((float)((float)color.R * 0.003921569f), (float)((float)color.G * 0.003921569f), (float)((float)color.B * 0.003921569f), (float)((float)color.A * 0.003921569f));
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)this.uMin, (float)this.vMin);
        GL11.glVertex2f((float)this.m_v1.X, (float)this.m_v1.Y);
        GL11.glTexCoord2f((float)this.uMax, (float)this.vMin);
        GL11.glVertex2f((float)this.m_v2.X, (float)this.m_v2.Y);
        GL11.glTexCoord2f((float)this.uMax, (float)this.vMax);
        GL11.glVertex2f((float)this.m_v3.X, (float)this.m_v3.Y);
        GL11.glTexCoord2f((float)this.uMin, (float)this.vMax);
        GL11.glVertex2f((float)this.m_v4.X, (float)this.m_v4.Y);
        GL11.glEnd();
    }

    public void Draw(Texture2D texture, Vector2 position, Rectangle sourceRectangle, Color color, float rotation, Vector2 origin, Vector2 scale, SpriteEffects effects, float layerDepth) {
    }

    public void DrawString(SpriteFont spriteFont, String text, Vector2 position, Color color) {
        this._bindTexture(null);
        spriteFont.DrawString(position.X, position.Y, text, color);
    }

    public void DrawString(SpriteFont spriteFont, StringBuilder text, Vector2 position, Color color) {
    }

    public void DrawString(SpriteFont spriteFont, String text, Vector2 position, Color color, float rotation, Vector2 origin, float scale, SpriteEffects effects, float layerDepth) {
        this._bindTexture(null);
        spriteFont.Scale(scale, scale);
        spriteFont.DrawString(position.X - origin.X * scale, position.Y - origin.Y * scale, text, color);
    }

    public void DrawString(SpriteFont spriteFont, String text, Vector2 position, Color color, float rotation, Vector2 origin, Vector2 scale, SpriteEffects effects, float layerDepth) {
        this._bindTexture(FlxG.GetXnaSheet());
        spriteFont.Scale(scale.X, scale.Y);
        spriteFont.DrawString(position.X - origin.X * scale.X, position.Y - origin.Y * scale.Y, text, color);
    }

    public void DrawString(SpriteFont spriteFont, StringBuilder text, Vector2 position, Color color, float rotation, Vector2 origin, float scale, SpriteEffects effects, float layerDepth) {
        throw new AssertionError();
    }

    public void DrawString(SpriteFont spriteFont, StringBuilder text, Vector2 position, Color color, float rotation, Vector2 origin, Vector2 scale, SpriteEffects effects, float layerDepth) {
        throw new AssertionError();
    }

    public void End() {
    }
}

