/*
 * Decompiled with CFR 0.152.
 */
package Microsoft.Xna.Framework.Graphics;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Vector2;
import java.awt.Font;
import java.io.InputStream;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.UnicodeFont;
import org.newdawn.slick.font.effects.ColorEffect;

public class SpriteFont {
    org.newdawn.slick.Color m_stringColor = new org.newdawn.slick.Color(255, 255, 255, 255);
    Font m_awtFont;
    UnicodeFont m_font;
    Vector2 m_lastMeasure = new Vector2(1.0f, 1.0f);
    float m_scalex = 1.0f;
    float m_scaley = 1.0f;

    public SpriteFont(String filename, InputStream inputStreamOrNil) {
        try {
            this.m_font = new UnicodeFont(filename, 40, false, false, inputStreamOrNil);
            this.m_font.getEffects().add(new ColorEffect(java.awt.Color.white));
            this.m_font.addAsciiGlyphs();
            try {
                this.m_font.loadGlyphs();
            }
            catch (SlickException e) {
                System.out.println("Font initialization error:");
                e.printStackTrace();
            }
        }
        catch (SlickException e) {
            e.printStackTrace();
        }
    }

    public Vector2 MeasureString(String _text) {
        if (_text.length() > 0) {
            this.m_lastMeasure.X = this.m_font.getTextWidth(_text);
            this.m_lastMeasure.Y = this.m_font.getTextHeight(_text);
        } else {
            this.m_lastMeasure.X = 0.0f;
            this.m_lastMeasure.Y = 0.0f;
        }
        return this.m_lastMeasure;
    }

    public void Scale(float _scalex, float _scaley) {
        this.m_scalex = _scalex;
        this.m_scaley = _scaley;
    }

    public void DrawString(float _x, float _y, String _text, Color _color) {
        this.m_stringColor.r = (float)_color.R / 255.0f;
        this.m_stringColor.g = (float)_color.G / 255.0f;
        this.m_stringColor.b = (float)_color.B / 255.0f;
        this.m_stringColor.a = (float)_color.A / 255.0f;
        if (_text != null && _text.length() > 0) {
            this.m_font.setScale(this.m_scalex, this.m_scaley);
            this.m_font.drawString(_x, _y, _text, this.m_stringColor);
        }
    }
}

