/*
 * Decompiled with CFR 0.152.
 */
package Microsoft.Xna.Framework;

import Microsoft.Xna.Framework.Game;
import Microsoft.Xna.Framework.Graphics.DisplayMode;
import SSS.Util.IconLoader;
import System.Windows.Forms.MessageBox;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

public class GraphicsDeviceManager {
    protected Game m_game;
    boolean m_PreferMultiSampling = false;
    int m_PreferredBackBufferWidth = 0;
    int m_PreferredBackBufferHeight = 0;
    boolean m_bFullscreen = false;
    boolean m_bVSync = true;
    ArrayList<org.lwjgl.opengl.DisplayMode> m_modesToAvoid;

    public GraphicsDeviceManager(Game game) {
        this.m_game = game;
        this.m_game.setGraphicDeviceManager(this);
        DisplayMode.NativeDisplayMode = Display.getDesktopDisplayMode();
        this.m_modesToAvoid = new ArrayList(10);
    }

    public void PreferMultiSampling(boolean b) {
        this.m_PreferMultiSampling = b;
    }

    public void PreferredBackBufferWidth(int resX) {
        this.m_PreferredBackBufferWidth = resX;
    }

    public int PreferredBackBufferWidth() {
        return this.m_PreferredBackBufferWidth;
    }

    public void PreferredBackBufferHeight(int resY) {
        this.m_PreferredBackBufferHeight = resY;
    }

    public int PreferredBackBufferHeight() {
        return this.m_PreferredBackBufferHeight;
    }

    public boolean IsFullScreen() {
        return this.m_bFullscreen;
    }

    public void ToggleFullScreen() {
        this.m_bFullscreen = !this.m_bFullscreen;
    }

    public void ApplyChanges() {
        this.m_game.GraphicsDevice().Viewport().X = 0;
        this.m_game.GraphicsDevice().Viewport().Y = 0;
        this.m_game.GraphicsDevice().Viewport().Width = this.m_PreferredBackBufferWidth;
        this.m_game.GraphicsDevice().Viewport().Height = this.m_PreferredBackBufferHeight;
        this.initGL(this.m_PreferredBackBufferWidth, this.m_PreferredBackBufferHeight);
    }

    public boolean SynchronizeWithVerticalRetrace() {
        return this.m_bVSync;
    }

    public void SynchronizeWithVerticalRetrace(boolean value) {
        this.m_bVSync = value;
    }

    private void initGL(int width, int height) {
        org.lwjgl.opengl.DisplayMode mode = null;
        int modeValidNum = 0;
        try {
            Display.isCreated();
            if (this.m_bFullscreen) {
                org.lwjgl.opengl.DisplayMode[] modes = null;
                modes = Display.getAvailableDisplayModes();
                org.lwjgl.opengl.DisplayMode nativeMode = DisplayMode.NativeDisplayMode;
                if (width > nativeMode.getWidth()) {
                    width = nativeMode.getWidth();
                }
                if (height > nativeMode.getHeight()) {
                    height = nativeMode.getHeight();
                }
                float heightWidthCorrel = Float.MAX_VALUE;
                float heightWidthCorrelBest = Float.MAX_VALUE;
                org.lwjgl.opengl.DisplayMode[] displayModeArray = modes;
                int n = modes.length;
                int n2 = 0;
                while (n2 < n) {
                    org.lwjgl.opengl.DisplayMode mode1 = displayModeArray[n2];
                    if (mode1.isFullscreenCapable() && mode1.getBitsPerPixel() > 16 && mode1.getWidth() <= nativeMode.getWidth() && mode1.getHeight() <= nativeMode.getHeight() && mode1.getFrequency() == nativeMode.getFrequency() && !this.m_modesToAvoid.contains(mode1)) {
                        ++modeValidNum;
                        float w2 = mode1.getWidth() - width;
                        w2 *= w2;
                        float h2 = mode1.getHeight() - height;
                        if ((heightWidthCorrel = w2 + (h2 *= h2)) < heightWidthCorrelBest) {
                            heightWidthCorrelBest = heightWidthCorrel;
                            mode = mode1;
                            if (heightWidthCorrelBest <= 0.0f) break;
                        }
                    }
                    ++n2;
                }
            }
            Display.setTitle((String)"Blocks That Matter");
            if (mode == null) {
                this.m_bFullscreen = false;
                mode = new org.lwjgl.opengl.DisplayMode(width, height);
            }
            this.m_PreferredBackBufferWidth = mode.getWidth();
            this.m_PreferredBackBufferHeight = mode.getHeight();
            Display.setIcon((ByteBuffer[])IconLoader.LoadIcon("icon/icon_btm_16.png"));
            Display.setDisplayMode((org.lwjgl.opengl.DisplayMode)mode);
            Display.setFullscreen((boolean)this.m_bFullscreen);
            Display.setVSyncEnabled((boolean)this.m_bVSync);
            if (!Display.isCreated()) {
                Display.create();
            }
        }
        catch (LWJGLException e) {
            if (this.m_bFullscreen) {
                this.m_modesToAvoid.add(mode);
                if (modeValidNum > 0) {
                    this.initGL(width, height);
                } else {
                    System.out.println(e.getMessage());
                    e.printStackTrace();
                    MessageBox.Show("The requested fullscreen resolution configuration could not be achieved!\nPlease configure a new one (in config/DisplayOptions.xml) OR CHECK YOUR GRAPHICS DRIVER (OpenGL)", "Resolution error (fullsreen)");
                    System.exit(0);
                }
                return;
            }
            System.out.println(e.getMessage());
            e.printStackTrace();
            MessageBox.Show("The requested windowed resolution configuration could not be achieved!\nPlease configure a new one (in config/DisplayOptions.xml) OR CHECK YOUR GRAPHICS DRIVER (OpenGL)", "Resolution error (windowed)");
            System.exit(0);
        }
        GL11.glEnable((int)3553);
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glViewport((int)0, (int)0, (int)width, (int)height);
        GL11.glMatrixMode((int)5888);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)width, (double)height, (double)0.0, (double)1.0, (double)-1.0);
        GL11.glMatrixMode((int)5888);
        this.m_modesToAvoid.clear();
    }
}

