/*
 * Decompiled with CFR 0.152.
 */
package Microsoft.Xna.Framework.Input;

import Microsoft.Xna.Framework.Input.GamePadCapabilities;
import Microsoft.Xna.Framework.Input.GamePadDeadZone;
import Microsoft.Xna.Framework.Input.GamePadState;
import Microsoft.Xna.Framework.PlayerIndex;
import java.util.ArrayList;
import org.lwjgl.input.Controllers;

public class GamePad {
    protected static int MaxGamePad = 4;
    protected static boolean[] GetGameState1 = new boolean[MaxGamePad];
    protected static GamePadState[] GamePadStates1 = new GamePadState[MaxGamePad];
    protected static GamePadState[] GamePadStates2 = new GamePadState[MaxGamePad];
    protected static int[] LastGetStateFrameId = new int[MaxGamePad];
    private static GamePad Instance = null;
    private static int ForcedGamePadIdSelection = -1;
    ArrayList<String> m_validPartialGamepadName = new ArrayList();

    public static GamePad Instance() {
        if (Instance == null) {
            Instance = new GamePad();
            Instance.init();
        }
        return Instance;
    }

    public static int ForcedGamePadIdSelection() {
        return ForcedGamePadIdSelection;
    }

    public static void ForcedGamePadIdSelection(int value) {
        ForcedGamePadIdSelection = value;
        Instance.recomputeGamePad();
    }

    public void resetValidPartialGamepadNames() {
        this.m_validPartialGamepadName.clear();
    }

    public void addValidPartialGamepadName(String partialName) {
        this.m_validPartialGamepadName.add(partialName.toLowerCase());
    }

    public boolean isValidPartialGamepadName(String name) {
        String lowerName;
        if (this.m_validPartialGamepadName != null && this.m_validPartialGamepadName.size() > 0 && !(lowerName = name.toLowerCase()).contains("virtual")) {
            for (String partialName : this.m_validPartialGamepadName) {
                if (!lowerName.contains(partialName)) continue;
                return true;
            }
        }
        return false;
    }

    protected void InitJInput() {
        try {
            if (!Controllers.isCreated()) {
                Controllers.create();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected GamePad() {
    }

    protected void init() {
        this.InitJInput();
        this.m_validPartialGamepadName.add("controller");
        this.recomputeGamePad();
    }

    public void recomputeGamePad() {
        int i = 0;
        PlayerIndex[] playerIndexArray = PlayerIndex.values();
        int n = playerIndexArray.length;
        int n2 = 0;
        while (n2 < n) {
            PlayerIndex pi = playerIndexArray[n2];
            GamePad.GetGameState1[i] = false;
            GamePad.GamePadStates1[i] = new GamePadState(pi);
            GamePad.GamePadStates2[i] = new GamePadState(pi);
            GamePad.LastGetStateFrameId[i] = -1;
            ++i;
            ++n2;
        }
    }

    public static GamePadCapabilities GetCapabilities(PlayerIndex playerIndex) {
        return null;
    }

    public static GamePadState GetState(PlayerIndex playerIndex, int _frameId) {
        int piId = playerIndex.ordinal();
        boolean needUpdate = LastGetStateFrameId[piId] != _frameId;
        GamePadState gps = null;
        if (needUpdate) {
            GamePad.GetGameState1[piId] = !GetGameState1[piId];
        }
        gps = GetGameState1[piId] ? GamePadStates1[playerIndex.ordinal()] : GamePadStates2[playerIndex.ordinal()];
        if (needUpdate) {
            GamePad.LastGetStateFrameId[piId] = _frameId;
            GamePad._updateState(gps);
        }
        return gps;
    }

    protected static void _updateState(GamePadState _gps) {
        _gps.Buttons().updateState(_gps.Controller());
        _gps.DPad().updateState(_gps.Controller());
        _gps.ThumbSticks().updateState(_gps.Controller());
        _gps.Triggers().updateState(_gps.Controller());
    }

    public static GamePadState GetState(PlayerIndex playerIndex, GamePadDeadZone deadZoneMode) {
        return null;
    }

    public static boolean SetVibration(PlayerIndex playerIndex, float leftMotor, float rightMotor) {
        return false;
    }
}

