/*
 * Decompiled with CFR 0.152.
 */
package Microsoft.Xna.Framework.Input;

import Microsoft.Xna.Framework.Input.ButtonState;
import Microsoft.Xna.Framework.Input.GamePadState;
import java.util.HashMap;
import org.lwjgl.input.Controller;

public class GamePadItemState {
    public static HashMap<Integer, GamePadItemType> IdButtonToGamePadItemTypeButton = new HashMap<Integer, GamePadItemType>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(0, GamePadItemType.Button01);
            this.put(1, GamePadItemType.Button02);
            this.put(2, GamePadItemType.Button03);
            this.put(3, GamePadItemType.Button04);
            this.put(4, GamePadItemType.Button05);
            this.put(5, GamePadItemType.Button06);
            this.put(6, GamePadItemType.Button07);
            this.put(7, GamePadItemType.Button08);
            this.put(8, GamePadItemType.Button09);
            this.put(9, GamePadItemType.Button10);
            this.put(10, GamePadItemType.Button11);
            this.put(11, GamePadItemType.Button12);
            this.put(12, GamePadItemType.Button13);
            this.put(13, GamePadItemType.Button14);
            this.put(14, GamePadItemType.Button15);
            this.put(15, GamePadItemType.Button16);
            this.put(16, GamePadItemType.Button17);
            this.put(17, GamePadItemType.Button18);
            this.put(18, GamePadItemType.Button19);
            this.put(19, GamePadItemType.Button20);
            this.put(20, GamePadItemType.Button21);
            this.put(21, GamePadItemType.Button22);
            this.put(22, GamePadItemType.Button23);
            this.put(23, GamePadItemType.Button24);
            this.put(24, GamePadItemType.Button25);
            this.put(25, GamePadItemType.Button26);
            this.put(26, GamePadItemType.Button27);
            this.put(27, GamePadItemType.Button28);
            this.put(28, GamePadItemType.Button29);
            this.put(29, GamePadItemType.Button30);
        }
    };
    GamePadItemType m_gamepadItemType;

    public GamePadItemState(GamePadItemType _type) {
        this.m_gamepadItemType = _type;
    }

    public void changeItemType(GamePadItemType _newType) {
        this.m_gamepadItemType = _newType;
    }

    public GamePadItemType itemType() {
        return this.m_gamepadItemType;
    }

    private ButtonState getButtonState(Controller _controller, int btnId, int buttonCount) {
        if (btnId < buttonCount) {
            return _controller.isButtonPressed(btnId) ? ButtonState.Pressed : ButtonState.Released;
        }
        return ButtonState.Released;
    }

    private ButtonState getAxisButtonState(Controller _controller, int axisId) {
        if (axisId < _controller.getAxisCount() && _controller.getAxisValue(axisId) * _controller.getAxisValue(axisId) < GamePadState.ThumbstickThreshold) {
            return ButtonState.Released;
        }
        return ButtonState.Pressed;
    }

    ButtonState getButtonState(Controller _controller) {
        int buttonCount = _controller.getButtonCount();
        switch (this.m_gamepadItemType) {
            case Button01: {
                return this.getButtonState(_controller, 0, buttonCount);
            }
            case Button02: {
                return this.getButtonState(_controller, 1, buttonCount);
            }
            case Button03: {
                return this.getButtonState(_controller, 2, buttonCount);
            }
            case Button04: {
                return this.getButtonState(_controller, 3, buttonCount);
            }
            case Button05: {
                return this.getButtonState(_controller, 4, buttonCount);
            }
            case Button06: {
                return this.getButtonState(_controller, 5, buttonCount);
            }
            case Button07: {
                return this.getButtonState(_controller, 6, buttonCount);
            }
            case Button08: {
                return this.getButtonState(_controller, 7, buttonCount);
            }
            case Button09: {
                return this.getButtonState(_controller, 8, buttonCount);
            }
            case Button10: {
                return this.getButtonState(_controller, 9, buttonCount);
            }
            case Button11: {
                return this.getButtonState(_controller, 10, buttonCount);
            }
            case Button12: {
                return this.getButtonState(_controller, 11, buttonCount);
            }
            case Button13: {
                return this.getButtonState(_controller, 12, buttonCount);
            }
            case Button14: {
                return this.getButtonState(_controller, 13, buttonCount);
            }
            case Button15: {
                return this.getButtonState(_controller, 14, buttonCount);
            }
            case Button16: {
                return this.getButtonState(_controller, 15, buttonCount);
            }
            case Button17: {
                return this.getButtonState(_controller, 16, buttonCount);
            }
            case Button18: {
                return this.getButtonState(_controller, 17, buttonCount);
            }
            case Button19: {
                return this.getButtonState(_controller, 18, buttonCount);
            }
            case Button20: {
                return this.getButtonState(_controller, 19, buttonCount);
            }
            case Button21: {
                return this.getButtonState(_controller, 20, buttonCount);
            }
            case Button22: {
                return this.getButtonState(_controller, 21, buttonCount);
            }
            case Button23: {
                return this.getButtonState(_controller, 22, buttonCount);
            }
            case Button24: {
                return this.getButtonState(_controller, 23, buttonCount);
            }
            case Button25: {
                return this.getButtonState(_controller, 24, buttonCount);
            }
            case Button26: {
                return this.getButtonState(_controller, 25, buttonCount);
            }
            case Button27: {
                return this.getButtonState(_controller, 26, buttonCount);
            }
            case Button28: {
                return this.getButtonState(_controller, 27, buttonCount);
            }
            case Button29: {
                return this.getButtonState(_controller, 28, buttonCount);
            }
            case Button30: {
                return this.getButtonState(_controller, 29, buttonCount);
            }
            case Axis_01: {
                return this.getAxisButtonState(_controller, 0);
            }
            case Axis_02: {
                return this.getAxisButtonState(_controller, 1);
            }
            case Axis_03: {
                return this.getAxisButtonState(_controller, 2);
            }
            case Axis_04: {
                return this.getAxisButtonState(_controller, 3);
            }
            case Axis_05: {
                return this.getAxisButtonState(_controller, 4);
            }
            case Axis_06: {
                return this.getAxisButtonState(_controller, 5);
            }
            case Axis_07: {
                return this.getAxisButtonState(_controller, 6);
            }
            case Axis_08: {
                return this.getAxisButtonState(_controller, 7);
            }
            case Axis_Z: {
                try {
                    if (_controller.getZAxisValue() * _controller.getZAxisValue() < GamePadState.ThumbstickThreshold) {
                        return ButtonState.Released;
                    }
                }
                catch (Exception e) {
                    return ButtonState.Released;
                }
                return ButtonState.Pressed;
            }
            case PovX_pos: {
                try {
                    if (_controller.getPovX() > GamePadState.ThumbstickThresholdSquared) {
                        return ButtonState.Pressed;
                    }
                }
                catch (Exception e) {
                    return ButtonState.Released;
                }
                return ButtonState.Released;
            }
            case PovX_neg: {
                try {
                    if (_controller.getPovX() < -GamePadState.ThumbstickThresholdSquared) {
                        return ButtonState.Pressed;
                    }
                }
                catch (Exception e) {
                    return ButtonState.Released;
                }
                return ButtonState.Released;
            }
            case PovY_pos: {
                try {
                    if (_controller.getPovY() > GamePadState.ThumbstickThresholdSquared) {
                        return ButtonState.Pressed;
                    }
                }
                catch (Exception e) {
                    return ButtonState.Released;
                }
                return ButtonState.Released;
            }
            case PovY_neg: {
                try {
                    if (_controller.getPovY() < -GamePadState.ThumbstickThresholdSquared) {
                        return ButtonState.Pressed;
                    }
                }
                catch (Exception e) {
                    return ButtonState.Released;
                }
                return ButtonState.Released;
            }
            case Axis_01_pos: {
                if (this.getFloatState(_controller, 0, true, 1.0f) != 0.0f) {
                    return ButtonState.Pressed;
                }
                return ButtonState.Released;
            }
            case Axis_01_neg: {
                if (this.getFloatState(_controller, 0, false, 1.0f) != 0.0f) {
                    return ButtonState.Pressed;
                }
                return ButtonState.Released;
            }
            case Axis_02_pos: {
                if (this.getFloatState(_controller, 1, true, 1.0f) != 0.0f) {
                    return ButtonState.Pressed;
                }
                return ButtonState.Released;
            }
            case Axis_02_neg: {
                if (this.getFloatState(_controller, 1, false, 1.0f) != 0.0f) {
                    return ButtonState.Pressed;
                }
                return ButtonState.Released;
            }
            case Axis_03_pos: {
                if (this.getFloatState(_controller, 2, true, 1.0f) != 0.0f) {
                    return ButtonState.Pressed;
                }
                return ButtonState.Released;
            }
            case Axis_03_neg: {
                if (this.getFloatState(_controller, 2, false, 1.0f) != 0.0f) {
                    return ButtonState.Pressed;
                }
                return ButtonState.Released;
            }
            case Axis_04_pos: {
                if (this.getFloatState(_controller, 3, true, 1.0f) != 0.0f) {
                    return ButtonState.Pressed;
                }
                return ButtonState.Released;
            }
            case Axis_04_neg: {
                if (this.getFloatState(_controller, 3, false, 1.0f) != 0.0f) {
                    return ButtonState.Pressed;
                }
                return ButtonState.Released;
            }
            case Axis_05_pos: {
                if (this.getFloatState(_controller, 4, true, 1.0f) != 0.0f) {
                    return ButtonState.Pressed;
                }
                return ButtonState.Released;
            }
            case Axis_05_neg: {
                if (this.getFloatState(_controller, 4, false, 1.0f) != 0.0f) {
                    return ButtonState.Pressed;
                }
                return ButtonState.Released;
            }
            case Axis_06_pos: {
                if (this.getFloatState(_controller, 5, true, 1.0f) != 0.0f) {
                    return ButtonState.Pressed;
                }
                return ButtonState.Released;
            }
            case Axis_06_neg: {
                if (this.getFloatState(_controller, 5, false, 1.0f) != 0.0f) {
                    return ButtonState.Pressed;
                }
                return ButtonState.Released;
            }
            case Axis_07_pos: {
                if (this.getFloatState(_controller, 6, true, 1.0f) != 0.0f) {
                    return ButtonState.Pressed;
                }
                return ButtonState.Released;
            }
            case Axis_07_neg: {
                if (this.getFloatState(_controller, 6, false, 1.0f) != 0.0f) {
                    return ButtonState.Pressed;
                }
                return ButtonState.Released;
            }
            case Axis_08_pos: {
                if (this.getFloatState(_controller, 7, true, 1.0f) != 0.0f) {
                    return ButtonState.Pressed;
                }
                return ButtonState.Released;
            }
            case Axis_08_neg: {
                if (this.getFloatState(_controller, 7, false, 1.0f) != 0.0f) {
                    return ButtonState.Pressed;
                }
                return ButtonState.Released;
            }
            case Axis_Z_pos: {
                try {
                    if (_controller.getZAxisValue() > GamePadState.ThumbstickThresholdSquared) {
                        return ButtonState.Pressed;
                    }
                }
                catch (Exception e) {
                    return ButtonState.Released;
                }
                return ButtonState.Released;
            }
            case Axis_Z_neg: {
                try {
                    if (_controller.getZAxisValue() < -GamePadState.ThumbstickThresholdSquared) {
                        return ButtonState.Pressed;
                    }
                }
                catch (Exception e) {
                    return ButtonState.Released;
                }
                return ButtonState.Released;
            }
        }
        return ButtonState.Released;
    }

    private float getFloatState(Controller _controller, int axisValue) {
        if (axisValue < _controller.getAxisCount()) {
            return _controller.getAxisValue(axisValue);
        }
        return 0.0f;
    }

    private float getFloatState(Controller _controller, int axisId, boolean _positive, float factor) {
        if (axisId < _controller.getAxisCount()) {
            float axisValue = _controller.getAxisValue(axisId);
            if (_positive && axisValue > GamePadState.ThumbstickThresholdSquared || !_positive && axisValue < -GamePadState.ThumbstickThresholdSquared) {
                return axisValue * factor;
            }
            return 0.0f;
        }
        return 0.0f;
    }

    private float getButtonFloatState(Controller _controller, int btnId) {
        if (this.getButtonState(_controller, btnId, _controller.getButtonCount()) == ButtonState.Pressed) {
            return 1.0f;
        }
        return 0.0f;
    }

    public float getFloatState(Controller _controller) {
        switch (this.m_gamepadItemType) {
            case Button01: {
                return this.getButtonFloatState(_controller, 0);
            }
            case Button02: {
                return this.getButtonFloatState(_controller, 1);
            }
            case Button03: {
                return this.getButtonFloatState(_controller, 2);
            }
            case Button04: {
                return this.getButtonFloatState(_controller, 3);
            }
            case Button05: {
                return this.getButtonFloatState(_controller, 4);
            }
            case Button06: {
                return this.getButtonFloatState(_controller, 5);
            }
            case Button07: {
                return this.getButtonFloatState(_controller, 6);
            }
            case Button08: {
                return this.getButtonFloatState(_controller, 7);
            }
            case Button09: {
                return this.getButtonFloatState(_controller, 8);
            }
            case Button10: {
                return this.getButtonFloatState(_controller, 9);
            }
            case Button11: {
                return this.getButtonFloatState(_controller, 10);
            }
            case Button12: {
                return this.getButtonFloatState(_controller, 11);
            }
            case Button13: {
                return this.getButtonFloatState(_controller, 12);
            }
            case Button14: {
                return this.getButtonFloatState(_controller, 13);
            }
            case Button15: {
                return this.getButtonFloatState(_controller, 14);
            }
            case Button16: {
                return this.getButtonFloatState(_controller, 15);
            }
            case Button17: {
                return this.getButtonFloatState(_controller, 16);
            }
            case Button18: {
                return this.getButtonFloatState(_controller, 17);
            }
            case Button19: {
                return this.getButtonFloatState(_controller, 18);
            }
            case Button20: {
                return this.getButtonFloatState(_controller, 19);
            }
            case Button21: {
                return this.getButtonFloatState(_controller, 20);
            }
            case Button22: {
                return this.getButtonFloatState(_controller, 21);
            }
            case Button23: {
                return this.getButtonFloatState(_controller, 22);
            }
            case Button24: {
                return this.getButtonFloatState(_controller, 23);
            }
            case Button25: {
                return this.getButtonFloatState(_controller, 24);
            }
            case Button26: {
                return this.getButtonFloatState(_controller, 25);
            }
            case Button27: {
                return this.getButtonFloatState(_controller, 26);
            }
            case Button28: {
                return this.getButtonFloatState(_controller, 27);
            }
            case Button29: {
                return this.getButtonFloatState(_controller, 28);
            }
            case Button30: {
                return this.getButtonFloatState(_controller, 29);
            }
            case Axis_01: {
                return this.getFloatState(_controller, 0);
            }
            case Axis_02: {
                return this.getFloatState(_controller, 1);
            }
            case Axis_03: {
                return this.getFloatState(_controller, 2);
            }
            case Axis_04: {
                return this.getFloatState(_controller, 3);
            }
            case Axis_05: {
                return this.getFloatState(_controller, 4);
            }
            case Axis_06: {
                return this.getFloatState(_controller, 5);
            }
            case Axis_07: {
                return this.getFloatState(_controller, 6);
            }
            case Axis_08: {
                return this.getFloatState(_controller, 7);
            }
            case Axis_Z: {
                try {
                    return _controller.getZAxisValue();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return 0.0f;
                }
            }
            case Axis_RZ: {
                try {
                    return _controller.getRZAxisValue();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return 0.0f;
                }
            }
            case PovX_pos: {
                try {
                    return _controller.getPovX();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return 0.0f;
                }
            }
            case PovX_neg: {
                try {
                    return _controller.getPovX();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return 0.0f;
                }
            }
            case PovY_pos: {
                try {
                    return _controller.getPovY();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return 0.0f;
                }
            }
            case PovY_neg: {
                try {
                    return _controller.getPovY();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return 0.0f;
                }
            }
            case Axis_01_pos: {
                return this.getFloatState(_controller, 0, true, 1.0f);
            }
            case Axis_01_neg: {
                return this.getFloatState(_controller, 0, false, 1.0f);
            }
            case Axis_02_pos: {
                return this.getFloatState(_controller, 1, true, 1.0f);
            }
            case Axis_02_neg: {
                return this.getFloatState(_controller, 1, false, 1.0f);
            }
            case Axis_03_pos: {
                return this.getFloatState(_controller, 2, true, 1.0f);
            }
            case Axis_03_neg: {
                return this.getFloatState(_controller, 2, false, 1.0f);
            }
            case Axis_04_pos: {
                return this.getFloatState(_controller, 3, true, 1.0f);
            }
            case Axis_04_neg: {
                return this.getFloatState(_controller, 3, false, 1.0f);
            }
            case Axis_05_pos: {
                return this.getFloatState(_controller, 4, true, 1.0f);
            }
            case Axis_05_neg: {
                return this.getFloatState(_controller, 4, false, 1.0f);
            }
            case Axis_06_pos: {
                return this.getFloatState(_controller, 5, true, 1.0f);
            }
            case Axis_06_neg: {
                return this.getFloatState(_controller, 5, false, 1.0f);
            }
            case Axis_07_pos: {
                return this.getFloatState(_controller, 6, true, 1.0f);
            }
            case Axis_07_neg: {
                return this.getFloatState(_controller, 6, false, 1.0f);
            }
            case Axis_08_pos: {
                return this.getFloatState(_controller, 7, true, 1.0f);
            }
            case Axis_08_neg: {
                return this.getFloatState(_controller, 7, false, 1.0f);
            }
            case Axis_Z_pos: {
                try {
                    if (_controller.getZAxisValue() > GamePadState.ThumbstickThresholdSquared) {
                        return _controller.getZAxisValue();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return 0.0f;
            }
            case Axis_Z_neg: {
                try {
                    if (_controller.getZAxisValue() < -GamePadState.ThumbstickThresholdSquared) {
                        return -1.0f * _controller.getZAxisValue();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return 0.0f;
            }
            case Axis_01_pos_inv: {
                return this.getFloatState(_controller, 0, true, -1.0f);
            }
            case Axis_01_neg_inv: {
                return this.getFloatState(_controller, 0, false, -1.0f);
            }
            case Axis_02_pos_inv: {
                return this.getFloatState(_controller, 1, true, -1.0f);
            }
            case Axis_02_neg_inv: {
                return this.getFloatState(_controller, 1, false, -1.0f);
            }
            case Axis_03_pos_inv: {
                return this.getFloatState(_controller, 2, true, -1.0f);
            }
            case Axis_03_neg_inv: {
                return this.getFloatState(_controller, 2, false, -1.0f);
            }
            case Axis_04_pos_inv: {
                return this.getFloatState(_controller, 3, true, -1.0f);
            }
            case Axis_04_neg_inv: {
                return this.getFloatState(_controller, 3, false, -1.0f);
            }
        }
        return 0.0f;
    }

    public static enum GamePadItemType {
        Button01,
        Button02,
        Button03,
        Button04,
        Button05,
        Button06,
        Button07,
        Button08,
        Button09,
        Button10,
        Button11,
        Button12,
        Button13,
        Button14,
        Button15,
        Button16,
        Button17,
        Button18,
        Button19,
        Button20,
        Button21,
        Button22,
        Button23,
        Button24,
        Button25,
        Button26,
        Button27,
        Button28,
        Button29,
        Button30,
        Axis_01,
        Axis_02,
        Axis_03,
        Axis_04,
        Axis_05,
        Axis_06,
        Axis_07,
        Axis_08,
        Axis_01_pos,
        Axis_01_neg,
        Axis_02_pos,
        Axis_02_neg,
        Axis_03_pos,
        Axis_03_neg,
        Axis_04_pos,
        Axis_04_neg,
        Axis_05_pos,
        Axis_05_neg,
        Axis_06_pos,
        Axis_06_neg,
        Axis_07_pos,
        Axis_07_neg,
        Axis_08_pos,
        Axis_08_neg,
        Axis_01_pos_inv,
        Axis_01_neg_inv,
        Axis_02_pos_inv,
        Axis_02_neg_inv,
        Axis_03_pos_inv,
        Axis_03_neg_inv,
        Axis_04_pos_inv,
        Axis_04_neg_inv,
        Axis_Z,
        Axis_RZ,
        Axis_Z_pos,
        Axis_Z_neg,
        PovX_pos,
        PovX_neg,
        PovY_pos,
        PovY_neg,
        None;

    }
}

