/*
 * Decompiled with CFR 0.152.
 */
package Microsoft.Xna.Framework.Input;

import Microsoft.Xna.Framework.Input.ButtonState;
import Microsoft.Xna.Framework.Input.Buttons;
import Microsoft.Xna.Framework.Input.GamePad;
import Microsoft.Xna.Framework.Input.GamePadButtons;
import Microsoft.Xna.Framework.Input.GamePadDPad;
import Microsoft.Xna.Framework.Input.GamePadThumbSticks;
import Microsoft.Xna.Framework.Input.GamePadTriggers;
import Microsoft.Xna.Framework.PlayerIndex;
import Microsoft.Xna.Framework.Vector2;
import org.lwjgl.input.Controller;
import org.lwjgl.input.Controllers;

public class GamePadState {
    public static float ThumbstickThreshold = 0.2f;
    public static float ThumbstickThresholdSquared = 0.4f;
    PlayerIndex m_index;
    private Controller m_controller = null;
    protected GamePadThumbSticks m_gamePadThumbSticks;
    protected GamePadTriggers m_gamePadTriggers;
    protected GamePadButtons m_gamePadButtons;
    protected GamePadDPad m_gamePadDPad;
    protected boolean m_bValidControllerFound = false;

    public Controller Controller() {
        return this.m_controller;
    }

    public String ControllerName(int id) {
        if (this.m_controller != null) {
            return this.m_controller.getName();
        }
        Controller ctrl = this._getControllerOrNil(id);
        if (ctrl != null) {
            return ctrl.getName();
        }
        return null;
    }

    public GamePadState(PlayerIndex _index) {
        this.m_index = _index;
        this.m_gamePadThumbSticks = new GamePadThumbSticks();
        this.m_gamePadTriggers = new GamePadTriggers();
        this.m_gamePadButtons = new GamePadButtons();
        this.m_gamePadDPad = new GamePadDPad();
        this.recomputeController();
    }

    protected void recomputeController() {
        this.m_controller = this._getControllerOrNil(this.m_index.ordinal());
    }

    protected Controller _getControllerOrNil(int _index) {
        int lastValidCtrlId = -1;
        Controller ctrl = null;
        Controller lastValidCtrl = null;
        this.m_bValidControllerFound = false;
        int i = 0;
        while (i < Controllers.getControllerCount()) {
            ctrl = Controllers.getController((int)i);
            if (ctrl != null) {
                String name = ctrl.getName();
                if (GamePad.Instance().isValidPartialGamepadName(name) && (++lastValidCtrlId == _index || lastValidCtrlId == GamePad.ForcedGamePadIdSelection())) {
                    lastValidCtrl = ctrl;
                    this.m_bValidControllerFound = true;
                    if (lastValidCtrlId == GamePad.ForcedGamePadIdSelection()) {
                        return lastValidCtrl;
                    }
                }
            }
            ++i;
        }
        return lastValidCtrl;
    }

    public GamePadState(Vector2 leftThumbStick, Vector2 rightThumbStick, float leftTrigger, float rightTrigger, Buttons[] buttons) {
    }

    public GamePadButtons Buttons() {
        return this.m_gamePadButtons;
    }

    public GamePadDPad DPad() {
        return this.m_gamePadDPad;
    }

    public boolean IsConnected() {
        return this.m_bValidControllerFound;
    }

    public int PacketNumber() {
        return 0;
    }

    public GamePadThumbSticks ThumbSticks() {
        return this.m_gamePadThumbSticks;
    }

    public GamePadTriggers Triggers() {
        return this.m_gamePadTriggers;
    }

    public int GetHashCode() {
        return 0;
    }

    public boolean IsButtonDown(Buttons button) {
        return this._isButtonState(button, ButtonState.Pressed);
    }

    public boolean IsButtonUp(Buttons button) {
        return this._isButtonState(button, ButtonState.Released);
    }

    protected boolean _isButtonState(Buttons button, ButtonState state) {
        switch (button) {
            case A: {
                return this.m_gamePadButtons.A() == state;
            }
            case B: {
                return this.m_gamePadButtons.B() == state;
            }
            case Y: {
                return this.m_gamePadButtons.Y() == state;
            }
            case X: {
                return this.m_gamePadButtons.X() == state;
            }
            case LeftShoulder: {
                return this.m_gamePadButtons.LeftShoulder() == state;
            }
            case RightShoulder: {
                return this.m_gamePadButtons.RightShoulder() == state;
            }
            case DPadUp: {
                return this.m_gamePadDPad.Up() == state;
            }
            case DPadDown: {
                return this.m_gamePadDPad.Down() == state;
            }
            case DPadLeft: {
                return this.m_gamePadDPad.Left() == state;
            }
            case DPadRight: {
                return this.m_gamePadDPad.Right() == state;
            }
            case LeftThumbstickUp: {
                return state == ButtonState.Pressed ? this.m_gamePadThumbSticks.Left().Y > ThumbstickThreshold : this.m_gamePadThumbSticks.Left().Y < ThumbstickThreshold;
            }
            case LeftThumbstickDown: {
                return state == ButtonState.Pressed ? this.m_gamePadThumbSticks.Left().Y < -ThumbstickThreshold : this.m_gamePadThumbSticks.Left().Y > -ThumbstickThreshold;
            }
            case LeftThumbstickLeft: {
                return state == ButtonState.Pressed ? this.m_gamePadThumbSticks.Left().X < -ThumbstickThreshold : this.m_gamePadThumbSticks.Left().X > -ThumbstickThreshold;
            }
            case LeftThumbstickRight: {
                return state == ButtonState.Pressed ? this.m_gamePadThumbSticks.Left().X > ThumbstickThreshold : this.m_gamePadThumbSticks.Left().X < ThumbstickThreshold;
            }
            case RightThumbstickUp: {
                return state == ButtonState.Pressed ? this.m_gamePadThumbSticks.Right().Y > ThumbstickThreshold : this.m_gamePadThumbSticks.Right().Y < ThumbstickThreshold;
            }
            case RightThumbstickDown: {
                return state == ButtonState.Pressed ? this.m_gamePadThumbSticks.Right().Y < -ThumbstickThreshold : this.m_gamePadThumbSticks.Right().Y > -ThumbstickThreshold;
            }
            case RightThumbstickLeft: {
                return state == ButtonState.Pressed ? this.m_gamePadThumbSticks.Right().X < -ThumbstickThreshold : this.m_gamePadThumbSticks.Right().X > -ThumbstickThreshold;
            }
            case RightThumbstickRight: {
                return state == ButtonState.Pressed ? this.m_gamePadThumbSticks.Right().X > ThumbstickThreshold : this.m_gamePadThumbSticks.Right().X < ThumbstickThreshold;
            }
            case LeftTrigger: {
                return state == ButtonState.Pressed ? this.m_gamePadTriggers.Left() > ThumbstickThreshold : this.m_gamePadTriggers.Left() < ThumbstickThreshold;
            }
            case RightTrigger: {
                return state == ButtonState.Pressed ? this.m_gamePadTriggers.Right() > ThumbstickThreshold : this.m_gamePadTriggers.Right() < ThumbstickThreshold;
            }
            case Start: {
                return this.m_gamePadButtons.Start() == state;
            }
            case Back: {
                return this.m_gamePadButtons.Back() == state;
            }
            case RightStick: {
                return this.m_gamePadButtons.RightStick() == state;
            }
            case LeftStick: {
                return this.m_gamePadButtons.LeftStick() == state;
            }
        }
        return false;
    }
}

