/*
 * Decompiled with CFR 0.152.
 */
package Microsoft.Xna.Framework.Input;

import Microsoft.Xna.Framework.Input.Keys;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.input.Keyboard;

public class KeyboardState {
    static HashMap<Keys, Integer> KeysToLWJGL = new HashMap<Keys, Integer>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(Keys.Escape, 1);
            this.put(Keys.Tab, 15);
            this.put(Keys.Back, 14);
            this.put(Keys.OemComma, 51);
            this.put(Keys.OemPeriod, 52);
            this.put(Keys.Decimal, 83);
            this.put(Keys.A, 30);
            this.put(Keys.B, 48);
            this.put(Keys.C, 46);
            this.put(Keys.D, 32);
            this.put(Keys.E, 18);
            this.put(Keys.F, 33);
            this.put(Keys.G, 34);
            this.put(Keys.H, 35);
            this.put(Keys.I, 23);
            this.put(Keys.J, 36);
            this.put(Keys.K, 37);
            this.put(Keys.L, 38);
            this.put(Keys.M, 50);
            this.put(Keys.N, 49);
            this.put(Keys.O, 24);
            this.put(Keys.P, 25);
            this.put(Keys.Q, 16);
            this.put(Keys.R, 19);
            this.put(Keys.S, 31);
            this.put(Keys.T, 20);
            this.put(Keys.U, 22);
            this.put(Keys.V, 47);
            this.put(Keys.W, 17);
            this.put(Keys.X, 45);
            this.put(Keys.Y, 21);
            this.put(Keys.Z, 44);
            this.put(Keys.NumPad0, 82);
            this.put(Keys.NumPad1, 79);
            this.put(Keys.NumPad2, 80);
            this.put(Keys.NumPad3, 81);
            this.put(Keys.NumPad4, 75);
            this.put(Keys.NumPad5, 76);
            this.put(Keys.NumPad6, 77);
            this.put(Keys.NumPad7, 71);
            this.put(Keys.NumPad8, 72);
            this.put(Keys.NumPad9, 73);
            this.put(Keys.D0, 11);
            this.put(Keys.D1, 2);
            this.put(Keys.D2, 3);
            this.put(Keys.D3, 4);
            this.put(Keys.D4, 5);
            this.put(Keys.D5, 6);
            this.put(Keys.D6, 7);
            this.put(Keys.D7, 8);
            this.put(Keys.D8, 9);
            this.put(Keys.D9, 10);
            this.put(Keys.F1, 59);
            this.put(Keys.F2, 60);
            this.put(Keys.F3, 61);
            this.put(Keys.F4, 62);
            this.put(Keys.F5, 63);
            this.put(Keys.F6, 64);
            this.put(Keys.F7, 65);
            this.put(Keys.F8, 66);
            this.put(Keys.F9, 67);
            this.put(Keys.F10, 68);
            this.put(Keys.F11, 87);
            this.put(Keys.F12, 88);
            this.put(Keys.Up, 200);
            this.put(Keys.Down, 208);
            this.put(Keys.Left, 203);
            this.put(Keys.Right, 205);
            this.put(Keys.Space, 57);
            this.put(Keys.Enter, 28);
            this.put(Keys.LeftShift, 42);
            this.put(Keys.RightShift, 54);
            this.put(Keys.LeftControl, 29);
            this.put(Keys.RightControl, 157);
            this.put(Keys.LeftAlt, 56);
            this.put(Keys.RightAlt, 184);
            this.put(Keys.Multiply, 55);
            this.put(Keys.OemMinus, 12);
            this.put(Keys.Subtract, 74);
            this.put(Keys.Divide, 181);
            this.put(Keys.Delete, 211);
            this.put(Keys.Insert, 210);
        }
    };
    static int KeyFlagsSize = -1;
    private boolean[] m_keyUpFlags = null;

    public KeyboardState() {
        if (KeyFlagsSize < 0) {
            int maxId = 0;
            for (Map.Entry<Keys, Integer> keys : KeysToLWJGL.entrySet()) {
                int value = keys.getValue();
                if (value <= maxId) continue;
                maxId = value;
            }
            KeyFlagsSize = maxId + 1;
        }
        this.m_keyUpFlags = new boolean[KeyFlagsSize];
        Arrays.fill(this.m_keyUpFlags, true);
    }

    public boolean IsKeyDown(Keys key) {
        if (KeysToLWJGL.containsKey((Object)key)) {
            return !this.m_keyUpFlags[KeysToLWJGL.get((Object)key)];
        }
        return false;
    }

    public boolean IsKeyUp(Keys key) {
        if (KeysToLWJGL.containsKey((Object)key)) {
            return this.m_keyUpFlags[KeysToLWJGL.get((Object)key)];
        }
        return true;
    }

    public void updateState() {
        for (Map.Entry<Keys, Integer> keys : KeysToLWJGL.entrySet()) {
            int value = keys.getValue();
            boolean bl = this.m_keyUpFlags[value] = !Keyboard.isKeyDown((int)value);
        }
    }
}

