/*
 * Decompiled with CFR 0.152.
 */
package Microsoft.Xna.Framework.Storage;

import System.IO.FileMode;
import System.IO.Stream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileStream
extends Stream {
    File m_file = null;

    public FileStream(String file, FileMode fileMode) {
        this.m_file = new File(file);
        if (!this.m_file.exists()) {
            try {
                this.m_file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public int length() {
        if (this.m_file != null) {
            return (int)this.m_file.length();
        }
        return 0;
    }

    @Override
    public void Write(byte[] byteArray, int off, int length) {
        if (this.m_file != null) {
            try {
                if (this.m_file.canWrite()) {
                    FileOutputStream fos = new FileOutputStream(this.m_file);
                    fos.write(byteArray, off, length);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void Close() {
    }

    @Override
    public void Read(byte[] byteArray, int off, int length) {
        if (this.m_file != null && this.m_file.exists()) {
            try {
                FileInputStream fis = new FileInputStream(this.m_file);
                fis.read(byteArray, off, length);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            throw new AssertionError();
        }
    }
}

