/*
 * Decompiled with CFR 0.152.
 */
package Microsoft.Xna.Framework.Storage;

import Microsoft.Xna.Framework.Storage.FileStream;
import Microsoft.Xna.Framework.Storage.StorageDevice;
import System.IO.FileAccess;
import System.IO.FileMode;
import System.IO.FileShare;
import System.IO.Stream;
import java.io.File;

public class StorageContainer {
    File m_directoryRoot = null;
    String m_containerName = null;
    String m_displayName = "HDD";
    StorageDevice m_storageDevice = null;

    protected void openContainer(String value) {
        this.m_containerName = value;
        this.m_directoryRoot = new File(String.valueOf(StorageDevice.StorageHelper().executionPath()) + "/" + value);
        if (!this.m_directoryRoot.exists()) {
            this.m_directoryRoot.mkdir();
        }
    }

    protected StorageContainer(StorageDevice _storageDevice) {
        this.m_storageDevice = _storageDevice;
    }

    public String DisplayName() {
        return this.m_displayName;
    }

    public boolean IsDisposed() {
        return true;
    }

    public StorageDevice StorageDevice() {
        return this.m_storageDevice;
    }

    public void CreateDirectory(String directory) {
        if (this.m_directoryRoot != null) {
            File dir = new File(String.valueOf(this.m_directoryRoot.getAbsolutePath()) + "/" + directory);
            if (!dir.exists() || dir.isFile()) {
                dir.mkdir();
            }
        } else {
            throw new AssertionError();
        }
    }

    public Stream CreateFile(String file) {
        return new FileStream(String.valueOf(this.m_directoryRoot.getAbsolutePath()) + "/" + file, FileMode.Create);
    }

    public void DeleteDirectory(String directory) {
        File dir;
        if (this.m_directoryRoot != null && (dir = new File(String.valueOf(this.m_directoryRoot.getAbsolutePath()) + "/" + directory)).exists() && !dir.isFile()) {
            dir.delete();
        }
    }

    public void DeleteFile(String file) {
        File f;
        if (this.m_directoryRoot != null && (f = new File(String.valueOf(this.m_directoryRoot.getAbsolutePath()) + "/" + file)).exists() && f.isFile()) {
            f.delete();
        }
    }

    public boolean DirectoryExists(String directory) {
        File dir;
        return this.m_directoryRoot != null && (dir = new File(String.valueOf(this.m_directoryRoot.getAbsolutePath()) + "/" + directory)).exists() && !dir.isFile();
    }

    public void Dispose() {
    }

    public boolean FileExists(String file) {
        File fileToTest;
        return this.m_directoryRoot != null && (fileToTest = new File(String.valueOf(this.m_directoryRoot.getAbsolutePath()) + "/" + file)).exists() && fileToTest.isFile();
    }

    public String[] GetDirectoryNames() {
        throw new AssertionError();
    }

    public String[] GetDirectoryNames(String searchPattern) {
        throw new AssertionError();
    }

    public String[] GetFileNames() {
        throw new AssertionError();
    }

    public String[] GetFileNames(String searchPattern) {
        throw new AssertionError();
    }

    public Stream OpenFile(String file, FileMode fileMode) {
        return this.OpenFile(file, fileMode, FileAccess.Read, FileShare.Read);
    }

    public Stream OpenFile(String file, FileMode fileMode, FileAccess fileAccess) {
        return this.OpenFile(file, fileMode, fileAccess, FileShare.Read);
    }

    public Stream OpenFile(String file, FileMode fileMode, FileAccess fileAccess, FileShare fileShare) {
        return new FileStream(String.valueOf(this.m_directoryRoot.getAbsolutePath()) + "/" + file, fileMode);
    }
}

