/*
 * Decompiled with CFR 0.152.
 */
package Microsoft.Xna.Framework;

public class Vector2
implements Cloneable {
    public static final Vector2 _Zero = new Vector2(0.0f, 0.0f);
    public static final Vector2 _One = new Vector2(1.0f, 1.0f);
    public float X;
    public float Y;

    public static final Vector2 Zero() {
        return _Zero.clone();
    }

    public static final Vector2 One() {
        return _One.clone();
    }

    public Vector2() {
        this.X = 0.0f;
        this.Y = 0.0f;
    }

    public Vector2(Vector2 _vector) {
        this.X = _vector.X;
        this.Y = _vector.Y;
    }

    public Vector2(float xy) {
        this.X = xy;
        this.Y = xy;
    }

    public Vector2(float x, float y) {
        this.X = x;
        this.Y = y;
    }

    public void selMultiply(float factor) {
        this.X *= factor;
        this.Y *= factor;
    }

    public Vector2 multiply(float factor) {
        return new Vector2(this.X * factor, this.Y * factor);
    }

    public static void add(Vector2 a, Vector2 b, Vector2 res) {
        res.X = a.X + b.X;
        res.Y = a.Y + b.Y;
    }

    public static void multiply(Vector2 a, Vector2 b, Vector2 res) {
        res.X = a.X * b.X;
        res.Y = a.Y * b.Y;
    }

    public static void multiply(Vector2 a, float b, Vector2 res) {
        res.X = a.X * b;
        res.Y = a.Y * b;
    }

    public Vector2 clone() {
        try {
            return (Vector2)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void copy(Vector2 toCopy) {
        this.X = toCopy.X;
        this.Y = toCopy.Y;
    }
}

