/*
 * Decompiled with CFR 0.152.
 */
package SSS.API;

import SSS.API.BlankGameAPI;
import SSS.API.GameAPI;
import SSS.API.SteamGameAPI;
import SSS.API.eGameAPI;
import precompiler.MACRO;

public class GameAPIManager {
    protected static GameAPI m_gameAPI = null;
    protected static eGameAPI m_apiType = eGameAPI.BlankGameAPI;

    public static eGameAPI GameAPIType() {
        return m_apiType;
    }

    private GameAPIManager() {
    }

    public static void BuildAPI(eGameAPI _type) {
        if (m_gameAPI == null) {
            m_apiType = _type;
            switch (_type) {
                case SteamGameAPI: {
                    m_gameAPI = new SteamGameAPI();
                    break;
                }
                case BlankGameAPI: {
                    m_gameAPI = new BlankGameAPI();
                    break;
                }
                default: {
                    m_gameAPI = new BlankGameAPI();
                }
            }
            if (!m_gameAPI.Build() && _type != eGameAPI.BlankGameAPI) {
                m_gameAPI = null;
                m_apiType = eGameAPI.BlankGameAPI;
            }
        }
    }

    public static String GetApiFriendlyName() {
        String res = "";
        switch (MACRO.USED_GAME_API_IF_NOT_BLANK) {
            case SteamGameAPI: {
                res = "Steam";
                break;
            }
            case DesuraGameAPI: {
                res = "Desura";
                break;
            }
            case GamersGateGameAPI: {
                res = "GamersGate";
                break;
            }
            case IndievaniaGameAPI: {
                res = "Indievania";
                break;
            }
            case EurogamerGameAPI: {
                res = "Eurogamer";
                break;
            }
            case HumbleGameAPI: {
                res = "Humble Version";
                break;
            }
            case Direct2DriveGameAPI: {
                res = "D2D";
                break;
            }
            case GenericGameAPI: {
                res = "full";
            }
        }
        return res;
    }

    public static GameAPI GameAPI() {
        return m_gameAPI;
    }
}

