/*
 * Decompiled with CFR 0.152.
 */
package SSS.API;

import SSS.API.GameAPI;
import SSS.API.GameAPIOverlayPosition;
import SSS.Managers.BTM.AchievementManager;
import SSS.Managers.FileManager;
import SSS.Util.Utility;
import api.SteamAPI;
import org.flixel.FlxG;

public class SteamGameAPI
implements GameAPI {
    SteamAPI m_steamAPI;
    boolean m_bCorrecltyInitialized = false;
    boolean m_bThreadOverlayAchInProgress = false;
    boolean m_bFirstUpdate = true;
    boolean m_bMac = false;

    @Override
    public boolean Build() {
        this.m_bMac = Utility.GetOsType() == Utility.eOsType.OSX;
        try {
            this.m_steamAPI = new SteamAPI();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean Init() {
        this.m_bCorrecltyInitialized = this.m_steamAPI.SteamAPI_Init();
        return this.m_bCorrecltyInitialized;
    }

    @Override
    public void ShutDown() {
        if (this.m_bCorrecltyInitialized) {
            this.m_steamAPI.SteamAPI_Shutdown();
        }
    }

    @Override
    public void SetOverlayNotificationPosition(GameAPIOverlayPosition position) {
        if (!this.m_bCorrecltyInitialized) {
            return;
        }
        int value = 0;
        switch (position) {
            case PositionTopLeft: {
                value = 0;
                break;
            }
            case PositionTopRight: {
                value = 1;
                break;
            }
            case PositionBottomLeft: {
                value = 2;
                break;
            }
            case PositionBottomRight: {
                value = 3;
                break;
            }
            default: {
                value = 0;
            }
        }
        this.m_steamAPI.SteamUtil_SetOverlayNotificationPosition(value);
    }

    @Override
    public long GetUserID() {
        if (!this.m_bCorrecltyInitialized) {
            return 0L;
        }
        return this.m_steamAPI.SteamUser_GetSteamID();
    }

    @Override
    public String GetUserName() {
        if (!this.m_bCorrecltyInitialized) {
            return "ERROR";
        }
        return this.m_steamAPI.SteamFriends_GetPersonaName();
    }

    @Override
    public boolean RequestCurrentStats() {
        if (!this.m_bCorrecltyInitialized) {
            return true;
        }
        return this.m_steamAPI.SteamUserStats_RequestCurrentStats();
    }

    @Override
    public void SetAchievement(String _ID) {
        if (!this.m_bCorrecltyInitialized) {
            return;
        }
        this.m_steamAPI.SteamUserStats_SetAchievement(_ID);
    }

    @Override
    public void UpdateFrame() {
        if (!this.m_bCorrecltyInitialized) {
            return;
        }
        if (this.m_steamAPI.IsGameOverlayJustDeactivated() || this.m_bFirstUpdate) {
            this.m_bFirstUpdate = false;
            this._checkAchievementOverlayRelated();
        }
        if (this.m_bMac) {
            if (this.m_steamAPI.IsGameOverlayJustDeactivated()) {
                FlxG.mouse.useBlankCursor();
            } else if (this.m_steamAPI.IsGameOverlayJustActivated()) {
                FlxG.mouse.useNativeCursor();
            }
        }
        this.m_steamAPI.UpdateFrame();
    }

    protected void _checkAchievementOverlayRelated() {
        if (!this.m_bThreadOverlayAchInProgress) {
            boolean bCheckGroup;
            boolean bl = bCheckGroup = !AchievementManager.Instance().isAchievementUnlocked("ACH_GROUP");
            if (bCheckGroup) {
                final boolean threadCheckGroup = bCheckGroup;
                final long steamId = this.m_steamAPI.SteamUser_GetSteamID();
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        String groupContent;
                        if (threadCheckGroup && (groupContent = FileManager.Instance().listGroupMember("http://steamcommunity.com/games/blocksthatmatter/memberslistxml/?xml=1")) != null) {
                            int pageNumber = 1;
                            if (groupContent.contains("totalPages")) {
                                try {
                                    String xmlTag = "<totalPages>";
                                    int beginIndex = groupContent.indexOf("<totalPages>", 0);
                                    int endIndex = groupContent.indexOf("</totalPages>", beginIndex);
                                    String numberStr = groupContent.substring(beginIndex + xmlTag.length(), endIndex);
                                    pageNumber = Integer.parseInt(numberStr);
                                }
                                catch (Exception e) {
                                    pageNumber = 1;
                                }
                            }
                            int page = 1;
                            while (page <= pageNumber) {
                                if (groupContent.contains(Long.toString(steamId))) {
                                    AchievementManager.Instance().unlockAchievementNextFrame("ACH_GROUP");
                                    break;
                                }
                                groupContent = FileManager.Instance().listGroupMember("http://steamcommunity.com/games/blocksthatmatter/memberslistxml/?xml=1&p=" + page);
                                if (groupContent == null) break;
                                ++page;
                            }
                        }
                    }
                };
                Thread thread = new Thread(r);
                thread.start();
            }
        }
    }

    @Override
    public boolean IsAchievementAchevied(String _ID) {
        if (!this.m_bCorrecltyInitialized) {
            return false;
        }
        return this.m_steamAPI.SteamUserStats_GetAchievement(_ID);
    }

    @Override
    public void ResetAllStats(boolean _bEraseAchievementToo) {
        if (!this.m_bCorrecltyInitialized) {
            return;
        }
        this.m_steamAPI.SteamUserStats_ResetAllStats(_bEraseAchievementToo);
        if (_bEraseAchievementToo) {
            AchievementManager.Instance().resetAchievementDeferred();
            AchievementManager.Instance().buildAchievements();
        }
    }

    @Override
    public int GetCloudAvailableSpace() {
        if (!this.m_bCorrecltyInitialized) {
            return 0;
        }
        return this.m_steamAPI.SteamRemoteStorage_GetQuota_AvailableSpace();
    }

    @Override
    public int GetCloudTotalSpace() {
        if (!this.m_bCorrecltyInitialized) {
            return 0;
        }
        return this.m_steamAPI.SteamRemoteStorage_GetQuota_TotalSpace();
    }

    @Override
    public void SetCloudEnabled(boolean value) {
        if (!this.m_bCorrecltyInitialized) {
            return;
        }
        this.m_steamAPI.SteamRemoteStorage_SetCloudEnabledForApp(value);
    }

    @Override
    public boolean CloudFileExists(String _filename) {
        if (!this.m_bCorrecltyInitialized) {
            return false;
        }
        return this.m_steamAPI.SteamRemoteStorage_FileExists(_filename);
    }

    @Override
    public boolean CloudFileDelete(String _filename) {
        if (!this.m_bCorrecltyInitialized) {
            return true;
        }
        return this.m_steamAPI.SteamRemoteStorage_FileDelete(_filename);
    }

    @Override
    public long CloudFileTimestamp(String _filename) {
        if (!this.m_bCorrecltyInitialized) {
            return 0L;
        }
        return this.m_steamAPI.SteamRemoteStorage_GetFileTimestamp(_filename);
    }

    @Override
    public int CloudFileSize(String _filename) {
        if (!this.m_bCorrecltyInitialized) {
            return 0;
        }
        return this.m_steamAPI.SteamRemoteStorage_GetFileSize(_filename);
    }

    @Override
    public boolean CloudFileWrite(String _filename, byte[] data) {
        if (!this.m_bCorrecltyInitialized) {
            return true;
        }
        return this.m_steamAPI.SteamRemoteStorage_FileWrite(_filename, data);
    }

    @Override
    public byte[] CloudFileRead(String _filename) {
        if (!this.m_bCorrecltyInitialized) {
            return null;
        }
        return this.m_steamAPI.SteamRemoteStorage_FileRead(_filename);
    }

    @Override
    public boolean CorrectlyInitialized() {
        return this.m_bCorrecltyInitialized;
    }

    @Override
    public void OpenGameOverlay(String _dialogID) {
        if (!this.m_bCorrecltyInitialized) {
            return;
        }
        this.m_steamAPI.SteamFriends_ActivateGameOverlay(_dialogID);
    }
}

