/*
 * Decompiled with CFR 0.152.
 */
package SSS;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Graphics.SpriteBatch;
import Microsoft.Xna.Framework.Vector2;
import Microsoft.Xna.Framework.Vector4;
import SSS.BTM.GameVars;
import SSS.Behaviour;
import SSS.BehaviourManager;
import SSS.BehaviourParameter;
import SSS.Level;
import SSS.SssGroup;
import SSS.Util.Debug;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.flixel.FlxSprite;

public class Actor
extends FlxSprite {
    public static eActorMaterial[] IntToeActorMaterial = eActorMaterial.values();
    protected static String[] FriendlyMaterialNames = new String[]{"ennemy", "spawnpoint", "text", "triggerdialog", "spawnbackground", "spawnsound", "player", "physics", "physicsAuto", "slimespawner", "slimedrop", "breakable", "wood", "stone", "iron", "diamond", "ruby", "jade", "obsidian", "sand", "dirt", "gold", "tnt", "chest", "chestBTM", "paint", "workshop", "spawnWorkshop", "threshold", "ironOre", "goldOre", "rubyOre", "jadeOre", "diamondOre", "obsidianOre", "clay", "levelEnd", "animNoiser", "ice", "portal", "switch", "door", "whiteChocolate", "brownChocolate", "blackChocolate", "pinkChocolate", "blueChocolate"};
    public static HashMap<String, eActorMaterial> MaterialNameEnumDictionnary = new HashMap<String, eActorMaterial>(){
        private static final long serialVersionUID = 8839697874568018620L;
        {
            this.put("ennemy", eActorMaterial.eActorMaterial_Ennemy);
            this.put("spawnpoint", eActorMaterial.eActorMaterial_Spawnpoint);
            this.put("text", eActorMaterial.eActorMaterial_Text);
            this.put("triggerdialog", eActorMaterial.eActorMaterial_TriggerDialog);
            this.put("spawnbackground", eActorMaterial.eActorMaterial_SpawnBackground);
            this.put("spawnsound", eActorMaterial.eActorMaterial_Spawnsound);
            this.put("player", eActorMaterial.eActorMaterial_Player);
            this.put("physics", eActorMaterial.eActorMaterial_Unbreakable);
            this.put("physicsAuto", eActorMaterial.eActorMaterial_UnbreakableAutoAnim);
            this.put("slimespawner", eActorMaterial.eActorMaterial_UnbreakableSlimeSpawn);
            this.put("slimedrop", eActorMaterial.eActorMaterial_SlimeDrop);
            this.put("breakable", eActorMaterial.eActorMaterial_Wood);
            this.put("wood", eActorMaterial.eActorMaterial_Wood);
            this.put("stone", eActorMaterial.eActorMaterial_Stone);
            this.put("iron", eActorMaterial.eActorMaterial_Iron);
            this.put("diamond", eActorMaterial.eActorMaterial_Diamond);
            this.put("ruby", eActorMaterial.eActorMaterial_Ruby);
            this.put("jade", eActorMaterial.eActorMaterial_Jade);
            this.put("obsidian", eActorMaterial.eActorMaterial_Obsidian);
            this.put("sand", eActorMaterial.eActorMaterial_Sand);
            this.put("dirt", eActorMaterial.eActorMaterial_Dirt);
            this.put("gold", eActorMaterial.eActorMaterial_Gold);
            this.put("tnt", eActorMaterial.eActorMaterial_Tnt);
            this.put("chest", eActorMaterial.eActorMaterial_Chest);
            this.put("chestBTM", eActorMaterial.eActorMaterial_ChestBTM);
            this.put("paint", eActorMaterial.eActorMaterial_Paint);
            this.put("workshop", eActorMaterial.eActorMaterial_Workshop);
            this.put("spawnWorkshop", eActorMaterial.eActorMaterial_SpawnWorkshop);
            this.put("threshold", eActorMaterial.eActorMaterial_Threshold);
            this.put("ironOre", eActorMaterial.eActorMaterial_IronOre);
            this.put("goldOre", eActorMaterial.eActorMaterial_GoldOre);
            this.put("rubyOre", eActorMaterial.eActorMaterial_RubyOre);
            this.put("jadeOre", eActorMaterial.eActorMaterial_JadeOre);
            this.put("diamondOre", eActorMaterial.eActorMaterial_DiamondOre);
            this.put("obsidianOre", eActorMaterial.eActorMaterial_ObsidianOre);
            this.put("clay", eActorMaterial.eActorMaterial_Clay);
            this.put("levelEnd", eActorMaterial.eActorMaterial_LevelEnd);
            this.put("animNoiser", eActorMaterial.eActorMaterial_AnimNoiser);
            this.put("ice", eActorMaterial.eActorMaterial_Ice);
            this.put("portal", eActorMaterial.eActorMaterial_Portal);
            this.put("switch", eActorMaterial.eActorMaterial_Switch);
            this.put("door", eActorMaterial.eActorMaterial_Door);
            this.put("whiteChocolate", eActorMaterial.eActorMaterial_WhiteChocolate);
            this.put("brownChocolate", eActorMaterial.eActorMaterial_BrownChocolate);
            this.put("blackChocolate", eActorMaterial.eActorMaterial_BlackChocolate);
            this.put("pinkChocolate", eActorMaterial.eActorMaterial_PinkChocolate);
            this.put("blueChocolate", eActorMaterial.eActorMaterial_BlueChocolate);
        }
    };
    public static HashMap<eActorMaterial, Color> MaterialEnumParticleColorDictionnary = new HashMap<eActorMaterial, Color>(){
        private static final long serialVersionUID = -8868358712009576480L;
        {
            this.put(eActorMaterial.eActorMaterial_Ennemy, Color.White());
            this.put(eActorMaterial.eActorMaterial_Spawnpoint, Color.White());
            this.put(eActorMaterial.eActorMaterial_Text, Color.White());
            this.put(eActorMaterial.eActorMaterial_TriggerDialog, Color.White());
            this.put(eActorMaterial.eActorMaterial_SpawnBackground, Color.White());
            this.put(eActorMaterial.eActorMaterial_Spawnsound, Color.White());
            this.put(eActorMaterial.eActorMaterial_Player, Color.White());
            this.put(eActorMaterial.eActorMaterial_Unbreakable, Color.White());
            this.put(eActorMaterial.eActorMaterial_UnbreakableAutoAnim, Color.White());
            this.put(eActorMaterial.eActorMaterial_UnbreakableSlimeSpawn, Color.White());
            this.put(eActorMaterial.eActorMaterial_SlimeDrop, Color.White());
            this.put(eActorMaterial.eActorMaterial_Wood, new Color(98, 72, 32));
            this.put(eActorMaterial.eActorMaterial_Stone, new Color(85, 85, 85));
            this.put(eActorMaterial.eActorMaterial_Iron, new Color(147, 147, 147));
            this.put(eActorMaterial.eActorMaterial_Diamond, new Color(109, 180, 229));
            this.put(eActorMaterial.eActorMaterial_Ruby, new Color(229, 75, 89));
            this.put(eActorMaterial.eActorMaterial_Jade, new Color(84, 255, 126));
            this.put(eActorMaterial.eActorMaterial_Obsidian, new Color(10, 10, 10));
            this.put(eActorMaterial.eActorMaterial_Sand, new Color(185, 186, 29));
            this.put(eActorMaterial.eActorMaterial_Dirt, Color.White());
            this.put(eActorMaterial.eActorMaterial_Gold, new Color(151, 118, 25));
            this.put(eActorMaterial.eActorMaterial_Tnt, new Color(124, 36, 37));
            this.put(eActorMaterial.eActorMaterial_Chest, new Color(158, 130, 92));
            this.put(eActorMaterial.eActorMaterial_ChestBTM, new Color(98, 67, 32));
            this.put(eActorMaterial.eActorMaterial_Paint, Color.White());
            this.put(eActorMaterial.eActorMaterial_Workshop, Color.White());
            this.put(eActorMaterial.eActorMaterial_SpawnWorkshop, Color.White());
            this.put(eActorMaterial.eActorMaterial_Threshold, Color.White());
            this.put(eActorMaterial.eActorMaterial_IronOre, new Color(85, 85, 85));
            this.put(eActorMaterial.eActorMaterial_DiamondOre, new Color(85, 85, 85));
            this.put(eActorMaterial.eActorMaterial_ObsidianOre, new Color(85, 85, 85));
            this.put(eActorMaterial.eActorMaterial_GoldOre, new Color(85, 85, 85));
            this.put(eActorMaterial.eActorMaterial_RubyOre, new Color(85, 85, 85));
            this.put(eActorMaterial.eActorMaterial_JadeOre, new Color(85, 85, 85));
            this.put(eActorMaterial.eActorMaterial_Clay, Color.White());
            this.put(eActorMaterial.eActorMaterial_LevelEnd, Color.White());
            this.put(eActorMaterial.eActorMaterial_AnimNoiser, Color.White());
            this.put(eActorMaterial.eActorMaterial_Ice, new Color(184, 236, 239));
            this.put(eActorMaterial.eActorMaterial_Portal, Color.White());
            this.put(eActorMaterial.eActorMaterial_Switch, Color.White());
            this.put(eActorMaterial.eActorMaterial_Door, Color.White());
            this.put(eActorMaterial.eActorMaterial_WhiteChocolate, new Color(230, 193, 159));
            this.put(eActorMaterial.eActorMaterial_BrownChocolate, new Color(146, 67, 26));
            this.put(eActorMaterial.eActorMaterial_BlackChocolate, new Color(64, 25, 7));
            this.put(eActorMaterial.eActorMaterial_PinkChocolate, new Color(249, 119, 109));
            this.put(eActorMaterial.eActorMaterial_BlueChocolate, new Color(89, 134, 185));
        }
    };
    public static HashMap<eActorMaterial, String> MaterialEnumNameDictionnary = new HashMap<eActorMaterial, String>(){
        private static final long serialVersionUID = 8704650630444000535L;
        {
            this.put(eActorMaterial.eActorMaterial_Ennemy, "ennemy");
            this.put(eActorMaterial.eActorMaterial_Spawnpoint, "spawnpoint");
            this.put(eActorMaterial.eActorMaterial_Text, "text");
            this.put(eActorMaterial.eActorMaterial_TriggerDialog, "triggerdialog");
            this.put(eActorMaterial.eActorMaterial_SpawnBackground, "spawnbackground");
            this.put(eActorMaterial.eActorMaterial_Spawnsound, "spawnsound");
            this.put(eActorMaterial.eActorMaterial_Player, "player");
            this.put(eActorMaterial.eActorMaterial_Unbreakable, "physics");
            this.put(eActorMaterial.eActorMaterial_UnbreakableAutoAnim, "physicsAuto");
            this.put(eActorMaterial.eActorMaterial_UnbreakableSlimeSpawn, "slimespawner");
            this.put(eActorMaterial.eActorMaterial_SlimeDrop, "slimedrop");
            this.put(eActorMaterial.eActorMaterial_Wood, "wood");
            this.put(eActorMaterial.eActorMaterial_Stone, "stone");
            this.put(eActorMaterial.eActorMaterial_Iron, "iron");
            this.put(eActorMaterial.eActorMaterial_Diamond, "diamond");
            this.put(eActorMaterial.eActorMaterial_Ruby, "ruby");
            this.put(eActorMaterial.eActorMaterial_Jade, "jade");
            this.put(eActorMaterial.eActorMaterial_Obsidian, "obsidian");
            this.put(eActorMaterial.eActorMaterial_Sand, "sand");
            this.put(eActorMaterial.eActorMaterial_Dirt, "dirt");
            this.put(eActorMaterial.eActorMaterial_Gold, "gold");
            this.put(eActorMaterial.eActorMaterial_Tnt, "tnt");
            this.put(eActorMaterial.eActorMaterial_Chest, "chest");
            this.put(eActorMaterial.eActorMaterial_ChestBTM, "chestBTM");
            this.put(eActorMaterial.eActorMaterial_Paint, "paint");
            this.put(eActorMaterial.eActorMaterial_Workshop, "workshop");
            this.put(eActorMaterial.eActorMaterial_SpawnWorkshop, "spawnWorkshop");
            this.put(eActorMaterial.eActorMaterial_Threshold, "threshold");
            this.put(eActorMaterial.eActorMaterial_IronOre, "ironOre");
            this.put(eActorMaterial.eActorMaterial_DiamondOre, "diamondOre");
            this.put(eActorMaterial.eActorMaterial_ObsidianOre, "obsidianOre");
            this.put(eActorMaterial.eActorMaterial_GoldOre, "goldOre");
            this.put(eActorMaterial.eActorMaterial_RubyOre, "rubyOre");
            this.put(eActorMaterial.eActorMaterial_JadeOre, "jadeOre");
            this.put(eActorMaterial.eActorMaterial_Clay, "clay");
            this.put(eActorMaterial.eActorMaterial_LevelEnd, "levelEnd");
            this.put(eActorMaterial.eActorMaterial_AnimNoiser, "animNoiser");
            this.put(eActorMaterial.eActorMaterial_Ice, "ice");
            this.put(eActorMaterial.eActorMaterial_Portal, "portal");
            this.put(eActorMaterial.eActorMaterial_Switch, "switch");
            this.put(eActorMaterial.eActorMaterial_Door, "door");
            this.put(eActorMaterial.eActorMaterial_WhiteChocolate, "whiteChocolate");
            this.put(eActorMaterial.eActorMaterial_BrownChocolate, "brownChocolate");
            this.put(eActorMaterial.eActorMaterial_BlackChocolate, "blackChocolate");
            this.put(eActorMaterial.eActorMaterial_PinkChocolate, "pinkChocolate");
            this.put(eActorMaterial.eActorMaterial_BlueChocolate, "blueChocolate");
        }
    };
    static int m_firstDrillableMatId = eActorMaterial.eActorMaterial_Sand.ordinal();
    static int m_lastDrillableMatId = eActorMaterial.eActorMaterial_Jade.ordinal();
    static int m_firstCollectableMatId = eActorMaterial.eActorMaterial_Sand.ordinal();
    static int m_lastCollectableMatId = eActorMaterial.eActorMaterial_Clay.ordinal();
    public static eActorMaterial NothingToDrillStep = eActorMaterial.eActorMaterial_Sand;
    public static eActorMaterial UpdateDrillStep01 = eActorMaterial.eActorMaterial_Wood;
    public static eActorMaterial UpdateDrillStep02 = eActorMaterial.eActorMaterial_Gold;
    public static eActorMaterial UpdateDrillStep03 = eActorMaterial.eActorMaterial_Jade;
    static int m_numCollectableMat = m_lastCollectableMatId - m_firstCollectableMatId + 1;
    protected static boolean[] DrillTable = new boolean[m_numCollectableMat];
    protected static boolean bCanDrillAlmostOneThing = false;
    protected int m_specialFlags = eSpecialFlag.eSpecialFlag_None.ordinal();
    protected boolean m_bAlwaysVisible = false;
    protected boolean m_bCanUpdateOwnerBase = true;
    protected boolean m_bCanUpdateBehaviour = true;
    protected boolean m_bDying = false;
    boolean m_bNeedRoundedSorting = false;
    boolean m_bInitialized = false;
    boolean m_bShake = false;
    Vector2 m_shakeOffset = Vector2.Zero();
    float m_savex;
    float m_savey;
    eActorMaterial m_material = eActorMaterial.eActorMaterial_Unknown;
    protected Level m_level = null;
    protected ArrayList<Behaviour> m_rendererBehaviours = null;
    protected ArrayList<Behaviour> m_behaviours = null;
    protected SssGroup m_tmpDeleteLayer = null;
    protected Vector4 m_bboxInit = Vector4.Zero();
    protected Vector4 m_bboxTweak = Vector4.Zero();
    protected float m_scaleTweak = 1.0f;
    protected String m_friendlyName;

    public static boolean DoesFriendlyMaterialNamesContain(String search) {
        int i = 0;
        while (i < FriendlyMaterialNames.length) {
            if (FriendlyMaterialNames[i].equals(search)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean IsBreakable(eActorMaterial _material) {
        boolean bRes = false;
        switch (_material) {
            case eActorMaterial_Obsidian: {
                bRes = false;
                break;
            }
            case eActorMaterial_LevelEnd: {
                bRes = true;
                break;
            }
            case eActorMaterial_Tnt: {
                bRes = true;
                break;
            }
            case eActorMaterial_Clay: {
                bRes = true;
                break;
            }
            default: {
                bRes = _material.ordinal() <= Actor.LastDrillableMatId();
            }
        }
        return bRes;
    }

    public static boolean CanExplodeMaterial(eActorMaterial _material) {
        return _material == eActorMaterial.eActorMaterial_Tnt;
    }

    public static boolean CanFallDependingMaterial(eActorMaterial _material) {
        return _material == eActorMaterial.eActorMaterial_Sand || _material == eActorMaterial.eActorMaterial_Obsidian || _material == eActorMaterial.eActorMaterial_PinkChocolate;
    }

    public static boolean CanSlideDependingMaterial(eActorMaterial _material) {
        return _material == eActorMaterial.eActorMaterial_Ice || _material == eActorMaterial.eActorMaterial_PinkChocolate;
    }

    public static boolean IsConsirededAsGround(eActorMaterial _material) {
        return _material == eActorMaterial.eActorMaterial_Unbreakable || _material == eActorMaterial.eActorMaterial_UnbreakableSlimeSpawn || _material == eActorMaterial.eActorMaterial_UnbreakableAutoAnim;
    }

    public static boolean IsRemovableNotLineParticipating(eActorMaterial _material) {
        return !GameVars.ChocolateBlockCanDoLines() && (_material == eActorMaterial.eActorMaterial_BlackChocolate || _material == eActorMaterial.eActorMaterial_BrownChocolate || _material == eActorMaterial.eActorMaterial_WhiteChocolate || _material == eActorMaterial.eActorMaterial_PinkChocolate);
    }

    public static boolean IsInDrillableRange(eActorMaterial _material) {
        return _material.ordinal() >= m_firstDrillableMatId && _material.ordinal() <= m_lastDrillableMatId;
    }

    public static int FirstDrillableMatId() {
        return m_firstDrillableMatId;
    }

    public static int LastDrillableMatId() {
        return m_lastDrillableMatId;
    }

    public static boolean IsInCollectableRangeHACK(eActorMaterial _material) {
        return _material.ordinal() >= m_firstCollectableMatId && _material.ordinal() <= m_lastCollectableMatId;
    }

    public static int FirstCollectableMatIdHACK() {
        return m_firstCollectableMatId;
    }

    public static int LastCollectableMatIdHACK() {
        return m_lastCollectableMatId;
    }

    public static int NumCollectableMat() {
        return m_numCollectableMat;
    }

    public static boolean CanDrillAlmostOneThing() {
        return bCanDrillAlmostOneThing;
    }

    public boolean hasFlag(eSpecialFlag _flag) {
        return (_flag.getValue() & this.m_specialFlags) > 0;
    }

    public void addFlag(eSpecialFlag _flag) {
        this.m_specialFlags |= _flag.getValue();
    }

    public void removeFlag(eSpecialFlag _flag) {
        this.m_specialFlags &= ~_flag.getValue();
    }

    public boolean AlwaysVisible() {
        return this.m_bAlwaysVisible;
    }

    public void AlwaysVisible(boolean value) {
        this.m_bAlwaysVisible = value;
    }

    public boolean CanUpdateOwnerBase() {
        return this.m_bCanUpdateOwnerBase;
    }

    public void CanUpdateOwnerBase(boolean value) {
        this.m_bCanUpdateOwnerBase = value;
    }

    public boolean CanUpdateBehaviour() {
        return this.m_bCanUpdateBehaviour;
    }

    public void CanUpdateBehaviour(boolean value) {
        this.m_bCanUpdateBehaviour = value;
    }

    public boolean Dying() {
        return this.m_bDying;
    }

    public void Dying(boolean value) {
        this.m_bDying = value;
    }

    public boolean NeedRoundedSorting() {
        return this.m_bNeedRoundedSorting;
    }

    public void NeedRoundedSorting(boolean value) {
        this.m_bNeedRoundedSorting = value;
    }

    public boolean Shake() {
        return this.m_bShake;
    }

    public void Shake(boolean value) {
        this.m_bShake = value;
        if (!this.m_bShake) {
            this.m_shakeOffset = Vector2.Zero();
        }
    }

    public float ShakeX() {
        return this.m_shakeOffset.X;
    }

    public void ShakeX(float value) {
        this.m_shakeOffset.X = value;
    }

    public float ShakeY() {
        return this.m_shakeOffset.Y;
    }

    public void ShakeY(float value) {
        this.m_shakeOffset.Y = value;
    }

    public eActorMaterial Material() {
        return this.m_material;
    }

    public void Material(eActorMaterial value) {
        this.m_material = value;
    }

    public Level Level() {
        return this.m_level;
    }

    public ArrayList<Behaviour> Behaviours() {
        return this.m_behaviours;
    }

    public boolean HasBehaviours() {
        return this.m_behaviours != null && this.m_behaviours.size() > 0;
    }

    public boolean HasBehavioursParams() {
        if (this.HasBehaviours()) {
            for (Behaviour b : this.m_behaviours) {
                if (!b.HasParam()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean HasBehavioursParamsOverride() {
        if (this.HasBehaviours()) {
            for (Behaviour b : this.m_behaviours) {
                if (!b.HasParamOverride()) continue;
                return true;
            }
        }
        return false;
    }

    public int IndexPosX() {
        return (int)(this.x / (float)GameVars.TileStep());
    }

    public void IndexPosX(int value) {
        this.x = value * GameVars.TileStep();
    }

    public int IndexPosY() {
        return (int)((this.y + this.height) / (float)GameVars.TileStep());
    }

    public void IndexPosY(int value) {
        this.y = (float)(value * GameVars.TileStep()) - this.height;
    }

    public SssGroup TmpDeleteLayer() {
        return this.m_tmpDeleteLayer;
    }

    public void TmpDeleteLayer(SssGroup value) {
        this.m_tmpDeleteLayer = value;
    }

    public Vector4 BBoxInit() {
        return this.m_bboxTweak;
    }

    public Vector4 BBoxTweak() {
        return this.m_bboxTweak;
    }

    public float ScaleTweak() {
        return this.m_scaleTweak;
    }

    public String FriendlyName() {
        return this.m_friendlyName;
    }

    public void FriendlyName(String value) {
        this.m_friendlyName = value;
    }

    public Actor() {
    }

    public Actor(FlxSprite _visual) {
        super(_visual);
        this._defaultActorPropertiesInit();
        this._bboxTweakInit();
        this._defaultAnimInit(_visual);
        this.color(_visual.color());
    }

    public Actor(Actor _actor, Level _owner) {
        super(_actor);
        this.m_level = _owner;
        this._defaultActorPropertiesInit();
        if (_actor.HasBehaviours()) {
            for (Behaviour behaviour : _actor.Behaviours()) {
                Behaviour b = BehaviourManager.InstanciateBehaviour(behaviour.Id(), behaviour.Material(), this);
                b.copyParameters(behaviour, _owner != null ? !_owner.PlayableMode() : true);
            }
        }
        this.m_friendlyName = _actor.FriendlyName();
        this._bboxTweakInit();
        this._bboxTweak(_actor);
        this._scaleTweakInit(_actor);
        this._defaultAnimInit(_actor);
    }

    @Override
    public void kill() {
        if (this.dead) {
            return;
        }
        if (this.Behaviours() != null) {
            for (Behaviour behaviour : this.Behaviours()) {
                behaviour.deinit();
            }
        }
        super.kill();
    }

    @Override
    public void destroy() {
        this.kill();
    }

    public void destroyEdit() {
        if (this.dead) {
            return;
        }
        if (this.Behaviours() != null) {
            for (Behaviour behaviour : this.Behaviours()) {
                behaviour.deinitEdit();
            }
        }
        super.kill();
    }

    protected void _defaultAnimInit(FlxSprite _source) {
        if (_source.animations().size() > 0 && _source.CurAnim() != null) {
            this.play(_source.CurAnim().name);
        }
    }

    public static boolean CanMakeDrillParticle(eActorMaterial _material) {
        return Actor.CanBeDrilled(_material) && _material != eActorMaterial.eActorMaterial_Tnt;
    }

    public static boolean CanBeDrilled(eActorMaterial _material) {
        if (GameVars.ChocolateBlockCanBeCollected() && (_material == eActorMaterial.eActorMaterial_WhiteChocolate || _material == eActorMaterial.eActorMaterial_BrownChocolate || _material == eActorMaterial.eActorMaterial_BlackChocolate)) {
            return true;
        }
        if (_material == eActorMaterial.eActorMaterial_Chest || _material == eActorMaterial.eActorMaterial_Workshop || _material == eActorMaterial.eActorMaterial_ChestBTM || _material == eActorMaterial.eActorMaterial_Paint || _material == eActorMaterial.eActorMaterial_PinkChocolate || _material == eActorMaterial.eActorMaterial_BlueChocolate) {
            return true;
        }
        if (_material.ordinal() >= eActorMaterial.eActorMaterial_Sand.ordinal() && _material.ordinal() <= eActorMaterial.eActorMaterial_Wood.ordinal()) {
            return true;
        }
        int id = _material.ordinal() - m_firstCollectableMatId;
        if (DrillTable.length > id) {
            return DrillTable[id];
        }
        return false;
    }

    public static void SetCanBeDrilled(eActorMaterial _material, boolean _value) {
        int id = _material.ordinal() - m_firstCollectableMatId;
        if (id < 0) {
            id = 0;
        }
        if (!_value) {
            int i = 0;
            while (i < id) {
                Actor.DrillTable[i] = true;
                ++i;
            }
            i = id;
            while (i < DrillTable.length) {
                Actor.DrillTable[i] = false;
                ++i;
            }
            GameVars.MaxDrillableMatId(-1);
        } else {
            int i = 0;
            while (i <= id) {
                Actor.DrillTable[i] = true;
                ++i;
            }
            i = id + 1;
            while (i < DrillTable.length) {
                Actor.DrillTable[i] = false;
                ++i;
            }
            GameVars.MaxDrillableMatId(_material.ordinal());
        }
        if (_value) {
            bCanDrillAlmostOneThing = true;
        } else if (_material.ordinal() < UpdateDrillStep01.ordinal()) {
            bCanDrillAlmostOneThing = false;
        }
    }

    protected void _defaultActorPropertiesInit() {
        this.moves = false;
        this.fixed = true;
    }

    public float distanceSquared(Actor _other) {
        float dx = _other.getCenterX() - this.getCenterX();
        float dy = _other.getCenterY() - this.getCenterY();
        return dx * dx + dy * dy;
    }

    public void reinitValueBBoxTweakRelated() {
        this.width = this.m_bboxInit.X;
        this.height = this.m_bboxInit.Y;
        this.offset.X = (int)this.m_bboxInit.Z;
        this.offset.Y = (int)this.m_bboxInit.W;
    }

    public void restaureValueBBoxTweakRelated() {
        this.width = this.m_bboxTweak.X;
        this.height = this.m_bboxTweak.Y;
        this.offset.X = (int)this.m_bboxTweak.Z;
        this.offset.Y = (int)this.m_bboxTweak.W;
    }

    protected void _bboxTweakInit() {
        this.m_bboxTweak.X = this.width;
        this.m_bboxTweak.Y = this.height;
        this.m_bboxTweak.Z = this.offset.X;
        this.m_bboxTweak.W = this.offset.Y;
        this.m_bboxInit.copy(this.m_bboxTweak);
    }

    protected void _bboxTweak(Actor _otherActor) {
        this.m_bboxTweak.copy(_otherActor.BBoxTweak());
        this.width = this.m_bboxTweak.X;
        this.height = this.m_bboxTweak.Y;
        this.offset.X = (int)this.m_bboxTweak.Z;
        this.offset.Y = (int)this.m_bboxTweak.W;
    }

    protected void _scaleTweakInit(Actor _otherActor) {
        this.m_scaleTweak = _otherActor.ScaleTweak();
        this.scale(this.m_scaleTweak);
    }

    public void tweakScale(float _scale) {
        this.m_scaleTweak = _scale;
    }

    public void tweakBoundingBox(int _width, int _height, int _offsetx, int _offsety) {
        this.m_bboxTweak.X = _width;
        this.m_bboxTweak.Y = _height;
        this.m_bboxTweak.Z = _offsetx;
        this.m_bboxTweak.W = _offsety;
    }

    public void createComponents(Level _levelOwner, boolean _bEdit) {
        if (!this.m_bInitialized) {
            Debug.Assert(_levelOwner.equals(this.m_level));
            if (this.m_behaviours != null) {
                for (Behaviour b : this.m_behaviours) {
                    if (_bEdit) {
                        b.initEdit();
                        continue;
                    }
                    b.init();
                }
            }
            this.m_bInitialized = true;
        }
    }

    public Behaviour getBehaviour(String _idBehaviour) {
        Behaviour res = null;
        if (this.m_behaviours != null) {
            for (Behaviour b : this.m_behaviours) {
                if (!b.Id().equals(_idBehaviour)) continue;
                res = b;
                break;
            }
        }
        return res;
    }

    public Behaviour getBehaviour(int _idBehaviourIndex) {
        if (this.m_behaviours != null && this.m_behaviours.size() > _idBehaviourIndex) {
            return this.m_behaviours.get(_idBehaviourIndex);
        }
        return null;
    }

    @Override
    public void update() {
        if (this.m_bCanUpdateBehaviour && this.m_bInitialized && this.m_behaviours != null && this.m_behaviours.size() > 0) {
            for (Behaviour b : this.m_behaviours) {
                b.update();
            }
        }
        if (this.m_bCanUpdateOwnerBase) {
            super.update();
        }
    }

    @Override
    public void render(SpriteBatch spriteBatch) {
        if (this.m_bShake) {
            this.m_savex = this.x;
            this.m_savey = this.y;
            this.x += this.m_shakeOffset.X;
            this.y += this.m_shakeOffset.Y;
        }
        if (this.m_bAlwaysVisible || this.isVisibleOnScreen()) {
            if (this.alpha() > 0.0f) {
                super.render(spriteBatch);
            }
            if (this.m_rendererBehaviours != null) {
                for (Behaviour behaviour : this.m_rendererBehaviours) {
                    behaviour.render(spriteBatch);
                }
            }
        }
        if (this.m_bShake) {
            this.x = this.m_savex;
            this.y = this.m_savey;
        }
    }

    public void renderBase(SpriteBatch spriteBatch) {
        super.render(spriteBatch);
    }

    public void notifyBehavioursParameterChanges() {
        for (Behaviour behaviour : this.m_behaviours) {
            behaviour.onParamsChanged();
        }
    }

    public void addRendererBehaviour(Behaviour _behaviour) {
        if (this.m_rendererBehaviours == null) {
            this.m_rendererBehaviours = new ArrayList();
        }
        this.m_rendererBehaviours.add(_behaviour);
    }

    public void removeRendererBehaviour(Behaviour _behaviour) {
        if (this.m_rendererBehaviours != null) {
            this.m_rendererBehaviours.remove(_behaviour);
        }
    }

    public void addBehaviourObject(Behaviour _behaviour) {
        if (this.m_behaviours == null) {
            this.m_behaviours = new ArrayList();
        }
        this.m_behaviours.add(_behaviour);
    }

    public float getTop() {
        return this.y;
    }

    public float getBottom() {
        return this.y + this.height;
    }

    public float getLeft() {
        return this.x;
    }

    public float getRight() {
        return this.x + this.width;
    }

    public float getRightOffseted() {
        return this.x + this.width + (float)this.offset.X;
    }

    public float getBottomOffseted() {
        return this.y + this.height + (float)this.offset.Y;
    }

    public float getCenterX() {
        return this.x + this.width * 0.5f;
    }

    public float getCenterY() {
        return this.y + this.height * 0.5f;
    }

    public float getRadiusSquared() {
        return (this.width * this.width + this.height * this.height) * 0.5f;
    }

    public void checkCollisions() {
        if (this.m_behaviours.size() > 0) {
            for (Behaviour b : this.m_behaviours) {
                b.checkCollisions();
            }
        }
    }

    protected float _getNormalizedSortIndex() {
        float ix = (this.x + (float)this.offset.X) * GameVars.OneOverTileStep();
        float iy = (this.y + (float)this.offset.Y) * GameVars.OneOverTileStep();
        return 0.0f;
    }

    public int IsoCompare(Actor _other) {
        float dx = _other.getRight() - this.getLeft();
        float dy = _other.getTop() - this.getBottom();
        if (dx <= 0.0f && dy <= 0.0f) {
            return -1;
        }
        return 1;
    }

    public float getLeftRounded() {
        if (this.NeedRoundedSorting()) {
            float l = this.getLeft();
            float modulo = l % 64.0f;
            int div = (int)((l + modulo) / 64.0f);
            return (float)div * 64.0f;
        }
        return this.getLeft();
    }

    public float getTopRounded() {
        if (this.NeedRoundedSorting()) {
            float t = this.getTop() - 32.0f;
            float modulo = t % 64.0f;
            int div = (int)((t + modulo) / 64.0f);
            return (float)div * 64.0f;
        }
        return this.getTop();
    }

    public void handleGenericMessage(eGenericMessage _message, Actor _sender) {
        if (this.m_behaviours != null) {
            for (Behaviour b : this.m_behaviours) {
                b.handleGenericMessage(_message, _sender);
            }
        }
    }

    public String getEditorDescription() {
        String desc = this.m_friendlyName;
        if (this.HasBehaviours()) {
            for (Behaviour b : this.m_behaviours) {
                BehaviourParameter<Object> param;
                desc = String.valueOf(desc) + " [" + b.Id();
                if (b.IntParamsDictionary() != null) {
                    for (Map.Entry<String, BehaviourParameter<Number>> entry : b.IntParamsDictionary().entrySet()) {
                        param = entry.getValue();
                        if (!param.isEditable()) continue;
                        desc = String.valueOf(desc) + " " + entry.getKey() + ":" + param.getValue();
                    }
                }
                if (b.FloatParamsDictionary() != null) {
                    for (Map.Entry<String, BehaviourParameter<Object>> entry : b.FloatParamsDictionary().entrySet()) {
                        param = entry.getValue();
                        if (!param.isEditable()) continue;
                        desc = String.valueOf(desc) + " " + entry.getKey() + ":" + param.getValue();
                    }
                }
                if (b.StringParamsDictionary() != null) {
                    for (Map.Entry<String, BehaviourParameter<Object>> entry : b.StringParamsDictionary().entrySet()) {
                        param = entry.getValue();
                        if (!param.isEditable()) continue;
                        desc = String.valueOf(desc) + " " + entry.getKey() + ":" + (String)param.getValue();
                    }
                }
                desc = String.valueOf(desc) + "]";
            }
        } else {
            desc = String.valueOf(desc) + " [No Component]";
        }
        return desc;
    }

    public Color getEmitterParticuleColor() {
        int type;
        if (this.m_material == eActorMaterial.eActorMaterial_Chest && this.HasBehaviours() && (type = this.m_behaviours.get(0).getIntParameter("chestType")) == 1) {
            return new Color(135, 25, 78);
        }
        return MaterialEnumParticleColorDictionnary.get((Object)this.m_material);
    }

    public static enum eActorMaterial {
        eActorMaterial_Hud_L1,
        eActorMaterial_Hud_L2,
        eActorMaterial_Chest,
        eActorMaterial_ChestBTM,
        eActorMaterial_Sand,
        eActorMaterial_Stone,
        eActorMaterial_Ice,
        eActorMaterial_IronOre,
        eActorMaterial_DiamondOre,
        eActorMaterial_ObsidianOre,
        eActorMaterial_GoldOre,
        eActorMaterial_RubyOre,
        eActorMaterial_JadeOre,
        eActorMaterial_Wood,
        eActorMaterial_Dirt,
        eActorMaterial_Iron,
        eActorMaterial_Gold,
        eActorMaterial_Diamond,
        eActorMaterial_Ruby,
        eActorMaterial_Jade,
        eActorMaterial_Tnt,
        eActorMaterial_Obsidian,
        eActorMaterial_WhiteChocolate,
        eActorMaterial_BrownChocolate,
        eActorMaterial_BlackChocolate,
        eActorMaterial_PinkChocolate,
        eActorMaterial_BlueChocolate,
        eActorMaterial_Clay,
        eActorMaterial_Unknown,
        eActorMaterial_Workshop,
        eActorMaterial_SpawnWorkshop,
        eActorMaterial_Switch,
        eActorMaterial_Door,
        eActorMaterial_Lava,
        eActorMaterial_Player,
        eActorMaterial_Ennemy,
        eActorMaterial_Spawnpoint,
        eActorMaterial_TriggerDialog,
        eActorMaterial_SpawnBackground,
        eActorMaterial_Spawnsound,
        eActorMaterial_Unbreakable,
        eActorMaterial_UnbreakableAutoAnim,
        eActorMaterial_UnbreakableSlimeSpawn,
        eActorMaterial_SlimeDrop,
        eActorMaterial_Threshold,
        eActorMaterial_LevelEnd,
        eActorMaterial_AnimNoiser,
        eActorMaterial_Portal,
        eActorMaterial_Text,
        eActorMaterial_Paint,
        eActorMaterial_COUNT;

    }

    public static enum eGenericMessage {
        eGenericMessage_SlimeDropContact,
        eGenericMessage_SlimeDropBorn,
        eGenericMessage_SlimeDropDie,
        eGenericMessage_BurningBlocContact,
        eGenericMessage_EnnemyWalkContact,
        eGenericMessage_PushToSlide,
        eGenericMessage_Drill,
        eGenericMessage_DrillFake,
        eGenericMessage_TntBlow,
        eGenericMessage_IncrementMaterialStock,
        eGenericMessage_DecrementMaterialStock,
        eGenericMessage_IncrementMaterialStockNeeded,
        eGenericMessage_ResetCollectableNeededCounters,
        eGenericMessage_PlayerRun,
        eGenericMessage_PlayerHitByJump,
        eGenericMessage_BlocStopJump,
        eGenericMessage_BlocRepulsion,
        eGenericMessage_BlocCrush,
        eGenericMessage_BlocRepulsionForced,
        eGenericMessage_EnnemyHitPlayer,
        eGenericMessage_PortalControlPlayerBegin,
        eGenericMessage_PortalControlPlayerEnd,
        eGenericMessage_DialogControlPlayerBegin,
        eGenericMessage_DialogControlPlayerEnd,
        eGenericMessage_OnEditSpawn,
        eGenericMessage_FreezeEnnemy,
        eGenericMessage_UnFreezeEnnemy,
        eGenericMessage_SwitchActivated,
        eGenericMessage_SwitchDeactivated,
        eGenericMessage_SwitchCountIncrease,
        eGenericMessage_DoorBaseInit,
        eGenericMessage_DoorBlocShow,
        eGenericMessage_DoorBlocHide,
        eGenericMessage_BigSlimeDestroy,
        eGenericMessage_PutToSleep,
        eGenericMessage_UpdateLevelStats,
        eGenericMessage_GoToNextLevelGeneric,
        eGenericMessage_GoToNextLevelInUniverse,
        eGenericMessage_GoToPreviousLevelInUniverse,
        eGenericMessage_RestartLevel,
        eGenericMessage_BTMGrabed,
        eGenericMessage_DrillBreakStep1,
        eGenericMessage_DrillBreakStep2,
        eGenericMessage_DrillBreakStep3,
        eGenericMessage_DisplayLevelResults,
        eGenericMessage_Kaboom,
        eGenericMessage_UpdateUpgrade,
        eGenericMessage_ValidateUpgrade,
        eGenericMessage_PuzzleModeEnter,
        eGenericMessage_PuzzleModeLeave,
        eGenericMessage_PuzzleModeExplode,
        eGenericMessage_DoorObstructed,
        eGenericMessage_RequestLookAtWithCallback,
        eGenericMessage_LookAtCallback,
        eGenericMessage_LookAtGiveBack,
        eGenericMessage_WorkshopShowOpeningEnd,
        eGenericMessage_BigJump,
        eGenericMessage_ActorInitDefaultColor,
        eGenericMessage_EatingBlocContact;

    }

    public static enum eSpecialFlag {
        eSpecialFlag_None(0),
        eSpecialFlag_PassiveIso(1),
        eSpecialFlag_InALine(2),
        eSpecialFlag_MustBlink(4),
        eSpecialFlag_Occupied(8),
        eSpecialFlag_AvoidStainColor(16),
        eSpecialFlag_NotRenderedYet(32),
        eSpecialFlag_AlignedWithGrid(64),
        eSpecialFlag_RenderOverall(128),
        eSpecialFlag_GroundToBeRemoved(256),
        eSpecialFlag_GroundToBeRecomputed(512),
        eSpecialFlag_MarkAsDestroyed(1024),
        eSpecialFlag_NoCollidePhysic(2048),
        eSpecialFlag_Falling(4096),
        eSpecialFlag_LastActorInALine(8192),
        eSpecialFlag_FallBlockedByPlayer(16384);

        private final int id;

        private eSpecialFlag(int id) {
            this.id = id;
        }

        public int getValue() {
            return this.id;
        }
    }
}

