/*
 * Decompiled with CFR 0.152.
 */
package SSS.BTM;

import Java.Tricks.ref;
import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Graphics.Texture2D;
import Microsoft.Xna.Framework.Input.Buttons;
import Microsoft.Xna.Framework.Vector2;
import SSS.Actor;
import SSS.BTM.GameMode;
import SSS.BTM.GameVars;
import SSS.Behaviours.BTM.PlayerBehaviour;
import SSS.Events.CallbackSimple;
import SSS.Level;
import SSS.Managers.BTM.AchievementManager;
import SSS.Managers.BTM.BlocksSoundsManager;
import SSS.Managers.BTM.LevelDataBase;
import SSS.Managers.BTM.LevelGroup;
import SSS.Managers.BTM.LevelInfo;
import SSS.Managers.BTM.TextDataBase;
import SSS.Managers.LoginManager;
import SSS.Managers.MusicManager;
import SSS.Tween.TweenManager;
import SSS.Tween.Tweenable;
import SSS.Util.InputManager;
import SSS.Util.MultipleLinesText;
import SSS.Util.Utility;
import java.util.Arrays;
import org.flixel.FlxG;
import org.flixel.FlxGroup;
import org.flixel.FlxSprite;
import org.flixel.FlxText;

public class CollectedMaterialHud {
    static float TextShadowOffset = 2.0f;
    static Color ColorTetrominoCounterRegularText = new Color(220, 220, 220);
    static Color ColorRegularText = new Color(254, 211, 8);
    static Color ColorGreenText = new Color(30, 255, 52);
    static Color ColorRedText = new Color(254, 31, 49);
    static Color ColorLBRBText = new Color(197, 135, 244);
    static float TetrominosTextOffsetX = -12.0f;
    static float TetrominosTextOffsetY = -22.0f;
    static float TetrominosIconOffsetX = -5.0f;
    static float TetrominosIconOffsetY = 32.0f;
    eHudState m_hudState = eHudState.eHudState_InGame;
    eDisplayingResultState m_resultState = eDisplayingResultState.eDisplayingResultState_Begin;
    eDocking m_docking = eDocking.eDocking_Down;
    static final float HudAlpha = 0.2f;
    FlxSprite m_hudY;
    FlxSprite m_hud_Y_Alone;
    static float m_hud_Y_Alone_offsetx = -33.0f;
    static float m_hud_Y_Alone_offsety = -28.0f;
    FlxText m_hud_Y_AloneKeyText = null;
    Color m_hud_Y_AloneKeyTextColor = new Color(255, 210, 0);
    FlxSprite m_hudX_LT;
    FlxSprite m_hud_LT_Alone;
    static float m_hud_LT_Alone_offsetx = -37.0f;
    static float m_hud_LT_Alone_offsety = -28.0f;
    FlxText m_hud_LT_AloneKeyText = null;
    Color m_hud_LT_AloneKeyTextColor = new Color(191, 191, 191);
    FlxSprite m_hud_X_Alone;
    static float m_hud_X_Alone_offsetx = -36.0f;
    static float m_hud_X_Alone_offsety = -28.0f;
    FlxText m_hud_X_AloneKeyText = null;
    Color m_hud_X_AloneKeyTextColor = new Color(34, 159, 255);
    FlxSprite m_hudA;
    FlxSprite m_hud_A_Alone;
    static float m_hud_A_Alone_offsetx = -33.0f;
    static float m_hud_A_Alone_offsety = -28.0f;
    FlxText m_hud_A_AloneKeyText = null;
    Color m_hud_A_AloneKeyTextColor = new Color(30, 255, 51);
    FlxSprite m_hudB;
    FlxSprite m_hud_B_Alone;
    static float m_hud_B_Alone_offsetx = -33.0f;
    static float m_hud_B_Alone_offsety = -28.0f;
    FlxText m_hud_B_AloneKeyText = null;
    Color m_hud_B_AloneKeyTextColor = new Color(255, 53, 13);
    FlxSprite m_hudTetromino;
    FlxText m_hudTetrominoText;
    ref<FlxText> m_refText = new ref<Object>(null);
    boolean m_bAnyGamePad = false;
    FlxSprite m_hudChestBTM = null;
    boolean m_bCanRefreshHudPar = true;
    FlxGroup m_hudParGroup = null;
    FlxSprite m_hudStarPAR = null;
    FlxText m_txtHudStarPAR_currentBlocNum = null;
    int m_parCurValue = 0;
    int m_parBestValue = 0;
    int m_parTargetValue = 99;
    boolean m_parAlreadyDone = false;
    float HudStarPARscale = 0.22f;
    float HudStarPARTextTopOffsetPercX = 0.9f;
    float HudStarPARTextTopOffsetPercY = -0.5f;
    float HudStarPARTextBotOffsetPercX = 0.9f;
    float HudStarPARTextBotOffsetPercY = 0.4f;
    Vector2 m_chestPositionMoveBegin = Vector2.Zero();
    Vector2 m_chestPositionMoveEnd = Vector2.Zero();
    static float ShowResultChestPosPercX = 0.5f;
    static float ShowResultChestPosPercY = 0.5f;
    boolean m_bUseScaleAnim = false;
    FlxSprite m_hudStarPARBackground = null;
    FlxSprite m_hudStarPARForeground = null;
    float m_scalePAR = 0.0f;
    float m_scalePARstep;
    int m_numShakeLeft = 0;
    int m_numShakePar = 0;
    float m_timeShake = 0.0f;
    boolean m_bGreenStar = false;
    int m_numShake = 0;
    float m_scaleTimeBeg = 0.2f;
    float m_scaleTimeEnd = 0.14f;
    float m_scaleTimeOverPar = 0.05f;
    boolean m_bWaitForKeyPAR = false;
    float m_colorGrayBeg = 0.19f;
    float m_colorGrayLerp = 0.1f;
    float m_colorGrayEnd = 1.0f;
    FlxSprite m_hudBackgroundPAR = null;
    FlxSprite m_hudForegroundPAR = null;
    FlxSprite m_hudBackgroundBTM = null;
    FlxSprite m_hudBTM = null;
    FlxText m_txtCongratz;
    FlxText m_txtInfo;
    FlxText m_txtPress;
    MultipleLinesText m_txtTM;
    MultipleLinesText m_txtCongratzPAR;
    FlxText m_txtPressPAR;
    FlxSprite m_perfectCircle = null;
    FlxSprite m_frame = null;
    boolean m_bBTM_alreadyFound = false;
    FlxSprite[] m_arrows = new FlxSprite[4];
    Color m_unvailableColor = Color.Black();
    int m_firstMatId = 0;
    int m_lastMatId = 0;
    int m_numMat = 0;
    int m_numMatVisible = 0;
    boolean m_bWaitForKeyDisplayBTMDone = false;
    boolean m_bDisplayResultBTMDone = false;
    boolean m_bWaitForKeyDisplayPARDone = false;
    boolean m_bDisplayResultPARDone = false;
    Actor[] m_iconMat = null;
    FlxSprite[] m_backgroundBlocbar = null;
    FlxText[] m_txtCounter = null;
    int[] m_valueTxtCounter;
    FlxText[] m_txtCounterNeeded = null;
    int[] m_valueTxtCounterNeeded;
    FlxText m_txt_LB = null;
    FlxText m_txt_RB = null;
    FlxGroup m_layer;
    PlayerBehaviour m_contoller = null;
    float m_widthPercentage = 0.5f;
    float m_bottomMarginPercentage = 0.005f;
    boolean m_bVisible = false;
    protected CallbackSimple m_PARCallbackScaleStepDone = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            CollectedMaterialHud.this._scaleStepDone(0.0f);
        }
    };
    protected CallbackSimple m_PARCallbackDone = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            CollectedMaterialHud.this._parDone();
        }
    };
    CallbackSimple m_tweenShowResultDone = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            CollectedMaterialHud.this._tweenShowResultDone(_sender, _args);
        }
    };

    public boolean DisplayResultBTMDone() {
        return this.m_bDisplayResultBTMDone;
    }

    public boolean DisplayResultPARDone() {
        return this.m_bDisplayResultBTMDone;
    }

    public CollectedMaterialHud(PlayerBehaviour _contoller, FlxGroup _layer) {
        this.m_contoller = _contoller;
        if (this.m_contoller.Level().PlayableMode()) {
            this.m_firstMatId = Actor.FirstCollectableMatIdHACK();
            this.m_lastMatId = Actor.LastCollectableMatIdHACK();
            this.m_numMat = Actor.NumCollectableMat();
            this.m_layer = _layer;
            this._buildBackgrounds();
            this._buildIcons();
            this._buildTexts();
            this._updateNumMatVisibleCount();
            this._buildShowResultsStuff();
            this._orderIcons();
            this._buildCursor();
            this.hide();
            this.enterNewMode(PlayerBehaviour.ePlayerMode.ePlayerMode_Move);
        }
    }

    protected void _buildShowResultsStuff() {
        this.m_hudChestBTM = this.m_contoller.Level().instanciateSprite("chestBTMBlocSprite");
        this.m_hudChestBTM.play("idle");
        this.m_hudChestBTM.scrollFactor = Vector2.Zero();
        this.m_hudChestBTM.visible = false;
        this.m_chestPositionMoveBegin.X = this.m_hudChestBTM.x + this.m_hudChestBTM.width * this.m_hudChestBTM.scale() * 0.5f;
        this.m_chestPositionMoveBegin.Y = this.m_hudChestBTM.y + this.m_hudChestBTM.height * this.m_hudChestBTM.scale() * 0.5f;
        this.m_chestPositionMoveEnd.X = (float)FlxG.width * 0.5f;
        this.m_chestPositionMoveEnd.Y = (float)FlxG.height * 0.5f;
        LevelInfo li = LevelDataBase.Instance().getLevelInfo(this.m_contoller.Level());
        if (li != null) {
            LevelGroup lg;
            this.m_bBTM_alreadyFound = li.BTMFound();
            this.m_hudBTM = new FlxSprite(li.BTM().RevealedRepresentation());
            this.m_hudBTM.play(li.BTM().FoundAnimId());
            this.m_hudBTM.visible = false;
            this.m_parTargetValue = li.ParToReachValue();
            if (li.Done() && (lg = this.m_contoller.Level().Group()) != null && lg.Flag() == LevelGroup.eSpecialFlag.None && li.BTMFound()) {
                this._initializeHudPar(li.ParDone(), li.ParBestValue(), li.ParToReachValue());
            }
        } else {
            FlxSprite customSprite = null;
            if (GameVars.GameCommunityMode() && this.m_contoller.Level().Mode() == Level.eLevelMode.eLevelMode_Play) {
                Texture2D t2d = null;
                t2d = GameVars.GameMode() == GameMode.GameMode_LocalLevelEditor ? FlxG.Content().LoadTexture2D("btm", "Community/MyWorkspace/" + GameVars.LastCommunityEditLevelFolderName()) : FlxG.Content().LoadTexture2D("btm", "Community/CommunityLevels/" + GameVars.LastCommunityPlayedLevelArchiveName() + ".btm");
                if (t2d != null) {
                    customSprite = new FlxSprite();
                    customSprite.loadGraphic(t2d);
                }
            }
            if (customSprite == null) {
                this.m_hudBTM = this.m_contoller.Level().instanciateSprite("chestBTMBlocSprite");
                this.m_hudBTM.play("idle");
            } else {
                this.m_hudBTM = customSprite;
            }
        }
        this.m_hudBTM.scrollFactor = Vector2.Zero();
        this.m_perfectCircle = new FlxSprite();
        this.m_perfectCircle.loadGraphic(FlxG.Content().LoadTexture2D("sss/textures/menus/menu_perfect"));
        this.m_perfectCircle.visible = false;
        this.m_perfectCircle.scrollFactor = Vector2.Zero();
        this.m_perfectCircle.alpha(0.0f);
        this.m_frame = new FlxSprite();
        this.m_frame.loadGraphic(FlxG.Content().LoadTexture2D("sss/textures/menus/menu_cadre"));
        this.m_frame.visible = false;
        this.m_frame.scrollFactor = Vector2.Zero();
        this.m_frame.alpha(0.0f);
        this.m_hudBackgroundBTM = new FlxSprite();
        this.m_hudBackgroundBTM.createGraphic(FlxG.width + 2, FlxG.height + 2, Color.Black());
        this.m_hudBackgroundBTM.scrollFactor = Vector2.Zero();
        this.m_hudBackgroundBTM.UseRounding(false);
        this.m_hudBackgroundBTM.visible = false;
        this.m_hudBackgroundBTM.alpha(0.0f);
        this.m_hudForegroundPAR = new FlxSprite();
        this.m_hudForegroundPAR.createGraphic(FlxG.width + 2, FlxG.height + 2, Color.Black());
        this.m_hudForegroundPAR.scrollFactor = Vector2.Zero();
        this.m_hudForegroundPAR.UseRounding(false);
        this.m_hudForegroundPAR.visible = false;
        this.m_hudForegroundPAR.alpha(0.0f);
        this.m_hudChestBTM.x = 0.0f;
        this.m_hudChestBTM.y = (float)FlxG.height - this.m_hudChestBTM.height;
        this.m_hudBTM.x = this.m_hudChestBTM.x + this.m_hudChestBTM.width * 0.5f - this.m_hudBTM.width * 0.5f;
        this.m_hudBTM.y = this.m_hudChestBTM.y + this.m_hudChestBTM.height * 0.5f - this.m_hudBTM.height * 0.5f;
        this.m_hudBTM.scale(this.m_hudChestBTM.width / this.m_hudBTM.width);
        this._positionnateHudPar();
        this._refreshHudPar(true);
        this.m_txtCongratz = new FlxText(0.0f, 0.0f, FlxG.width);
        this.m_txtCongratz.visible = false;
        this.m_txtInfo = new FlxText(0.0f, 0.0f, FlxG.width);
        this.m_txtInfo.visible = false;
        this.m_txtPress = new FlxText(0.0f, 0.0f, FlxG.width);
        this.m_txtPress.visible = false;
        this.m_txtTM = new MultipleLinesText();
        this.m_txtTM.initAttributes("", Color.White(), (float)FlxG.width * 0.5f, (float)FlxG.height * 0.95f, 1.0f, 1.0f, 1.0f);
        this.m_txtTM.scrollFactor = Vector2.Zero();
        this.m_txtTM.visible = false;
        this.m_txtCongratzPAR = new MultipleLinesText();
        this.m_txtCongratzPAR.Justification(FlxText.FlxJustification.Center);
        this.m_txtCongratzPAR.visible = false;
        this.m_txtPressPAR = new FlxText(0.0f, 0.0f, FlxG.width);
        this.m_txtPressPAR.visible = false;
        this.m_layer.add(this.m_txtCongratzPAR);
        this.m_layer.add(this.m_txtPressPAR);
        this.m_layer.add(this.m_hudForegroundPAR);
        this.m_hudParGroup = new FlxGroup();
        this.m_layer.add(this.m_hudParGroup);
        this._registerHudPar();
        this.m_layer.add(this.m_hudBackgroundBTM);
        this.m_layer.add(this.m_perfectCircle);
        this.m_layer.add(this.m_hudChestBTM);
        this.m_layer.add(this.m_hudBTM);
        this.m_layer.add(this.m_txtCongratz);
        this.m_layer.add(this.m_txtInfo);
        this.m_layer.add(this.m_txtPress);
        this.m_layer.add(this.m_frame);
        this.m_layer.add(this.m_txtTM);
    }

    public void initializeCustomPar(int _customPar) {
        if (_customPar > 0 && this.m_hudStarPAR == null) {
            this.m_parTargetValue = _customPar;
            this._initializeHudPar(false, 0, this.m_parTargetValue);
            this._registerHudPar();
            this._positionnateHudPar();
        }
    }

    protected void _registerHudPar() {
        if (this.m_hudStarPAR != null) {
            this.m_hudParGroup.add(this.m_hudStarPAR);
            this.m_hudParGroup.add(this.m_txtHudStarPAR_currentBlocNum);
        }
    }

    protected void _initializeHudPar(boolean _parAlreadyDone, int _parBestValue, int _parToReachValue) {
        this.m_hudStarPAR = new FlxSprite();
        this.m_hudStarPAR.loadGraphic(FlxG.Content().LoadTexture2D("sss/textures/menus/Star_big"));
        this.m_hudStarPAR.scrollFactor = Vector2.Zero();
        this.m_hudStarPAR.visible = true;
        this.m_hudStarPAR.scale(this.HudStarPARscale);
        this.m_hudStarPAR.color(new Color(this.m_colorGrayBeg, this.m_colorGrayBeg, this.m_colorGrayBeg));
        this.m_txtHudStarPAR_currentBlocNum = new FlxText(0.0f, 0.0f, 50.0f);
        this.m_txtHudStarPAR_currentBlocNum.UseShadow(true);
        this.m_txtHudStarPAR_currentBlocNum.scale(2.0f);
        this.m_txtHudStarPAR_currentBlocNum.alignment = FlxText.FlxJustification.Center;
        this.m_txtHudStarPAR_currentBlocNum.text(Utility.ArrayStringDigit[0]);
        this.m_txtHudStarPAR_currentBlocNum.ShadowOffset(TextShadowOffset);
        this.m_txtHudStarPAR_currentBlocNum.color(ColorTetrominoCounterRegularText);
        this.m_txtHudStarPAR_currentBlocNum.visible = true;
        this.m_parAlreadyDone = _parAlreadyDone;
        int n = this.m_parBestValue = this.m_parAlreadyDone ? _parBestValue : _parToReachValue;
        if (this.m_parBestValue > 99) {
            this.m_parBestValue = 99;
        }
    }

    protected void _positionnateHudPar() {
        if (this.m_hudStarPAR != null) {
            this.m_hudStarPAR.x = this.m_hudChestBTM.x + this.m_hudChestBTM.width * 0.5f - this.m_hudStarPAR.width * 0.5f;
            this.m_hudStarPAR.y = this.m_hudChestBTM.y + this.m_hudChestBTM.height * 0.5f - this.m_hudStarPAR.height * 0.5f;
            if (this.m_hudChestBTM.visible || this.m_hudBTM.visible) {
                this.m_hudStarPAR.x += this.m_hudChestBTM.width * this.m_hudChestBTM.scale();
            }
            float cx = this.m_hudStarPAR.x + this.m_hudStarPAR.width * 0.5f;
            float cy = this.m_hudStarPAR.y + this.m_hudStarPAR.height * 0.5f;
            float realW = this.m_hudStarPAR.width * this.HudStarPARscale;
            float realH = this.m_hudStarPAR.height * this.HudStarPARscale;
            this.m_txtHudStarPAR_currentBlocNum.x = cx + 0.5f * realW * this.HudStarPARTextTopOffsetPercX - this.m_txtHudStarPAR_currentBlocNum.width * 0.5f;
            this.m_txtHudStarPAR_currentBlocNum.y = cy + 0.5f * realH * this.HudStarPARTextBotOffsetPercY - this.m_txtHudStarPAR_currentBlocNum.height * 0.5f;
        }
    }

    protected void _refreshHudPar(boolean _bForce) {
        if (this.m_hudStarPAR != null && this.m_bCanRefreshHudPar) {
            int curLeft = this.m_contoller.NumCollectableLeft();
            if (_bForce || this.m_parCurValue != curLeft) {
                int oldCur = this.m_parCurValue;
                this.m_parCurValue = curLeft;
                if (this.m_parCurValue > 99) {
                    this.m_parCurValue = 99;
                }
                this.m_txtHudStarPAR_currentBlocNum.text(Utility.ArrayStringDigit[this.m_parCurValue]);
                boolean bounce = false;
                if (this.m_parAlreadyDone) {
                    if (this.m_parCurValue > this.m_parTargetValue) {
                        this.m_hudStarPAR.color().change(0.0f, 1.0f, 0.0f);
                        if (oldCur == this.m_parTargetValue) {
                            bounce = true;
                        }
                    } else {
                        this.m_hudStarPAR.color().change(1.0f, 1.0f, 1.0f);
                        if (oldCur > this.m_parTargetValue) {
                            bounce = true;
                        }
                    }
                    this.m_hudStarPAR.alpha(1.0f);
                } else if (this.m_parCurValue > this.m_parBestValue && oldCur <= this.m_parBestValue) {
                    this.m_hudStarPAR.color().change(0.0f, 1.0f, 0.0f);
                    bounce = true;
                } else if (this.m_parCurValue >= this.m_parBestValue && oldCur <= this.m_parBestValue) {
                    this.m_hudStarPAR.color().change(1.0f, 1.0f, 1.0f);
                    bounce = true;
                } else if (this.m_parCurValue < this.m_parBestValue) {
                    this.m_hudStarPAR.color().change(0.3f, 0.3f, 0.3f);
                    this.m_hudStarPAR.alpha(0.5f);
                }
                if (bounce) {
                    this.m_hudStarPAR.scale(this.HudStarPARscale * 2.8f);
                    this.m_contoller.Level().TweenManager().ToScale((Tweenable)this.m_hudStarPAR, new Vector2(this.HudStarPARscale), 3.0f, TweenManager.EaseType.EASE_OUTBOUNCE, 0.0f, (CallbackSimple)null);
                    this.m_hudStarPAR.alpha(0.5f);
                    this.m_contoller.Level().TweenManager().ToAlpha((Tweenable)this.m_hudStarPAR, 1.0f, 1.0f, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
                }
            }
        }
    }

    protected void _buildBackgrounds() {
        this.m_hudBackgroundPAR = new FlxSprite();
        this.m_hudBackgroundPAR.createGraphic(FlxG.width + 2, FlxG.height + 2, Color.Black());
        this.m_hudBackgroundPAR.scrollFactor = Vector2.Zero();
        this.m_hudBackgroundPAR.UseRounding(false);
        this.m_hudBackgroundPAR.visible = false;
        this.m_hudBackgroundPAR.alpha(0.0f);
        this.m_layer.add(this.m_hudBackgroundPAR);
        this.m_hudStarPARBackground = new FlxSprite();
        this.m_hudStarPARBackground.loadGraphic(FlxG.Content().LoadTexture2D("sss/textures/menus/Star_big"));
        this.m_hudStarPARBackground.scrollFactor = Vector2.Zero();
        this.m_hudStarPARBackground.x = (float)FlxG.width * 0.5f - this.m_hudStarPARBackground.width * 0.5f;
        this.m_hudStarPARBackground.y = (float)FlxG.height * 0.5f - this.m_hudStarPARBackground.height * 0.5f;
        this.m_hudStarPARBackground.visible = false;
        this.m_hudStarPARBackground.alpha(0.0f);
        int lvlGray = 50;
        this.m_hudStarPARBackground.color(new Color(lvlGray, lvlGray, lvlGray));
        this.m_layer.add(this.m_hudStarPARBackground);
        this.m_hudStarPARForeground = new FlxSprite();
        this.m_hudStarPARForeground.loadGraphic(FlxG.Content().LoadTexture2D("sss/textures/menus/Star_big"));
        this.m_hudStarPARForeground.scrollFactor = Vector2.Zero();
        this.m_hudStarPARForeground.x = (float)FlxG.width * 0.5f - this.m_hudStarPARForeground.width * 0.5f;
        this.m_hudStarPARForeground.y = (float)FlxG.height * 0.5f - this.m_hudStarPARForeground.height * 0.5f;
        this.m_hudStarPARForeground.visible = false;
        this.m_hudStarPARForeground.alpha(0.0f);
        this.m_layer.add(this.m_hudStarPARForeground);
        this.m_backgroundBlocbar = new FlxSprite[this.m_numMat];
        int i = 0;
        while (i < this.m_backgroundBlocbar.length) {
            FlxSprite bg = this.m_contoller.Level().instanciateSprite("blocbar");
            this.m_layer.add(bg, true);
            this.m_backgroundBlocbar[i] = bg;
            ++i;
        }
    }

    protected void _buildCursor() {
    }

    protected void _buildIcons() {
        this.m_iconMat = new Actor[this.m_numMat];
        int i = 0;
        while (i < this.m_iconMat.length) {
            Actor actor = this.m_contoller.Level().instanciateActor(this.m_contoller.getBlocActorId(i));
            this.m_layer.add(actor, true);
            actor.reinitValueBBoxTweakRelated();
            this.m_iconMat[i] = actor;
            ++i;
        }
        float margin = 10.0f;
        this.m_hudY = this.m_contoller.Level().instanciateSprite("HUD_sheet");
        this.m_hudX_LT = this.m_contoller.Level().instanciateSprite("HUD_sheet");
        this.m_hudA = this.m_contoller.Level().instanciateSprite("HUD_sheet");
        this.m_hudB = this.m_contoller.Level().instanciateSprite("HUD_sheet");
        this.m_hud_LT_Alone = this.m_contoller.Level().instanciateSprite("buttons_plalette2");
        this.m_hud_LT_Alone.play("XBOX_LT");
        this.m_hud_X_Alone = this.m_contoller.Level().instanciateSprite("buttons_plalette");
        this.m_hud_X_Alone.play("XBOX_X");
        this.m_hud_Y_Alone = this.m_contoller.Level().instanciateSprite("buttons_plalette");
        this.m_hud_Y_Alone.play("XBOX_Y");
        this._buildTextKey(this.m_refText, Buttons.Y);
        this.m_hud_Y_AloneKeyText = this.m_refText.get();
        this._buildTextKey(this.m_refText, Buttons.LeftTrigger);
        this.m_hud_LT_AloneKeyText = this.m_refText.get();
        this._buildTextKey(this.m_refText, Buttons.X);
        this.m_hud_X_AloneKeyText = this.m_refText.get();
        this._buildTextKey(this.m_refText, Buttons.A);
        this.m_hud_A_AloneKeyText = this.m_refText.get();
        this._buildTextKey(this.m_refText, Buttons.B);
        this.m_hud_B_AloneKeyText = this.m_refText.get();
        this.m_hud_A_Alone = this.m_contoller.Level().instanciateSprite("buttons_plalette");
        this.m_hud_A_Alone.play("XBOX_A");
        this.m_hud_B_Alone = this.m_contoller.Level().instanciateSprite("buttons_plalette");
        this.m_hud_B_Alone.play("XBOX_B");
        int i2 = 0;
        while (i2 < this.m_arrows.length) {
            this.m_arrows[i2] = this.m_contoller.Level().instanciateSprite("look_arrow");
            this.m_arrows[i2].scrollFactor = Vector2.Zero();
            this.m_arrows[i2].visible = false;
            this.m_layer.add(this.m_arrows[i2]);
            ++i2;
        }
        this.m_hudY.scrollFactor = Vector2.Zero();
        this.m_hudX_LT.scrollFactor = Vector2.Zero();
        this.m_hudA.scrollFactor = Vector2.Zero();
        this.m_hudB.scrollFactor = Vector2.Zero();
        this.m_hud_LT_Alone.scrollFactor = Vector2.Zero();
        this.m_hud_X_Alone.scrollFactor = Vector2.Zero();
        this.m_hud_Y_Alone.scrollFactor = Vector2.Zero();
        this.m_hud_A_Alone.scrollFactor = Vector2.Zero();
        this.m_hud_B_Alone.scrollFactor = Vector2.Zero();
        this.m_hudX_LT.x = 10.0f;
        this.m_hudX_LT.y = 10.0f;
        this.m_hud_LT_Alone.x = this.m_hudX_LT.x + this.m_hudX_LT.width - this.m_hud_LT_Alone.width * 0.5f + m_hud_LT_Alone_offsetx;
        this.m_hud_LT_Alone.y = this.m_hudX_LT.y + this.m_hudX_LT.height - this.m_hud_LT_Alone.height * 0.5f + m_hud_LT_Alone_offsety;
        this.m_hud_LT_AloneKeyText.x = this.m_hud_LT_Alone.x + 5.0f;
        this.m_hud_LT_AloneKeyText.y = this.m_hud_LT_Alone.y;
        this.m_hud_X_Alone.x = this.m_hudX_LT.x + this.m_hudX_LT.width - this.m_hud_X_Alone.width * 0.5f + m_hud_X_Alone_offsetx;
        this.m_hud_X_Alone.y = this.m_hudX_LT.y + this.m_hudX_LT.height - this.m_hud_X_Alone.height * 0.5f + m_hud_X_Alone_offsety;
        this.m_hud_X_AloneKeyText.x = this.m_hud_X_Alone.x;
        this.m_hud_X_AloneKeyText.y = this.m_hud_X_Alone.y;
        this.m_hudY.x = (float)FlxG.width - this.m_hudY.width - 10.0f;
        this.m_hudY.y = 10.0f;
        this.m_hud_Y_Alone.x = this.m_hudY.x + this.m_hudY.width - this.m_hud_Y_Alone.width * 0.5f + m_hud_Y_Alone_offsetx;
        this.m_hud_Y_Alone.y = this.m_hudY.y + this.m_hudY.height - this.m_hud_Y_Alone.height * 0.5f + m_hud_Y_Alone_offsety;
        this.m_hud_Y_AloneKeyText.x = this.m_hud_Y_Alone.x;
        this.m_hud_Y_AloneKeyText.y = this.m_hud_Y_Alone.y;
        this.m_hudB.x = (float)FlxG.width - this.m_hudB.width - 10.0f;
        this.m_hudB.y = (float)FlxG.height - this.m_hudB.height - 10.0f;
        this.m_hud_B_Alone.x = this.m_hudB.x + this.m_hudB.width - this.m_hud_B_Alone.width * 0.5f + m_hud_B_Alone_offsetx;
        this.m_hud_B_Alone.y = this.m_hudB.y + this.m_hudB.height - this.m_hud_B_Alone.height * 0.5f + m_hud_B_Alone_offsety;
        this.m_hud_B_AloneKeyText.x = this.m_hud_B_Alone.x;
        this.m_hud_B_AloneKeyText.y = this.m_hud_B_Alone.y;
        this.m_hudA.x = this.m_hudB.x - this.m_hudA.width - this.m_hudA.width * 0.25f;
        this.m_hudA.y = this.m_hudB.y;
        this.m_hud_A_Alone.x = this.m_hudA.x + this.m_hudA.width - this.m_hud_A_Alone.width * 0.5f + m_hud_A_Alone_offsetx;
        this.m_hud_A_Alone.y = this.m_hudA.y + this.m_hudA.height - this.m_hud_A_Alone.height * 0.5f + m_hud_A_Alone_offsety;
        this.m_hud_A_AloneKeyText.x = this.m_hud_A_Alone.x;
        this.m_hud_A_AloneKeyText.y = this.m_hud_A_Alone.y;
        FlxSprite arrow = this.m_arrows[0];
        arrow.x = (float)FlxG.width * 0.5f - arrow.width * 0.5f;
        arrow.y = 0.0f;
        arrow = this.m_arrows[1];
        arrow.x = (float)FlxG.width * 0.5f - arrow.width * 0.5f;
        arrow.y = (float)FlxG.height - arrow.height;
        arrow.angle(180.0f);
        arrow = this.m_arrows[2];
        arrow.x = 0.0f;
        arrow.y = (float)FlxG.height * 0.5f - arrow.height * 0.5f;
        arrow.angle(-90.0f);
        arrow = this.m_arrows[3];
        arrow.x = (float)FlxG.width - arrow.width;
        arrow.y = (float)FlxG.height * 0.5f - arrow.height * 0.5f;
        arrow.angle(90.0f);
        this.m_layer.add(this.m_hudY);
        this.m_layer.add(this.m_hudX_LT);
        this.m_layer.add(this.m_hudA);
        this.m_layer.add(this.m_hudB);
        this.m_layer.add(this.m_hud_LT_Alone);
        this.m_layer.add(this.m_hud_X_Alone);
        this.m_layer.add(this.m_hud_Y_Alone);
        this.m_layer.add(this.m_hud_A_Alone);
        this.m_layer.add(this.m_hud_B_Alone);
        this.m_layer.add(this.m_hud_Y_AloneKeyText);
        this.m_layer.add(this.m_hud_X_AloneKeyText);
        this.m_layer.add(this.m_hud_LT_AloneKeyText);
        this.m_layer.add(this.m_hud_B_AloneKeyText);
        this.m_layer.add(this.m_hud_A_AloneKeyText);
        this.m_hudY.visible = false;
        this.m_hudX_LT.visible = false;
        this.m_hudA.visible = false;
        this.m_hudB.visible = false;
        this.m_hud_LT_Alone.visible = false;
        this.m_hud_X_Alone.visible = false;
        this.m_hud_Y_Alone.visible = false;
        this.m_hud_A_Alone.visible = false;
        this.m_hud_B_Alone.visible = false;
        this.m_hud_Y_AloneKeyText.visible = false;
        this.m_hud_X_AloneKeyText.visible = false;
        this.m_hud_LT_AloneKeyText.visible = false;
        this.m_hud_B_AloneKeyText.visible = false;
        this.m_hud_A_AloneKeyText.visible = false;
        this.m_hudTetromino = this.m_contoller.Level().instanciateSprite("tetrominos");
        this.m_hudTetromino.visible = false;
        this.m_hudTetromino.scrollFactor = Vector2.Zero();
        this.m_hudTetrominoText = new FlxText(0.0f, 0.0f, 50.0f);
        this.m_hudTetrominoText.UseShadow(true);
        this.m_hudTetrominoText.scale(2.0f);
        this.m_hudTetrominoText.alignment = FlxText.FlxJustification.Center;
        this.m_hudTetrominoText.text(Utility.ArrayStringDigit[0]);
        this.m_hudTetrominoText.ShadowOffset(TextShadowOffset);
        this.m_hudTetrominoText.color(ColorTetrominoCounterRegularText);
        this.m_hudTetrominoText.visible = false;
        this.m_layer.add(this.m_hudTetromino);
        this.m_layer.add(this.m_hudTetrominoText);
    }

    protected void _buildTextKey(ref<FlxText> _refTextRef, Buttons _button) {
        FlxText _refText = new FlxText(0.0f, 0.0f, 150.0f);
        _refText.text(InputManager.GetFriendlyButtonName(_button, true));
        _refText.alignment = FlxText.FlxJustification.Left;
        _refText.scale(2.0f);
        _refTextRef.set(_refText);
    }

    protected void _refreshText(FlxText _text, Buttons _button) {
        _text.text(InputManager.GetFriendlyButtonName(_button, true));
    }

    protected void _buildTexts() {
        this.m_txtCounter = new FlxText[this.m_numMat];
        this.m_txtCounterNeeded = new FlxText[this.m_numMat];
        this.m_valueTxtCounter = new int[this.m_numMat];
        this.m_valueTxtCounterNeeded = new int[this.m_numMat];
        Arrays.fill(this.m_valueTxtCounter, 0);
        Arrays.fill(this.m_valueTxtCounterNeeded, 0);
        int i = 0;
        while (i < this.m_txtCounter.length) {
            FlxText text = new FlxText(0.0f, 0.0f, 50.0f);
            FlxText textNeeded = new FlxText(0.0f, 0.0f, 50.0f);
            text.UseShadow(true);
            text.scale(2.0f);
            text.alignment = FlxText.FlxJustification.Right;
            text.text(Utility.ArrayStringDigit[0]);
            text.color(ColorRegularText);
            text.ShadowOffset(TextShadowOffset);
            this.m_txtCounter[i] = text;
            this.m_layer.add(text, true);
            textNeeded.UseShadow(true);
            textNeeded.scale(2.0f);
            textNeeded.alignment = FlxText.FlxJustification.Right;
            textNeeded.text(Utility.ArrayStringDigit[0]);
            textNeeded.visible = false;
            textNeeded.color(Color.Gray());
            this.m_txtCounterNeeded[i] = textNeeded;
            this.m_layer.add(textNeeded, true);
            ++i;
        }
        this.m_txt_LB = new FlxText(0.0f, 0.0f, 20.0f);
        if (InputManager.IsAnyGamepadConnected()) {
            this.m_txt_LB.text("<LB");
        } else {
            this.m_txt_LB.text("<" + InputManager.GetFriendlyButtonName(Buttons.LeftShoulder, true));
        }
        this.m_txt_LB.setFormat(null, 2.0f, ColorLBRBText, FlxText.FlxJustification.Right, this.m_txt_LB.backColor);
        this.m_txt_LB.visible = false;
        this.m_layer.add(this.m_txt_LB, true);
        this.m_txt_RB = new FlxText(0.0f, 0.0f, 20.0f);
        if (InputManager.IsAnyGamepadConnected()) {
            this.m_txt_RB.text("RB>");
        } else {
            this.m_txt_RB.text(String.valueOf(InputManager.GetFriendlyButtonName(Buttons.RightShoulder, true)) + ">");
        }
        this.m_txt_RB.setFormat(null, 2.0f, ColorLBRBText, FlxText.FlxJustification.Left, this.m_txt_RB.backColor);
        this.m_txt_RB.visible = false;
        this.m_layer.add(this.m_txt_RB, true);
    }

    protected void _orderIcons() {
        float realWidth = (float)FlxG.width * this.m_widthPercentage;
        float realBottomMargin = (float)FlxG.height * this.m_bottomMarginPercentage;
        float iconWidth = this.m_iconMat[0].width;
        float iconheight = this.m_iconMat[0].height;
        float step = this.m_backgroundBlocbar[0].width - 4.0f;
        float scale = 0.5f;
        float curx = (float)FlxG.width * 0.5f - step * (float)this.m_numMatVisible * 0.5f;
        float cury = this.m_docking == eDocking.eDocking_Down ? (float)FlxG.height - this.m_backgroundBlocbar[0].height : 0.0f;
        float angle = this.m_docking == eDocking.eDocking_Down ? 180.0f : 0.0f;
        Actor actor = null;
        FlxText txt = null;
        FlxText txtNeeded = null;
        int amount = 0;
        int amountNeeded = 0;
        FlxSprite bg = null;
        int index = this.m_contoller.PlayMode() == PlayerBehaviour.ePlayerMode.ePlayerMode_Bloc ? this.m_contoller.getCollectableSelectedIndex() : -1;
        boolean bPuzzleMode = this.m_contoller.PlayMode() == PlayerBehaviour.ePlayerMode.ePlayerMode_Bloc;
        int numMatVisible = 0;
        int numMatCollected = 0;
        float minBgLeft = Float.MAX_VALUE;
        float maxBgRight = Float.MIN_VALUE;
        int i = 0;
        while (i < this.m_iconMat.length) {
            bg = this.m_backgroundBlocbar[i];
            actor = this.m_iconMat[i];
            txt = this.m_txtCounter[i];
            txtNeeded = this.m_txtCounterNeeded[i];
            amount = this.m_contoller.getCollectableAmount(i);
            amountNeeded = this.m_contoller.getCollectableNeededAmount(i);
            if (amount > 0 || amountNeeded > 0) {
                bg.x = curx;
                bg.y = cury;
                bg.angle(angle);
                if (bg.x < minBgLeft) {
                    minBgLeft = bg.x;
                }
                if (bg.x + bg.width > maxBgRight) {
                    maxBgRight = bg.x + bg.width;
                }
                if (index == i) {
                    bg.play("sel");
                } else {
                    bg.play("notsel");
                }
                ++numMatVisible;
                if (amount > 0) {
                    ++numMatCollected;
                }
                bg.visible = true;
                actor.visible = true;
                txt.visible = true;
                actor.x = bg.x + bg.width * 0.5f - actor.width * actor.scaleX();
                actor.y = bg.y + bg.height * 0.5f - actor.height * actor.scaleY();
                curx += step;
                txt.x = actor.x + actor.width * actor.scale() - txt.width * 0.5f;
                txt.y = actor.y + actor.height * 0.5f + txt.height * 0.5f;
                if (amountNeeded > 0) {
                    txtNeeded.visible = !bPuzzleMode;
                    txtNeeded.x = txt.x;
                    txtNeeded.y = actor.y + actor.height * actor.scale() * 0.45f;
                } else {
                    txtNeeded.visible = false;
                }
            } else {
                bg.visible = false;
                actor.visible = false;
                txt.visible = false;
                txtNeeded.visible = false;
            }
            actor.scale(scale);
            ++i;
        }
        if (numMatVisible > 1 && numMatCollected > 1 && bPuzzleMode) {
            this.m_txt_LB.x = minBgLeft - this.m_txt_LB.width - 5.0f;
            this.m_txt_RB.x = maxBgRight + 5.0f;
            this.m_txt_LB.y = cury + bg.height * 0.5f - this.m_txt_LB.height * 0.5f;
            this.m_txt_RB.y = cury + bg.height * 0.5f - this.m_txt_RB.height * 0.5f;
            this.m_txt_LB.visible = true;
            this.m_txt_RB.visible = true;
        } else {
            this.m_txt_LB.visible = false;
            this.m_txt_RB.visible = false;
        }
        if (numMatVisible > 1) {
            float cxbase = this.m_txt_LB.visible ? this.m_txt_LB.x : minBgLeft;
            this.updateTetrominosCounterAttribs(cxbase - this.m_hudTetromino.width + TetrominosIconOffsetX, cury + TetrominosIconOffsetY, true);
        } else if (numMatVisible == 1) {
            this.updateTetrominosCounterAttribs(minBgLeft - this.m_hudTetromino.width + TetrominosIconOffsetX, cury + TetrominosIconOffsetY, true);
        } else {
            this.updateTetrominosCounterAttribs((float)FlxG.width * 0.5f, cury + TetrominosIconOffsetY, bPuzzleMode);
        }
    }

    protected void updateTetrominosCounterAttribs(float _centerx, float _centery, boolean _bVisible) {
        if (_bVisible) {
            int numPieceDoable = this.m_contoller.NumCollectableLeft() / GameVars.BlocCountToFormPiece();
            if (numPieceDoable > 99) {
                numPieceDoable = 99;
            }
            this.m_hudTetromino.x = _centerx - this.m_hudTetromino.width * 0.5f;
            this.m_hudTetromino.y = _centery - this.m_hudTetromino.height * 0.5f;
            this.m_hudTetrominoText.text(Utility.ArrayStringDigit[numPieceDoable]);
            this.m_hudTetrominoText.x = this.m_hudTetromino.x + this.m_hudTetromino.width + TetrominosTextOffsetX - this.m_hudTetrominoText.width * 0.5f;
            this.m_hudTetrominoText.y = this.m_hudTetromino.y + this.m_hudTetromino.height + TetrominosTextOffsetY - this.m_hudTetrominoText.height * 0.5f;
        }
        this.m_hudTetromino.visible = _bVisible;
        this.m_hudTetrominoText.visible = _bVisible;
    }

    public void show() {
        this._setVisible(true);
    }

    public void hide() {
        this._setVisible(false);
    }

    protected void _setVisible(boolean _bVisible) {
        this.m_bVisible = _bVisible;
        int numSwitchable = 0;
        int amount = 0;
        int i = 0;
        while (i < this.m_iconMat.length) {
            boolean bVisible;
            amount = this.m_contoller.getCollectableAmount(i);
            boolean bl = !_bVisible ? false : (bVisible = amount > 0 || this.m_contoller.getCollectableNeededAmount(i) > 0);
            if (bVisible && amount > 0) {
                ++numSwitchable;
            }
            this.m_iconMat[i].visible = bVisible;
            this.m_txtCounter[i].visible = bVisible;
            this.m_backgroundBlocbar[i].visible = bVisible;
            ++i;
        }
        if (numSwitchable > 1 && this.m_contoller.PlayMode() == PlayerBehaviour.ePlayerMode.ePlayerMode_Bloc) {
            this.m_txt_LB.visible = true;
            this.m_txt_RB.visible = true;
        } else {
            this.m_txt_LB.visible = false;
            this.m_txt_RB.visible = false;
        }
        if (_bVisible) {
            this._updateNumMatVisibleCount();
            this._orderIcons();
        }
    }

    protected void _updateNumMatVisibleCount() {
        this.m_numMatVisible = 0;
        int i = 0;
        while (i < this.m_iconMat.length) {
            if (this.m_contoller.getCollectableAmount(i) > 0 || this.m_contoller.getCollectableNeededAmount(i) > 0) {
                ++this.m_numMatVisible;
            }
            ++i;
        }
    }

    protected void _updateDigits() {
        this._updateNumMatVisibleCount();
        this._orderIcons();
        int amount = 0;
        int amountNeeded = 0;
        FlxText txtNeeded = null;
        int i = 0;
        while (i < this.m_txtCounter.length) {
            txtNeeded = null;
            amount = this.m_contoller.getCollectableAmount(i);
            amountNeeded = this.m_contoller.getCollectableNeededAmount(i);
            if (this.m_valueTxtCounter[i] != amount) {
                if (amount < 100) {
                    this.m_txtCounter[i].text(Utility.ArrayStringDigit[amount]);
                } else {
                    this.m_txtCounter[i].text(Utility.ArrayStringDigit[99]);
                }
                this.m_valueTxtCounter[i] = amount;
            }
            txtNeeded = this.m_txtCounterNeeded[i];
            if (this.m_valueTxtCounterNeeded[i] != amountNeeded) {
                if (amountNeeded < 100) {
                    txtNeeded.text(Utility.ArrayStringDigit[amountNeeded]);
                } else {
                    txtNeeded.text(Utility.ArrayStringDigit[99]);
                }
                this.m_valueTxtCounterNeeded[i] = amountNeeded;
            }
            if (txtNeeded != null) {
                if (amountNeeded > amount) {
                    txtNeeded.color(ColorRedText);
                } else {
                    txtNeeded.color(ColorGreenText);
                }
            }
            ++i;
        }
        this._syncPuzzleGauge();
        if (this.m_contoller.Level().PlayableMode() && (this.m_contoller.isModeNew(PlayerBehaviour.ePlayerMode.ePlayerMode_Bloc) || this.m_contoller.isModeNew(PlayerBehaviour.ePlayerMode.ePlayerMode_Move))) {
            this._setVisible(true);
        }
        this._refreshHudPar(false);
    }

    public void syncDigits() {
        this._updateDigits();
    }

    public void sync() {
        if (!this.m_contoller.Level().PlayableMode()) {
            return;
        }
        this._updateDigits();
        this.updateHudDependingState();
        this._updateChestOrBTM_visibility();
    }

    public void updateHudDependingState() {
        if (!this.m_contoller.Level().PlayableMode()) {
            return;
        }
        this.enterNewMode(this.m_contoller.PlayMode());
    }

    public void update() {
        if (!this.m_contoller.Level().PlayableMode()) {
            return;
        }
        if (this.m_bAnyGamePad != InputManager.IsAnyGamepadConnected()) {
            this.m_bAnyGamePad = InputManager.IsAnyGamepadConnected();
            this._refreshText(this.m_hud_Y_AloneKeyText, Buttons.Y);
            this._refreshText(this.m_hud_LT_AloneKeyText, Buttons.LeftTrigger);
            this._refreshText(this.m_hud_X_AloneKeyText, Buttons.X);
            this._refreshText(this.m_hud_A_AloneKeyText, Buttons.A);
            this._refreshText(this.m_hud_B_AloneKeyText, Buttons.B);
            if (this.m_contoller.Level().PuzzleMode()) {
                this._hudA();
                this._hudB();
            }
            this._hudY();
            this._hudX_LT();
        }
        this.m_hudY.update();
        this.m_hudX_LT.update();
        this.m_hudA.update();
        this.m_hudB.update();
        if (this.m_hudState == eHudState.eHudState_DisplayingResultsPAR) {
            if (this.m_bWaitForKeyPAR && InputManager.IsAnyButtonPress(true)) {
                this.m_bWaitForKeyPAR = false;
                this._parDone();
            }
        } else if (this.m_hudState == eHudState.eHudState_DisplayingResultsBTM && this.m_bWaitForKeyDisplayBTMDone && InputManager.IsAnyButtonPress(true)) {
            this.m_bDisplayResultBTMDone = true;
        }
    }

    public void enterNewMode(PlayerBehaviour.ePlayerMode _mode) {
        if (!this.m_contoller.Level().PlayableMode()) {
            return;
        }
        if (!this.m_contoller.Level().PlayableMode()) {
            return;
        }
        switch (_mode) {
            case ePlayerMode_Bloc: {
                this._enterBlocModeUpdate();
                break;
            }
            case ePlayerMode_Camera: {
                this._enterCameraModeUpdate();
                break;
            }
            case ePlayerMode_Move: {
                this._enterMoveModeUpdate();
                break;
            }
            case ePlayerMode_ShowLevelResultBTM: {
                if (this.m_hudState == eHudState.eHudState_DisplayingResultsBTM) break;
                this.m_hudState = eHudState.eHudState_DisplayingResultsBTM;
                this._buildShowBTMResultTweens();
                if (!GameVars.GameCommunityMode()) break;
                GameVars.LastCommunityPlayedLevelBTMChestFound(this.m_contoller.BTM_Found());
                break;
            }
            case ePlayerMode_ShowLevelResultPAR: {
                if (this.m_hudState == eHudState.eHudState_DisplayingResultsPAR) break;
                this.m_hudState = eHudState.eHudState_DisplayingResultsPAR;
                this._buildShowPARResultTweens();
            }
        }
    }

    protected void _checkOneHundredAchievement() {
        if (!AchievementManager.Instance().isAchievementUnlocked("ACH_ONE_HUNDRED")) {
            LoginManager.Instance().computeCurrentMainCompletion();
            float mainCompletion = LoginManager.Instance().getCurrentSlotMainCompletionValue();
            if (mainCompletion >= 100.0f) {
                AchievementManager.Instance().unlockAchievement("ACH_ONE_HUNDRED");
            }
        }
    }

    protected void _buildShowPARResultTweens() {
        if (this.m_contoller.PAR_NewRecord()) {
            int numCollectableNeeded;
            int numCollectableLeft;
            TweenManager tm = this.m_contoller.Level().TweenManager();
            float curTime = 0.0f;
            float duration = 0.0f;
            this.m_hudBackgroundPAR.alpha(0.0f);
            this.m_hudBackgroundPAR.visible = true;
            duration = 2.0f;
            tm.ToAlpha((Tweenable)this.m_hudBackgroundPAR, 1.0f, 2.0f, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
            curTime += duration;
            if (this.m_bUseScaleAnim) {
                this.m_hudStarPARBackground.alpha(0.0f);
                this.m_hudStarPARBackground.visible = true;
                duration = 2.0f;
                tm.ToAlpha((Tweenable)this.m_hudStarPARBackground, 1.0f, duration, TweenManager.EaseType.EASE_INOUTSIN, curTime, (CallbackSimple)null);
                curTime += duration + curTime;
            }
            boolean bl = this.m_bGreenStar = (numCollectableLeft = this.m_contoller.NumCollectableLeft()) > (numCollectableNeeded = this.m_contoller.PAR_RequiredNum());
            if (numCollectableNeeded == 0) {
                ++numCollectableNeeded;
            }
            float maxAnimTime = 5.0f;
            this.m_hudStarPARForeground.visible = true;
            if (this.m_bUseScaleAnim) {
                this.m_hudStarPARForeground.alpha(1.0f);
                this.m_hudStarPARForeground.scale(0.0f);
            } else {
                this.m_hudStarPARForeground.scale(0.0f);
                this.m_hudStarPARForeground.alpha(0.0f);
                duration = 1.0f;
                tm.ToAlpha((Tweenable)this.m_hudStarPARForeground, this.m_colorGrayBeg, duration, TweenManager.EaseType.EASE_INOUTSIN, curTime, (CallbackSimple)null);
                tm.ToScale((Tweenable)this.m_hudStarPARForeground, Vector2.One(), duration, TweenManager.EaseType.EASE_INOUTSIN, curTime, (CallbackSimple)null);
                if (this.m_hudStarPAR != null) {
                    this.m_bCanRefreshHudPar = false;
                    tm.ToAlpha((Tweenable)this.m_hudStarPAR, 0.0f, duration, TweenManager.EaseType.EASE_INOUTSIN, curTime, (CallbackSimple)null);
                    tm.ToAlpha((Tweenable)this.m_txtHudStarPAR_currentBlocNum, 0.0f, duration, TweenManager.EaseType.EASE_INOUTSIN, curTime, (CallbackSimple)null);
                }
                curTime += duration;
            }
            this.m_scalePARstep = 1.0f / (float)numCollectableNeeded;
            this.m_scalePAR = 0.0f;
            this.m_numShakePar = numCollectableNeeded;
            this.m_numShakeLeft = numCollectableLeft;
            this.m_numShake = numCollectableLeft;
            if (this.m_bUseScaleAnim) {
                this.m_scaleTimeBeg = 0.2f;
                this.m_scaleTimeEnd = 0.14f;
                this.m_scaleTimeOverPar = 0.05f;
                ++this.m_numShake;
                this._scaleStepDone(curTime);
            } else {
                float approxTotalDuration = (float)this.m_numShake * 0.4f;
                float percentageSpeedEnd = 0.25f;
                this.m_scaleTimeBeg = approxTotalDuration / (float)this.m_numShake;
                this.m_scaleTimeEnd = this.m_scaleTimeBeg * percentageSpeedEnd;
                this.m_timeShake = 0.1f;
                this.m_scaleTimeOverPar = 0.05f;
                this.m_contoller.Level().TweenManager().ToScale((Tweenable)this.m_hudStarPARForeground, new Vector2(1.0f), this.m_timeShake, TweenManager.EaseType.EASE_LINEAR, curTime, this.m_PARCallbackScaleStepDone);
            }
            MusicManager.Instance().playTracks(null, null, 3.0f, false);
        } else {
            this._parDone();
        }
    }

    protected void _scaleStepDone(float _delay) {
        this.m_timeShake = this.m_numShakeLeft / this.m_numShake;
        this.m_timeShake = this.m_scaleTimeBeg * this.m_timeShake + (1.0f - this.m_timeShake) * this.m_scaleTimeEnd;
        if (!(_delay > 0.0f)) {
            this.m_scalePAR += this.m_scalePARstep;
            --this.m_numShakeLeft;
        }
        if (this.m_numShakePar == this.m_numShake - this.m_numShakeLeft) {
            FlxG.flash.start(Color.White());
            MusicManager.Instance().playTracks("bonus01", null, 1.0f, false);
            this.m_contoller.Level().BlocSoundManager().triggerBlocSoundEvent(BlocksSoundsManager.eBlocSoundEvent.eBlocSoundEvent_BlockSpecial, this.m_contoller.Owner());
            this._checkAchivementPAR();
            if (this.m_bGreenStar) {
                this.m_hudStarPARForeground.color().change(0.0f, 1.0f, 0.0f);
            } else {
                this.m_hudStarPARForeground.color().change(1.0f, 1.0f, 1.0f);
            }
            this.m_txtCongratzPAR.visible = true;
            this.m_txtPressPAR.visible = true;
            this.m_txtCongratzPAR.alpha(0.0f);
            this.m_txtPressPAR.alpha(0.0f);
            this.m_txtCongratzPAR.initAttributes(TextDataBase.Instance().getText("TXT_PAR"), Color.White(), (float)FlxG.width * 0.5f, (float)FlxG.height * 0.2f - this.m_txtCongratz.height * 0.5f, 3.0f, 0.0f, 1.0f);
            this.m_txtPressPAR.text(TextDataBase.Instance().getText("TXT_PRESS_ANYTHING"));
            this.m_txtPressPAR.x = (float)FlxG.width * 0.5f - this.m_txtPress.width * 0.5f;
            this.m_txtPressPAR.y = (float)FlxG.height * 0.85f - this.m_txtPress.height * 0.5f;
            this.m_txtPressPAR.scale(1.5f);
            TweenManager tm = this.m_contoller.Level().TweenManager();
            tm.ToAlpha((Tweenable)this.m_txtCongratzPAR, 1.0f, 0.8f, TweenManager.EaseType.EASE_OUTBOUNCE, 0.0f, (CallbackSimple)null);
            tm.ToAlpha((Tweenable)this.m_txtPressPAR, 1.0f, 0.8f, TweenManager.EaseType.EASE_OUTBOUNCE, 0.0f, (CallbackSimple)null);
            tm.ToAlpha((Tweenable)this.m_txtPressPAR, 0.2f, 1.0f, TweenManager.EaseType.EASE_INOUTSIN, 1.0f, TweenManager.LoopType.Loop);
            this.m_bWaitForKeyPAR = true;
        }
        if (this.m_numShakeLeft >= 0) {
            if (this.m_scalePAR > 1.0f) {
                if (this.m_bUseScaleAnim) {
                    this.m_hudStarPARForeground.scale(0.9f);
                }
                this.m_scalePAR = 1.0f;
                this.m_timeShake = this.m_scaleTimeOverPar;
            }
            if (!(_delay > 0.0f)) {
                this.m_contoller.decreaseCollectableStock();
                if (!this.m_bUseScaleAnim) {
                    this.m_hudStarPARForeground.scale(0.9f);
                }
            }
            if (this.m_bUseScaleAnim) {
                this.m_contoller.Level().TweenManager().ToScale((Tweenable)this.m_hudStarPARForeground, new Vector2(this.m_scalePAR), this.m_timeShake, TweenManager.EaseType.EASE_OUTBOUNCE, _delay, this.m_PARCallbackScaleStepDone);
                this.m_hudStarPARForeground.scale(0.0f);
            } else {
                this.m_contoller.Level().TweenManager().ToScale((Tweenable)this.m_hudStarPARForeground, new Vector2(1.0f), this.m_timeShake, TweenManager.EaseType.EASE_OUTBOUNCE, _delay, this.m_PARCallbackScaleStepDone);
                this.m_colorGrayLerp = (1.0f - this.m_scalePAR) * this.m_colorGrayBeg + this.m_scalePAR * this.m_colorGrayEnd;
                this.m_hudStarPARForeground.alpha(this.m_colorGrayLerp);
            }
            if (!this.m_bWaitForKeyPAR) {
                this.m_contoller.Level().BlocSoundManager().triggerBlocSoundEvent(BlocksSoundsManager.eBlocSoundEvent.eBlocSoundEvent_BlockBreak, this.m_contoller.Owner());
            }
        } else {
            this.m_hudStarPARBackground.visible = false;
            float duration = 0.8f;
            this.m_contoller.Level().TweenManager().ToScale((Tweenable)this.m_hudStarPARForeground, new Vector2(1.1f), duration, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, TweenManager.LoopType.PingPong);
            this.m_contoller.Level().TweenManager().ToAngle((Tweenable)this.m_hudStarPARForeground, 2.0f, duration, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, TweenManager.LoopType.None);
            this.m_contoller.Level().TweenManager().ToAngle((Tweenable)this.m_hudStarPARForeground, -2.0f, duration, TweenManager.EaseType.EASE_INOUTSIN, duration, TweenManager.LoopType.PingPong);
        }
    }

    protected void _parDone() {
        if (this.m_contoller.PAR_NewRecord() && this.m_contoller.BTM_Found() && !this.m_bBTM_alreadyFound) {
            this.m_hudForegroundPAR.alpha(0.0f);
            this.m_hudForegroundPAR.visible = true;
            this.m_contoller.Level().TweenManager().ToAlpha((Tweenable)this.m_hudForegroundPAR, 1.0f, 0.5f, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
        }
        this.enterNewMode(PlayerBehaviour.ePlayerMode.ePlayerMode_ShowLevelResultBTM);
    }

    protected void _buildShowBTMResultTweens() {
        if (this.m_contoller.BTM_Found() && !this.m_bBTM_alreadyFound) {
            TweenManager tm = this.m_contoller.Level().TweenManager();
            this.m_hudBTM.color(Color.White());
            this.m_hudBTM.scrollFactor = Vector2.Zero();
            tm.ToPosition(this.m_hudChestBTM, new Vector2((float)FlxG.width * 0.5f, (float)FlxG.height * 0.5f), 2.0f, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, null);
            this.m_hudBackgroundBTM.alpha(0.0f);
            this.m_hudBackgroundBTM.visible = true;
            tm.ToAlpha((Tweenable)this.m_hudBackgroundBTM, 1.0f, 2.0f, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
            tm.TriggerTracks("bonus01", null, 1.0f, 3.0f);
            this.m_frame.visible = true;
            this.m_frame.alpha(0.0f);
            this.m_frame.x = (float)FlxG.width * 0.5f - this.m_frame.width * 0.5f;
            this.m_frame.y = (float)FlxG.height * 0.5f - this.m_frame.height * 0.5f;
            this.m_frame.scale(1.2f);
            tm.ToAlpha((Tweenable)this.m_frame, 1.0f, 0.1f, TweenManager.EaseType.EASE_INOUTSIN, 2.2f, (CallbackSimple)null);
            tm.ToScale((Tweenable)this.m_frame, Vector2.One(), 0.2f, TweenManager.EaseType.EASE_OUTBOUNCE, 2.2f, (CallbackSimple)null);
            this.m_perfectCircle.alpha(0.0f);
            this.m_perfectCircle.visible = true;
            this.m_perfectCircle.scrollFactor = Vector2.Zero();
            this.m_perfectCircle.x = (float)FlxG.width * 0.5f - this.m_perfectCircle.width * 0.5f;
            this.m_perfectCircle.y = (float)FlxG.height * 0.5f - this.m_perfectCircle.height * 0.5f;
            tm.ToAngle((Tweenable)this.m_perfectCircle, -360.0f, 10.0f, TweenManager.EaseType.EASE_LINEAR, 0.0f, TweenManager.LoopType.Loop);
            tm.ToScale((Tweenable)this.m_perfectCircle, new Vector2(2.5f), 1.2f, TweenManager.EaseType.EASE_INOUTSIN, 2.5f, (CallbackSimple)null);
            tm.ToAlpha((Tweenable)this.m_perfectCircle, 0.8f, 0.2f, TweenManager.EaseType.EASE_INOUTSIN, 2.5f, (CallbackSimple)null);
            tm.ToAlpha((Tweenable)this.m_hudChestBTM, 0.0f, 0.5f, TweenManager.EaseType.EASE_INOUTSIN, 3.0f, (CallbackSimple)null);
            this.m_hudBTM.scale(0.0f);
            this.m_hudBTM.alpha(0.0f);
            this.m_hudBTM.scrollFactor = Vector2.Zero();
            this.m_hudBTM.visible = true;
            this.m_hudBTM.x = (float)FlxG.width * ShowResultChestPosPercX - this.m_hudBTM.width * 0.5f;
            this.m_hudBTM.y = (float)FlxG.height * ShowResultChestPosPercY - this.m_hudBTM.height * 0.5f;
            tm.ToAlpha((Tweenable)this.m_hudBTM, 1.0f, 0.8f, TweenManager.EaseType.EASE_INOUTSIN, 3.5f, (CallbackSimple)null);
            tm.ToScale((Tweenable)this.m_hudBTM, Vector2.One(), 1.2f, TweenManager.EaseType.EASE_OUTBOUNCE, 3.5f, (CallbackSimple)null);
            this.m_txtCongratz.visible = true;
            this.m_txtInfo.visible = true;
            this.m_txtPress.visible = true;
            this.m_txtCongratz.alpha(0.0f);
            this.m_txtInfo.alpha(0.0f);
            this.m_txtPress.alpha(0.0f);
            LevelInfo li = LevelDataBase.Instance().getLevelInfo(this.m_contoller.Level());
            if (li != null && li.BTM().tmID() != null && li.BTM().tmID().length() > 0) {
                this.m_txtTM.changeText(TextDataBase.Instance().getText(li.BTM().tmID()));
                this.m_txtTM.visible = true;
                this.m_txtTM.changeAlpha(0.0f);
            } else {
                this.m_txtTM.visible = false;
            }
            this.m_txtCongratz.text(TextDataBase.Instance().getText("TXT_FOUND_BTM"));
            this.m_txtInfo.text(li != null ? li.BTM().GameName() : "");
            this.m_txtPress.text(TextDataBase.Instance().getText("TXT_PRESS_ANYTHING"));
            this.m_txtCongratz.x = (float)FlxG.width * 0.5f - this.m_txtCongratz.width * 0.5f;
            this.m_txtInfo.x = (float)FlxG.width * 0.5f - this.m_txtInfo.width * 0.5f;
            this.m_txtPress.x = (float)FlxG.width * 0.5f - this.m_txtPress.width * 0.5f;
            this.m_txtCongratz.y = (float)FlxG.height * 0.2f - this.m_txtCongratz.height * 0.5f;
            this.m_txtInfo.y = (float)FlxG.height * 0.75f - this.m_txtInfo.height * 0.5f;
            this.m_txtPress.y = (float)FlxG.height * 0.85f - this.m_txtPress.height * 0.5f;
            this.m_txtCongratz.scale(3.0f);
            this.m_txtInfo.scale(3.0f);
            this.m_txtPress.scale(1.5f);
            tm.ToAlpha((Tweenable)this.m_txtCongratz, 1.0f, 0.8f, TweenManager.EaseType.EASE_OUTBOUNCE, 4.5f, (CallbackSimple)null);
            if (this.m_txtTM.visible) {
                tm.ToAlpha((Tweenable)this.m_txtTM, 1.0f, 0.8f, TweenManager.EaseType.EASE_OUTBOUNCE, 4.5f, (CallbackSimple)null);
            }
            tm.ToAlpha((Tweenable)this.m_txtInfo, 1.0f, 0.8f, TweenManager.EaseType.EASE_OUTBOUNCE, 4.5f, this.m_tweenShowResultDone);
            tm.ToAlpha((Tweenable)this.m_txtPress, 1.0f, 0.8f, TweenManager.EaseType.EASE_OUTBOUNCE, 6.5f, (CallbackSimple)null);
            tm.ToAlpha((Tweenable)this.m_txtPress, 0.2f, 1.0f, TweenManager.EaseType.EASE_INOUTSIN, 7.0f, TweenManager.LoopType.Loop);
            this.m_bDisplayResultBTMDone = false;
        } else {
            this.m_bDisplayResultBTMDone = true;
            this._checkOneHundredAchievement();
        }
    }

    protected void _tweenShowResultDone(Object _sender, Object _e) {
        this.m_bWaitForKeyDisplayBTMDone = true;
        this._checkAchivementBTM();
    }

    protected void _checkAchivementBTM() {
        LevelGroup lvlGroup;
        if (GameVars.GameMode() == GameMode.GameMode_Main && (lvlGroup = this.m_contoller.Level().Group()) != null) {
            LevelInfo li;
            int numBTM = lvlGroup.getBTMFoundNumber();
            if (numBTM >= 1) {
                AchievementManager.Instance().unlockAchievement("ACH_FIRST_BTM");
            }
            if (numBTM >= 10) {
                AchievementManager.Instance().unlockAchievement("ACH_10_BTM");
            }
            if (numBTM >= 20) {
                AchievementManager.Instance().unlockAchievement("ACH_20_BTM");
            }
            if (numBTM >= 40) {
                AchievementManager.Instance().unlockAchievement("ACH_40_BTM");
            }
            if ((li = lvlGroup.getLevelInfoOrNil(this.m_contoller.Level())) != null && li.BTM() != null) {
                String btmID = li.BTM().ID();
                if (AchievementManager.ACH_FrenchConnexionBTM.contains(btmID)) {
                    if (!AchievementManager.Instance().isAchievementUnlocked("ACH_FRENCH_TOUCH") && lvlGroup.hasBTMdone(AchievementManager.ACH_FrenchConnexionBTM)) {
                        AchievementManager.Instance().unlockAchievement("ACH_FRENCH_TOUCH");
                    }
                } else if (AchievementManager.ACH_B_T_M.contains(btmID) && !AchievementManager.Instance().isAchievementUnlocked("ACH_B_T_M") && lvlGroup.hasBTMdone(AchievementManager.ACH_B_T_M)) {
                    AchievementManager.Instance().unlockAchievement("ACH_B_T_M");
                }
            }
        }
    }

    protected void _checkAchivementPAR() {
        if (GameVars.GameMode() == GameMode.GameMode_Main) {
            LevelGroup lvlGroup = this.m_contoller.Level().Group();
            if (lvlGroup != null) {
                int numPAR = lvlGroup.getPARFoundNumber();
                if (this.m_bGreenStar) {
                    AchievementManager.Instance().unlockAchievement("ACH_GREEN_STAR");
                }
                if (numPAR == 10) {
                    AchievementManager.Instance().unlockAchievement("ACH_10_STARS");
                } else if (numPAR == 20) {
                    AchievementManager.Instance().unlockAchievement("ACH_20_STARS");
                } else if (numPAR == 40) {
                    AchievementManager.Instance().unlockAchievement("ACH_40_STARS");
                }
            }
            if (!this.m_contoller.BTM_Found() || this.m_bBTM_alreadyFound) {
                this._checkOneHundredAchievement();
            }
        }
    }

    public void onLineScanDone() {
        this._hudX_LT();
        this._hudY();
    }

    public void onPuzzleCursorMove() {
        this._hudA();
    }

    protected void _hudArrows() {
        int i = 0;
        while (i < this.m_arrows.length) {
            this.m_arrows[i].visible = this.m_contoller.PlayMode() == PlayerBehaviour.ePlayerMode.ePlayerMode_Camera;
            ++i;
        }
    }

    protected void _hudA() {
        if (this.m_contoller.BlocSpawner().cursorPoseAvailable()) {
            this.m_hudA.visible = true;
            this.m_hudA.play("a_puzz_on");
            this.m_hudA.color(Color.White());
            this._setVisibility(this.m_hud_A_Alone, this.m_hud_A_AloneKeyText, this.m_hudA.visible);
            this._setColor(this.m_hud_A_Alone, this.m_hud_A_AloneKeyText, this.m_hudA.color(), this.m_hud_A_AloneKeyTextColor);
        } else {
            this.m_hudA.visible = true;
            this.m_hudA.play("a_puzz_off");
            this.m_hudA.color(this.m_unvailableColor);
            this._setVisibility(this.m_hud_A_Alone, this.m_hud_A_AloneKeyText, this.m_hudA.visible);
            this._setColor(this.m_hud_A_Alone, this.m_hud_A_AloneKeyText, this.m_hudA.color(), this.m_unvailableColor);
        }
    }

    protected void _hudB() {
        if (this.m_contoller.BlocSpawner().canUndo()) {
            this.m_hudB.visible = true;
            this.m_hudB.play("b_puzz_on");
            this.m_hudB.color(Color.White());
            this._setVisibility(this.m_hud_B_Alone, this.m_hud_B_AloneKeyText, this.m_hudB.visible);
            this._setColor(this.m_hud_B_Alone, this.m_hud_B_AloneKeyText, this.m_hudB.color(), this.m_hud_B_AloneKeyTextColor);
        } else {
            this.m_hudB.visible = true;
            this.m_hudB.play("b_puzz_off");
            this.m_hudB.color(this.m_unvailableColor);
            this._setVisibility(this.m_hud_B_Alone, this.m_hud_B_AloneKeyText, this.m_hudB.visible);
            this._setColor(this.m_hud_B_Alone, this.m_hud_B_AloneKeyText, this.m_hudB.color(), this.m_unvailableColor);
        }
    }

    protected void _hudX_LT() {
        if (this.m_contoller.PlayMode() == PlayerBehaviour.ePlayerMode.ePlayerMode_Move) {
            if (!GameVars.CanGoCameraMode()) {
                this.m_hudX_LT.visible = false;
                this._setVisibility(this.m_hud_X_Alone, this.m_hud_X_AloneKeyText, false);
                this._setVisibility(this.m_hud_LT_Alone, this.m_hud_LT_AloneKeyText, false);
            } else {
                this.m_hudX_LT.visible = true;
                this.m_hudX_LT.play("lt_move");
                this.m_hudX_LT.color(Color.White());
                this._setVisibility(this.m_hud_X_Alone, this.m_hud_X_AloneKeyText, false);
                this._setVisibility(this.m_hud_LT_Alone, this.m_hud_LT_AloneKeyText, true);
                this._setColor(this.m_hud_X_Alone, this.m_hud_X_AloneKeyText, this.m_hudX_LT.color(), this.m_hud_X_AloneKeyTextColor);
                this._setColor(this.m_hud_LT_Alone, this.m_hud_LT_AloneKeyText, this.m_hudX_LT.color(), this.m_hud_LT_AloneKeyTextColor);
            }
        } else if (this.m_contoller.PlayMode() == PlayerBehaviour.ePlayerMode.ePlayerMode_Camera) {
            this.m_hudX_LT.visible = true;
            this.m_hudX_LT.play("lt_move");
            this.m_hudX_LT.color(this.m_unvailableColor);
            this._setVisibility(this.m_hud_X_Alone, this.m_hud_X_AloneKeyText, false);
            this._setVisibility(this.m_hud_LT_Alone, this.m_hud_LT_AloneKeyText, true);
            this._setColor(this.m_hud_X_Alone, this.m_hud_X_AloneKeyText, this.m_hudX_LT.color(), this.m_unvailableColor);
            this._setColor(this.m_hud_LT_Alone, this.m_hud_LT_AloneKeyText, this.m_hudX_LT.color(), this.m_unvailableColor);
        } else if (this.m_contoller.PlayMode() == PlayerBehaviour.ePlayerMode.ePlayerMode_Bloc) {
            if (GameVars.PlayerCanDoLines() > 0) {
                if (this.m_contoller.BlocSpawner().isDestroyScanAvailable()) {
                    this.m_hudX_LT.visible = true;
                    this.m_hudX_LT.play("x_puzz_on");
                    this.m_hudX_LT.color(Color.White());
                    this._setVisibility(this.m_hud_X_Alone, this.m_hud_X_AloneKeyText, true);
                    this._setVisibility(this.m_hud_LT_Alone, this.m_hud_LT_AloneKeyText, false);
                    this._setColor(this.m_hud_X_Alone, this.m_hud_X_AloneKeyText, this.m_hudX_LT.color(), this.m_hud_X_AloneKeyTextColor);
                    this._setColor(this.m_hud_LT_Alone, this.m_hud_LT_AloneKeyText, this.m_hudX_LT.color(), this.m_hud_LT_AloneKeyTextColor);
                } else {
                    this.m_hudX_LT.visible = true;
                    this.m_hudX_LT.play("x_puzz_off");
                    this.m_hudX_LT.color(this.m_unvailableColor);
                    this._setVisibility(this.m_hud_X_Alone, this.m_hud_X_AloneKeyText, true);
                    this._setVisibility(this.m_hud_LT_Alone, this.m_hud_LT_AloneKeyText, false);
                    this._setColor(this.m_hud_X_Alone, this.m_hud_X_AloneKeyText, this.m_hudX_LT.color(), this.m_unvailableColor);
                    this._setColor(this.m_hud_LT_Alone, this.m_hud_LT_AloneKeyText, this.m_hudX_LT.color(), this.m_unvailableColor);
                }
            } else {
                this.m_hudX_LT.visible = false;
                this._setVisibility(this.m_hud_X_Alone, this.m_hud_X_AloneKeyText, false);
                this._setVisibility(this.m_hud_LT_Alone, this.m_hud_LT_AloneKeyText, false);
            }
        }
    }

    protected void _hudMaterialBar() {
        boolean visible = this.m_contoller.PlayMode() == PlayerBehaviour.ePlayerMode.ePlayerMode_Move && this.m_contoller.NumCollectableLeft() > 0 || this.m_contoller.PlayMode() == PlayerBehaviour.ePlayerMode.ePlayerMode_Bloc;
        boolean bCamMode = this.m_contoller.PlayMode() == PlayerBehaviour.ePlayerMode.ePlayerMode_Camera;
        boolean notNul = false;
        boolean needed = false;
        int i = 0;
        while (i < this.m_iconMat.length) {
            boolean itemVisible;
            needed = this.m_contoller.getCollectableNeededAmount(i) > 0;
            notNul = this.m_contoller.getCollectableAmount(i) > 0;
            this.m_iconMat[i].visible = itemVisible = visible && notNul || needed && !bCamMode;
            this.m_backgroundBlocbar[i].visible = itemVisible;
            this.m_txtCounter[i].visible = itemVisible;
            this.m_txtCounterNeeded[i].visible = needed && !bCamMode;
            ++i;
        }
        this.m_hudTetromino.visible = visible;
        this.m_hudTetrominoText.visible = visible;
    }

    protected void _hudY() {
        if (this.m_contoller.PlayMode() == PlayerBehaviour.ePlayerMode.ePlayerMode_Move) {
            this.m_hudY.visible = GameVars.PlayerCanDoPuzzle() > 0;
            this.m_hudY.play("y_move");
            this.m_hudY.color(Color.White());
            this._setVisibility(this.m_hud_Y_Alone, this.m_hud_Y_AloneKeyText, this.m_hudY.visible);
            this._setColor(this.m_hud_Y_Alone, this.m_hud_Y_AloneKeyText, this.m_hudY.color(), this.m_hud_Y_AloneKeyTextColor);
        } else if (this.m_contoller.PlayMode() == PlayerBehaviour.ePlayerMode.ePlayerMode_Camera) {
            this.m_hudY.visible = true;
            this.m_hudY.play("y_move");
            this.m_hudY.color(this.m_unvailableColor);
            this._setVisibility(this.m_hud_Y_Alone, this.m_hud_Y_AloneKeyText, this.m_hudY.visible);
            this._setColor(this.m_hud_Y_Alone, this.m_hud_Y_AloneKeyText, this.m_hudY.color(), this.m_unvailableColor);
        } else if (this.m_contoller.PlayMode() == PlayerBehaviour.ePlayerMode.ePlayerMode_Bloc) {
            if (!this.m_contoller.BlocSpawner().isScanningOrDestoring()) {
                this.m_hudY.visible = true;
                this.m_hudY.play("y_puzz_on");
                this.m_hudY.color(Color.White());
                this._setVisibility(this.m_hud_Y_Alone, this.m_hud_Y_AloneKeyText, this.m_hudY.visible);
                this._setColor(this.m_hud_Y_Alone, this.m_hud_Y_AloneKeyText, this.m_hudY.color(), this.m_hud_Y_AloneKeyTextColor);
            } else {
                this.m_hudY.visible = true;
                this.m_hudY.play("y_puzz_off");
                this.m_hudY.color(this.m_unvailableColor);
                this._setVisibility(this.m_hud_Y_Alone, this.m_hud_Y_AloneKeyText, this.m_hudY.visible);
                this._setColor(this.m_hud_Y_Alone, this.m_hud_Y_AloneKeyText, this.m_hudY.color(), this.m_unvailableColor);
            }
        }
    }

    protected void _setVisibility(FlxSprite _spriteButton, FlxText _textOrNil, boolean _bVisible) {
        if (InputManager.IsAnyGamepadConnected()) {
            _spriteButton.visible = _bVisible;
            _textOrNil.visible = false;
        } else {
            _spriteButton.visible = false;
            _textOrNil.visible = _bVisible;
        }
    }

    protected void _setColor(FlxSprite _spriteButton, FlxText _textOrNil, Color _colorButton, Color _colorText) {
        if (InputManager.IsAnyGamepadConnected()) {
            _spriteButton.color(_colorButton);
        } else {
            _textOrNil.color(_colorText);
        }
    }

    protected void _updateChestOrBTM_visibility() {
        this.m_hudChestBTM.visible = this.m_contoller.BTM_Found() && !this.m_bBTM_alreadyFound;
        this.m_hudBTM.visible = this.m_contoller.BTM_Found() && this.m_bBTM_alreadyFound;
        this._positionnateHudPar();
    }

    protected void _enterBlocModeUpdate() {
        this.m_hudA.visible = true;
        this.m_hudB.visible = true;
        this.m_hudY.visible = true;
        this.m_hudX_LT.visible = true;
        this._setVisibility(this.m_hud_LT_Alone, this.m_hud_LT_AloneKeyText, false);
        this._setVisibility(this.m_hud_X_Alone, this.m_hud_X_AloneKeyText, true);
        this._setVisibility(this.m_hud_Y_Alone, this.m_hud_Y_AloneKeyText, this.m_hudY.visible);
        this._setVisibility(this.m_hud_A_Alone, this.m_hud_A_AloneKeyText, this.m_hudA.visible);
        this._setVisibility(this.m_hud_B_Alone, this.m_hud_B_AloneKeyText, this.m_hudB.visible);
        this._hudA();
        this._hudB();
        this._hudY();
        this._hudX_LT();
        this._updateChestOrBTM_visibility();
    }

    protected void _enterMoveModeUpdate() {
        this.m_hudA.visible = false;
        this.m_hudB.visible = false;
        this.m_hudY.visible = true;
        this.m_hudX_LT.visible = true;
        this._setVisibility(this.m_hud_LT_Alone, this.m_hud_LT_AloneKeyText, true);
        this._setVisibility(this.m_hud_X_Alone, this.m_hud_X_AloneKeyText, false);
        this._setVisibility(this.m_hud_Y_Alone, this.m_hud_Y_AloneKeyText, this.m_hudY.visible);
        this._setVisibility(this.m_hud_A_Alone, this.m_hud_A_AloneKeyText, this.m_hudA.visible);
        this._setVisibility(this.m_hud_B_Alone, this.m_hud_B_AloneKeyText, this.m_hudB.visible);
        this._hudY();
        this._hudX_LT();
        this._hudArrows();
        this._hudMaterialBar();
        this._updateChestOrBTM_visibility();
    }

    protected void _enterCameraModeUpdate() {
        this.m_hudA.visible = false;
        this.m_hudB.visible = false;
        this.m_hudY.visible = false;
        this.m_hudX_LT.visible = false;
        this._setVisibility(this.m_hud_LT_Alone, this.m_hud_LT_AloneKeyText, false);
        this._setVisibility(this.m_hud_X_Alone, this.m_hud_X_AloneKeyText, false);
        this._setVisibility(this.m_hud_Y_Alone, this.m_hud_Y_AloneKeyText, this.m_hudY.visible);
        this._setVisibility(this.m_hud_A_Alone, this.m_hud_A_AloneKeyText, this.m_hudA.visible);
        this._setVisibility(this.m_hud_B_Alone, this.m_hud_B_AloneKeyText, this.m_hudB.visible);
        this._hudArrows();
        this._hudMaterialBar();
        this._updateChestOrBTM_visibility();
    }

    protected void _syncPuzzleGauge() {
    }

    public static enum eDisplayingResultState {
        eDisplayingResultState_Begin,
        eDisplayingResultState_MoveBTMChest,
        eDisplayingResultState_OpenBTMChest,
        eDisplayingResultState_ShowBTM,
        eDisplayingResultState_ShowText,
        eDisplayingResultState_End;

    }

    static enum eDocking {
        eDocking_Down,
        eDocking_Top;

    }

    public static enum eHudState {
        eHudState_InGame,
        eHudState_DisplayingResultsPAR,
        eHudState_DisplayingResultsBTM,
        eHudState_ResultsDisplayed;

    }
}

