/*
 * Decompiled with CFR 0.152.
 */
package SSS.BTM;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Vector2;
import SSS.BTM.GameVars;
import SSS.Level;
import SSS.Managers.BTM.BlocManager;
import org.flixel.FlxG;
import org.flixel.FlxGroup;
import org.flixel.FlxSprite;

public class HologramPuzzleZone {
    FlxSprite m_followTarget;
    FlxSprite m_hologramZoneVisualCursor;
    Vector2 m_hologramLastValidePosition = Vector2.Zero();
    Vector2 m_hologramPosition = Vector2.Zero();
    Vector2 m_hologramPositionOffset = Vector2.Zero();
    FlxGroup m_layer;
    boolean m_bVisible = false;
    Level m_level;
    int m_idCol;
    int m_idLine;
    boolean m_bFullscreen = false;

    public HologramPuzzleZone(FlxGroup _layer, Level _level, FlxSprite _followTarget) {
        this.m_followTarget = _followTarget;
        this.m_layer = _layer;
        this.m_level = _level;
        this._build();
    }

    protected void _build() {
        this.m_bFullscreen = GameVars.HologramBlocHeight() == 0;
        float height = this.m_bFullscreen ? FlxG.height : GameVars.HologramBlocHeight() * GameVars.TileStep();
        this.m_hologramZoneVisualCursor = new FlxSprite();
        this.m_hologramZoneVisualCursor.createGraphic(GameVars.HologramBlocWidth() * GameVars.TileStep(), (int)height, Color.White());
        this.m_hologramZoneVisualCursor.height = height;
        this.m_hologramZoneVisualCursor.alpha(0.2f);
        this.m_hologramZoneVisualCursor.visible = this.m_bVisible;
        this.m_hologramPositionOffset.X = 9.0f;
        this.m_hologramPositionOffset.Y = this.m_bFullscreen ? 0.0f : 9.0f;
        this.m_layer.add(this.m_hologramZoneVisualCursor);
    }

    public void update() {
        float minx = this.m_level.LeftBottom().X + (float)(GameVars.HologramBlocWidth() * GameVars.TileStep()) * 0.5f;
        float maxx = this.m_level.RightTop().X - (float)(GameVars.HologramBlocWidth() * GameVars.TileStep()) * 0.5f + (float)GameVars.TileStep();
        if (this.m_followTarget.x < minx) {
            this.m_followTarget.x = minx;
        } else if (this.m_followTarget.x + this.m_followTarget.width > maxx) {
            this.m_followTarget.x = maxx - this.m_followTarget.width;
        }
    }

    public void updateMiddleScreenPosition(boolean _bForce) {
        float middleX = this.m_followTarget.x + this.m_followTarget.width * 0.5f;
        float middleY = -FlxG.scroll.Y + (float)FlxG.height * 0.5f;
        this.m_level.BlocManager().getLeftRightPointGridLocationHologramZone(middleX, middleY, BlocManager.idCol, BlocManager.idLine);
        this.m_idCol = BlocManager.idCol.get();
        this.m_idLine = BlocManager.idLine.get();
        this.m_hologramPosition.X = this.m_idCol * GameVars.TileStep();
        this.m_hologramPosition.Y = this.m_bFullscreen ? middleY - this.m_hologramZoneVisualCursor.height * 0.5f : (float)(-this.m_idLine * GameVars.TileStep());
        this._positionateHologramCursor(_bForce);
    }

    protected void _positionateHologramCursor(boolean _bForce) {
        float oldx = this.m_hologramZoneVisualCursor.x;
        this.m_hologramZoneVisualCursor.x = this.m_hologramPositionOffset.X + this.m_hologramPosition.X;
        this.m_hologramZoneVisualCursor.y = this.m_hologramPositionOffset.Y + this.m_hologramPosition.Y;
        if (_bForce || oldx != this.m_hologramZoneVisualCursor.x) {
            this._hilightLines();
        }
    }

    protected void _hilightLines() {
        this.m_level.BlocManager().hilightLineHologramArea(this.m_idLine, this.m_idCol);
    }

    public void endMoveMode() {
        this.m_hologramZoneVisualCursor.visible = false;
        this.m_level.BlocManager().unhilightLines();
    }

    public void validateCurrentPosition() {
        if (this.m_hologramLastValidePosition.X != this.m_hologramPosition.X || this.m_hologramLastValidePosition.Y != this.m_hologramPosition.Y) {
            FlxG.flash.start(Color.White());
            this.m_hologramLastValidePosition.X = this.m_hologramZoneVisualCursor.x;
            this.m_hologramLastValidePosition.Y = this.m_hologramZoneVisualCursor.y;
            this.m_level.BlocManager().checkHologramArea(this.m_idLine, this.m_idCol);
        }
    }

    public void show() {
        this.m_hologramZoneVisualCursor.visible = true;
        this.updateMiddleScreenPosition(true);
    }
}

