/*
 * Decompiled with CFR 0.152.
 */
package SSS.BTM;

import Java.Tricks.ref;
import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.MathHelper;
import Microsoft.Xna.Framework.Vector2;
import SSS.Actor;
import SSS.BTM.GameMode;
import SSS.BTM.GameVars;
import SSS.Events.CallbackSimple;
import SSS.Level;
import SSS.Managers.BTM.AchievementManager;
import SSS.Managers.BTM.BlocManager;
import SSS.Managers.BTM.LevelDataBase;
import SSS.Managers.BTM.LevelInfo;
import SSS.Tween.TweenManager;
import SSS.Tween.Tweenable;
import SSS.Tween.Tweener;
import SSS.Util.Utility;
import java.util.ArrayList;
import java.util.Stack;
import org.flixel.FlxG;
import org.flixel.FlxGroup;
import org.flixel.FlxSound;
import org.flixel.FlxSprite;
import org.flixel.FlxText;

public class LineScanner {
    ArrayList<CallbackSimple> LineScanDone = new ArrayList();
    eScanSense m_scanLineSense = eScanSense.eScanSense_LeftRight;
    eScanSense m_destroyLineSense = eScanSense.eScanSense_LeftRight;
    protected eScanState m_state = eScanState.eScanState_Off;
    protected eScanState m_stateOld = eScanState.eScanState_Off;
    protected double m_blinkTimeElapsed = 0.0;
    protected float m_alphaBlink = 1.0f;
    protected static final float m_minAlphaBlink = 0.3f;
    protected static final float m_maxAlphaBlink = 1.0f;
    protected double m_blinkSpeed = 10.0;
    protected float m_timePausingElapsed = 0.0f;
    protected float m_timePausingMax = 0.2f;
    protected float m_timePausingMaxBegin = 0.2f;
    protected float m_timePausingMaxEnd = 0.02f;
    protected float m_timePausingAccelFactor = 0.85f;
    protected FlxGroup m_layer;
    protected Level m_level;
    FlxSprite m_DBG_min;
    FlxSprite m_DBG_max;
    static final float Margin = 256.0f;
    static final float RightMargin = 256.0f;
    float m_positionRight = (float)FlxG.width + 256.0f + 256.0f;
    float m_positionLeft = -256.0f;
    float m_positionTop = -256.0f;
    float m_positionBot = (float)FlxG.height + 256.0f;
    float m_LineScanTimeMax = 1.0f;
    float m_timeElapsed = 0.0f;
    float m_percentageProgression = 0.0f;
    int m_indexPanSound = 0;
    int m_blocMgrLineIdMin = 0;
    int m_blocMgrLineIdMax = 0;
    int m_blocMgrColIdMin = 0;
    int m_blocMgrColIdMax = 0;
    FlxSprite m_dbgVisualLineScan;
    FlxSprite m_dbgVisualDestroyScan;
    ref<FlxSprite> m_refSprite = new ref<Object>(null);
    int m_numLine = 0;
    int m_numLineScanned = 0;
    boolean m_bCheck4LinesAchievement = false;
    int m_scanColId = -1;
    int m_scanColOld = -1;
    int m_scanLineId = -1;
    int m_scanLineOld = -1;
    FlxSound m_sndLineFound = null;
    FlxSound m_sndGreenScan = null;
    FlxSound[] m_sndDestroyPans = null;
    FlxSound[] m_sndNoDestroyPans = null;
    static float TweenTextMaxScale = 5.0f;
    static float TweenTextTweenTotalDuration = 0.5f;
    static float TextOffsetX = 10.0f;
    static float TextOffsetY = -15.0f;
    static float TextHalfWidthScale = 0.25f;
    Stack<FlxText> m_poolText = new Stack();
    ArrayList<FlxText> m_toTween = new ArrayList(30);
    ArrayList<FlxText> m_inTween = new ArrayList(30);

    public void addLineScanDone(CallbackSimple _LineScanDone) {
        this.LineScanDone.add(_LineScanDone);
    }

    public eScanState ScanState() {
        return this.m_state;
    }

    public eScanState ScanStateOld() {
        return this.m_stateOld;
    }

    public int NumLineScanned() {
        return this.m_numLineScanned;
    }

    public void check4LinesAchievement(boolean value) {
        this.m_bCheck4LinesAchievement = value;
    }

    public LineScanner(FlxGroup _layer, Level _level) {
        LevelInfo lvlInfo;
        this.m_layer = _layer;
        this.m_level = _level;
        if (GameVars.GameMode() == GameMode.GameMode_Bonus && !AchievementManager.Instance().isAchievementUnlocked("ACH_TETRIS") && (lvlInfo = LevelDataBase.Instance().getLevelInfo(_level)) != null && lvlInfo.FriendlyName().equals("MANUAL TETRIS")) {
            this.m_bCheck4LinesAchievement = true;
        }
        this._build();
    }

    protected void _build() {
        this._buildSprite(this.m_refSprite, this.m_scanLineSense, Color.Green());
        this.m_dbgVisualLineScan = this.m_refSprite.get();
        this._buildSprite(this.m_refSprite, this.m_destroyLineSense, GameVars.PuzzleColorLine());
        this.m_dbgVisualDestroyScan = this.m_refSprite.get();
        FlxText txt = null;
        int i = 0;
        while (i < 30) {
            txt = new FlxText(0.0f, 0.0f, 20.0f);
            txt.UseShadow(false);
            txt.visible = false;
            this.m_poolText.push(txt);
            this.m_layer.add(txt, true);
            ++i;
        }
        this._setVisible(false);
        if (this.m_level.MainPlayerBehaviour() != null) {
            this.m_sndLineFound = new FlxSound();
            this.m_sndLineFound.loadEmbedded(this.m_level.MainPlayerBehaviour().getStringParameter("SndLinesFound"), false, true, true);
            this.m_sndGreenScan = new FlxSound();
            this.m_sndGreenScan.loadEmbedded(this.m_level.MainPlayerBehaviour().getStringParameter("SndGreenScan"), false, true, true);
            int num = this.m_level.MainPlayerBehaviour().getIntParameter("NumPanSound");
            this.m_sndNoDestroyPans = new FlxSound[num];
            this.m_sndDestroyPans = new FlxSound[num];
            FlxSound snd = null;
            String destroySndBase = this.m_level.MainPlayerBehaviour().getStringParameter("SndColDestroyBasePan");
            String noDestroySndBase = this.m_level.MainPlayerBehaviour().getStringParameter("SndColIntactBasePan");
            int i2 = 0;
            while (i2 < num) {
                String formatNum = String.format("%02d", i2);
                snd = new FlxSound();
                snd.loadEmbedded(String.valueOf(destroySndBase) + formatNum, false, true, true);
                this.m_sndDestroyPans[i2] = snd;
                snd = new FlxSound();
                snd.loadEmbedded(String.valueOf(noDestroySndBase) + formatNum, false, true, true);
                this.m_sndNoDestroyPans[i2] = snd;
                ++i2;
            }
            this.m_timePausingAccelFactor = this.m_level.MainPlayerBehaviour().getFloatParameter("DestroyScanPauseAccel");
        }
    }

    protected void _buildSprite(ref<FlxSprite> _spriteRef, eScanSense _sense, Color _color) {
        FlxSprite _sprite = this.m_level.instanciateSprite("scan");
        if (_sense == eScanSense.eScanSense_LeftRight || _sense == eScanSense.eScanSense_RightLeft) {
            _sprite.scale((float)FlxG.height / _sprite.height);
            _sprite.scrollFactor = Vector2.Zero();
            _sprite.y = (float)FlxG.height * 0.5f - _sprite.height * 0.5f;
            _sprite.x = this.m_positionLeft - _sprite.width;
        } else {
            _sprite.angle(90.0f);
            _sprite.scrollFactor = Vector2.Zero();
            _sprite.x = 0.0f;
            _sprite.y = this.m_positionTop;
        }
        _sprite.color(_color);
        this.m_layer.add(_sprite);
        int size = 100;
        this.m_DBG_min = new FlxSprite();
        this.m_DBG_min.createGraphic(100, 100, Color.Red());
        this.m_DBG_max = new FlxSprite();
        this.m_DBG_max.createGraphic(100, 100, Color.Yellow());
        _spriteRef.set(_sprite);
    }

    public void launchDestroyScanner() {
        if (this.m_state == eScanState.eScanState_Off) {
            this._reinitTweenTextPool();
            if (this.m_numLine > 0) {
                this.m_state = eScanState.eScanState_DestroyingLine;
                this._initPositionning();
                this._setVisible(true);
            }
        }
    }

    public void cancelDestroyScanner() {
        this._reinitTweenTextPool();
        if (this.m_numLine > 0) {
            this._updateBlinking(true);
            this.m_numLine = 0;
            this.m_numLineScanned = 0;
        }
    }

    public void launchLineScanner(boolean _bFirstOne) {
        if (this.m_state == eScanState.eScanState_Off || this.m_state == eScanState.eScanState_ScanningLine) {
            this._reinitTweenTextPool();
            this.m_state = eScanState.eScanState_ScanningLine;
            this._initPositionning();
            this._setVisible(true);
            this._buildBlocManagerCornersIds(_bFirstOne);
            this._flagActorsInALine();
            this.m_sndGreenScan.play();
        }
    }

    protected void _reinitTweenTextPool() {
        int i;
        if (this.m_inTween.size() > 0) {
            i = 0;
            while (i < this.m_inTween.size()) {
                this.m_level.TweenManager().RemoveTweenable(this.m_inTween.get(i));
                this._refillPool(this.m_inTween.get(i));
                ++i;
            }
            this.m_inTween.clear();
        }
        if (this.m_toTween.size() > 0) {
            i = 0;
            while (i < this.m_toTween.size()) {
                this._refillPool(this.m_toTween.get(i));
                ++i;
            }
            this.m_toTween.clear();
        }
    }

    protected void _buildBlocManagerCornersIds(boolean _bFirstTime) {
        float margin = 0.0f;
        float left = -FlxG.scroll.X + margin;
        float right = left + (float)FlxG.width - 2.0f * margin;
        float top = -FlxG.scroll.Y + margin;
        float bot = top + (float)FlxG.height - 2.0f * margin;
        this.m_level.BlocManager().getPointGridLocationClamped(left, bot, BlocManager.idCo, BlocManager.idLi);
        this.m_blocMgrColIdMin = BlocManager.idCo.get();
        this.m_blocMgrLineIdMin = BlocManager.idLi.get();
        this.m_level.BlocManager().getPointGridLocationClamped(right, top, BlocManager.idCo, BlocManager.idLi);
        this.m_blocMgrColIdMax = BlocManager.idCo.get();
        this.m_blocMgrLineIdMax = BlocManager.idLi.get();
        this.m_DBG_min.x = this.m_blocMgrColIdMin * GameVars.TileStep();
        this.m_DBG_min.y = -this.m_blocMgrLineIdMin * GameVars.TileStep();
        this.m_DBG_max.x = this.m_blocMgrColIdMax * GameVars.TileStep();
        this.m_DBG_max.y = -this.m_blocMgrLineIdMax * GameVars.TileStep();
        this.m_DBG_min.x -= this.m_DBG_min.width * 0.5f;
        this.m_DBG_min.y -= this.m_DBG_min.height * 0.5f;
        this.m_DBG_max.x -= this.m_DBG_max.width * 0.5f;
        this.m_DBG_max.y -= this.m_DBG_max.height * 0.5f;
        Actor actor = null;
        int li = this.m_blocMgrLineIdMin;
        while (li <= this.m_blocMgrLineIdMax) {
            int co = this.m_blocMgrColIdMin;
            while (co <= this.m_blocMgrColIdMax) {
                actor = this.m_level.BlocManager().getActorInBlocSlot(li, co, true);
                if (actor != null) {
                    actor.removeFlag(Actor.eSpecialFlag.eSpecialFlag_InALine);
                    actor.removeFlag(Actor.eSpecialFlag.eSpecialFlag_LastActorInALine);
                }
                ++co;
            }
            ++li;
        }
    }

    public void beginUse() {
        this.m_dbgVisualLineScan.alpha(1.0f);
        this.m_level.TweenManager().ToAlpha((Tweenable)this.m_dbgVisualLineScan, 0.5f, 0.1f, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, TweenManager.LoopType.PingPong);
        this.m_dbgVisualDestroyScan.alpha(1.0f);
        this.m_level.TweenManager().ToAlpha((Tweenable)this.m_dbgVisualDestroyScan, 0.5f, 0.4f, TweenManager.EaseType.EASE_INOUTBOUNCE, 0.0f, TweenManager.LoopType.PingPong);
    }

    public void endUse() {
        this.m_level.TweenManager().RemoveTweenable(this.m_dbgVisualLineScan);
        this.m_level.TweenManager().RemoveTweenable(this.m_dbgVisualDestroyScan);
    }

    protected void _updateBlinking(boolean _bForceOpaque) {
        this.m_blinkTimeElapsed += (double)FlxG.elapsed * this.m_blinkSpeed;
        float f = this.m_alphaBlink = _bForceOpaque ? 1.0f : (float)(Math.cos(this.m_blinkTimeElapsed) * 0.5 + 0.5);
        if (!_bForceOpaque) {
            this.m_alphaBlink = MathHelper.Lerp(0.3f, 1.0f, this.m_alphaBlink);
        }
        if (this.m_numLine > 0) {
            Actor actor = null;
            int li = this.m_blocMgrLineIdMin;
            while (li <= this.m_blocMgrLineIdMax) {
                int co = this.m_blocMgrColIdMin;
                while (co <= this.m_blocMgrColIdMax) {
                    actor = this.m_level.BlocManager().getActorInBlocSlot(li, co, true);
                    if (actor != null && actor.hasFlag(Actor.eSpecialFlag.eSpecialFlag_MustBlink)) {
                        actor.alpha(this.m_alphaBlink);
                        if (_bForceOpaque) {
                            actor.removeFlag(Actor.eSpecialFlag.eSpecialFlag_MustBlink);
                            actor.removeFlag(Actor.eSpecialFlag.eSpecialFlag_InALine);
                            actor.removeFlag(Actor.eSpecialFlag.eSpecialFlag_LastActorInALine);
                            this._stainColor(actor);
                        } else {
                            actor.color(GameVars.PuzzleColorLine());
                        }
                    }
                    ++co;
                }
                ++li;
            }
        }
    }

    protected void _stainColor(Actor _actor) {
        if (!_actor.hasFlag(Actor.eSpecialFlag.eSpecialFlag_AvoidStainColor)) {
            if (_actor.Material() == Actor.eActorMaterial.eActorMaterial_Paint) {
                _actor.color().multiply(GameVars.PuzzleColorStain());
            } else {
                _actor.color(GameVars.PuzzleColorStain());
            }
        } else if (_actor.Material() == Actor.eActorMaterial.eActorMaterial_Paint) {
            _actor.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_ActorInitDefaultColor, null);
        } else {
            _actor.color(Color.White());
        }
    }

    protected void _flagActorsInALine() {
        if (GameVars.PlayerCanDoLines() == 0) {
            return;
        }
        Actor lastActorInLine = null;
        Actor actor = null;
        int numSuccessiveBloc = 0;
        int co = 0;
        this.m_numLine = 0;
        this.m_numLineScanned = 0;
        int li = this.m_blocMgrLineIdMin;
        while (li <= this.m_blocMgrLineIdMax) {
            co = this.m_blocMgrColIdMin;
            while (co <= this.m_blocMgrColIdMax) {
                actor = this.m_level.BlocManager().getActorInBlocSlot(li, co, true);
                int idBeg = co;
                numSuccessiveBloc = 0;
                if (actor != null && Actor.IsRemovableNotLineParticipating(actor.Material())) {
                    actor = null;
                }
                while (actor != null && co <= this.m_blocMgrColIdMax) {
                    actor = this.m_level.BlocManager().getActorInBlocSlot(li, co, true);
                    if (actor == null) continue;
                    ++numSuccessiveBloc;
                    ++co;
                }
                if (numSuccessiveBloc >= GameVars.BlocManagerTick()) {
                    ++this.m_numLine;
                    lastActorInLine = null;
                    int idCo = idBeg;
                    while (idCo < idBeg + numSuccessiveBloc) {
                        actor = this.m_level.BlocManager().getActorInBlocSlot(li, idCo, true);
                        if (actor != null) {
                            lastActorInLine = actor;
                            actor.addFlag(Actor.eSpecialFlag.eSpecialFlag_InALine);
                        }
                        ++idCo;
                    }
                    if (lastActorInLine != null && !actor.hasFlag(Actor.eSpecialFlag.eSpecialFlag_LastActorInALine)) {
                        actor.addFlag(Actor.eSpecialFlag.eSpecialFlag_LastActorInALine);
                        this._prepareTweenText(actor, numSuccessiveBloc);
                    }
                }
                ++co;
            }
            ++li;
        }
    }

    protected void _updateBlocDependingScanTypeAndSense(FlxSprite _visual, boolean _bDestroying, eScanSense _sense) {
        float left = -FlxG.scroll.X + _visual.x + _visual.width;
        float top = -FlxG.scroll.Y + _visual.y;
        this.m_level.BlocManager().getPointGridLocationNoCheck(left, top, BlocManager.idCol, BlocManager.idLine);
        int idLine = BlocManager.idLine.get();
        int idCol = BlocManager.idCol.get();
        this.m_scanColOld = this.m_scanColId;
        this.m_scanColId = idCol;
        this.m_scanLineOld = this.m_scanLineId;
        this.m_scanLineId = ++idLine;
        this.m_scanColOld = Utility.Clamp(this.m_scanColOld, this.m_blocMgrColIdMin, this.m_blocMgrColIdMax);
        this.m_scanColId = Utility.Clamp(this.m_scanColId, this.m_blocMgrColIdMin, this.m_blocMgrColIdMax);
        boolean bDestroySound = false;
        boolean bNoDestroySound = false;
        if (_sense == eScanSense.eScanSense_LeftRight || _sense == eScanSense.eScanSense_RightLeft) {
            if (this.m_scanColOld >= this.m_blocMgrColIdMin && this.m_scanColOld <= this.m_blocMgrColIdMax && this.m_scanColId >= this.m_blocMgrColIdMin && this.m_scanColId <= this.m_blocMgrColIdMax && this.m_scanColId != this.m_scanColOld) {
                Actor actor = null;
                int co = this.m_scanColOld;
                while (co <= this.m_scanColId) {
                    int li = this.m_blocMgrLineIdMin;
                    while (li <= this.m_blocMgrLineIdMax) {
                        actor = this.m_level.BlocManager().getActorInBlocSlot(li, co, true);
                        if (actor != null) {
                            if (actor.hasFlag(Actor.eSpecialFlag.eSpecialFlag_InALine)) {
                                if (_bDestroying) {
                                    if (!actor.hasFlag(Actor.eSpecialFlag.eSpecialFlag_MarkAsDestroyed)) {
                                        this._goToPause();
                                        bDestroySound = true;
                                        if (GameVars.BlueScanShakeAmplitudeDuration().X > 0.0f && GameVars.BlueScanShakeAmplitudeDuration().Y > 0.0f) {
                                            FlxG.quake.start(GameVars.BlueScanShakeAmplitudeDuration().X, GameVars.BlueScanShakeAmplitudeDuration().Y);
                                        }
                                        actor.addFlag(Actor.eSpecialFlag.eSpecialFlag_MarkAsDestroyed);
                                        actor.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_PuzzleModeExplode, null);
                                    }
                                } else {
                                    actor.addFlag(Actor.eSpecialFlag.eSpecialFlag_MustBlink);
                                    if (actor.hasFlag(Actor.eSpecialFlag.eSpecialFlag_LastActorInALine)) {
                                        this._launchTweenText(actor);
                                        actor.removeFlag(Actor.eSpecialFlag.eSpecialFlag_LastActorInALine);
                                    }
                                }
                            } else {
                                actor.removeFlag(Actor.eSpecialFlag.eSpecialFlag_MustBlink);
                                actor.alpha(1.0f);
                                this._stainColor(actor);
                            }
                        }
                        ++li;
                    }
                    ++co;
                }
            }
        } else if (this.m_scanLineOld >= this.m_blocMgrLineIdMin && this.m_scanLineOld <= this.m_blocMgrLineIdMax && this.m_scanLineId >= this.m_blocMgrLineIdMin && this.m_scanLineId <= this.m_blocMgrLineIdMax && this.m_scanLineId != this.m_scanLineOld) {
            Actor actor = null;
            int co = this.m_blocMgrColIdMin;
            while (co <= this.m_blocMgrColIdMax) {
                actor = this.m_level.BlocManager().getActorInBlocSlot(this.m_scanLineId, co, true);
                if (actor != null && actor.hasFlag(Actor.eSpecialFlag.eSpecialFlag_InALine)) {
                    if (actor.hasFlag(Actor.eSpecialFlag.eSpecialFlag_InALine)) {
                        if (_bDestroying) {
                            actor.Level().removeActorsToPhysic(actor);
                        } else {
                            actor.addFlag(Actor.eSpecialFlag.eSpecialFlag_MustBlink);
                        }
                    } else {
                        actor.removeFlag(Actor.eSpecialFlag.eSpecialFlag_MustBlink);
                        actor.alpha(1.0f);
                        this._stainColor(actor);
                    }
                }
                ++co;
            }
        }
        if (_bDestroying && this.m_scanColOld != this.m_scanColId) {
            if (!bDestroySound) {
                bNoDestroySound = true;
            }
            if (bDestroySound) {
                this._playSoundDependingProgression(this.m_dbgVisualDestroyScan, this.m_sndDestroyPans);
            }
            if (bNoDestroySound) {
                this._playSoundDependingProgression(this.m_dbgVisualDestroyScan, this.m_sndNoDestroyPans);
            }
        }
    }

    protected void _launchTweenText(Actor _actor) {
        this.m_level.BlocManager().getActorGridLocation(_actor, BlocManager.idCol, BlocManager.idLine);
        int idCol = BlocManager.idCol.get();
        int idLine = BlocManager.idLine.get();
        boolean bFound = false;
        int i = 0;
        float rightScreenX = -FlxG.scroll.X + (float)FlxG.width;
        float textx = 0.0f;
        FlxText txt = null;
        while (!bFound && i < this.m_toTween.size()) {
            txt = this.m_toTween.get(i);
            int c = (int)txt.x;
            int l = (int)txt.y;
            if (c == idCol && l == idLine) {
                txt.x = _actor.x + _actor.width * 0.5f - txt.width * 0.5f + TextOffsetX;
                txt.y = _actor.y + _actor.height * 0.5f - txt.height * 0.5f + TextOffsetY;
                txt.alignment = FlxText.FlxJustification.Center;
                txt.alpha(0.0f);
                txt.visible = true;
                txt.scale(TweenTextMaxScale);
                this.m_level.TweenManager().ToAlpha((Tweenable)txt, 0.7f, TweenTextTweenTotalDuration, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, (CallbackSimple)null);
                this.m_level.TweenManager().ToAlpha((Tweenable)txt, 0.2f, TweenTextTweenTotalDuration * 2.5f, TweenManager.EaseType.EASE_INOUTSIN, TweenTextTweenTotalDuration, TweenManager.LoopType.PingPong);
                textx = txt.x + txt.width - TextHalfWidthScale * txt.width;
                if (textx > rightScreenX) {
                    txt.x -= textx - rightScreenX + txt.width;
                }
                bFound = true;
            }
            ++i;
        }
        if (bFound && txt != null) {
            this.m_toTween.remove(txt);
            this.m_inTween.add(txt);
        }
    }

    protected void _refillPool(FlxText _tweenerText) {
        _tweenerText.visible = false;
        this.m_poolText.push(_tweenerText);
    }

    protected void _prepareTweenText(Actor _actor, int _value) {
        if (this.m_poolText.size() > 0) {
            this.m_level.BlocManager().getActorGridLocation(_actor, BlocManager.idCol, BlocManager.idLine);
            int idCol = BlocManager.idCol.get();
            int idLine = BlocManager.idLine.get();
            FlxText txt = this.m_poolText.pop();
            this.m_toTween.add(txt);
            txt.x = idCol;
            txt.y = idLine;
            txt.text(Utility.ArrayStringDigit[_value]);
        }
    }

    protected void _tweenTextDone(Object _sender, Object _e) {
        Tweener tweener = (Tweener)_sender;
        FlxText txt = (FlxText)tweener.Tweenable();
        this._refillPool(txt);
        this.m_inTween.remove(txt);
    }

    protected void _playSoundDependingProgression(FlxSprite _visual, FlxSound[] _arrSoundPans) {
        float percentage = _visual.x + _visual.width * 0.5f;
        int id = (int)((percentage /= (float)FlxG.width) * (float)_arrSoundPans.length);
        if (id < 0) {
            id = 0;
        } else if (id >= _arrSoundPans.length) {
            id = _arrSoundPans.length - 1;
        }
        _arrSoundPans[id].play();
    }

    protected void _goToPause() {
        this.m_timePausingElapsed = 0.0f;
        this.m_state = eScanState.eScanState_DestroyingLinePausing;
    }

    protected void _updateDestroyLineId() {
    }

    protected void _initPositionning() {
        this.m_indexPanSound = 0;
        this.m_timePausingMax = this.m_timePausingMaxBegin;
        switch (this.m_state) {
            case eScanState_DestroyingLine: {
                this._initPositionning(this.m_dbgVisualDestroyScan, this.m_destroyLineSense);
                break;
            }
            case eScanState_ScanningLine: {
                this._initPositionning(this.m_dbgVisualLineScan, this.m_scanLineSense);
            }
        }
    }

    protected void _initPositionning(FlxSprite _sprite, eScanSense _scanSense) {
        switch (_scanSense) {
            case eScanSense_LeftRight: {
                _sprite.x = this.m_positionLeft - _sprite.width;
                break;
            }
            case eScanSense_RightLeft: {
                _sprite.x = this.m_positionRight;
                break;
            }
            case eScanSense_BottomTop: {
                _sprite.y = this.m_positionBot;
                break;
            }
            case eScanSense_TopBottom: {
                _sprite.y = this.m_positionTop - _sprite.width;
            }
        }
        this.m_timeElapsed = 0.0f;
    }

    protected void _setVisible(boolean _bVisible) {
        this.m_dbgVisualLineScan.visible = _bVisible;
        this.m_dbgVisualDestroyScan.visible = _bVisible;
    }

    public void update() {
        this.m_stateOld = this.m_state;
        switch (this.m_state) {
            case eScanState_Off: {
                break;
            }
            case eScanState_DestroyingLine: {
                this._updateVisual(this.m_dbgVisualDestroyScan, this.m_destroyLineSense, true, eScanState.eScanState_DestroyingLineShowResult, this.m_LineScanTimeMax);
                break;
            }
            case eScanState_DestroyingLinePausing: {
                this.m_timePausingElapsed += FlxG.elapsed;
                if (!(this.m_timePausingElapsed > this.m_timePausingMax)) break;
                this.m_timePausingMax *= this.m_timePausingAccelFactor;
                if (this.m_timePausingMax < this.m_timePausingMaxEnd) {
                    this.m_timePausingMax = this.m_timePausingMaxEnd;
                }
                this.m_timePausingElapsed = 0.0f;
                this.m_state = eScanState.eScanState_DestroyingLine;
                break;
            }
            case eScanState_ScanningLine: {
                this._updateVisual(this.m_dbgVisualLineScan, this.m_scanLineSense, false, eScanState.eScanState_ScanningLineShowResult, this.m_LineScanTimeMax * GameVars.GreenScanSpeed());
                if (this.m_state != eScanState.eScanState_ScanningLineShowResult) break;
                this.m_numLineScanned = this.m_numLine;
                if (this.LineScanDone == null) break;
                int i = 0;
                while (i < this.LineScanDone.size()) {
                    this.LineScanDone.get(i).onCallback(this, null);
                    ++i;
                }
                break;
            }
            case eScanState_ScanningLineShowResult: {
                if (this.m_numLineScanned > 0) {
                    this.m_sndLineFound.play();
                }
                this.m_state = eScanState.eScanState_Off;
                break;
            }
            case eScanState_DestroyingLineShowResult: {
                this.m_state = eScanState.eScanState_Off;
                if (!this.m_bCheck4LinesAchievement || this.m_numLineScanned != 4) break;
                AchievementManager.Instance().unlockAchievement("ACH_TETRIS");
                this.m_bCheck4LinesAchievement = false;
            }
        }
        this._updateBlinking(false);
    }

    protected void _updateVisual(FlxSprite _visual, eScanSense _sense, boolean _bDestroying, eScanState _nextState, float _lineScanTime) {
        this.m_timeElapsed += FlxG.elapsed;
        if (this.m_timeElapsed > _lineScanTime) {
            this.m_state = _nextState;
            this.m_timeElapsed = _lineScanTime;
        }
        this.m_percentageProgression = this.m_timeElapsed / _lineScanTime;
        switch (this.m_scanLineSense) {
            case eScanSense_LeftRight: {
                _visual.x = MathHelper.Lerp(this.m_positionLeft, this.m_positionRight, this.m_percentageProgression);
                _visual.x -= _visual.width;
                break;
            }
            case eScanSense_RightLeft: {
                _visual.x = MathHelper.Lerp(this.m_positionRight, this.m_positionLeft, this.m_percentageProgression);
                break;
            }
            case eScanSense_TopBottom: {
                _visual.y = MathHelper.Lerp(this.m_positionTop, this.m_positionBot, this.m_percentageProgression);
                break;
            }
            case eScanSense_BottomTop: {
                _visual.y = MathHelper.Lerp(this.m_positionBot, this.m_positionTop, this.m_percentageProgression);
            }
        }
        this._updateBlocDependingScanTypeAndSense(_visual, _bDestroying, _sense);
    }

    protected static enum eScanSense {
        eScanSense_LeftRight,
        eScanSense_RightLeft,
        eScanSense_TopBottom,
        eScanSense_BottomTop;

    }

    public static enum eScanState {
        eScanState_Off,
        eScanState_ScanningLine,
        eScanState_DestroyingLine,
        eScanState_DestroyingLinePausing,
        eScanState_ScanningLineShowResult,
        eScanState_DestroyingLineShowResult;

    }
}

