/*
 * Decompiled with CFR 0.152.
 */
package SSS.BTM;

import SSS.BTM.GameMode;
import SSS.BTM.GameVars;
import SSS.Level;
import SSS.Managers.BTM.LevelDataBase;
import SSS.Managers.BTM.LevelGroup;
import org.flixel.FlxG;
import org.flixel.FlxState;

public class PlayState
extends FlxState {
    protected Level m_level;
    boolean m_bPlay = false;
    boolean m_bAllowEdit = false;
    String m_sequence = "";
    String m_levelName = "";
    LevelGroup m_levelGroup = null;
    boolean m_bLoadAtCreation = false;

    public Level Level() {
        return this.m_level;
    }

    public PlayState() {
    }

    public PlayState(boolean _bPlayOnStart, boolean _bAllowEdit, String _sequence) {
        this.m_bPlay = _bPlayOnStart;
        this.m_bAllowEdit = _bAllowEdit;
        this.m_sequence = _sequence;
        this.m_levelName = "";
        this.m_levelGroup = null;
    }

    public PlayState(boolean _bPlayOnStart, boolean _bAllowEdit, String _levelName, String _levelGroupId) {
        LevelGroup lvlGroup = null;
        if (_levelGroupId != null && _levelGroupId.length() > 0) {
            lvlGroup = LevelDataBase.Instance().getLevelGroup(_levelGroupId);
        }
        this._construct(_bPlayOnStart, _bAllowEdit, _levelName, lvlGroup);
    }

    public PlayState(boolean _bPlayOnStart, boolean _bAllowEdit, String _levelName, LevelGroup _levelGroup) {
        this._construct(_bPlayOnStart, _bAllowEdit, _levelName, _levelGroup);
    }

    protected void _construct(boolean _bPlayOnStart, boolean _bAllowEdit, String _levelName, LevelGroup _levelGroup) {
        this.m_bPlay = _bPlayOnStart;
        this.m_bAllowEdit = _bAllowEdit;
        this.m_sequence = "";
        if (GameVars.GameMode() == GameMode.GameMode_LocalLevelEditor) {
            this.m_levelName = GameVars.LastCommunityEditLevelXmlName();
        } else if (GameVars.GameMode() == GameMode.GameMode_OnlineContent) {
            this.m_bAllowEdit = false;
            this.m_levelName = GameVars.LastCommunityPlayedLevelXmlName();
        } else {
            this.m_levelName = _levelName;
        }
        this.m_levelGroup = _levelGroup;
        this.m_bLoadAtCreation = true;
    }

    @Override
    public void create() {
        FlxG.SSSUseNearTextureFiltering = false;
        System.gc();
        if (this.m_bPlay) {
            this.m_level = new Level(this, Level.eLevelMode.eLevelMode_Play);
            this.m_level.allowEdit(this.m_bAllowEdit);
            if (this.m_sequence != null && this.m_sequence.length() > 0) {
                this.m_level.launchFirstLevelInSequence(this.m_sequence);
                this.m_bLoadAtCreation = false;
            }
        } else {
            this.m_level = new Level(this, Level.eLevelMode.eLevelMode_Edit);
        }
        if (this.m_bLoadAtCreation && this.m_levelName.length() > 0) {
            this.m_level.loadLevel(this.m_levelName, this.m_levelGroup);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.m_level.destroy();
    }

    @Override
    public void update() {
        if (!this.m_level.Pause()) {
            super.update();
        }
        this.m_level.update();
    }
}

