/*
 * Decompiled with CFR 0.152.
 */
package SSS.BTM;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Input.Buttons;
import Microsoft.Xna.Framework.MathHelper;
import Microsoft.Xna.Framework.Point;
import Microsoft.Xna.Framework.Vector2;
import SSS.Actor;
import SSS.BTM.GameVars;
import SSS.BTM.LineScanner;
import SSS.BTM.PieceDefVars;
import SSS.Behaviours.BTM.PlayerBehaviour;
import SSS.Events.CallbackSimple;
import SSS.Managers.BTM.AchievementManager;
import SSS.Managers.BTM.BlocManager;
import SSS.SssGroup;
import SSS.Tween.TweenManager;
import SSS.Tween.Tweenable;
import SSS.Util.Debug;
import SSS.Util.InputManager;
import SSS.Util.Utility;
import java.util.ArrayList;
import java.util.Arrays;
import org.flixel.FlxG;
import org.flixel.FlxSound;
import org.flixel.FlxText;

public class PuzzleBlocSpawner {
    ArrayList<CallbackSimple> PuzzleBlocSpawnerJustLeave = new ArrayList();
    ArrayList<CallbackSimple> CursorMoved = new ArrayList();
    ArrayList<CallbackSimple> ScanLineLaunched = new ArrayList();
    ArrayList<CallbackSimple> ScanLineDone = new ArrayList();
    ArrayList<CallbackSimple> DestroyLineLaunched = new ArrayList();
    ArrayList<CallbackSimple> DestroyLineDone = new ArrayList();
    PlayerBehaviour m_playerComponent;
    SssGroup m_blocLayer;
    SssGroup m_delimiterLayer;
    Actor m_currentBloc = null;
    int m_currentBlocColId;
    int m_currentBlocLineId;
    boolean m_bOverlap = false;
    boolean m_bLinkedToExitingBloc = false;
    int m_blocCounter = 0;
    SssGroup m_actorToMaterialize = new SssGroup();
    SssGroup m_currentPieceGroup = new SssGroup();
    float m_spawnx;
    float m_spawny;
    static final float AlphaBlocNotMaterialized = 0.5f;
    FlxText[] m_arrBlocCountDownTexts = null;
    Actor m_cursor;
    float m_cursorOffsetx = 10.0f;
    float m_cursorOffsety = 10.0f;
    static float CurrentBlocOffsetx = -5.0f;
    static float CurrentBlocOffsety = -5.0f;
    Actor[][] m_fullscreenGrid;
    int m_fullscreenGridSizeX = 0;
    int m_fullscreenGridSizeY = 0;
    int m_fullscreenGridColIdMin;
    int m_fullscreenGridLineIdMin;
    int m_fullscreenGridColIdMax;
    int m_fullscreenGridLineIdMax;
    static Color AroundGridCusor_Color = new Color(1.0f, 1.0f, 1.0f);
    static float AroundGridCusor_Alpha = 0.8f;
    static Color GridCusor_Color = new Color(1.0f, 1.0f, 1.0f);
    static float GridCusor_Alpha = 0.8f;
    static float GridCellVisibleOnScreenScale = 0.4f;
    int m_cursorIdLineOrigin;
    int m_cursorIdColOrigin;
    Actor[][] m_cursorKernelGrid = null;
    int m_cursorKernelGridSize = 0;
    int m_cursorCenterKernelId = 0;
    boolean m_bLeaverequested = false;
    LineScanner m_lineScanner;
    boolean m_bLineScan = true;
    float m_timeStickDownElapsed = 0.0f;
    float m_timeStickDownElapsedTotal = 0.0f;
    float m_timeFromBegToEnd = 1.0f;
    float m_timeAutoStickMaxInterpol;
    float m_timeAutoStickMaxBeg = 0.25f;
    float m_timeAutoStickMaxEnd = 0.1f;
    boolean m_bJustMove = false;
    float m_alphaBloc = 1.0f;
    float m_timeElapsed = 0.0f;
    FlxSound m_sndPoseBloc = null;
    FlxSound m_sndMoveBloc = null;
    FlxSound m_sndCancelBloc = null;
    boolean m_bCheckIJLOSTZ = false;
    int[] m_numPiecesIJLOSTZ = null;
    CallbackSimple m_LineScanDone = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            PuzzleBlocSpawner.this.LineScanDone(_sender, _args);
        }
    };
    static boolean[][] IJLOSTZ = new boolean[][]{new boolean[4], new boolean[4], new boolean[4], new boolean[4]};
    static int[] DetermineTetrominoIdX = new int[4];
    static int[] DetermineTetrominoIdY = new int[4];

    public void addPuzzleBlocSpawnerJustLeave(CallbackSimple _callback) {
        this.PuzzleBlocSpawnerJustLeave.add(_callback);
    }

    public void addCursorMoved(CallbackSimple _callback) {
        this.CursorMoved.add(_callback);
    }

    public void addScanLineLaunched(CallbackSimple _callback) {
        this.ScanLineLaunched.add(_callback);
    }

    public void addScanLineDone(CallbackSimple _callback) {
        this.ScanLineDone.add(_callback);
    }

    public void addDestroyLineLaunched(CallbackSimple _callback) {
        this.DestroyLineLaunched.add(_callback);
    }

    public void addDestroyLineDone(CallbackSimple _callback) {
        this.DestroyLineDone.add(_callback);
    }

    public boolean UseLineScan() {
        return this.m_bLineScan;
    }

    public PuzzleBlocSpawner(PlayerBehaviour _playerComponent, SssGroup _blocLayer, SssGroup _delimiterLayer) {
        this.m_playerComponent = _playerComponent;
        this.m_blocLayer = _blocLayer;
        this.m_delimiterLayer = _delimiterLayer;
        this._buildFullscreenGrid();
        this._buildCursorGrid();
        this._showHideCursorGrid(false);
        this._buildTexts();
        this._buildSounds();
        this.m_lineScanner = new LineScanner(_delimiterLayer, this.m_playerComponent.Level());
        this.m_lineScanner.addLineScanDone(this.m_LineScanDone);
        boolean bl = this.m_bCheckIJLOSTZ = !AchievementManager.Instance().isAchievementUnlocked("ACH_IJLOSTZ");
        if (this.m_bCheckIJLOSTZ) {
            this.m_numPiecesIJLOSTZ = new int[7];
            Arrays.fill(this.m_numPiecesIJLOSTZ, 0);
        }
    }

    public boolean isScanningOrDestoring() {
        return this.m_lineScanner.ScanState() == LineScanner.eScanState.eScanState_ScanningLine || this.m_lineScanner.ScanState() == LineScanner.eScanState.eScanState_DestroyingLine;
    }

    public boolean isDestroyScanAvailable() {
        return this.m_lineScanner.NumLineScanned() > 0 && (this.m_lineScanner.ScanState() == LineScanner.eScanState.eScanState_ScanningLineShowResult || this.m_lineScanner.ScanState() == LineScanner.eScanState.eScanState_Off);
    }

    protected void _buildSounds() {
        this.m_sndPoseBloc = new FlxSound();
        this.m_sndPoseBloc.loadEmbedded(this.m_playerComponent.getStringParameter("SndBlocPose"), false, true, true);
        this.m_sndMoveBloc = new FlxSound();
        this.m_sndMoveBloc.loadEmbedded(this.m_playerComponent.getStringParameter("SndCursorMove"), false, true, true);
        this.m_sndCancelBloc = new FlxSound();
        this.m_sndCancelBloc.loadEmbedded(this.m_playerComponent.getStringParameter("SndCursorCancel"), false, true, true);
    }

    protected void _buildFullscreenGrid() {
        if (this.m_playerComponent.Level().PlayableMode()) {
            Actor gridCell = null;
            this.m_fullscreenGridSizeX = (int)((float)FlxG.width * GameVars.OneOverTileStep()) + 1;
            this.m_fullscreenGridSizeY = (int)((float)FlxG.height * GameVars.OneOverTileStep()) + 1;
            Debug.Assert(this.m_fullscreenGridSizeX > 0 && this.m_fullscreenGridSizeY > 0);
            this.m_fullscreenGrid = new Actor[this.m_fullscreenGridSizeY][this.m_fullscreenGridSizeX];
            int li = 0;
            while (li < this.m_fullscreenGridSizeY) {
                int co = 0;
                while (co < this.m_fullscreenGridSizeX) {
                    gridCell = this.m_playerComponent.Level().instanciateActor("puzzleCursorNew");
                    gridCell.play("grid");
                    gridCell.visible = false;
                    gridCell.color(GameVars.PuzzleModeColorFullscreenGrid());
                    gridCell.alpha((float)GameVars.PuzzleModeColorFullscreenGrid().A / 255.0f);
                    this.m_fullscreenGrid[li][co] = gridCell;
                    this.m_delimiterLayer.add(gridCell);
                    ++co;
                }
                ++li;
            }
        }
    }

    protected void _positionnateFullscreenGrid() {
        float left = -FlxG.scroll.X;
        float top = -FlxG.scroll.Y;
        this.m_playerComponent.Level().BlocManager().getPointGridLocationClamped(left, top, BlocManager.idCol, BlocManager.idLine);
        int idCol = BlocManager.idCol.get();
        int idLine = BlocManager.idLine.get();
        ++idLine;
        this.m_fullscreenGridColIdMin = Integer.MAX_VALUE;
        this.m_fullscreenGridLineIdMin = Integer.MAX_VALUE;
        this.m_fullscreenGridColIdMax = Integer.MIN_VALUE;
        this.m_fullscreenGridLineIdMax = Integer.MIN_VALUE;
        float x = (float)(GameVars.TileStep() * idCol) + this.m_cursorOffsetx;
        float y = (float)(-GameVars.TileStep() * idLine) + this.m_cursorOffsety;
        Actor gridCell = null;
        int li = 0;
        while (li < this.m_fullscreenGridSizeY) {
            x = (float)(GameVars.TileStep() * idCol) + this.m_cursorOffsetx;
            int co = 0;
            while (co < this.m_fullscreenGridSizeX) {
                gridCell = this.m_fullscreenGrid[li][co];
                gridCell.x = x;
                gridCell.y = y;
                gridCell.color(GameVars.PuzzleModeColorFullscreenGrid());
                gridCell.alpha((float)GameVars.PuzzleModeColorFullscreenGrid().A / 255.0f);
                if (gridCell.isVisibleOnScreen(GridCellVisibleOnScreenScale)) {
                    this.m_playerComponent.Level().BlocManager().getPointGridLocationClamped(x, y, BlocManager.idCo, BlocManager.idLi);
                    int cellIdCol = BlocManager.idCo.get();
                    int cellIdLine = BlocManager.idLi.get();
                    if (cellIdCol > this.m_fullscreenGridColIdMax) {
                        this.m_fullscreenGridColIdMax = cellIdCol;
                    }
                    if (cellIdCol < this.m_fullscreenGridColIdMin) {
                        this.m_fullscreenGridColIdMin = cellIdCol;
                    }
                    if (cellIdLine > this.m_fullscreenGridLineIdMax) {
                        this.m_fullscreenGridLineIdMax = cellIdLine;
                    }
                    if (cellIdLine < this.m_fullscreenGridLineIdMin) {
                        this.m_fullscreenGridLineIdMin = cellIdLine;
                    }
                } else {
                    gridCell.alpha(1.0f);
                }
                x += (float)GameVars.TileStep();
                ++co;
            }
            y += (float)GameVars.TileStep();
            ++li;
        }
    }

    protected void _showHideFullscreenGrid(boolean _bShow) {
        if (this.m_playerComponent.Level().PlayableMode()) {
            int li = 0;
            while (li < this.m_fullscreenGridSizeY) {
                int co = 0;
                while (co < this.m_fullscreenGridSizeX) {
                    this.m_fullscreenGrid[li][co].visible = _bShow;
                    ++co;
                }
                ++li;
            }
        }
    }

    protected void _buildCursorGrid() {
        this.m_cursorKernelGridSize = GameVars.BlocCountToFormPiece() * 2 - 1;
        this.m_cursorCenterKernelId = this.m_cursorKernelGridSize / 2;
        this.m_cursorKernelGrid = new Actor[this.m_cursorKernelGridSize][this.m_cursorKernelGridSize];
        int i = 0;
        while (i < this.m_cursorKernelGridSize) {
            int j = 0;
            while (j < this.m_cursorKernelGridSize) {
                Actor newAct = this.m_playerComponent.Level().instanciateActor("puzzleCursorNew");
                newAct.Material(Actor.eActorMaterial.eActorMaterial_Hud_L2);
                newAct.play("c");
                newAct.color(GameVars.PuzzleModeColorAroundCursorGrid());
                newAct.alpha((float)GameVars.PuzzleModeColorAroundCursorGrid().A / 255.0f);
                newAct.visible = false;
                this.m_delimiterLayer.add(newAct);
                this.m_cursorKernelGrid[i][j] = newAct;
                ++j;
            }
            ++i;
        }
        this.m_cursorKernelGrid[this.m_cursorCenterKernelId][this.m_cursorCenterKernelId].visible = false;
        this.m_cursor = this.m_playerComponent.Level().instanciateActor("puzzleCursorNew");
        this.m_cursor.Material(Actor.eActorMaterial.eActorMaterial_Hud_L1);
        this.m_cursor.visible = false;
        this.m_delimiterLayer.add(this.m_cursor);
    }

    protected void _sortCursorKernelGrid() {
        this.m_playerComponent.Level().sortIsoLayer(this.m_delimiterLayer);
    }

    protected void _showHideCursorGrid(boolean _bShow) {
        if (_bShow && this.m_cursor.visible != _bShow && this.m_playerComponent.NumCollectableLeft() < GameVars.BlocCountToFormPiece()) {
            return;
        }
        if (_bShow) {
            this._updateCursorKernenGridVisibility_OneBloc();
            this.m_cursor.visible = true;
        } else {
            int i = 0;
            while (i < this.m_cursorKernelGridSize) {
                int j = 0;
                while (j < this.m_cursorKernelGridSize) {
                    this.m_cursorKernelGrid[i][j].visible = false;
                    ++j;
                }
                ++i;
            }
            this.m_cursor.visible = false;
        }
    }

    protected void _flagGridCells(Actor.eSpecialFlag _flag, boolean _addFlag) {
        int i = 0;
        while (i < this.m_cursorKernelGridSize) {
            int j = 0;
            while (j < this.m_cursorKernelGridSize) {
                if (_addFlag) {
                    this.m_cursorKernelGrid[i][j].addFlag(_flag);
                } else {
                    this.m_cursorKernelGrid[i][j].removeFlag(_flag);
                }
                ++j;
            }
            ++i;
        }
    }

    protected void _flagGridCellUnderActor(Actor _actor, Actor.eSpecialFlag _flag, boolean _addFlag) {
        this.m_playerComponent.Level().BlocManager().getActorGridLocation(_actor, BlocManager.idCo, BlocManager.idLi);
        int idKernelCol = BlocManager.idCo.get();
        int idKernelLine = BlocManager.idLi.get();
        idKernelLine = this.m_cursorCenterKernelId + idKernelLine - this.m_cursorIdLineOrigin;
        idKernelCol = this.m_cursorCenterKernelId + idKernelCol - this.m_cursorIdColOrigin;
        if (idKernelLine >= 0 && idKernelLine < this.m_cursorKernelGridSize && idKernelCol >= 0 && idKernelCol < this.m_cursorKernelGridSize) {
            if (_addFlag) {
                this.m_cursorKernelGrid[idKernelLine][idKernelCol].addFlag(_flag);
            } else {
                this.m_cursorKernelGrid[idKernelLine][idKernelCol].removeFlag(_flag);
            }
        }
    }

    protected void _positionateCursorKernenGrid(Actor _centerActor, boolean _bForce, boolean _bOffset) {
        if (_bForce || this.m_blocCounter == 0) {
            float cx = _centerActor.x + (_bOffset ? this.m_cursorOffsetx : 0.0f);
            float cy = _centerActor.y + (_bOffset ? this.m_cursorOffsety : 0.0f);
            int liOffset = -this.m_cursorKernelGridSize / 2;
            int li = 0;
            while (li < this.m_cursorKernelGridSize) {
                int coOffset = -this.m_cursorKernelGridSize / 2;
                int co = 0;
                while (co < this.m_cursorKernelGridSize) {
                    Actor cell = this.m_cursorKernelGrid[li][co];
                    cell.x = cx + (float)(coOffset * GameVars.TileStep());
                    cell.y = cy - (float)(liOffset * GameVars.TileStep());
                    ++coOffset;
                    ++co;
                }
                ++liOffset;
                ++li;
            }
        }
    }

    protected boolean _updateCursorKernenGridVisibility_MultiBloc(float _lastMoveDx, float _lastMoveDy) {
        this._showHideCursorGrid(false);
        this._flagGridCells(Actor.eSpecialFlag.eSpecialFlag_Occupied, false);
        int b = 0;
        while (b < this.m_currentPieceGroup.members.size()) {
            this._flagGridCellUnderActor((Actor)this.m_currentPieceGroup.members.get(b), Actor.eSpecialFlag.eSpecialFlag_Occupied, true);
            ++b;
        }
        this.m_cursor.visible = true;
        Point offset = Point.Zero();
        this._updateKernelGrid(0, 0);
        int offsetId = 0;
        while (offsetId < 4) {
            offset.copy(PieceDefVars.PieceLinkOffets[offsetId]);
            this._updateKernelGrid(offset.X, offset.Y);
            ++offsetId;
        }
        if (_lastMoveDx != 0.0f || _lastMoveDy != 0.0f) {
            return this._computeNextCursorPosition(_lastMoveDx, _lastMoveDy);
        }
        return true;
    }

    protected void _updateKernelGrid(int _offsetX, int _offsetY) {
        this.m_playerComponent.Level().BlocManager().getActorGridLocation(this.m_playerComponent.Owner(), BlocManager.idCo, BlocManager.idLi);
        int idPlayerCol = BlocManager.idCo.get();
        int idPlayerLine = BlocManager.idLi.get();
        int i = 0;
        while (i < this.m_currentPieceGroup.members.size()) {
            Actor currentPieces = (Actor)this.m_currentPieceGroup.members.get(i);
            this.m_playerComponent.Level().BlocManager().getActorGridLocation(currentPieces, BlocManager.idCol, BlocManager.idLine);
            int idCol = BlocManager.idCol.get();
            int idLine = BlocManager.idLine.get();
            int idKernelLine = this.m_cursorCenterKernelId + (idLine += _offsetY) - this.m_cursorIdLineOrigin;
            int idKernelCol = this.m_cursorCenterKernelId + (idCol += _offsetX) - this.m_cursorIdColOrigin;
            Actor curKernelBloc = this.m_cursorKernelGrid[idKernelLine][idKernelCol];
            if (this.m_playerComponent.Level().BlocManager().isBlocSlotOccupied(idLine, idCol) || this._isBlocNotMaterializedYetAt(idLine, idCol) || idPlayerCol == idCol && idPlayerLine == idLine) {
                curKernelBloc.visible = false;
            } else {
                curKernelBloc.visible = true;
                curKernelBloc.play("c");
                curKernelBloc.color(AroundGridCusor_Color);
                curKernelBloc.alpha(AroundGridCusor_Alpha);
            }
            ++i;
        }
    }

    protected boolean _computeNextCursorPosition(float _lastMoveDx, float _lastMoveDy) {
        this.m_cursor.x -= _lastMoveDx;
        this.m_cursor.y -= _lastMoveDy;
        int stepCol = 0;
        int stepLine = 0;
        boolean findNewIdLineStep = false;
        boolean findNewIdColStep = false;
        this.m_playerComponent.Level().BlocManager().getActorOffsetedGridLocationClamped(this.m_cursor, this.m_cursorOffsetx, this.m_cursorOffsety, BlocManager.idCo, BlocManager.idLi);
        int cursorIdCol = BlocManager.idCo.get();
        int cursorIdLine = BlocManager.idLi.get();
        int idLine = cursorIdLine - this.m_cursorIdLineOrigin + this.m_cursorCenterKernelId;
        int idCol = cursorIdCol - this.m_cursorIdColOrigin + this.m_cursorCenterKernelId;
        if (_lastMoveDx > 0.0f) {
            stepCol = 1;
        } else if (_lastMoveDx < 0.0f) {
            stepCol = -1;
        }
        int idNewCol = idCol;
        if (stepCol != 0 && (idNewCol += stepCol) >= 0 && idNewCol < this.m_cursorKernelGridSize && this.m_cursorKernelGrid[idLine][idNewCol].visible) {
            this.m_cursor.x += (float)((idNewCol - idCol) * GameVars.TileStep());
        }
        if (_lastMoveDy > 0.0f) {
            stepLine = -1;
        } else if (_lastMoveDy < 0.0f) {
            stepLine = 1;
        }
        int idNewLine = idLine;
        if (stepLine != 0 && (idNewLine += stepLine) >= 0 && idNewLine < this.m_cursorKernelGridSize && this.m_cursorKernelGrid[idNewLine][idCol].visible) {
            this.m_cursor.y += (float)((idLine - idNewLine) * GameVars.TileStep());
        }
        return true;
    }

    protected boolean _isValidGridLineSlotForCursor(int _idLine, int _idColBeg, int _idColEnd) {
        int start = _idColBeg;
        int end = _idColEnd;
        if (_idColBeg > _idColEnd) {
            start = _idColEnd;
            end = _idColBeg;
        }
        int co = start;
        while (co <= end) {
            if (this._isValidGridSlotForCursor(_idLine, co)) {
                return true;
            }
            ++co;
        }
        return false;
    }

    protected boolean _isValidGridSlotForCursor(int _idLine, int _idCol) {
        return this.m_cursorKernelGrid[_idLine][_idCol].visible && !this.m_cursorKernelGrid[_idLine][_idCol].hasFlag(Actor.eSpecialFlag.eSpecialFlag_Occupied);
    }

    protected void LineScanDone(Object sender, Object args) {
        this._updateCursorHudVisibility();
        if (this.ScanLineDone != null) {
            int i = 0;
            while (i < this.ScanLineDone.size()) {
                this.ScanLineDone.get(i).onCallback(this, null);
                ++i;
            }
        }
    }

    protected void _updateCursorHudVisibility() {
    }

    protected void _updateCursorKernenGridVisibility_OneBloc() {
        int numAnchorValid = 0;
        this.m_playerComponent.Level().BlocManager().getActorOffsetedGridLocationClamped(this.m_cursor, this.m_cursorOffsetx, this.m_cursorOffsety, BlocManager.colId, BlocManager.lineId);
        int cursorColId = BlocManager.colId.get();
        int cursorLineId = BlocManager.lineId.get();
        int lineId = cursorLineId - this.m_cursorCenterKernelId;
        int li = 0;
        while (li < this.m_cursorKernelGridSize) {
            int colId = cursorColId - this.m_cursorCenterKernelId;
            int co = 0;
            while (co < this.m_cursorKernelGridSize) {
                Actor act = this.m_cursorKernelGrid[li][co];
                if (this.m_blocCounter == 0) {
                    if (this._isCrossCursorNeighbour(li, co)) {
                        act.visible = true;
                        if (li == this.m_cursorCenterKernelId - 1) {
                            act.play("b");
                        } else if (li == this.m_cursorCenterKernelId + 1) {
                            act.play("t");
                        } else if (co == this.m_cursorCenterKernelId + 1) {
                            act.play("r");
                        } else if (co == this.m_cursorCenterKernelId - 1) {
                            act.play("l");
                        }
                        if (this.m_playerComponent.Level().BlocManager().isBlocSlotOccupied(lineId, colId) || this._isBlocNotMaterializedYetAt(lineId, colId)) {
                            ++numAnchorValid;
                        }
                    } else {
                        act.visible = false;
                    }
                }
                ++colId;
                ++co;
            }
            ++lineId;
            ++li;
        }
        if (this.m_blocCounter == 0) {
            if (numAnchorValid > 0) {
                Point offset = Point.Zero();
                int anchorOffId = 0;
                while (anchorOffId < 4) {
                    offset.copy(PieceDefVars.PieceLinkOffets[anchorOffId]);
                    int anchorLi = offset.X + cursorLineId;
                    int anchorCo = offset.Y + cursorColId;
                    int kernelLineId = offset.X + this.m_cursorCenterKernelId;
                    int kernelColId = offset.Y + this.m_cursorCenterKernelId;
                    Actor curKernelActor = this.m_cursorKernelGrid[kernelLineId][kernelColId];
                    curKernelActor.alpha(GridCusor_Alpha);
                    if (this.m_bOverlap) {
                        curKernelActor.color(Color.Red());
                    } else if (this.m_playerComponent.Level().BlocManager().isBlocSlotOccupied(anchorLi, anchorCo) || this._isBlocNotMaterializedYetAt(anchorLi, anchorCo)) {
                        curKernelActor.color(Color.Green());
                    } else {
                        curKernelActor.color(Color.White());
                    }
                    ++anchorOffId;
                }
            } else {
                this.m_cursorKernelGrid[this.m_cursorCenterKernelId - 1][this.m_cursorCenterKernelId].color(Color.Red());
                this.m_cursorKernelGrid[this.m_cursorCenterKernelId + 1][this.m_cursorCenterKernelId].color(Color.Red());
                this.m_cursorKernelGrid[this.m_cursorCenterKernelId][this.m_cursorCenterKernelId - 1].color(Color.Red());
                this.m_cursorKernelGrid[this.m_cursorCenterKernelId][this.m_cursorCenterKernelId + 1].color(Color.Red());
            }
        }
    }

    protected boolean _isBlocNotMaterializedYetAt(int _lineId, int _colId) {
        if (this.m_actorToMaterialize.members.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < this.m_actorToMaterialize.members.size()) {
            Actor act = (Actor)this.m_actorToMaterialize.members.get(i);
            this.m_playerComponent.Level().BlocManager().getActorGridLocation(act, BlocManager.idCol, BlocManager.idLine);
            int idCol = BlocManager.idCol.get();
            int idLine = BlocManager.idLine.get();
            if (idCol == _colId && idLine == _lineId) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean _overlapingPlayerOrEnnemies(int _idLine, int _idCol) {
        return false;
    }

    protected boolean _isCrossCursorNeighbour(int li, int co) {
        return li == this.m_cursorCenterKernelId && (co == this.m_cursorCenterKernelId - 1 || co == this.m_cursorCenterKernelId + 1) || co == this.m_cursorCenterKernelId && (li == this.m_cursorCenterKernelId - 1 || li == this.m_cursorCenterKernelId + 1);
    }

    protected void _buildTexts() {
        if (GameVars.BlocCountToFormPiece() > 1) {
            this.m_arrBlocCountDownTexts = new FlxText[GameVars.BlocCountToFormPiece()];
            int i = 0;
            while (i < this.m_arrBlocCountDownTexts.length) {
                FlxText text = new FlxText(0.0f, 0.0f, 100.0f);
                text.alignment = FlxText.FlxJustification.Center;
                text.visible = false;
                text.scrollFactor.X = 1.0f;
                text.scrollFactor.Y = 1.0f;
                this.m_delimiterLayer.add(text);
                this.m_arrBlocCountDownTexts[i] = text;
                ++i;
            }
        }
    }

    protected void _positionateInfoText(int _counter, Actor _actor) {
        if (_counter <= this.m_arrBlocCountDownTexts.length) {
            FlxText txt = this.m_arrBlocCountDownTexts[_counter - 1];
            if (_actor != null) {
                txt.text(String.format("{0}/{1}", _counter, GameVars.BlocCountToFormPiece()));
                txt.x = _actor.x + (float)_actor.offset.X + _actor.width * 0.5f - txt.width * 0.5f;
                txt.y = _actor.y + (float)_actor.offset.Y + _actor.height * 0.5f - txt.height * 0.5f;
                txt.visible = false;
            } else {
                txt.visible = false;
            }
        }
    }

    public void beginActivation() {
        if (!GameVars.UseHologramZone()) {
            this._showDelimiterZones();
        }
        this._showHideCursorGrid(true);
        this._showHideFullscreenGrid(true);
        this._positionnateFullscreenGrid();
        this.m_blocCounter = 0;
        this._addBlocNearPoint(this.m_playerComponent.Owner().x + this.m_playerComponent.Owner().width * 0.5f, this.m_playerComponent.Owner().y - this.m_playerComponent.Owner().height);
        this._move(0.0f, -GameVars.TileStep(), true, true);
        this.m_playerComponent.Owner().Level().AllowEnnemiesMove(false);
        this.m_lineScanner.beginUse();
        this.m_lineScanner.launchLineScanner(true);
    }

    public boolean canLeave() {
        return this.m_lineScanner.ScanState() == LineScanner.eScanState.eScanState_Off;
    }

    public void leave(boolean _leaveWithDestroy) {
        if (!this.m_bLeaverequested) {
            this.m_bLeaverequested = true;
            this._endActivationBegin();
            if (_leaveWithDestroy) {
                this.m_lineScanner.launchDestroyScanner();
            } else {
                this.m_lineScanner.cancelDestroyScanner();
            }
        }
    }

    public void endActivation() {
        this._endActicvationEnd();
    }

    protected void _endActivationBegin() {
        if (!GameVars.UseHologramZone()) {
            this._hideDelimiterZones();
        }
        this._showHideCursorGrid(false);
        this._showHideFullscreenGrid(false);
        this._killCurrentBloc();
        if (this.m_currentPieceGroup.members.size() > 0) {
            int i = 0;
            while (i < this.m_currentPieceGroup.members.size()) {
                Actor act = (Actor)this.m_currentPieceGroup.members.get(i);
                this.m_playerComponent.increaseCollectableStock(act.Material());
                this.m_playerComponent.Level().removeActorFromLayer(this.m_blocLayer, act, false);
                act.kill();
                ++i;
            }
            this.m_currentPieceGroup.members.clear();
        }
        this._hideTextInfo();
    }

    protected void _endActicvationEnd() {
        this._realMaterializeBlocs();
        this.m_playerComponent.Owner().Level().AllowEnnemiesMove(true);
    }

    protected void _hideTextInfo() {
        if (this.m_arrBlocCountDownTexts != null) {
            int i = 0;
            while (i < this.m_arrBlocCountDownTexts.length) {
                this.m_arrBlocCountDownTexts[i].visible = false;
                ++i;
            }
        }
    }

    protected void _realMaterializeBlocs() {
        if (this.m_actorToMaterialize.members.size() > 0) {
            int i = 0;
            while (i < this.m_actorToMaterialize.members.size()) {
                Actor act = (Actor)this.m_actorToMaterialize.members.get(i);
                act.removeFlag(Actor.eSpecialFlag.eSpecialFlag_AvoidStainColor);
                if (!act.hasFlag(Actor.eSpecialFlag.eSpecialFlag_InALine)) {
                    act.color(Color.White());
                    act.alpha(1.0f);
                    this._unregisterActorForScan(act);
                    this.m_playerComponent.Level().materializeActorsInBlocManager(act);
                } else {
                    this._unregisterActorForScan(act);
                }
                this._undoActorHack(act);
                ++i;
            }
            this.m_actorToMaterialize.members.clear();
        }
    }

    protected void _addBlocNearPoint(float _nearx, float _neary) {
        this._computeSpawnPointPivotNear(_nearx, _neary);
        this.m_timeElapsed = 0.0f;
        this.syncMaterial();
    }

    protected void _computeSpawnPointPivotNear(float _x, float _y) {
        int tmpx = (int)(_x / (float)GameVars.TileStep());
        int tmpy = (int)(_y / (float)GameVars.TileStep());
        this.m_spawnx = tmpx * GameVars.TileStep();
        this.m_spawny = tmpy * GameVars.TileStep();
    }

    protected void _killCurrentBloc() {
        if (this.m_currentBloc != null) {
            this.m_playerComponent.Level().removeActorFromLayer(this.m_blocLayer, this.m_currentBloc, false);
            this.m_currentBloc.kill();
            this.m_currentBloc = null;
        }
    }

    protected void _updateDelimiterZone() {
        if (this.m_currentBloc != null) {
            this.m_playerComponent.Level().BlocManager().getZoneDelimiter(this.m_currentBloc, BlocManager.leftx, BlocManager.rightx, BlocManager.zoneDelimiterUsed);
            float leftx = BlocManager.leftx.get().floatValue();
            float rightx = BlocManager.rightx.get().floatValue();
            int zoneDelimiterUsed = BlocManager.zoneDelimiterUsed.get();
            this._showDelimiterZones();
            this._positionnateDelimiterZones(leftx, rightx);
        } else {
            this._hideDelimiterZones();
        }
    }

    protected void _showDelimiterZones() {
    }

    protected void _hideDelimiterZones() {
    }

    protected void _positionnateDelimiterZones(float _leftx, float _rightx) {
    }

    public boolean canDoFullPiece() {
        return this.m_playerComponent.NumCollectableLeft() + this.m_currentPieceGroup.members.size() >= GameVars.BlocCountToFormPiece();
    }

    public void update() {
        if (this.m_bLeaverequested) {
            if (this.m_lineScanner.ScanState() == LineScanner.eScanState.eScanState_Off) {
                if (this.PuzzleBlocSpawnerJustLeave != null) {
                    this.m_bLeaverequested = false;
                    int i = 0;
                    while (i < this.PuzzleBlocSpawnerJustLeave.size()) {
                        this.PuzzleBlocSpawnerJustLeave.get(i).onCallback(this, null);
                        ++i;
                    }
                }
                this.m_lineScanner.endUse();
            } else {
                this.m_lineScanner.update();
            }
            return;
        }
        this.m_bJustMove = false;
        float oldx = this.m_cursor.x;
        float oldy = this.m_cursor.y;
        boolean bStickLeft = InputManager.IsButtonDown(Buttons.LeftThumbstickLeft) || InputManager.IsButtonDown(Buttons.DPadLeft);
        boolean bStickRight = InputManager.IsButtonDown(Buttons.LeftThumbstickRight) || InputManager.IsButtonDown(Buttons.DPadRight);
        boolean bStickUp = InputManager.IsButtonDown(Buttons.LeftThumbstickUp) || InputManager.IsButtonDown(Buttons.DPadUp);
        boolean bStickDown = InputManager.IsButtonDown(Buttons.LeftThumbstickDown) || InputManager.IsButtonDown(Buttons.DPadDown);
        boolean bAutoStick = false;
        if (bStickLeft || bStickRight || bStickUp || bStickDown) {
            this.m_timeStickDownElapsed += FlxG.elapsed;
            this.m_timeStickDownElapsedTotal += FlxG.elapsed;
            this.m_timeAutoStickMaxInterpol = MathHelper.Lerp(this.m_timeAutoStickMaxBeg, this.m_timeAutoStickMaxEnd, this.m_timeStickDownElapsedTotal / this.m_timeFromBegToEnd);
            if (this.m_timeStickDownElapsed > this.m_timeAutoStickMaxInterpol) {
                this.m_timeStickDownElapsed = 0.0f;
                bAutoStick = true;
            }
        } else {
            this.m_timeStickDownElapsedTotal = 0.0f;
            this.m_timeStickDownElapsed = 0.0f;
        }
        bStickRight &= bAutoStick;
        bStickUp &= bAutoStick;
        bStickDown &= bAutoStick;
        if (InputManager.IsNewButtonPress(Buttons.LeftThumbstickLeft) || InputManager.IsNewButtonPress(Buttons.DPadLeft) || (bStickLeft &= bAutoStick)) {
            this._move(-GameVars.TileStep(), 0.0f, true, true);
        } else if (InputManager.IsNewButtonPress(Buttons.LeftThumbstickRight) || InputManager.IsNewButtonPress(Buttons.DPadRight) || bStickRight) {
            this._move(GameVars.TileStep(), 0.0f, true, true);
        }
        if (InputManager.IsNewButtonPress(Buttons.LeftThumbstickUp) || InputManager.IsNewButtonPress(Buttons.DPadUp) || bStickUp) {
            this._move(0.0f, -GameVars.TileStep(), true, true);
        } else if (InputManager.IsNewButtonPress(Buttons.LeftThumbstickDown) || InputManager.IsNewButtonPress(Buttons.DPadDown) || bStickDown) {
            this._move(0.0f, GameVars.TileStep(), true, true);
        }
        if (oldx != this.m_cursor.x || oldy != this.m_cursor.y) {
            this.m_bJustMove = true;
        }
        if (this.m_cursor.visible && InputManager.IsNewButtonPress(Buttons.A) || this.m_bJustMove && InputManager.IsButtonDown(Buttons.A)) {
            if (this.m_currentBloc != null && !this.m_bOverlap && this.m_bLinkedToExitingBloc && this.m_playerComponent.NumCollectableLeft() > 0) {
                if (this.m_blocCounter == 0) {
                    this.m_playerComponent.Level().BlocManager().getActorOffsetedGridLocationClamped(this.m_cursor, this.m_cursorOffsetx, this.m_cursorOffsety, BlocManager.idCo, BlocManager.idLi);
                    this.m_cursorIdColOrigin = BlocManager.idCo.get();
                    this.m_cursorIdLineOrigin = BlocManager.idLi.get();
                }
                ++this.m_blocCounter;
                this._positionateInfoText(this.m_blocCounter, this.m_currentBloc);
                this._positionnateBlocUnderCursor();
                this._tweenPoseBloc(this.m_currentBloc);
                this.m_currentPieceGroup.members.add(this.m_currentBloc);
                this.m_sndPoseBloc.play();
                if (this.m_blocCounter == GameVars.BlocCountToFormPiece()) {
                    this._hideTextInfo();
                    this.m_blocCounter = 0;
                    int i = 0;
                    while (i < this.m_currentPieceGroup.members.size()) {
                        Actor act = (Actor)this.m_currentPieceGroup.members.get(i);
                        act.color(Color.White());
                        act.alpha(0.5f);
                        act.addFlag(Actor.eSpecialFlag.eSpecialFlag_AvoidStainColor);
                        this.m_actorToMaterialize.members.add(act);
                        this.m_playerComponent.Level().BlocManager().registerRemovableBloc(act);
                        ++i;
                    }
                    this.m_currentPieceGroup.members.clear();
                    this.m_lineScanner.launchLineScanner(false);
                } else {
                    this.m_currentBloc.alpha(0.5f);
                }
                float nextx = this.m_currentBloc.x;
                float nexty = this.m_currentBloc.y;
                this.m_currentBloc = null;
                this.m_playerComponent.decreaseCurrentCollectableStock();
                this._addBlocNearPoint(nextx, nexty);
                this.m_currentBloc.x = nextx;
                this.m_currentBloc.y = nexty;
                if (GameVars.BlocCountToFormPiece() == 1) {
                    this._realMaterializeBlocs();
                }
                this._move(0.0f, 0.0f, true, false);
            } else {
                FlxG.quake.start(0.01f, 0.25f);
            }
            if (this.m_playerComponent.NumCollectableLeft() == 0) {
                this.m_currentBloc.visible = false;
            }
        } else if (InputManager.IsNewButtonPress(Buttons.B)) {
            this._removeLastBloc();
        } else if (this.m_bJustMove) {
            this.m_sndMoveBloc.play();
        }
        float t = (float)(0.5 + Math.cos(this.m_timeElapsed * 7.0f) * 0.5);
        this.m_alphaBloc = MathHelper.Lerp(0.5f, 1.0f, t);
        this.m_timeElapsed += FlxG.elapsed;
        this.m_currentBloc.alpha(this.m_alphaBloc);
        if (!GameVars.UseHologramZone()) {
            this._updateDelimiterZone();
        }
        this.m_lineScanner.update();
        this._checkAchievementIJLOSTZ();
        this._checkCursorVisibility();
        if (this.m_currentBloc != null && !this.m_cursor.visible) {
            this.m_currentBloc.visible = false;
        }
    }

    protected void _checkAchievementIJLOSTZ() {
        if (this.m_bCheckIJLOSTZ && this.m_lineScanner.ScanStateOld() == LineScanner.eScanState.eScanState_ScanningLineShowResult && this.m_lineScanner.ScanState() == LineScanner.eScanState.eScanState_Off && this.m_actorToMaterialize.members.size() >= GameVars.BlocCountToFormPiece()) {
            int idY;
            int idX;
            Actor act;
            int minXoffset = Integer.MAX_VALUE;
            int minYoffset = Integer.MAX_VALUE;
            int i = 0;
            while (i < this.m_actorToMaterialize.members.size()) {
                act = (Actor)this.m_actorToMaterialize.members.get(i);
                if (act != null) {
                    idX = act.IndexPosX();
                    idY = act.IndexPosY();
                    if (minXoffset > idX) {
                        minXoffset = idX;
                    }
                    if (minYoffset > idY) {
                        minYoffset = idY;
                    }
                }
                ++i;
            }
            i = 0;
            while (i < IJLOSTZ.length) {
                int j = 0;
                while (j < IJLOSTZ[i].length) {
                    PuzzleBlocSpawner.IJLOSTZ[i][j] = false;
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < this.m_actorToMaterialize.members.size()) {
                act = (Actor)this.m_actorToMaterialize.members.get(i);
                if (act != null) {
                    idX = act.IndexPosX() - minXoffset;
                    idY = act.IndexPosY() - minYoffset;
                    if (idX >= 0 && idX < 4 && idY >= 0 && idY < 4) {
                        PuzzleBlocSpawner.IJLOSTZ[idY][idX] = true;
                    }
                }
                ++i;
            }
            this._checkAchievementGridIJLOSTZ();
        }
    }

    protected void _checkAchievementGridIJLOSTZ() {
        boolean achDone = true;
        boolean found = false;
        if (!found && (IJLOSTZ[0][0] && IJLOSTZ[0][1] && IJLOSTZ[0][2] && IJLOSTZ[0][3] || IJLOSTZ[0][0] && IJLOSTZ[1][0] && IJLOSTZ[2][0] && IJLOSTZ[3][0])) {
            this.m_numPiecesIJLOSTZ[0] = this.m_numPiecesIJLOSTZ[0] + 1;
            found = true;
        }
        if (!found && (IJLOSTZ[0][1] && IJLOSTZ[1][1] && IJLOSTZ[2][1] && IJLOSTZ[2][0] || IJLOSTZ[0][0] && IJLOSTZ[1][0] && IJLOSTZ[1][1] && IJLOSTZ[1][2] || IJLOSTZ[0][0] && IJLOSTZ[0][1] && IJLOSTZ[1][0] && IJLOSTZ[2][0] || IJLOSTZ[0][0] && IJLOSTZ[0][1] && IJLOSTZ[0][2] && IJLOSTZ[1][2])) {
            this.m_numPiecesIJLOSTZ[1] = this.m_numPiecesIJLOSTZ[1] + 1;
            found = true;
        }
        if (!found && (IJLOSTZ[0][0] && IJLOSTZ[1][0] && IJLOSTZ[2][0] && IJLOSTZ[2][1] || IJLOSTZ[0][0] && IJLOSTZ[0][1] && IJLOSTZ[0][2] && IJLOSTZ[1][0] || IJLOSTZ[0][0] && IJLOSTZ[0][1] && IJLOSTZ[1][1] && IJLOSTZ[2][1] || IJLOSTZ[1][0] && IJLOSTZ[1][1] && IJLOSTZ[1][2] && IJLOSTZ[0][2])) {
            this.m_numPiecesIJLOSTZ[2] = this.m_numPiecesIJLOSTZ[2] + 1;
            found = true;
        }
        if (!found && IJLOSTZ[0][0] && IJLOSTZ[0][1] && IJLOSTZ[1][0] && IJLOSTZ[1][1]) {
            this.m_numPiecesIJLOSTZ[3] = this.m_numPiecesIJLOSTZ[3] + 1;
            found = true;
        }
        if (!found && (IJLOSTZ[1][0] && IJLOSTZ[1][1] && IJLOSTZ[0][1] && IJLOSTZ[0][2] || IJLOSTZ[0][0] && IJLOSTZ[1][0] && IJLOSTZ[1][1] && IJLOSTZ[2][1])) {
            this.m_numPiecesIJLOSTZ[4] = this.m_numPiecesIJLOSTZ[4] + 1;
            found = true;
        }
        if (!found && (IJLOSTZ[0][0] && IJLOSTZ[0][1] && IJLOSTZ[0][2] && IJLOSTZ[1][1] || IJLOSTZ[1][0] && IJLOSTZ[0][1] && IJLOSTZ[1][1] && IJLOSTZ[2][1] || IJLOSTZ[0][1] && IJLOSTZ[1][0] && IJLOSTZ[1][1] && IJLOSTZ[1][2] || IJLOSTZ[0][0] && IJLOSTZ[1][0] && IJLOSTZ[2][0] && IJLOSTZ[1][1])) {
            this.m_numPiecesIJLOSTZ[5] = this.m_numPiecesIJLOSTZ[5] + 1;
            found = true;
        }
        if (!found && (IJLOSTZ[0][0] && IJLOSTZ[0][1] && IJLOSTZ[1][1] && IJLOSTZ[1][2] || IJLOSTZ[0][1] && IJLOSTZ[1][1] && IJLOSTZ[1][0] && IJLOSTZ[2][0])) {
            this.m_numPiecesIJLOSTZ[6] = this.m_numPiecesIJLOSTZ[6] + 1;
            found = true;
        }
        int i = 0;
        while (i < this.m_numPiecesIJLOSTZ.length) {
            if (this.m_numPiecesIJLOSTZ[i] == 0) {
                achDone = false;
                break;
            }
            ++i;
        }
        if (achDone) {
            AchievementManager.Instance().unlockAchievement("ACH_IJLOSTZ");
            this.m_bCheckIJLOSTZ = false;
        }
    }

    protected void _tweenPoseBloc(Actor _bloc) {
        this.m_currentBloc.Shake(false);
        this.m_currentBloc.ShakeX(0.0f);
        this.m_currentBloc.ShakeY(0.0f);
        this.m_playerComponent.Level().TweenManager().ToScale((Tweenable)this.m_currentBloc, Vector2.One(), 0.5f, TweenManager.EaseType.EASE_OUTBOUNCE, 0.0f, (CallbackSimple)null);
    }

    protected void _undoActorHack(Actor _bloc) {
        _bloc.Shake(false);
        _bloc.ShakeX(0.0f);
        _bloc.ShakeY(0.0f);
        _bloc.AlwaysVisible(false);
    }

    protected void _checkCursorVisibility() {
        if (this.m_cursor.visible && this.m_playerComponent.NumCollectableLeft() + this.m_blocCounter < GameVars.BlocCountToFormPiece()) {
            this._showHideCursorGrid(false);
        } else if (!this.m_cursor.visible && this.m_playerComponent.NumCollectableLeft() + this.m_blocCounter >= GameVars.BlocCountToFormPiece()) {
            this._showHideCursorGrid(true);
        }
    }

    protected void _positionnateBlocUnderCursor() {
        this.m_currentBloc.x = this.m_cursor.x - this.m_cursorOffsetx;
        this.m_currentBloc.y = this.m_cursor.y - this.m_cursorOffsety;
    }

    public boolean canUndo() {
        return this.m_blocCounter > 0 || this.m_actorToMaterialize.members.size() > 0;
    }

    protected void _removeLastBloc() {
        Actor toCancel = null;
        if (this.m_blocCounter > 0) {
            if (this.m_currentPieceGroup.members.size() > 0) {
                toCancel = (Actor)this.m_currentPieceGroup.members.get(this.m_currentPieceGroup.members.size() - 1);
                this.m_currentPieceGroup.members.remove(toCancel);
                --this.m_blocCounter;
                this.m_arrBlocCountDownTexts[this.m_blocCounter].visible = false;
            }
        } else if (this.m_actorToMaterialize.members.size() >= GameVars.BlocCountToFormPiece()) {
            toCancel = (Actor)this.m_actorToMaterialize.members.get(this.m_actorToMaterialize.members.size() - 1);
            this.m_actorToMaterialize.members.remove(toCancel);
            this._unregisterActorForScan(toCancel);
            Actor toMove = null;
            int i = 0;
            while (i < GameVars.BlocCountToFormPiece() - 1) {
                toMove = (Actor)this.m_actorToMaterialize.members.get(this.m_actorToMaterialize.members.size() - 1);
                this.m_actorToMaterialize.members.remove(toMove);
                this._unregisterActorForScan(toMove);
                this.m_currentPieceGroup.members.add(0, toMove);
                ++i;
            }
            this.m_blocCounter = GameVars.BlocCountToFormPiece() - 1;
            this._updateCurrentPieceGroupTextAndColor();
            Actor firstActor = (Actor)this.m_currentPieceGroup.members.get(0);
            this.m_playerComponent.Level().BlocManager().getActorGridLocation(firstActor, BlocManager.idCo, BlocManager.idLi);
            this.m_cursorIdColOrigin = BlocManager.idCo.get();
            this.m_cursorIdLineOrigin = BlocManager.idLi.get();
            this._positionateCursorKernenGrid(firstActor, true, true);
            this._updateCursorKernenGridVisibility_MultiBloc(0.0f, 0.0f);
            this.m_lineScanner.launchLineScanner(false);
        }
        if (toCancel != null) {
            this.m_currentBloc.x = toCancel.x;
            this.m_currentBloc.y = toCancel.y;
            this.m_cursor.x = toCancel.x + this.m_cursorOffsetx;
            this.m_cursor.y = toCancel.y + this.m_cursorOffsety;
            this.m_playerComponent.increaseCollectableStock(toCancel.Material());
            this.m_playerComponent.changeCollectableIndex(toCancel.Material());
            this.m_playerComponent.Level().removeActorFromLayer(this.m_blocLayer, toCancel, false);
            toCancel.kill();
            this._move(0.0f, 0.0f, true, false);
            this.syncMaterial();
            this.m_sndCancelBloc.play();
        }
    }

    protected void _unregisterActorForScan(Actor _actor) {
        _actor.removeFlag(Actor.eSpecialFlag.eSpecialFlag_MustBlink);
        _actor.removeFlag(Actor.eSpecialFlag.eSpecialFlag_InALine);
        this.m_playerComponent.Level().BlocManager().unregisterRemovableBloc(_actor);
    }

    protected void _updateCurrentPieceGroupTextAndColor() {
        int numBloc = this.m_currentPieceGroup.members.size();
        Actor bloc = null;
        int i = 0;
        while (i < GameVars.BlocCountToFormPiece()) {
            if (i < numBloc) {
                bloc = (Actor)this.m_currentPieceGroup.members.get(i);
                bloc.color(Color.White());
                bloc.alpha(0.5f);
            } else {
                bloc = null;
            }
            this._positionateInfoText(i + 1, bloc);
            ++i;
        }
    }

    protected void _move(float dx, float dy, boolean _bCheckOverlapsAndLink, boolean _bRealMove) {
        if (!this.m_cursor.visible) {
            return;
        }
        this.m_cursor.x = this.m_currentBloc.x + this.m_cursorOffsetx;
        this.m_cursor.y = this.m_currentBloc.y + this.m_cursorOffsety;
        if ((dx != 0.0f || dy != 0.0f) && _bRealMove) {
            this.m_playerComponent.Level().BlocManager().getPointGridLocationClamped(this.m_cursor.getCenterX(), this.m_cursor.getCenterY(), BlocManager.colId, BlocManager.lineId);
            this.m_currentBlocColId = BlocManager.colId.get();
            this.m_currentBlocLineId = BlocManager.lineId.get();
            this.m_currentBlocLineId -= (int)(dy / (float)GameVars.TileStep());
            this.m_currentBlocColId += (int)(dx / (float)GameVars.TileStep());
            if (this.m_currentBlocLineId < this.m_fullscreenGridLineIdMin || this.m_currentBlocLineId > this.m_fullscreenGridLineIdMax || this.m_currentBlocColId < this.m_fullscreenGridColIdMin || this.m_currentBlocColId > this.m_fullscreenGridColIdMax) {
                return;
            }
        }
        float savex = this.m_cursor.x;
        float savey = this.m_cursor.y;
        boolean bLinkAndOverlap = this.cursorPoseAvailable();
        this.m_currentBloc.x += dx;
        this.m_currentBloc.y += dy;
        this.m_cursor.x = this.m_currentBloc.x + this.m_cursorOffsetx;
        this.m_cursor.y = this.m_currentBloc.y + this.m_cursorOffsety;
        if (_bCheckOverlapsAndLink && this.m_blocCounter != 0 && this._updateCursorKernenGridVisibility_MultiBloc(dx, dy)) {
            this._positionnateBlocUnderCursor();
        }
        if (_bCheckOverlapsAndLink) {
            this._checkOverlaps();
            if (!this.m_bOverlap) {
                this._checkLinking();
            }
            this._updateColor();
        }
        if (_bCheckOverlapsAndLink) {
            this._positionateCursorKernenGrid(this.m_cursor, false, false);
            if (this.m_blocCounter == 0) {
                this._updateCursorKernenGridVisibility_OneBloc();
            }
        }
        if (this.CursorMoved != null && (savex != this.m_cursor.x || savey != this.m_cursor.y || bLinkAndOverlap != this.cursorPoseAvailable())) {
            int i = 0;
            while (i < this.CursorMoved.size()) {
                this.CursorMoved.get(i).onCallback(this, null);
                ++i;
            }
        }
    }

    protected void _checkOverlaps() {
        this.m_bOverlap = false;
        if (GameVars.BlocCountToFormPiece() == 1) {
            this.m_bOverlap = this.m_playerComponent.Level().BlocManager().isOverlappingExistingBlocs(this.m_currentBloc);
        } else {
            if (this.m_playerComponent.Level().BlocManager().isOverlappingExistingBlocs(this.m_currentBloc)) {
                this.m_bOverlap = true;
            }
            if (!this.m_bOverlap && this.m_actorToMaterialize.members.size() > 0) {
                this.m_bOverlap = Utility.SssU_overlapSomething(this.m_actorToMaterialize, this.m_currentBloc);
            }
            if (!this.m_bOverlap && this.m_currentPieceGroup.members.size() > 0) {
                this.m_bOverlap = Utility.SssU_overlapSomething(this.m_currentPieceGroup, this.m_currentBloc);
            }
        }
        if (!this.m_bOverlap && this.m_playerComponent.Owner().overlaps(this.m_currentBloc)) {
            this.m_bOverlap = true;
        }
        if (!this.m_bOverlap) {
            this.m_bOverlap = Utility.SssU_overlapSomethingWithScale(this.m_playerComponent.Owner().Level().Ennemies(), this.m_currentBloc, 0.9f);
        }
        if (!this.m_bOverlap) {
            this.m_bOverlap = this._outsideLevelBounds();
        }
    }

    protected boolean _outsideLevelBounds() {
        Vector2 lb = this.m_playerComponent.Level().LeftBottom();
        Vector2 rt = this.m_playerComponent.Level().RightTop();
        return this.m_currentBloc.x < lb.X || this.m_currentBloc.x + this.m_currentBloc.width > rt.X || this.m_currentBloc.y < rt.Y || this.m_currentBloc.y + this.m_currentBloc.height > lb.Y;
    }

    protected void _updateColor() {
        if (this.m_playerComponent.NumCollectableLeft() == 0) {
            this.m_cursor.color(Color.Red());
            this.m_cursor.play("cursorKo");
            this.m_currentBloc.visible = false;
        } else if (this.m_bOverlap || !this.m_bLinkedToExitingBloc) {
            this.m_currentBloc.color(Color.Red());
            this.m_currentBloc.visible = !this.m_bOverlap;
            this.m_cursor.color(Color.Red());
            this.m_cursor.play("cursorKo");
        } else {
            this.m_currentBloc.color(Color.White());
            this.m_cursor.color(Color.Green());
            this.m_cursor.play("cursorOk");
            this.m_currentBloc.visible = true;
        }
    }

    protected void _checkLinking() {
        this.m_bLinkedToExitingBloc = false;
        if (GameVars.BlocCountToFormPiece() == 1) {
            this.m_bLinkedToExitingBloc = this.m_playerComponent.Level().BlocManager().isLinkedToExistingBlocs(this.m_currentBloc);
        } else {
            Point offset = Point.Zero();
            int iOff = 0;
            while (!this.m_bLinkedToExitingBloc && iOff < 4) {
                offset.copy(PieceDefVars.PieceLinkOffets[iOff]);
                offset.X *= GameVars.TileStep();
                offset.Y *= GameVars.TileStep();
                this._move(offset.X, offset.Y, false, false);
                if (this.m_blocCounter == 0) {
                    if (this.m_playerComponent.Level().BlocManager().isOverlappingExistingBlocs(this.m_currentBloc)) {
                        this.m_bLinkedToExitingBloc = true;
                    }
                    if (!this.m_bLinkedToExitingBloc && this.m_actorToMaterialize.members.size() > 0) {
                        this.m_bLinkedToExitingBloc = Utility.SssU_overlapSomething(this.m_actorToMaterialize, this.m_currentBloc);
                    }
                }
                if (!this.m_bLinkedToExitingBloc && this.m_currentPieceGroup.members.size() > 0) {
                    this.m_bLinkedToExitingBloc = Utility.SssU_overlapSomething(this.m_currentPieceGroup, this.m_currentBloc);
                }
                this._move(-offset.X, -offset.Y, false, false);
                ++iOff;
            }
        }
    }

    public boolean cursorPoseAvailable() {
        return !this.m_bOverlap && this.m_bLinkedToExitingBloc && this.m_playerComponent.NumCollectableLeft() > 0;
    }

    public void syncMaterial() {
        if (this.m_currentBloc != null) {
            this.m_spawnx = this.m_currentBloc.x;
            this.m_spawny = this.m_currentBloc.y;
        }
        this._killCurrentBloc();
        this.m_playerComponent.checkCollectableSelectedIndex();
        this.m_currentBloc = this.m_playerComponent.Level().instanciateActor(this.m_playerComponent.getBlocActorId(this.m_playerComponent.getCollectableSelectedIndex()));
        this.m_playerComponent.Level().addActorToLayer(this.m_blocLayer, this.m_currentBloc);
        this.m_currentBloc.scale(0.5f);
        this.m_currentBloc.Shake(true);
        this.m_currentBloc.ShakeX(CurrentBlocOffsetx);
        this.m_currentBloc.ShakeY(CurrentBlocOffsety);
        this.m_currentBloc.AlwaysVisible(true);
        this.m_currentBloc.x = this.m_spawnx;
        this.m_currentBloc.y = this.m_spawny;
        this._updateColor();
    }
}

