/*
 * Decompiled with CFR 0.152.
 */
package SSS;

import Microsoft.Xna.Framework.Graphics.SpriteBatch;
import SSS.Actor;
import SSS.BehaviourParameter;
import SSS.Level;
import SSS.Util.Debug;
import java.util.HashMap;
import java.util.Map;
import org.flixel.event.FlxSpriteCollisionEvent;

public abstract class Behaviour {
    static String DefaultDesc = "No descritpion available";
    protected String m_id;
    protected Actor m_owner;
    HashMap<String, BehaviourParameter<Integer>> m_intParameters = null;
    HashMap<String, BehaviourParameter<Float>> m_floatParameters = null;
    HashMap<String, BehaviourParameter<String>> m_stringParameters = null;
    HashMap<String, String> m_descriptions = null;
    boolean m_bModifiedParameters = false;
    int m_renderBehaviourRegistered = 0;
    protected Actor.eActorMaterial m_material;

    public String Id() {
        return this.m_id;
    }

    public Actor Owner() {
        return this.m_owner;
    }

    public HashMap<String, BehaviourParameter<Integer>> IntParamsDictionary() {
        return this.m_intParameters;
    }

    public HashMap<String, BehaviourParameter<Float>> FloatParamsDictionary() {
        return this.m_floatParameters;
    }

    public HashMap<String, BehaviourParameter<String>> StringParamsDictionary() {
        return this.m_stringParameters;
    }

    public boolean HasParam() {
        return this.m_intParameters != null || this.m_floatParameters != null || this.m_stringParameters != null;
    }

    public boolean HasParamOverride() {
        return this.m_bModifiedParameters;
    }

    public Actor.eActorMaterial Material() {
        return this.m_material;
    }

    public Level Level() {
        return this.m_owner.Level();
    }

    public Behaviour(String _id, Actor _owner, Actor.eActorMaterial _material) {
        this.m_id = _id;
        this.m_owner = _owner;
        this.m_material = _material;
        if (this.m_owner.Material() == Actor.eActorMaterial.eActorMaterial_Unknown) {
            this.m_owner.Material(_material);
        }
        this.initOwnerFlixelProperties();
    }

    protected abstract void initOwnerFlixelProperties();

    public abstract void init();

    public void initEdit() {
        this.init();
    }

    public abstract void deinit();

    public void deinitEdit() {
        this.deinit();
    }

    public abstract void update();

    public abstract void checkCollisions();

    public abstract void onOverlapsCallback(FlxSpriteCollisionEvent var1, int var2);

    public void addParameter(String _id, String _type, String _value, String _descOrNil, boolean _bEditable) {
        if (_type.equals("string")) {
            this.addParameterString(_id, _value, _bEditable);
        } else if (_type.equals("int")) {
            this.addParameterInt(_id, Integer.parseInt(_value), _bEditable);
        } else if (_type.equals("float")) {
            this.addParameterFloat(_id, Float.parseFloat(_value), _bEditable);
        } else {
            Debug.Assert(false, "Invalid Parameter Type", String.format("The type \"{0}\" provided is not handled", _type));
        }
        if (_descOrNil != null && _descOrNil.length() > 0) {
            if (this.m_descriptions == null) {
                this.m_descriptions = new HashMap();
            }
            this.m_descriptions.put(_id, _descOrNil);
        }
    }

    public void overrideParameter(String _id, String _type, String _value) {
        if (_type.equals("string")) {
            this.setStringParameter(_id, _value);
        } else if (_type.equals("int")) {
            this.setIntParameter(_id, Integer.parseInt(_value));
        } else if (_type.equals("float")) {
            this.setFloatParameter(_id, Float.parseFloat(_value));
        } else {
            Debug.Assert(false, "Invalid Parameter Type", String.format("The type \"{0}\" provided is not handled", _type));
        }
    }

    public void addParameterInt(String _id, int _value, boolean _bEditable) {
        if (this.m_intParameters == null) {
            this.m_intParameters = new HashMap();
        }
        this.m_intParameters.put(_id, new BehaviourParameter<Integer>(_value, _bEditable));
    }

    public void addParameterFloat(String _id, float _value, boolean _bEditable) {
        if (this.m_floatParameters == null) {
            this.m_floatParameters = new HashMap();
        }
        this.m_floatParameters.put(_id, new BehaviourParameter<Float>(Float.valueOf(_value), _bEditable));
    }

    public void addParameterString(String _id, String _value, boolean _bEditable) {
        if (this.m_stringParameters == null) {
            this.m_stringParameters = new HashMap();
        }
        this.m_stringParameters.put(_id, new BehaviourParameter<String>(_value, _bEditable));
    }

    public String getStringParameter(String _id) {
        return this.m_stringParameters != null ? this.m_stringParameters.get(_id).getValue() : null;
    }

    public String getParameterDescription(String _id) {
        if (this.m_descriptions != null && this.m_descriptions.containsKey(_id)) {
            return this.m_descriptions.get(_id);
        }
        return DefaultDesc;
    }

    public int getIntParameter(String _id) {
        return this.m_intParameters != null ? this.m_intParameters.get(_id).getValue() : 0;
    }

    public float getFloatParameter(String _id) {
        return this.m_floatParameters != null ? this.m_floatParameters.get(_id).getValue().floatValue() : 0.0f;
    }

    public void setStringParameter(String _id, String _value) {
        this.m_bModifiedParameters = true;
        BehaviourParameter<String> param = this.m_stringParameters.get(_id);
        if (param != null) {
            param.setValue(_value);
        } else {
            this.addParameterString(_id, _value, true);
        }
    }

    public void setIntParameter(String _id, int _value) {
        this.m_bModifiedParameters = true;
        BehaviourParameter<Integer> param = this.m_intParameters.get(_id);
        if (param != null) {
            param.setValue(_value);
        } else {
            this.addParameterInt(_id, _value, true);
        }
    }

    public void setFloatParameter(String _id, float _value) {
        this.m_bModifiedParameters = true;
        BehaviourParameter<Float> param = this.m_floatParameters.get(_id);
        if (param != null) {
            param.setValue(Float.valueOf(_value));
        } else {
            this.addParameterFloat(_id, _value, true);
        }
    }

    public void copyParametersValue(Behaviour _bFrom) {
        if (_bFrom.m_intParameters != null && this.m_intParameters != null) {
            for (Map.Entry<String, BehaviourParameter<Number>> entry : _bFrom.m_intParameters.entrySet()) {
                if (!this.m_intParameters.containsKey(entry.getKey())) continue;
                this.setIntParameter(entry.getKey(), (Integer)entry.getValue().getValue());
            }
        }
        if (_bFrom.m_floatParameters != null && this.m_floatParameters != null) {
            for (Map.Entry<String, BehaviourParameter<Object>> entry : _bFrom.m_floatParameters.entrySet()) {
                if (!this.m_floatParameters.containsKey(entry.getKey())) continue;
                this.setFloatParameter(entry.getKey(), ((Float)entry.getValue().getValue()).floatValue());
            }
        }
        if (_bFrom.m_stringParameters != null && this.m_stringParameters != null) {
            for (Map.Entry<String, BehaviourParameter<Object>> entry : _bFrom.m_stringParameters.entrySet()) {
                if (!this.m_stringParameters.containsKey(entry.getKey())) continue;
                this.setStringParameter(entry.getKey(), (String)entry.getValue().getValue());
            }
        }
    }

    public void copyParameters(Behaviour _bFrom, boolean _bCopyDesc) {
        BehaviourParameter<Object> param;
        this.m_bModifiedParameters = _bFrom.m_bModifiedParameters;
        if (this.m_intParameters != null) {
            this.m_intParameters.clear();
        }
        if (this.m_floatParameters != null) {
            this.m_floatParameters.clear();
        }
        if (this.m_stringParameters != null) {
            this.m_stringParameters.clear();
        }
        if (this.m_descriptions != null) {
            this.m_descriptions.clear();
        }
        if (_bFrom.m_intParameters != null) {
            for (Map.Entry<String, BehaviourParameter<Number>> entry : _bFrom.m_intParameters.entrySet()) {
                param = entry.getValue();
                this.addParameterInt(entry.getKey(), (Integer)param.getValue(), param.isEditable());
            }
        }
        if (_bFrom.m_floatParameters != null) {
            for (Map.Entry<String, BehaviourParameter<Object>> entry : _bFrom.m_floatParameters.entrySet()) {
                param = entry.getValue();
                this.addParameterFloat(entry.getKey(), ((Float)entry.getValue().getValue()).floatValue(), param.isEditable());
            }
        }
        if (_bFrom.m_stringParameters != null) {
            for (Map.Entry<String, BehaviourParameter<Object>> entry : _bFrom.m_stringParameters.entrySet()) {
                param = entry.getValue();
                this.addParameterString(entry.getKey(), (String)entry.getValue().getValue(), param.isEditable());
            }
        }
        if (_bCopyDesc && _bFrom.m_descriptions != null) {
            if (this.m_descriptions == null) {
                this.m_descriptions = new HashMap(_bFrom.m_descriptions.size());
            }
            for (Map.Entry<String, String> kvp : _bFrom.m_descriptions.entrySet()) {
                this.m_descriptions.put(kvp.getKey(), kvp.getValue());
            }
        }
    }

    public void onLoadParamOverrideDone() {
    }

    public void onParamsChanged() {
    }

    public void render(SpriteBatch spriteBatch) {
    }

    public void handleGenericMessage(Actor.eGenericMessage _message, Actor _sender) {
    }

    protected void _registerRendererBehaviour() {
        if (this.m_renderBehaviourRegistered == 0) {
            this.m_owner.addRendererBehaviour(this);
        }
        ++this.m_renderBehaviourRegistered;
    }

    protected void _unregisterRendererBehaviour() {
        if (this.m_renderBehaviourRegistered > 0) {
            --this.m_renderBehaviourRegistered;
            this.m_owner.removeRendererBehaviour(this);
        }
    }
}

