/*
 * Decompiled with CFR 0.152.
 */
package SSS;

import SSS.Actor;
import SSS.Behaviour;
import SSS.Behaviours.BTM.AnimNoiserBehaviour;
import SSS.Behaviours.BTM.BlocBehaviour;
import SSS.Behaviours.BTM.BlocSwitchBehaviour;
import SSS.Behaviours.BTM.DoorBehaviour;
import SSS.Behaviours.BTM.EnnemyBehaviour;
import SSS.Behaviours.BTM.PlayerBehaviour;
import SSS.Behaviours.BTM.PortalBehaviour;
import SSS.Behaviours.BTM.SlimeDropBehaviour;
import SSS.Behaviours.BTM.SpawnBackgroundBehaviour;
import SSS.Behaviours.BTM.SpawnSlimeDropBehaviour;
import SSS.Behaviours.BTM.SpawnText;
import SSS.Behaviours.BTM.SpawnWorkshopBehaviour;
import SSS.Behaviours.BTM.SpawnpointBehaviour;
import SSS.Behaviours.BTM.SpawnsoundBehaviour;
import SSS.Behaviours.BTM.ThresholdBehaviour;
import SSS.Behaviours.BTM.TriggerDialogBehaviour;
import SSS.Behaviours.BTM.WorkShopBehaviour;

public class BehaviourManager {
    public static Behaviour InstanciateBehaviour(String _behaviourId, Actor _actor) {
        Actor.eActorMaterial matId = Actor.MaterialNameEnumDictionnary.get(_behaviourId);
        return BehaviourManager.InstanciateBehaviour(_behaviourId, matId, _actor);
    }

    public static Behaviour InstanciateBehaviour(String _id, Actor.eActorMaterial _material, Actor _actor) {
        Behaviour behaviour = null;
        switch (_material) {
            case eActorMaterial_Portal: {
                behaviour = new PortalBehaviour(_id, _actor, _material);
                break;
            }
            case eActorMaterial_Player: {
                behaviour = new PlayerBehaviour(_id, _actor, _material);
                break;
            }
            case eActorMaterial_SpawnBackground: {
                behaviour = new SpawnBackgroundBehaviour(_id, _actor, _material);
                break;
            }
            case eActorMaterial_SpawnWorkshop: {
                behaviour = new SpawnWorkshopBehaviour(_id, _actor, _material);
                break;
            }
            case eActorMaterial_TriggerDialog: {
                behaviour = new TriggerDialogBehaviour(_id, _actor, _material);
                break;
            }
            case eActorMaterial_Spawnpoint: {
                behaviour = new SpawnpointBehaviour(_id, _actor, _material);
                break;
            }
            case eActorMaterial_Spawnsound: {
                behaviour = new SpawnsoundBehaviour(_id, _actor, _material);
                break;
            }
            case eActorMaterial_Text: {
                behaviour = new SpawnText(_id, _actor, _material);
                break;
            }
            case eActorMaterial_Ennemy: {
                behaviour = new EnnemyBehaviour(_id, _actor, _material);
                break;
            }
            case eActorMaterial_Threshold: {
                behaviour = new ThresholdBehaviour(_id, _actor, _material);
                break;
            }
            case eActorMaterial_UnbreakableSlimeSpawn: {
                behaviour = new SpawnSlimeDropBehaviour(_id, _actor, _material);
                break;
            }
            case eActorMaterial_SlimeDrop: {
                behaviour = new SlimeDropBehaviour(_id, _actor, _material);
                break;
            }
            case eActorMaterial_AnimNoiser: {
                behaviour = new AnimNoiserBehaviour(_id, _actor, _material);
                break;
            }
            case eActorMaterial_Workshop: {
                behaviour = new WorkShopBehaviour(_id, _actor, _material);
                break;
            }
            case eActorMaterial_Switch: {
                behaviour = new BlocSwitchBehaviour(_id, _actor, _material);
                break;
            }
            case eActorMaterial_Door: {
                behaviour = new DoorBehaviour(_id, _actor, _material);
                break;
            }
            case eActorMaterial_WhiteChocolate: 
            case eActorMaterial_BrownChocolate: 
            case eActorMaterial_BlackChocolate: 
            case eActorMaterial_PinkChocolate: {
                behaviour = new BlocBehaviour(_id, _actor, _material);
                break;
            }
            default: {
                behaviour = new BlocBehaviour(_id, _actor, _material);
            }
        }
        _actor.addBehaviourObject(behaviour);
        return behaviour;
    }
}

