/*
 * Decompiled with CFR 0.152.
 */
package SSS.Behaviours.BTM;

import Microsoft.Xna.Framework.Graphics.SpriteBatch;
import Microsoft.Xna.Framework.Vector2;
import SSS.Actor;
import SSS.Behaviour;
import org.flixel.FlxG;
import org.flixel.FlxSprite;
import org.flixel.event.FlxSpriteCollisionEvent;

public class BackgroundTiledBehaviour
extends Behaviour {
    FlxSprite m_background = null;
    int m_numTilex;
    int m_numTiley;
    float desiredWidth = 1280.0f;
    float desiredHeight = 720.0f;

    public void initParams(String _image, float _scrollfactorx, float _scrollfactory) {
        this.m_owner.scrollFactor.X = _scrollfactorx;
        this.m_owner.scrollFactor.Y = _scrollfactory;
        this.m_owner.addRendererBehaviour(this);
        this.m_background = new FlxSprite();
        this.m_background.loadGraphic(FlxG.Content().LoadTexture2D("sss/textures/" + _image));
        this.m_background.scrollFactor = Vector2.Zero();
        this.m_background.scaleX(this.desiredWidth / (1.0f * this.m_background.width));
        this.m_background.scaleY(this.desiredHeight / (1.0f * this.m_background.height));
        this.m_numTilex = 2 * (int)((float)FlxG.width / this.desiredWidth);
        this.m_numTiley = 2 * (int)((float)FlxG.height / this.desiredHeight);
    }

    public BackgroundTiledBehaviour(String _id, Actor _owner, Actor.eActorMaterial _material) {
        super(_id, _owner, _material);
        this.m_owner.AlwaysVisible(true);
    }

    @Override
    protected void initOwnerFlixelProperties() {
    }

    @Override
    public void init() {
    }

    @Override
    public void deinit() {
    }

    @Override
    public void update() {
    }

    @Override
    public void checkCollisions() {
    }

    @Override
    public void onOverlapsCallback(FlxSpriteCollisionEvent _event, int _callbackId) {
    }

    @Override
    public void render(SpriteBatch spriteBatch) {
        Vector2 ownerLeftTop = this.m_owner.getScreenXY();
        this.m_background.color(this.m_owner.color());
        int stepOffsetx = (int)((0.0f - ownerLeftTop.X) / this.desiredWidth);
        int stepOffsety = (int)((0.0f - ownerLeftTop.Y) / this.desiredHeight);
        if (0.0f < ownerLeftTop.X) {
            --stepOffsetx;
        }
        if (0.0f < ownerLeftTop.Y) {
            --stepOffsety;
        }
        float offsetx = (float)stepOffsetx * this.desiredWidth;
        float offsety = (float)stepOffsety * this.desiredHeight;
        float scaleOffsetx = (this.m_background.scaleX() - 1.0f) * this.m_background.width * 0.5f;
        float scaleOffsety = (this.m_background.scaleY() - 1.0f) * this.m_background.height * 0.5f;
        int i = 0;
        while (i < this.m_numTilex) {
            int j = 0;
            while (j < this.m_numTiley) {
                this.m_background.x = ownerLeftTop.X + (float)i * this.desiredWidth + offsetx + scaleOffsetx;
                this.m_background.y = ownerLeftTop.Y + (float)j * this.desiredHeight + offsety + scaleOffsety;
                this.m_background.render(spriteBatch);
                ++j;
            }
            ++i;
        }
    }
}

