/*
 * Decompiled with CFR 0.152.
 */
package SSS.Behaviours.BTM;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Graphics.SpriteBatch;
import Microsoft.Xna.Framework.MathHelper;
import SSS.Actor;
import SSS.BTM.GameVars;
import SSS.Behaviour;
import SSS.Behaviours.BTM.EnnemyBehaviour;
import SSS.Level;
import SSS.Managers.BTM.AchievementManager;
import SSS.Managers.BTM.BlocManager;
import SSS.Managers.BTM.BlocksSoundsManager;
import SSS.Managers.BTM.Particle.KaboomParticleEffect;
import SSS.SssGroup;
import SSS.Util.Utility;
import org.flixel.FlxG;
import org.flixel.FlxSprite;
import org.flixel.event.FlxSpriteCollisionEvent;

public class BlocBehaviour
extends Behaviour {
    static final float MinBreakThBeg = 0.0f;
    static final float MinBreakThEnd = 0.5f;
    static final float MedBreakThBeg = 0.5f;
    static final float MedBreakThEnd = 1.0f;
    static final float MaxBreakThBeg = 1.0f;
    static final int CallbackId_PieceBlocOverlapsExistingPhysics = 0;
    static final int CallbackId_PieceBlocOverlapsExistingCharacter = 1;
    static final int CallbackId_PieceBlocOverlapsExistingEnnemy = 2;
    float SpeedFall = 500.0f;
    boolean m_bCanSlide = false;
    boolean m_bSliding = false;
    float m_slidingSide = 1.0f;
    boolean m_bCanFall = false;
    boolean m_bFalling = false;
    float m_timeShaking = 0.0f;
    boolean m_bAlignedGridOverlap = true;
    boolean m_bCanExplode = false;
    boolean m_bExploding = false;
    float m_timeExplodeCountDown = 1.0f;
    boolean m_bDestroyed = false;
    float m_drillTime = 0.5f;
    float m_elapsedDrillTime = 0.0f;
    boolean m_bDrilled = false;
    boolean m_bDrilledFake = false;
    static FlxSprite m_BreakAnim = null;
    boolean m_bJumpShake = false;
    boolean m_bObstructShake = false;
    float m_elapsedJumpShakeTime = 0.0f;
    boolean m_bDieAnim = false;
    float m_elapsedTimeMove = 0.0f;
    static float TimeMoveMax = 0.15f;
    int m_idLineLast = -1;
    int m_idColLast = -1;
    static float ShakeSpeed = 20.0f;
    static float ShakeAmplitude = 4.0f;
    static float SlideSpeed = 400.0f;
    static float ShakeSpeedDrill = 100.0f;
    static float ShakeAmplitudeDrill = 3.0f;
    static float ShakeSpeedJump = 100.0f;
    static float ShakeAmplitudeJump = 3.0f;
    static float ShakeJumpTime = 0.2f;
    boolean m_bRegisteredForPuzzleModeChange = false;
    eLifeControl m_lifeControl = eLifeControl.eLifeControl_LetLive;
    float m_delayBeforeDying = GameVars.ChocolateDestroyDelay();
    boolean m_bRegisteredInBlocManager = false;

    public boolean Sliding() {
        return this.m_bSliding;
    }

    public boolean Falling() {
        return this.m_bFalling;
    }

    public BlocBehaviour(String _id, Actor _owner, Actor.eActorMaterial _material) {
        super(_id, _owner, _material);
    }

    @Override
    protected void initOwnerFlixelProperties() {
        this.m_owner.fixed = true;
        this.m_owner.moves = true;
    }

    @Override
    public void init() {
        if (this.m_owner.Level().PlayableMode()) {
            this.m_owner.removeFlag(Actor.eSpecialFlag.eSpecialFlag_RenderOverall);
            if (Actor.CanFallDependingMaterial(this.m_owner.Material())) {
                this._setCanFall(true);
            }
            if (Actor.CanSlideDependingMaterial(this.m_owner.Material())) {
                this._setCanSlide(true);
                this._setCanFall(true);
            }
            if (Actor.CanExplodeMaterial(this.m_owner.Material())) {
                this._setCanExplode(true);
            }
            this._registerInBlocManager(true);
            if (m_BreakAnim == null) {
                m_BreakAnim = this.m_owner.Level().instanciateSprite("break_anim");
                BlocBehaviour.m_BreakAnim.width = this.m_owner.width;
                BlocBehaviour.m_BreakAnim.height = this.m_owner.height;
                BlocBehaviour.m_BreakAnim.offset = this.m_owner.offset;
            }
            if (this.Material() == Actor.eActorMaterial.eActorMaterial_Ice) {
                this.m_owner.Level().ParticleManager().reserveEmitterTrigger("IceExplode");
            }
        }
        if (this.Material() == Actor.eActorMaterial.eActorMaterial_UnbreakableAutoAnim) {
            this.m_owner.play(this.getStringParameter("animId"));
            this.m_owner.CanUpdateBehaviour(false);
            this._checkPassiveFlag();
        } else if (this.Material() == Actor.eActorMaterial.eActorMaterial_Paint) {
            this._changeColorBasedOnProperties();
        }
    }

    protected void _changeColorBasedOnProperties() {
        int r = Utility.Clamp(this.getIntParameter("c1_R"), 0, 255);
        int g = Utility.Clamp(this.getIntParameter("c2_G"), 0, 255);
        int b = Utility.Clamp(this.getIntParameter("c3_B"), 0, 255);
        int a = Utility.Clamp(this.getIntParameter("c4_A"), 0, 255);
        this.m_owner.color(new Color(r, g, b));
        if (this.m_owner.Level().PlayableMode()) {
            this.m_owner.alpha((float)a / 255.0f);
        } else if (a <= 40) {
            this.m_owner.alpha(0.15686275f);
        } else {
            this.m_owner.alpha((float)a / 255.0f);
        }
    }

    protected void _setCanFall(boolean _bCanFall) {
        this.m_bCanFall = _bCanFall;
        if (this.m_bCanFall) {
            this._registerPuzzleModeChanged();
        } else {
            this._unregisterPuzzleModeChanged();
        }
    }

    protected void _setFalling(boolean _bFalling) {
        if (this.m_bCanFall && this.m_bFalling != _bFalling) {
            this.m_timeShaking = 0.0f;
            this.m_bFalling = _bFalling;
            this.m_owner.NeedRoundedSorting(_bFalling);
            this.m_owner.Shake(false);
            this.m_owner.ShakeX(0.0f);
            this.m_owner.ShakeY(0.0f);
            if (_bFalling) {
                this.m_owner.addFlag(Actor.eSpecialFlag.eSpecialFlag_Falling);
                this.m_owner.removeFlag(Actor.eSpecialFlag.eSpecialFlag_FallBlockedByPlayer);
                this.m_owner.Level().BlocSoundManager().triggerBlocSoundEvent(BlocksSoundsManager.eBlocSoundEvent.eBlocSoundEvent_FallBegin, this.m_owner);
                this._computeCurrentIdInBlocManager();
            } else {
                this.m_owner.removeFlag(Actor.eSpecialFlag.eSpecialFlag_Falling);
                if (this._playerCollisionBelow()) {
                    this.m_owner.addFlag(Actor.eSpecialFlag.eSpecialFlag_FallBlockedByPlayer);
                }
                this.m_owner.Level().BlocSoundManager().triggerBlocSoundEvent(BlocksSoundsManager.eBlocSoundEvent.eBlocSoundEvent_FallEnd, this.m_owner);
                if (this.m_owner.Level().BlocManager().isAlignedWithGrid(this.m_owner)) {
                    this.m_bAlignedGridOverlap = true;
                    this._unregisterInBlocManager(true);
                    this._registerInBlocManager(true);
                    if (this.Material() == Actor.eActorMaterial.eActorMaterial_Clay) {
                        this._setCanFall(false);
                    }
                    this.m_owner.Level().BlocSoundManager().triggerBlocSoundEvent(BlocksSoundsManager.eBlocSoundEvent.eBlocSoundEvent_Land, this.m_owner);
                }
            }
        }
    }

    protected void _setCanExplode(boolean _bCanExplode) {
        this.m_bCanExplode = _bCanExplode;
    }

    protected void _setExploding(boolean _bExplode) {
        if (this.m_bCanExplode && this.m_bExploding != _bExplode) {
            this.m_bExploding = _bExplode;
            if (_bExplode) {
                this._registerPuzzleModeChanged();
                this.m_owner.play("exploding");
                this.m_owner.Level().BlocSoundManager().triggerBlocSoundEvent(BlocksSoundsManager.eBlocSoundEvent.eBlocSoundEvent_TntTrigger, this.m_owner);
                this.m_timeExplodeCountDown = 1.0f * (float)GameVars.NumSecondBeforeTntExplode();
            }
        }
    }

    protected void _setCanSlide(boolean _bCanSlide) {
        this.m_bCanSlide = _bCanSlide;
        if (this.m_bCanSlide) {
            this._registerPuzzleModeChanged();
        } else {
            this._unregisterPuzzleModeChanged();
        }
    }

    protected void _setSliding(boolean _bSliding) {
        if (this.m_bCanSlide && this.m_bSliding != _bSliding) {
            if (_bSliding && GameVars.ChocolatePinkStick() && this.m_material == Actor.eActorMaterial.eActorMaterial_PinkChocolate && this.m_owner.Level().BlocManager().isAnyNeighbourActorsDiagonalsSameMaterial(this.m_owner)) {
                return;
            }
            this.m_slidingSide = this.m_owner.Level().MainPlayer().x < this.m_owner.x ? 1.0f : -1.0f;
            boolean canSetSlide = true;
            if (_bSliding) {
                if (this.m_owner.Level().BlocManager().isAlignedWithGrid(this.m_owner)) {
                    this.m_owner.Level().BlocManager().getPointGridLocation(this.m_owner.getLeft(), this.m_owner.getBottom() - 0.1f, BlocManager.idCol, BlocManager.idLine);
                    int idCol = BlocManager.idCol.get();
                    int idLine = BlocManager.idLine.get();
                    int n = idCol = this.m_slidingSide > 0.0f ? idCol + 1 : idCol - 1;
                    if (this.m_owner.Level().BlocManager().isBlocSlotOccupied(idLine, idCol, this.m_owner)) {
                        canSetSlide = false;
                    }
                } else {
                    canSetSlide = true;
                }
            }
            if (canSetSlide) {
                this.m_bSliding = _bSliding;
                if (_bSliding) {
                    this._checkRegisterInBlocManager();
                } else if (this.m_owner.Level().BlocManager().isAlignedWithGrid(this.m_owner)) {
                    this.m_bAlignedGridOverlap = true;
                    this._checkRegisterInBlocManager();
                }
            }
        }
    }

    protected void _registerInBlocManager(boolean _updateLastIds) {
        if (this.m_owner.Dying()) {
            return;
        }
        if (!(this.m_bDestroyed || this.m_bRegisteredInBlocManager || this.m_owner.Level().Mode() != Level.eLevelMode.eLevelMode_Play && this.m_owner.Level().Mode() != Level.eLevelMode.eLevelMode_Test)) {
            this.m_bRegisteredInBlocManager = true;
            if (Actor.IsConsirededAsGround(this.m_owner.Material())) {
                this.m_owner.Level().BlocManager().registerUnremovableBloc(this.m_owner);
            } else if (_updateLastIds) {
                this.m_owner.Level().BlocManager().registerRemovableBloc(this.m_owner, BlocManager.m_idColLast, BlocManager.m_idLineLast, true);
                this.m_idColLast = BlocManager.m_idColLast.get();
                this.m_idLineLast = BlocManager.m_idLineLast.get();
            } else {
                this.m_owner.Level().BlocManager().registerRemovableBloc(this.m_owner);
            }
        }
    }

    protected void _computeCurrentIdInBlocManager() {
        this.m_owner.Level().BlocManager().getActorGridLocation(this.m_owner, BlocManager.m_idColLast, BlocManager.m_idLineLast);
        this.m_idColLast = BlocManager.m_idColLast.get();
        this.m_idLineLast = BlocManager.m_idLineLast.get();
    }

    protected void _checkRegisterInBlocManager() {
        this.m_owner.Level().BlocManager().getActorGridLocation(this.m_owner, BlocManager.idCol, BlocManager.idLine);
        int idCol = BlocManager.idCol.get();
        int idLine = BlocManager.idLine.get();
        if (idCol != this.m_idColLast || idLine != this.m_idLineLast) {
            this._unregisterInBlocManager(true);
            this._registerInBlocManager(true);
        }
    }

    protected void _repositionnateFallingOrSlidingOnGrid() {
        boolean needRegisterUpdate = false;
        this.m_owner.Level().BlocManager().getActorGridLocation(this.m_owner, BlocManager.idCol, BlocManager.idLine);
        int idCol = BlocManager.idCol.get();
        int idLine = BlocManager.idLine.get();
        this.m_owner.Level().BlocManager().getPointGridLocation(this.m_owner.getCenterX(), this.m_owner.getCenterY() - 0.01f, BlocManager.idCol, BlocManager.idLine);
        int idColRepositioned = BlocManager.idCol.get();
        int idLineRepositionned = BlocManager.idLine.get();
        if (idColRepositioned != idCol || idLine != idLineRepositionned) {
            needRegisterUpdate = true;
            idCol = idColRepositioned;
            idLine = idLineRepositionned;
        }
        if (needRegisterUpdate) {
            this._unregisterInBlocManager(true);
        }
        this.m_owner.x = idCol * GameVars.TileStep();
        this.m_owner.y = (float)(-idLine * GameVars.TileStep()) - this.m_owner.height;
        if (needRegisterUpdate) {
            this._registerInBlocManager(true);
        }
    }

    protected void _unregisterInBlocManager(boolean _bUseLastIds) {
        if (this.m_bRegisteredInBlocManager) {
            if (Actor.IsConsirededAsGround(this.m_owner.Material())) {
                this.m_owner.Level().BlocManager().unregisterUnremovableBloc(this.m_owner);
            } else if (_bUseLastIds) {
                this.m_owner.Level().BlocManager().unregisterRemovableBlocAtSafe(this.m_owner, this.m_idColLast, this.m_idLineLast);
            } else {
                this.m_owner.Level().BlocManager().unregisterRemovableBlocSafe(this.m_owner);
            }
            this.m_bRegisteredInBlocManager = false;
        }
    }

    @Override
    public void deinit() {
        this._unregisterInBlocManager(false);
    }

    @Override
    public void update() {
        if (this.m_owner.Level().PuzzleMode()) {
            return;
        }
        if (this.m_owner.Dying()) {
            if (this.m_bDieAnim) {
                float scalexspeed = 10.0f;
                float scaleyspeed = 8.0f;
                float minscale = 0.2f;
                boolean bMove = false;
                if (this.m_owner.scaleX() > 0.2f) {
                    this.m_owner.scaleX(this.m_owner.scaleX() - FlxG.elapsed * 10.0f);
                    bMove = false;
                } else {
                    this.m_owner.scaleX(0.2f);
                    bMove = true;
                }
                if (this.m_owner.scaleY() > 0.2f) {
                    this.m_owner.scaleY(this.m_owner.scaleY() - FlxG.elapsed * 8.0f);
                    bMove = false;
                } else {
                    this.m_owner.scaleY(0.2f);
                    bMove = true;
                }
                if (bMove) {
                    if (!this.m_owner.hasFlag(Actor.eSpecialFlag.eSpecialFlag_RenderOverall)) {
                        this.m_owner.addFlag(Actor.eSpecialFlag.eSpecialFlag_RenderOverall);
                        this.m_owner.reinitValueBBoxTweakRelated();
                    }
                    float playerx = this.m_owner.Level().MainPlayer().getCenterX();
                    float playery = this.m_owner.Level().MainPlayer().getCenterY();
                    float blocx = this.m_owner.getCenterX();
                    float blocy = this.m_owner.getCenterY();
                    blocx = MathHelper.Lerp(blocx, playerx, this.m_elapsedTimeMove / TimeMoveMax);
                    blocy = MathHelper.Lerp(blocy, playery, this.m_elapsedTimeMove / TimeMoveMax);
                    this.m_owner.x = blocx - this.m_owner.width * 0.5f;
                    this.m_owner.y = blocy - this.m_owner.height * 0.5f;
                    if (this.m_elapsedTimeMove > TimeMoveMax) {
                        if (Actor.IsInCollectableRangeHACK(this.m_owner.Material())) {
                            this.m_owner.Level().MainPlayer().handleGenericMessage(Actor.eGenericMessage.eGenericMessage_IncrementMaterialStock, this.m_owner);
                        }
                        this._destroy();
                        this.m_bDieAnim = false;
                    }
                    this.m_elapsedTimeMove += FlxG.elapsed;
                }
            }
        } else {
            if (this.m_bExploding) {
                this._updateExplode();
            }
            if (this.m_bCanFall && !this.m_bSliding) {
                this._updateFall();
            }
            if (this.m_bCanSlide) {
                this._updateSlide();
            }
            if (this.m_lifeControl != eLifeControl.eLifeControl_LetLive) {
                this._updateLifeControl();
            }
            if (this._canBeCollected()) {
                this._updateDrill(FlxG.elapsed, false, true);
            }
            if (this.m_bJumpShake) {
                this.m_owner.Shake(true);
                this.m_owner.ShakeY((float)Math.cos(this.m_elapsedJumpShakeTime * ShakeSpeedJump) * ShakeAmplitudeJump);
                this.m_elapsedJumpShakeTime += FlxG.elapsed;
                if (this.m_elapsedJumpShakeTime > ShakeJumpTime) {
                    this.m_bJumpShake = false;
                    this.m_owner.Shake(false);
                    this.m_owner.ShakeY(0.0f);
                }
            } else if (this.m_bObstructShake) {
                this.m_owner.Shake(true);
                this.m_owner.ShakeX((float)Math.cos(this.m_elapsedJumpShakeTime * ShakeSpeedJump) * ShakeAmplitudeJump);
                this.m_elapsedJumpShakeTime += FlxG.elapsed;
                if (this.m_elapsedJumpShakeTime > ShakeJumpTime) {
                    this.m_elapsedJumpShakeTime = 0.0f;
                    this.m_bObstructShake = false;
                    this.m_owner.Shake(false);
                    this.m_owner.ShakeX(0.0f);
                }
            }
        }
    }

    protected void _updateDrill(float _step, boolean _bForce, boolean _bShake) {
        if (!this.m_owner.Dying()) {
            if (this.m_bDrilled || _bForce) {
                if (this.m_elapsedDrillTime <= 0.0f) {
                    this._registerRendererBehaviour();
                }
                float oldPerc = this.m_elapsedDrillTime / this.m_drillTime;
                this.m_elapsedDrillTime += _step;
                float perc = this.m_elapsedDrillTime / this.m_drillTime;
                if (oldPerc <= 0.0f && perc > 0.0f && perc < 0.5f) {
                    this.m_owner.Level().MainPlayer().handleGenericMessage(Actor.eGenericMessage.eGenericMessage_DrillBreakStep1, this.m_owner);
                } else if (oldPerc < 0.5f && perc > 0.5f && perc < 1.0f) {
                    this.m_owner.Level().MainPlayer().handleGenericMessage(Actor.eGenericMessage.eGenericMessage_DrillBreakStep2, this.m_owner);
                } else if (oldPerc < 1.0f && perc >= 1.0f) {
                    this.m_owner.Level().MainPlayer().handleGenericMessage(Actor.eGenericMessage.eGenericMessage_DrillBreakStep3, this.m_owner);
                }
                if (this.m_elapsedDrillTime > this.m_drillTime && !this.m_bDrilledFake) {
                    if (!Actor.IsInDrillableRange(this.m_owner.Material()) && this.m_owner.Material() == Actor.eActorMaterial.eActorMaterial_ChestBTM) {
                        this.m_owner.Level().MainPlayer().handleGenericMessage(Actor.eGenericMessage.eGenericMessage_BTMGrabed, this.m_owner);
                    }
                    this.m_owner.Dying(true);
                    this._unregisterInBlocManager(false);
                    if (this.m_owner.Material() == Actor.eActorMaterial.eActorMaterial_Chest) {
                        this._chestDrilled();
                    } else if (this.m_owner.Material() == Actor.eActorMaterial.eActorMaterial_Paint) {
                        this._destroy();
                    } else {
                        this.m_bDieAnim = true;
                    }
                }
                if (_bShake) {
                    this.m_owner.Shake(true);
                    this.m_owner.ShakeX((float)Math.cos(this.m_timeShaking * ShakeSpeedDrill) * ShakeAmplitudeDrill);
                    if (this.m_bDrilledFake) {
                        this.m_owner.ShakeX(this.m_owner.ShakeX() * 0.5f);
                    }
                    this.m_timeShaking += FlxG.elapsed;
                }
            } else if (this.m_elapsedDrillTime > 0.0f) {
                if (_bShake) {
                    this.m_owner.Shake(false);
                    this.m_owner.ShakeX(0.0f);
                }
                if (this.m_bDrilledFake) {
                    _step *= 2.0f;
                }
                this.m_elapsedDrillTime -= _step * 0.25f;
                if (this.m_elapsedDrillTime <= 0.0f) {
                    this.m_elapsedDrillTime = 0.0f;
                    this._unregisterRendererBehaviour();
                }
            }
            this.m_bDrilled = false;
        }
    }

    protected void _updateExplode() {
        if (this.m_bExploding) {
            this.m_timeExplodeCountDown -= FlxG.elapsed;
            this.m_timeShaking += FlxG.elapsed;
            this.m_owner.CurAnim().changeDelay(MathHelper.Lerp(this.m_owner.CurAnim().originalDelay * 0.1f, this.m_owner.CurAnim().originalDelay, this.m_timeExplodeCountDown / (1.0f * (float)GameVars.NumSecondBeforeTntExplode())));
            if (this.m_owner.CurFrameJustChanged()) {
                this.m_owner.Level().BlocSoundManager().triggerBlocSoundEvent(BlocksSoundsManager.eBlocSoundEvent.eBlocSoundEvent_TntBip, this.m_owner);
            }
            this.m_owner.Shake(true);
            this.m_owner.ShakeX((float)Math.cos(this.m_timeShaking * ShakeSpeed * 5.0f) * ShakeAmplitude * 0.5f);
            this.m_owner.ShakeY((float)Math.cos(this.m_timeShaking * ShakeSpeed * 5.0f) * ShakeAmplitude * 0.5f);
            if (this.m_timeExplodeCountDown < 0.0f) {
                this.m_bExploding = false;
                this.m_owner.Level().BlocSoundManager().triggerBlocSoundEvent(BlocksSoundsManager.eBlocSoundEvent.eBlocSoundEvent_TntExplode, this.m_owner);
                this.m_owner.Level().ParticleManager().startKaboomEmitter(this.m_owner.getCenterX(), this.m_owner.getCenterY(), this.m_owner, KaboomParticleEffect.Orange());
            }
        }
    }

    protected void _onKaboom() {
        this._propagateNeighbourKill(true, Actor.eGenericMessage.eGenericMessage_TntBlow);
        this._propagatePlayerAndEnnemiesKill();
        this._destroy();
        FlxG.quake.start(0.01f, 0.25f);
    }

    protected void _propagatePlayerAndEnnemiesKill() {
        float myCx = this.m_owner.getCenterX();
        float myCy = this.m_owner.getCenterY();
        float myRadiusSquared = (float)GameVars.TileStep() * 1.5f;
        myRadiusSquared *= myRadiusSquared;
        this._checkLivingActorBlowPropagate(this.m_owner.Level().MainPlayer(), myCx, myCy, myRadiusSquared);
        SssGroup ennemies = this.m_owner.Level().Ennemies();
        int i = 0;
        while (i < ennemies.members.size()) {
            this._checkLivingActorBlowPropagate((Actor)ennemies.members.get(i), myCx, myCy, myRadiusSquared);
            ++i;
        }
    }

    protected void _checkLivingActorBlowPropagate(Actor _actor, float _cx, float _cy, float _rSquared) {
        float rSquared;
        float cy;
        float cx;
        float distSquared;
        if (_actor != null && (distSquared = ((cx = _actor.getCenterX()) - _cx) * (cx - _cx) + ((cy = _actor.getCenterY()) - _cy) * (cy - _cy)) <= _rSquared + (rSquared = _actor.getRadiusSquared())) {
            _actor.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_TntBlow, this.m_owner);
        }
    }

    protected void _onPuzzleModeKaboom() {
        this._destroy();
    }

    protected void _destroy() {
        if (!this.m_bDestroyed) {
            this.m_owner.Dying(true);
            this.m_bDestroyed = true;
            this._unregisterInBlocManager(false);
            this.m_owner.Level().removeActorsToPhysic(this.m_owner);
            if (this.m_bRegisteredForPuzzleModeChange) {
                this._unregisterPuzzleModeChanged();
                if (this.m_lifeControl == eLifeControl.eLifeControl_Burning) {
                    this.m_owner.Level().BlocSoundManager().triggerBlocSoundEvent(BlocksSoundsManager.eBlocSoundEvent.eBlocSoundEvent_FireEnd, this.m_owner);
                }
                if (this.m_bFalling) {
                    this.m_owner.Level().BlocSoundManager().triggerBlocSoundEvent(BlocksSoundsManager.eBlocSoundEvent.eBlocSoundEvent_FallEnd, this.m_owner);
                }
            }
            if (this.m_bFalling) {
                this._setFalling(false);
            }
            if (this.m_bSliding) {
                this._setSliding(false);
            }
        }
    }

    protected boolean _canBeCollected() {
        return Actor.CanBeDrilled(this.m_owner.Material());
    }

    protected void _updateFall() {
        if (this.m_bFalling) {
            this.m_owner.y += FlxG.elapsed * this.SpeedFall;
            if (this.m_owner.y + this.m_owner.height > 0.0f) {
                this.m_owner.y = -this.m_owner.height;
                return;
            }
        }
        if (!this.m_bFalling) {
            if (!this.m_bAlignedGridOverlap || !this.m_owner.Level().BlocManager().isBlocSlotBelowOccupied(this.m_owner)) {
                if (GameVars.ChocolatePinkStick() && this.m_material == Actor.eActorMaterial.eActorMaterial_PinkChocolate && this.m_owner.Level().BlocManager().isAnyNeighbourActorsDiagonalsSameMaterial(this.m_owner)) {
                    this.m_timeShaking = 0.0f;
                    this.m_bFalling = false;
                    this.m_owner.NeedRoundedSorting(false);
                    this.m_owner.Shake(false);
                    this.m_owner.ShakeX(0.0f);
                    this.m_owner.ShakeY(0.0f);
                    return;
                }
                this.m_timeShaking += FlxG.elapsed;
                if (this.m_timeShaking > GameVars.TimeShakingBeforeFalling() || !this.m_bAlignedGridOverlap) {
                    if (!this._playerCollisionBelow() && !this._otherBlocCollisionBelow()) {
                        this._setFalling(true);
                    }
                } else {
                    if (!this.m_owner.Shake()) {
                        this.m_owner.Level().BlocSoundManager().triggerBlocSoundEvent(BlocksSoundsManager.eBlocSoundEvent.eBlocSoundEvent_Shake, this.m_owner);
                    }
                    this.m_owner.Shake(true);
                    this.m_owner.ShakeX((float)Math.cos(this.m_timeShaking * ShakeSpeed) * ShakeAmplitude);
                }
            } else if (this.m_owner.Shake()) {
                this.m_owner.Shake(false);
                this.m_owner.ShakeX(0.0f);
            }
        } else {
            Utility.SssU_overlap(this.m_owner.Level().LayerPlayer(), this.m_owner, this, 1);
            if (this.m_bFalling) {
                this.m_owner.Level().BlocManager().overlapFast(this.m_owner, this, 0);
                if (this.m_bFalling && GameVars.ChocolatePinkStick() && this.m_material == Actor.eActorMaterial.eActorMaterial_PinkChocolate) {
                    this.m_owner.Level().BlocManager().getPointGridLocation(this.m_owner.x, this.m_owner.y, BlocManager.idCo, BlocManager.idLi);
                    int idLiTop = BlocManager.idLi.get();
                    int idCo = BlocManager.idCo.get();
                    this.m_owner.Level().BlocManager().getPointGridLocation(this.m_owner.x, this.m_owner.y + this.m_owner.height, BlocManager.idCo, BlocManager.idLi);
                    int idLiBot = BlocManager.idLi.get();
                    if (idLiTop != idLiBot) {
                        Actor act = this.m_owner.Level().BlocManager().getActorInBlocSlot(idLiTop, idCo + 1, true);
                        boolean bStopFall = false;
                        if (act != null && act.Material() == this.m_material) {
                            bStopFall = true;
                        } else {
                            act = this.m_owner.Level().BlocManager().getActorInBlocSlot(idLiTop, idCo - 1, true);
                            if (act != null && act.Material() == this.m_material) {
                                bStopFall = true;
                            }
                        }
                        if (bStopFall) {
                            this.m_bAlignedGridOverlap = false;
                            this.m_owner.y = act.y;
                            this._setFalling(false);
                        }
                    }
                }
            }
            this._checkRegisterInBlocManager();
        }
    }

    protected boolean _otherBlocCollisionBelow() {
        int idLine = this.m_idLineLast;
        while (idLine >= this.m_idLineLast - 1) {
            Actor a;
            if (idLine >= 0 && (a = this.m_owner.Level().BlocManager().getActorInBlocSlot(idLine, this.m_idColLast, true)) != null && !a.equals(this.m_owner) && Utility.IsActorsOverlappingFastWithScale(a, this.m_owner, 1.01f)) {
                return true;
            }
            --idLine;
        }
        return false;
    }

    protected boolean _playerCollisionBelow() {
        if (this.m_owner.Level().MainPlayer().getCenterY() < this.m_owner.y + this.m_owner.height) {
            return false;
        }
        return Utility.IsActorsOverlappingFastWithScale(this.m_owner.Level().MainPlayer(), this.m_owner, 1.01f);
    }

    protected void _updateSlide() {
        if (this.m_bSliding) {
            this.m_owner.x += this.m_slidingSide * FlxG.elapsed * SlideSpeed;
            float pointx = this.m_slidingSide > 0.0f ? this.m_owner.getRight() : this.m_owner.getLeft();
            float pointy = this.m_owner.getBottom() - 0.1f;
            this.m_owner.Level().BlocManager().getPointGridLocation(pointx, pointy, BlocManager.idCol, BlocManager.idLine);
            int idCol = BlocManager.idCol.get();
            int idLine = BlocManager.idLine.get();
            if (this.m_owner.Level().BlocManager().isBlocSlotOccupied(idLine, idCol, this.m_owner)) {
                float newLeft;
                idCol = this.m_slidingSide > 0.0f ? idCol - 1 : idCol + 1;
                this.m_owner.x = newLeft = (float)(idCol * GameVars.TileStep());
                this._setSliding(false);
            } else {
                float pointxOpposite = this.m_slidingSide > 0.0f ? this.m_owner.getLeft() : this.m_owner.getRight();
                this.m_owner.Level().BlocManager().getPointGridLocation(pointxOpposite, pointy, BlocManager.idCol, BlocManager.idLine);
                idCol = BlocManager.idCol.get();
                idLine = BlocManager.idLine.get();
                if (!this.m_owner.Level().BlocManager().isBlocSlotOccupied(idLine - 1, idCol, this.m_owner)) {
                    float newLeft;
                    this.m_owner.x = newLeft = (float)(idCol * GameVars.TileStep());
                    this._setSliding(false);
                }
            }
            this._checkRegisterInBlocManager();
            if (this.m_bSliding) {
                Utility.SssU_overlapWithScale(this.m_owner.Level().Ennemies(), this.m_owner, this, 2, 1.1f);
                Actor ac = this.m_owner.Level().BlocManager().getActorInBlocSlotBelow(this.m_owner);
                if (ac != null) {
                    ac.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_PlayerRun, this.m_owner);
                }
            }
        }
    }

    protected void _updateLifeControl() {
        switch (this.m_lifeControl) {
            case eLifeControl_LetLive: {
                break;
            }
            case eLifeControl_KillingByMelt: {
                this.m_owner.Level().removeActorFromLayer(this.m_owner.Level().LayerPhysics(), this.m_owner, false);
                this.m_lifeControl = eLifeControl.eLifeControl_Killed;
                if (!this.m_bRegisteredForPuzzleModeChange) break;
                this._unregisterPuzzleModeChanged();
                break;
            }
            case eLifeControl_KillingByBurn: {
                this.m_owner.Level().removeActorFromLayer(this.m_owner.Level().LayerPhysics(), this.m_owner, false);
                this.m_lifeControl = eLifeControl.eLifeControl_Killed;
                this._propagateNeighbourKill(this.m_owner.Material() == Actor.eActorMaterial.eActorMaterial_Tnt, Actor.eGenericMessage.eGenericMessage_BurningBlocContact);
                if (!this.m_bRegisteredForPuzzleModeChange) break;
                this.m_owner.Level().BlocSoundManager().triggerBlocSoundEvent(BlocksSoundsManager.eBlocSoundEvent.eBlocSoundEvent_FireEnd, this.m_owner);
                this._unregisterPuzzleModeChanged();
                break;
            }
            case eLifeControl_KillingByEat: {
                this.m_owner.Level().removeActorFromLayer(this.m_owner.Level().LayerPhysics(), this.m_owner, false);
                this.m_lifeControl = eLifeControl.eLifeControl_Killed;
                this._propagateNeighbourKill(false, Actor.eGenericMessage.eGenericMessage_EatingBlocContact);
                if (!this.m_bRegisteredForPuzzleModeChange) break;
                this._unregisterPuzzleModeChanged();
                break;
            }
            case eLifeControl_Killing: {
                this.m_owner.Level().removeActorFromLayer(this.m_owner.Level().LayerPhysics(), this.m_owner, false);
                this.m_lifeControl = eLifeControl.eLifeControl_Killed;
                this._propagateNeighbourKill(this.m_owner.Material() == Actor.eActorMaterial.eActorMaterial_Tnt, Actor.eGenericMessage.eGenericMessage_BurningBlocContact);
                break;
            }
            case eLifeControl_Metlting: {
                this.m_lifeControl = eLifeControl.eLifeControl_KillingByMelt;
                break;
            }
            case eLifeControl_Burning: {
                if (!this.m_owner.finished) break;
                this.m_lifeControl = eLifeControl.eLifeControl_KillingByBurn;
                break;
            }
            case eLifeControl_Eating: {
                this.m_delayBeforeDying -= FlxG.elapsed;
                if (!(this.m_delayBeforeDying <= 0.0f)) break;
                this.m_owner.Level().BlocSoundManager().triggerBlocSoundEvent(BlocksSoundsManager.eBlocSoundEvent.eBlocSoundEvent_BlockBreak, this.m_owner);
                this.m_owner.Level().ParticleManager().emitterTrigger("ChocolateExplode", this.m_owner.getCenterX(), this.m_owner.getCenterY(), Actor.MaterialEnumParticleColorDictionnary.get((Object)this.m_owner.Material()));
                this.m_lifeControl = eLifeControl.eLifeControl_KillingByEat;
            }
        }
    }

    protected void _propagateNeighbourKill(boolean _bAllKernelNeighbour, Actor.eGenericMessage _message) {
        Actor up = null;
        Actor down = null;
        Actor left = null;
        Actor right = null;
        this.m_owner.Level().BlocManager().getNeighbourActors(this.m_owner, BlocManager.up, BlocManager.down, BlocManager.left, BlocManager.right);
        up = BlocManager.up.get();
        down = BlocManager.down.get();
        left = BlocManager.left.get();
        right = BlocManager.right.get();
        this._propagateKill(up, _message);
        this._propagateKill(down, _message);
        this._propagateKill(left, _message);
        this._propagateKill(right, _message);
        if (_bAllKernelNeighbour) {
            this.m_owner.Level().BlocManager().getNeighbourActorsDiagonals(this.m_owner, BlocManager.up, BlocManager.down, BlocManager.left, BlocManager.right);
            up = BlocManager.up.get();
            down = BlocManager.down.get();
            left = BlocManager.left.get();
            right = BlocManager.right.get();
            this._propagateKill(up, _message);
            this._propagateKill(down, _message);
            this._propagateKill(left, _message);
            this._propagateKill(right, _message);
        }
    }

    protected void _propagateKill(Actor _targetActor, Actor.eGenericMessage _message) {
        if (_targetActor != null && !Actor.IsConsirededAsGround(_targetActor.Material())) {
            _targetActor.handleGenericMessage(_message, this.m_owner);
        }
    }

    protected boolean isCharacter(Actor _actor) {
        return _actor.Material() == Actor.eActorMaterial.eActorMaterial_Player || _actor.Material() == Actor.eActorMaterial.eActorMaterial_Ennemy;
    }

    protected boolean _isBurnable() {
        return this.m_owner.Material() == Actor.eActorMaterial.eActorMaterial_Wood;
    }

    protected boolean _isEatable() {
        return this.m_owner.Material() == Actor.eActorMaterial.eActorMaterial_BlackChocolate || this.m_owner.Material() == Actor.eActorMaterial.eActorMaterial_BrownChocolate || this.m_owner.Material() == Actor.eActorMaterial.eActorMaterial_WhiteChocolate || this.m_owner.Material() == Actor.eActorMaterial.eActorMaterial_PinkChocolate;
    }

    protected boolean _isMeltable() {
        return this.m_owner.Material() == Actor.eActorMaterial.eActorMaterial_Ice;
    }

    protected void _handleFallingCollision(Actor _other) {
        if (!_other.Dying() && _other.getTop() > this.m_owner.getCenterY()) {
            float maxDistMargin;
            float dist = _other.getCenterX() - this.m_owner.getCenterX();
            if (dist < 0.0f) {
                dist *= -1.0f;
            }
            if (dist < (maxDistMargin = (this.m_owner.width * 0.5f + _other.width * 0.5f) * 0.9f)) {
                if (_other.Material() != Actor.eActorMaterial.eActorMaterial_Ennemy) {
                    this.m_bAlignedGridOverlap = false;
                    this.m_owner.y = _other.y - this.m_owner.height;
                    this._setFalling(false);
                } else {
                    _other.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_BlocCrush, this.m_owner);
                }
            }
        }
    }

    protected void _registerPuzzleModeChanged() {
        if (!this.m_bRegisteredForPuzzleModeChange) {
            this.m_owner.Level().addPuzzleModeChangedListener(this.m_owner);
            this.m_bRegisteredForPuzzleModeChange = true;
        }
    }

    protected void _unregisterPuzzleModeChanged() {
        if (this.m_bRegisteredForPuzzleModeChange) {
            this.m_owner.Level().removePuzzleModeChangedListener(this.m_owner);
            this.m_bRegisteredForPuzzleModeChange = false;
        }
    }

    @Override
    public void checkCollisions() {
    }

    @Override
    public void onOverlapsCallback(FlxSpriteCollisionEvent _event, int _callbackId) {
        switch (_callbackId) {
            case 0: {
                this._handleFallingCollision((Actor)_event.Object1());
                break;
            }
            case 1: {
                Actor act = (Actor)_event.Object1();
                if (!this.isCharacter(act)) break;
                this._handleFallingCollision(act);
                break;
            }
            case 2: {
                Actor act = (Actor)_event.Object1();
                act.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_BlocCrush, this.m_owner);
            }
        }
    }

    @Override
    public void handleGenericMessage(Actor.eGenericMessage _message, Actor _sender) {
        switch (_message) {
            case eGenericMessage_ActorInitDefaultColor: {
                if (this.Material() == Actor.eActorMaterial.eActorMaterial_Paint) {
                    this._changeColorBasedOnProperties();
                    break;
                }
                this.m_owner.color(Color.White());
                break;
            }
            case eGenericMessage_PuzzleModeEnter: {
                if (this.m_lifeControl == eLifeControl.eLifeControl_Burning) {
                    this.m_owner.play("burnFiged");
                    break;
                }
                if (this.m_bExploding) {
                    this.m_owner.CurAnim().changeDelay(0.0f);
                    break;
                }
                if (!this.m_bFalling && !this.m_bSliding && !this.m_bCanFall && !this.m_bCanSlide) break;
                this._repositionnateFallingOrSlidingOnGrid();
                break;
            }
            case eGenericMessage_PuzzleModeLeave: {
                if (this.m_lifeControl == eLifeControl.eLifeControl_Burning) {
                    this.m_owner.play("burn");
                    break;
                }
                if (!this.m_bExploding) break;
                this.m_owner.CurAnim().restaureOriginalDelay();
                break;
            }
            case eGenericMessage_PuzzleModeExplode: {
                this._destroy();
                break;
            }
            case eGenericMessage_Kaboom: {
                this._onKaboom();
                break;
            }
            case eGenericMessage_BigSlimeDestroy: {
                this.m_owner.Dying(true);
                if (this.m_owner.Material() == Actor.eActorMaterial.eActorMaterial_UnbreakableAutoAnim) {
                    this.m_owner.Level().BlocManager().diffuseRecomputeAutoAnimFlag(this.m_owner);
                }
                if (!this.m_bDestroyed) {
                    this.m_owner.Level().BlocSoundManager().triggerBlocSoundEvent(BlocksSoundsManager.eBlocSoundEvent.eBlocSoundEvent_BigMamaDestroyBloc, this.m_owner);
                }
                this._destroy();
                break;
            }
            case eGenericMessage_PlayerRun: {
                if (this.m_owner.Material() != Actor.eActorMaterial.eActorMaterial_Clay || !this.m_bAlignedGridOverlap || this.m_owner.Level().BlocManager().isBlocSlotBelowOccupied(this.m_owner)) break;
                this._setCanFall(true);
                break;
            }
            case eGenericMessage_TntBlow: {
                if (this.m_owner.Material() == Actor.eActorMaterial.eActorMaterial_Tnt) {
                    this.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_Drill, _sender);
                    break;
                }
                if (this._isBurnable()) {
                    this._propagateNeighbourKill(true, Actor.eGenericMessage.eGenericMessage_BurningBlocContact);
                    if (this.m_bRegisteredForPuzzleModeChange) {
                        this.m_owner.Level().BlocSoundManager().triggerBlocSoundEvent(BlocksSoundsManager.eBlocSoundEvent.eBlocSoundEvent_FireEnd, this.m_owner);
                        this._unregisterPuzzleModeChanged();
                    }
                }
                this.m_owner.Dying(true);
                this._destroy();
                break;
            }
            case eGenericMessage_DrillFake: {
                this._handleDrillMessage(true);
                break;
            }
            case eGenericMessage_DoorObstructed: {
                if (this.m_bObstructShake) break;
                this.m_bObstructShake = true;
                break;
            }
            case eGenericMessage_Drill: {
                if (!this.m_bCanSlide && Actor.CanBeDrilled(this.Material())) {
                    if (this.Material() == Actor.eActorMaterial.eActorMaterial_Paint) {
                        if (this.getIntParameter("drillable") == 0) {
                            _sender.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_BlocRepulsion, this.m_owner);
                        } else {
                            this._handleDrillMessage(false);
                        }
                    } else {
                        this._handleDrillMessage(false);
                    }
                } else if (Actor.CanExplodeMaterial(this.m_owner.Material())) {
                    this._handleDrillMessage(false);
                    _sender.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_BlocRepulsion, this.m_owner);
                } else if (!this.m_bCanSlide) {
                    _sender.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_BlocRepulsion, this.m_owner);
                }
                if (!this.m_bCanSlide) break;
                this._handleDrillMessage(true);
                float perc = this.m_elapsedDrillTime / this.m_drillTime;
                if (!(perc > 0.0f)) break;
                _sender.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_BlocRepulsionForced, this.m_owner);
                this.m_owner.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_PushToSlide, this.m_owner);
                break;
            }
            case eGenericMessage_PlayerHitByJump: {
                if (this.m_owner.Material() == Actor.eActorMaterial.eActorMaterial_Ice || this.m_owner.Material() == Actor.eActorMaterial.eActorMaterial_PinkChocolate) {
                    this._launchShake();
                } else if (this._canBeCollected() && !this.m_owner.Dying()) {
                    this._launchShake();
                    this.m_bDrilledFake = false;
                    this._updateDrill(this.m_drillTime * 0.75f, true, false);
                } else if (Actor.CanExplodeMaterial(this.m_owner.Material())) {
                    this.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_DrillFake, _sender);
                    this._launchShake();
                } else if (!Actor.IsConsirededAsGround(this.m_owner.Material())) {
                    this._launchShake();
                }
                _sender.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_BlocStopJump, this.m_owner);
                break;
            }
            case eGenericMessage_SlimeDropContact: {
                if (this._isBurnable()) {
                    this._launchBurn();
                    break;
                }
                if (this._isMeltable()) {
                    this._launchMelt();
                    break;
                }
                if (this.m_owner.Material() != Actor.eActorMaterial.eActorMaterial_Tnt) break;
                this.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_Drill, _sender);
                break;
            }
            case eGenericMessage_EatingBlocContact: {
                if (!this._isEatable()) break;
                this._launchEat(_sender);
                break;
            }
            case eGenericMessage_BurningBlocContact: {
                if (this._isBurnable()) {
                    this._launchBurn();
                    break;
                }
                if (this._isMeltable()) {
                    this._launchMelt();
                    break;
                }
                if (this.m_owner.Material() == Actor.eActorMaterial.eActorMaterial_Tnt) {
                    this.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_Drill, _sender);
                    break;
                }
                if (this.m_owner.Material() != Actor.eActorMaterial.eActorMaterial_Clay || !Utility.IsHorizontallyNearby(this.m_owner.getCenterX(), this.m_owner.width, _sender.getCenterX(), _sender.width, 0.9f)) break;
                this.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_PlayerRun, _sender);
                break;
            }
            case eGenericMessage_EnnemyWalkContact: {
                if (this.m_owner.Material() != Actor.eActorMaterial.eActorMaterial_Clay || !Utility.IsHorizontallyNearby(this.m_owner.getCenterX(), this.m_owner.width, _sender.getCenterX(), _sender.width, 0.9f)) break;
                this.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_PlayerRun, _sender);
                break;
            }
            case eGenericMessage_PushToSlide: {
                if (this.m_bFalling || this.m_lifeControl != eLifeControl.eLifeControl_LetLive) break;
                this._setSliding(true);
            }
        }
    }

    protected void _launchMelt() {
        if (this.m_lifeControl == eLifeControl.eLifeControl_LetLive) {
            this.m_lifeControl = eLifeControl.eLifeControl_Metlting;
            if (!this.m_bRegisteredForPuzzleModeChange) {
                this._registerPuzzleModeChanged();
            }
            if (this.Material() == Actor.eActorMaterial.eActorMaterial_Ice) {
                this.m_owner.Level().ParticleManager().emitterTrigger("IceExplode", this.m_owner.getCenterX(), this.m_owner.getCenterY());
            }
        }
    }

    protected void _launchEat(Actor _eater) {
        if (this.m_lifeControl == eLifeControl.eLifeControl_LetLive && _eater != null) {
            boolean canBeEaten = false;
            Actor.eActorMaterial material = this.m_owner.Material();
            Actor.eActorMaterial otherMaterial = _eater.Material();
            if (otherMaterial == Actor.eActorMaterial.eActorMaterial_Ennemy) {
                EnnemyBehaviour.eConsistance consistance;
                EnnemyBehaviour ennemyBehaviour = (EnnemyBehaviour)_eater.getBehaviour(0);
                if (ennemyBehaviour != null && ((consistance = ennemyBehaviour.getConsistance()) == EnnemyBehaviour.eConsistance.eConsistance_black && material == Actor.eActorMaterial.eActorMaterial_BlackChocolate || consistance == EnnemyBehaviour.eConsistance.eConsistance_brown && material == Actor.eActorMaterial.eActorMaterial_BrownChocolate || consistance == EnnemyBehaviour.eConsistance.eConsistance_white && material == Actor.eActorMaterial.eActorMaterial_WhiteChocolate || consistance == EnnemyBehaviour.eConsistance.eConsistance_pink && material == Actor.eActorMaterial.eActorMaterial_PinkChocolate)) {
                    canBeEaten = true;
                }
            } else if (otherMaterial == material) {
                canBeEaten = true;
            }
            if (canBeEaten) {
                this.m_lifeControl = eLifeControl.eLifeControl_Eating;
                if (!this.m_bRegisteredForPuzzleModeChange) {
                    this._registerPuzzleModeChanged();
                }
            }
        }
    }

    protected void _launchBurn() {
        if (this.m_lifeControl == eLifeControl.eLifeControl_LetLive) {
            this.m_lifeControl = eLifeControl.eLifeControl_Burning;
            this.m_owner.play("burn");
            if (!this.m_bRegisteredForPuzzleModeChange) {
                this._registerPuzzleModeChanged();
                this.m_owner.Level().BlocSoundManager().triggerBlocSoundEvent(BlocksSoundsManager.eBlocSoundEvent.eBlocSoundEvent_FireBegin, this.m_owner);
            }
            AchievementManager.Instance().incrementRaster("RAS_BURNED_BLOCKS", 1);
        }
    }

    protected void _launchShake() {
        if (!this.m_bJumpShake) {
            this.m_bJumpShake = true;
            this.m_elapsedJumpShakeTime = 0.0f;
        }
    }

    protected void _handleDrillMessage(boolean _bFakeDrill) {
        if (this.m_owner.Material() == Actor.eActorMaterial.eActorMaterial_Tnt) {
            this._setExploding(true);
        }
        this.m_bDrilled = true;
        this.m_bDrilledFake = _bFakeDrill;
    }

    protected void _checkPassiveFlag() {
        if (this.Material() == Actor.eActorMaterial.eActorMaterial_UnbreakableAutoAnim && this.getStringParameter("animId").equals("24")) {
            this.m_owner.addFlag(Actor.eSpecialFlag.eSpecialFlag_PassiveIso);
        }
    }

    @Override
    public void onLoadParamOverrideDone() {
        this._checkPassiveFlag();
    }

    @Override
    public void onParamsChanged() {
        if (this.Material() == Actor.eActorMaterial.eActorMaterial_Paint) {
            this._changeColorBasedOnProperties();
        }
    }

    @Override
    public void render(SpriteBatch spriteBatch) {
        if (!this.m_bDrilledFake && this.m_elapsedDrillTime > 0.0f) {
            BlocBehaviour.m_BreakAnim.x = this.m_owner.x;
            BlocBehaviour.m_BreakAnim.y = this.m_owner.y;
            float perc = this.m_elapsedDrillTime / this.m_drillTime;
            if (perc > 0.0f && perc < 0.5f) {
                m_BreakAnim.play("little");
            } else if (perc > 1.0f) {
                if (this.m_bDrilledFake) {
                    m_BreakAnim.play("little");
                } else {
                    m_BreakAnim.play("full");
                }
            } else if (this.m_bDrilledFake) {
                m_BreakAnim.play("little");
            } else {
                m_BreakAnim.play("avg");
            }
            m_BreakAnim.scaleX(this.m_owner.scaleX());
            m_BreakAnim.scaleY(this.m_owner.scaleY());
            m_BreakAnim.render(spriteBatch);
        }
    }

    protected void _chestDrilled() {
        if (GameVars.GameCommunityMode()) {
            this.m_owner.Level().ParticleManager().startFlyingMaterialEmitter(this, this.getIntParameter("limitContent") > 0);
        } else {
            this.m_owner.Level().ParticleManager().startFlyingMaterialEmitter(this, true);
        }
        this._destroy();
    }

    static enum eLifeControl {
        eLifeControl_LetLive,
        eLifeControl_Burning,
        eLifeControl_Metlting,
        eLifeControl_Killing,
        eLifeControl_KillingByBurn,
        eLifeControl_KillingByMelt,
        eLifeControl_Killed,
        eLifeControl_Eating,
        eLifeControl_KillingByEat;

    }
}

