/*
 * Decompiled with CFR 0.152.
 */
package SSS.Behaviours.BTM;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Graphics.SpriteBatch;
import SSS.Actor;
import SSS.Behaviour;
import SSS.Behaviours.BTM.DoorBehaviour;
import SSS.Level;
import SSS.Managers.BTM.BlocManager;
import org.flixel.FlxG;
import org.flixel.FlxSprite;
import org.flixel.event.FlxSpriteCollisionEvent;

public class BlocSwitchBehaviour
extends Behaviour {
    protected eSwitchState m_state = eSwitchState.eSwitchState_Off;
    static float WantedMaterialAlpha = 0.8f;
    static final String BlocActorSuffix = "Bloc";
    Actor m_wantedMaterial = null;
    boolean m_bGhost = false;
    float m_alpha = 1.0f;
    FlxSprite m_hud = null;
    int m_lineCheckId;
    int m_colCheckId;
    int m_dirx = 0;
    int m_diry = 0;
    float m_timeElapsed = 0.0f;
    int m_numBlinkWarm = 0;
    boolean m_bActivated = false;
    String m_targetDoorId = null;
    boolean m_bRegisteredInBlocManager = false;

    public String TargetDoorId() {
        return this.m_targetDoorId;
    }

    public BlocSwitchBehaviour(String _id, Actor _owner, Actor.eActorMaterial _material) {
        super(_id, _owner, _material);
    }

    @Override
    protected void initOwnerFlixelProperties() {
        this.m_owner.fixed = true;
        this.m_owner.moves = true;
    }

    @Override
    public void init() {
        this._initParameters();
        if (!this.m_bGhost) {
            this._registerRendererBehaviour();
            this._registerInBlocManager();
        }
        if (this.m_owner.Level().PlayableMode()) {
            this.m_owner.Level().SwitchObserver().addSwitch(this);
            this.m_owner.Level().BlocManager().getActorGridLocation(this.m_owner, BlocManager.m_colCheckId, BlocManager.m_lineCheckId);
            this.m_colCheckId = BlocManager.m_colCheckId.get();
            this.m_lineCheckId = BlocManager.m_lineCheckId.get();
            this.m_lineCheckId += this.m_diry;
            this.m_colCheckId += this.m_dirx;
            if (this.m_bGhost) {
                this.m_owner.alpha(this.m_alpha);
            }
        }
    }

    protected void _initParameters() {
        boolean bl = this.m_bGhost = this.getIntParameter("type") == 1;
        if (!this.m_bGhost) {
            this.m_hud = this.m_owner.Level().instanciateSprite("switchHudSprite");
            this.m_hud.x = this.m_owner.x + this.m_owner.width * 0.5f - this.m_hud.width * 0.5f;
            this.m_hud.y = this.m_owner.y + this.m_owner.height * 0.5f - this.m_hud.height * 0.5f;
            this.m_hud.color(Color.Red());
        } else {
            this.m_alpha = this.getFloatParameter("visibility");
        }
        this._initDir();
        this.m_targetDoorId = this.getStringParameter("targetDoorId");
        String mat = this.getStringParameter("materialIdWaited");
        boolean anyMat = mat.equals("any");
        if (anyMat) {
            mat = "threshold";
        }
        this.m_wantedMaterial = this.m_bGhost && anyMat ? null : this.m_owner.Level().instanciateActor(String.valueOf(mat) + BlocActorSuffix);
        if (this.m_wantedMaterial != null) {
            this.m_wantedMaterial.AlwaysVisible(true);
            this.m_wantedMaterial.reinitValueBBoxTweakRelated();
            this.m_wantedMaterial.x = this.m_owner.x + this.m_owner.width * 0.5f - this.m_wantedMaterial.width * 0.5f;
            this.m_wantedMaterial.y = this.m_owner.y + this.m_owner.height * 0.5f - this.m_wantedMaterial.height * 0.5f;
            this.m_wantedMaterial.scale(0.45f);
            this.m_wantedMaterial.alpha(WantedMaterialAlpha);
            this.m_wantedMaterial.x += 10.0f;
            this.m_wantedMaterial.y += 9.0f;
        }
    }

    protected void _initDir() {
        if (!this.m_bGhost) {
            int sense = this.getIntParameter("senseRLTB");
            switch (sense) {
                case 0: {
                    this.m_dirx = 1;
                    this.m_diry = 0;
                    this.m_hud.play("R");
                    break;
                }
                case 1: {
                    this.m_dirx = -1;
                    this.m_diry = 0;
                    this.m_hud.play("L");
                    break;
                }
                case 2: {
                    this.m_dirx = 0;
                    this.m_diry = 1;
                    this.m_hud.play("T");
                    break;
                }
                case 3: {
                    this.m_dirx = 0;
                    this.m_diry = -1;
                    this.m_hud.play("B");
                    break;
                }
                default: {
                    this.m_dirx = 0;
                    this.m_diry = 1;
                    this.m_hud.play("T");
                    break;
                }
            }
        } else {
            this.m_dirx = 0;
            this.m_dirx = 0;
        }
    }

    @Override
    public void deinit() {
    }

    @Override
    public void update() {
        if (this.m_owner.Level().PlayableMode()) {
            switch (this.m_state) {
                case eSwitchState_Off: {
                    Actor act = this.getActorOnSwitch();
                    if (act == null || this.m_wantedMaterial != null && act.Material() != this.m_wantedMaterial.Material() || act.Dying()) break;
                    if (this.m_owner.Level().PuzzleMode()) {
                        this._goTo(eSwitchState.eSwitchState_WarmPuzzleOn);
                        break;
                    }
                    this._goTo(eSwitchState.eSwitchState_WarmOn);
                    break;
                }
                case eSwitchState_On: {
                    Actor act = this.getActorOnSwitch();
                    if (act != null && !act.Dying()) break;
                    if (this.m_owner.Level().PuzzleMode()) {
                        this._goTo(eSwitchState.eSwitchState_WarmPuzzleOff);
                        break;
                    }
                    this._goTo(eSwitchState.eSwitchState_WarmOff);
                    break;
                }
                case eSwitchState_WarmOff: {
                    if (this.m_owner.Level().PuzzleMode()) {
                        this._goTo(eSwitchState.eSwitchState_WarmPuzzleOff);
                        break;
                    }
                    if (!this._blinkHudColor(DoorBehaviour.BlinkTickWarm)) break;
                    ++this.m_numBlinkWarm;
                    if (this.m_numBlinkWarm <= DoorBehaviour.NumBlinkWarmMax) break;
                    this._goTo(eSwitchState.eSwitchState_Off);
                    break;
                }
                case eSwitchState_WarmOn: {
                    if (this.m_owner.Level().PuzzleMode()) {
                        this._goTo(eSwitchState.eSwitchState_WarmPuzzleOn);
                        break;
                    }
                    if (!this._blinkHudColor(DoorBehaviour.BlinkTickWarm)) break;
                    ++this.m_numBlinkWarm;
                    if (this.m_numBlinkWarm <= DoorBehaviour.NumBlinkWarmMax) break;
                    this._goTo(eSwitchState.eSwitchState_On);
                    break;
                }
                case eSwitchState_WarmPuzzleOff: {
                    if (this.m_owner.Level().PuzzleMode()) {
                        this._blinkHudColor(DoorBehaviour.BlinkTickWarmPuzzle);
                        break;
                    }
                    this._goTo(eSwitchState.eSwitchState_WarmOff);
                    break;
                }
                case eSwitchState_WarmPuzzleOn: {
                    if (this.m_owner.Level().PuzzleMode()) {
                        Actor act = this.getActorOnSwitch();
                        if (act == null || act.Dying()) {
                            this._goTo(eSwitchState.eSwitchState_Off);
                            break;
                        }
                        this._blinkHudColor(DoorBehaviour.BlinkTickWarmPuzzle);
                        break;
                    }
                    this._goTo(eSwitchState.eSwitchState_WarmOn);
                }
            }
        }
    }

    protected Actor getActorOnSwitch() {
        if (this.m_bGhost && this.m_wantedMaterial == null) {
            return this.m_owner.Level().BlocManager().getActorInBlocSlot(this.m_lineCheckId, this.m_colCheckId, true);
        }
        if (this.m_wantedMaterial.Material() == Actor.eActorMaterial.eActorMaterial_Door) {
            return this.m_owner.Level().BlocManager().getActorInBlocSlot(this.m_lineCheckId, this.m_colCheckId, false);
        }
        return this.m_owner.Level().BlocManager().getActorInBlocSlot(this.m_lineCheckId, this.m_colCheckId, true);
    }

    protected boolean _blinkHudColor(float _maxTime) {
        this.m_timeElapsed += FlxG.elapsed;
        if (this.m_timeElapsed > _maxTime) {
            this.m_timeElapsed = 0.0f;
            if (!this.m_bGhost) {
                if (this.m_hud.color().R > 0) {
                    this.m_hud.color(Color.Green());
                } else {
                    this.m_hud.color(Color.Red());
                }
            }
            return true;
        }
        return false;
    }

    protected void _activate(boolean _value) {
        if (this.m_bActivated != _value) {
            this.m_bActivated = _value;
            if (_value) {
                this.m_owner.Level().SwitchObserver().propagateMessageToDoor(this.m_owner, this.m_targetDoorId, Actor.eGenericMessage.eGenericMessage_SwitchActivated);
            } else {
                this.m_owner.Level().SwitchObserver().propagateMessageToDoor(this.m_owner, this.m_targetDoorId, Actor.eGenericMessage.eGenericMessage_SwitchDeactivated);
            }
        }
    }

    protected void _goTo(eSwitchState _state) {
        this.m_timeElapsed = 0.0f;
        this.m_numBlinkWarm = 0;
        switch (_state) {
            case eSwitchState_Off: {
                if (!this.m_bGhost) {
                    this.m_hud.color(Color.Red());
                }
                this.m_state = eSwitchState.eSwitchState_Off;
                this._activate(false);
                break;
            }
            case eSwitchState_On: {
                if (!this.m_bGhost) {
                    this.m_hud.color(Color.Green());
                }
                this.m_state = eSwitchState.eSwitchState_On;
                this._activate(true);
                break;
            }
            case eSwitchState_WarmOff: {
                this.m_state = eSwitchState.eSwitchState_WarmOff;
                this._activate(false);
                break;
            }
            case eSwitchState_WarmOn: {
                this.m_state = eSwitchState.eSwitchState_WarmOn;
                this._activate(true);
                break;
            }
            case eSwitchState_WarmPuzzleOff: {
                this.m_state = eSwitchState.eSwitchState_WarmPuzzleOff;
                this._activate(false);
                break;
            }
            case eSwitchState_WarmPuzzleOn: {
                this.m_state = eSwitchState.eSwitchState_WarmPuzzleOn;
                this._activate(true);
            }
        }
    }

    @Override
    public void checkCollisions() {
    }

    @Override
    public void onOverlapsCallback(FlxSpriteCollisionEvent _event, int _callbackId) {
    }

    @Override
    public void onParamsChanged() {
        this._initParameters();
    }

    @Override
    public void handleGenericMessage(Actor.eGenericMessage _message, Actor _sender) {
        switch (_message) {
            case eGenericMessage_PlayerHitByJump: {
                _sender.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_BlocStopJump, this.m_owner);
                break;
            }
            case eGenericMessage_Drill: {
                _sender.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_BlocRepulsion, this.m_owner);
            }
        }
    }

    protected void _destroy() {
        this._unregisterInBlocManager();
    }

    protected void _registerInBlocManager() {
        if (this.m_owner.Level().Mode() == Level.eLevelMode.eLevelMode_Play || this.m_owner.Level().Mode() == Level.eLevelMode.eLevelMode_Test) {
            this.m_bRegisteredInBlocManager = true;
            this.m_owner.Level().BlocManager().registerUnremovableBloc(this.m_owner);
        }
    }

    protected void _unregisterInBlocManager() {
        if (this.m_bRegisteredInBlocManager) {
            this.m_owner.Level().BlocManager().unregisterUnremovableBloc(this.m_owner);
        }
    }

    @Override
    public void render(SpriteBatch spriteBatch) {
        this.m_hud.render(spriteBatch);
        this.m_wantedMaterial.render(spriteBatch);
    }

    public static enum eSwitchState {
        eSwitchState_Off,
        eSwitchState_On,
        eSwitchState_WarmOff,
        eSwitchState_WarmOn,
        eSwitchState_WarmPuzzleOff,
        eSwitchState_WarmPuzzleOn;

    }
}

