/*
 * Decompiled with CFR 0.152.
 */
package SSS.Behaviours.BTM;

import Microsoft.Xna.Framework.Graphics.SpriteBatch;
import SSS.Actor;
import SSS.Behaviour;
import SSS.Behaviours.BTM.PlayerBehaviour;
import SSS.Level;
import SSS.Managers.BTM.BlocManager;
import SSS.Util.Utility;
import org.flixel.FlxG;
import org.flixel.FlxSound;
import org.flixel.FlxSprite;
import org.flixel.event.FlxSpriteCollisionEvent;

public class DoorBehaviour
extends Behaviour {
    protected eDoorState m_state = eDoorState.eSwitchState_Open;
    static final String BlocActorSuffix = "Bloc";
    String m_idDoor = null;
    boolean m_bBlocked = false;
    float m_elapsed = 0.0f;
    float m_delay = 1.0f;
    int m_baseIdLine = -1;
    int m_baseIdCol = -1;
    int m_lineSpawnStart = -1;
    int m_colSpawnStart = -1;
    int m_lineSpawnEnd = -1;
    int m_colSpawnEnd = -1;
    int m_switchActivated = 0;
    int m_waitingSwitchNum = 0;
    boolean m_bIsDoorBase = false;
    boolean m_bDefaultClosed = true;
    int m_dirx = 0;
    int m_diry = 0;
    boolean m_bRegisteredInBlocManager = false;
    Actor[] m_spawnedBlocs = null;
    FlxSprite m_hud = null;
    FlxSound m_sndOpen = null;
    FlxSound m_sndLockUnlock = null;
    boolean m_bOpenAnim = true;
    float m_elapsedBlinkTime = 0.0f;
    int m_numBlinkWarm = 0;
    public static float BlinkTickWarmPuzzle = 1.0f;
    public static float BlinkTickWarm = 0.15f;
    public static int NumBlinkWarmMax = 4;
    int m_blocToTreat = 0;

    public eDoorState State() {
        return this.m_state;
    }

    public String DoorId() {
        return this.m_idDoor;
    }

    public DoorBehaviour(String _id, Actor _owner, Actor.eActorMaterial _material) {
        super(_id, _owner, _material);
    }

    @Override
    protected void initOwnerFlixelProperties() {
        this.m_owner.fixed = true;
        this.m_owner.moves = true;
    }

    @Override
    public void init() {
        if (this.m_owner.Level().PlayableMode()) {
            this._initParameters();
            if (this.m_bIsDoorBase) {
                this._registerInBlocManager();
                this.m_owner.Level().addDoor(this);
            } else {
                this.m_owner.Level().addActorToLayer(this.m_owner.Level().LayerIso(), this.m_owner);
                this.m_owner.visible = false;
            }
        }
    }

    protected void _initBaseDoor() {
        this._computeBedEndLiCoIds();
        this._allocateDoorBlocPool();
        this._registerRendererBehaviour();
        this.m_hud = this.m_owner.Level().instanciateSprite("doorHudSprite");
        this.m_hud.play("open");
        this.m_bOpenAnim = true;
        this.m_hud.x = this.m_owner.x + this.m_owner.width * 0.5f - this.m_hud.width * 0.5f;
        this.m_hud.y = this.m_owner.y + this.m_owner.height * 0.5f - this.m_hud.height * 0.5f;
        if (this.m_bDefaultClosed) {
            this._spawnBlocksUpdate(true, true);
            if (this.m_bBlocked) {
                this._goToState(eDoorState.eSwitchState_Closing);
            } else {
                this._goToState(eDoorState.eSwitchState_Close);
            }
        } else {
            this._goToState(eDoorState.eSwitchState_Open);
        }
    }

    protected void _hudAnim(boolean _openAnim) {
        if (this.m_bOpenAnim && !_openAnim) {
            this.m_hud.play("close");
            this.m_bOpenAnim = false;
        } else if (!this.m_bOpenAnim && _openAnim) {
            this.m_hud.play("open");
            this.m_bOpenAnim = true;
        }
    }

    protected void _allocateDoorBlocPool() {
        int poolSize = 1;
        poolSize += this.m_lineSpawnStart > this.m_lineSpawnEnd ? this.m_lineSpawnStart - this.m_lineSpawnEnd : this.m_lineSpawnEnd - this.m_lineSpawnStart;
        this.m_spawnedBlocs = new Actor[poolSize += this.m_colSpawnStart > this.m_colSpawnEnd ? this.m_colSpawnStart - this.m_colSpawnEnd : this.m_colSpawnEnd - this.m_colSpawnStart];
        int li = this.m_lineSpawnStart;
        int co = this.m_colSpawnStart;
        int i = 0;
        while (i < poolSize) {
            Actor act = this.m_owner.Level().instanciateActor("doorBloc");
            act.createComponents(this.m_owner.Level(), false);
            this.m_owner.Level().BlocManager().positionateActorOnGrid(act, li, co);
            this.m_spawnedBlocs[i] = act;
            li += this.m_diry;
            co += this.m_dirx;
            ++i;
        }
    }

    protected boolean _spawnBlocksUpdate(boolean _bInstant, boolean _bShow) {
        if (_bInstant) {
            if (_bShow) {
                int i = 0;
                while (!this.m_bBlocked && i < this.m_spawnedBlocs.length) {
                    this._threatDoolBloc(_bShow, false);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.m_spawnedBlocs.length) {
                    this.m_spawnedBlocs[i].handleGenericMessage(Actor.eGenericMessage.eGenericMessage_DoorBlocHide, this.m_owner);
                    ++i;
                }
            }
            return true;
        }
        this.m_elapsed += FlxG.elapsed;
        if (this.m_elapsed > this.m_delay || this.m_bBlocked) {
            this.m_elapsed = 0.0f;
            return this._threatDoolBloc(_bShow, true);
        }
        return false;
    }

    protected boolean _threatDoolBloc(boolean _bShow, boolean _playSounds) {
        boolean bRes = false;
        if (this.m_blocToTreat >= 0 && this.m_blocToTreat < this.m_spawnedBlocs.length) {
            if (_bShow) {
                int idLi = this.m_baseIdLine + (this.m_blocToTreat + 1) * this.m_diry;
                int idCo = this.m_baseIdCol + (this.m_blocToTreat + 1) * this.m_dirx;
                Actor act = this.m_owner.Level().BlocManager().getActorInBlocSlot(idLi, idCo, false);
                if (act == null) {
                    this.m_bBlocked = false;
                    this.m_spawnedBlocs[this.m_blocToTreat].handleGenericMessage(Actor.eGenericMessage.eGenericMessage_DoorBlocShow, this.m_owner);
                    if (_playSounds) {
                        this.m_sndOpen.play();
                    }
                    ++this.m_blocToTreat;
                    if (this.m_blocToTreat >= this.m_spawnedBlocs.length) {
                        this.m_blocToTreat = this.m_spawnedBlocs.length - 1;
                        bRes = true;
                    }
                } else {
                    this.m_bBlocked = true;
                    act.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_DoorObstructed, this.m_owner);
                }
            } else {
                this.m_spawnedBlocs[this.m_blocToTreat].handleGenericMessage(Actor.eGenericMessage.eGenericMessage_DoorBlocHide, this.m_owner);
                if (_playSounds) {
                    this.m_sndOpen.play();
                }
                this.m_bBlocked = false;
                --this.m_blocToTreat;
                if (this.m_blocToTreat < 0) {
                    this.m_blocToTreat = 0;
                    bRes = true;
                }
            }
        }
        return bRes;
    }

    protected void _computeBedEndLiCoIds() {
        int minIdCol = this.m_owner.Level().BlocManager().MinValidColId();
        int minIdLine = this.m_owner.Level().BlocManager().MinValidLineId();
        int maxIdCol = this.m_owner.Level().BlocManager().MaxValidColId();
        int maxIdLine = this.m_owner.Level().BlocManager().MaxValidLineId();
        this.m_owner.Level().BlocManager().getActorGridLocation(this.m_owner, BlocManager.baseIdCol, BlocManager.baseIdLine);
        int baseIdLine = BlocManager.baseIdLine.get();
        int baseIdCol = BlocManager.baseIdCol.get();
        this.m_baseIdLine = baseIdLine;
        this.m_baseIdCol = baseIdCol;
        this.m_lineSpawnStart = baseIdLine + this.m_diry;
        this.m_colSpawnStart = baseIdCol + this.m_dirx;
        this.m_lineSpawnEnd = this.m_lineSpawnStart;
        this.m_colSpawnEnd = this.m_colSpawnStart;
        boolean boundFound = false;
        int li = baseIdLine;
        int co = baseIdCol;
        Actor act = null;
        while (!boundFound) {
            if ((co += this.m_dirx) >= minIdCol && co <= maxIdCol && (li += this.m_diry) >= minIdLine && li <= maxIdLine) {
                act = this.m_owner.Level().BlocManager().getGroundActorInBlocSlot(li, co);
                if (act == null) {
                    this.m_lineSpawnEnd = li;
                    this.m_colSpawnEnd = co;
                    continue;
                }
                boundFound = true;
                continue;
            }
            boundFound = true;
        }
    }

    protected void _initParameters() {
        boolean bl = this.m_bIsDoorBase = this.getIntParameter("isDoorBase") > 0;
        if (this.m_bIsDoorBase) {
            this.m_delay = this.getFloatParameter("delay");
            this.m_idDoor = this.getStringParameter("doorId");
            int sense = this.getIntParameter("senseRLTB");
            switch (sense) {
                case 0: {
                    this.m_dirx = 1;
                    this.m_diry = 0;
                    break;
                }
                case 1: {
                    this.m_dirx = -1;
                    this.m_diry = 0;
                    break;
                }
                case 2: {
                    this.m_dirx = 0;
                    this.m_diry = 1;
                    break;
                }
                case 3: {
                    this.m_dirx = 0;
                    this.m_diry = -1;
                    break;
                }
                default: {
                    this.m_dirx = 1;
                    this.m_diry = 0;
                }
            }
            this.m_bDefaultClosed = this.getIntParameter("beginClosed") > 0;
            this.m_sndOpen = new FlxSound();
            this.m_sndOpen.loadEmbedded(this.getStringParameter("SndOpen"), false, true, true);
            this.m_sndLockUnlock = new FlxSound();
            this.m_sndLockUnlock.loadEmbedded(this.getStringParameter("SndLockUnlock"), false, true, true);
        }
    }

    @Override
    public void deinit() {
        if (this.m_sndOpen != null) {
            this.m_sndOpen.destroy();
            this.m_sndOpen = null;
        }
    }

    protected boolean _canOpen() {
        if (this.m_bDefaultClosed) {
            return this.m_switchActivated >= this.m_waitingSwitchNum;
        }
        return this.m_switchActivated < this.m_waitingSwitchNum;
    }

    @Override
    public void update() {
        if (this.m_bIsDoorBase && this.m_owner.Level().PlayableMode()) {
            this._checkDoorBlocksColors();
            switch (this.m_state) {
                case eSwitchState_Close: {
                    if (!this._canOpen()) break;
                    if (this.m_owner.Level().PuzzleMode()) {
                        this._goToState(eDoorState.eSwitchState_OpeningWarmPuzzle);
                        break;
                    }
                    this._goToState(eDoorState.eSwitchState_OpeningWarm);
                    break;
                }
                case eSwitchState_Open: {
                    if (this._canOpen()) break;
                    if (this.m_owner.Level().PuzzleMode()) {
                        this._goToState(eDoorState.eSwitchState_ClosingWarmPuzzle);
                        break;
                    }
                    this._goToState(eDoorState.eSwitchState_ClosingWarm);
                    break;
                }
                case eSwitchState_Opening: {
                    if (this.m_owner.Level().PuzzleMode()) break;
                    if (this._canOpen()) {
                        if (!this._spawnBlocksUpdate(false, false)) break;
                        this._goToState(eDoorState.eSwitchState_Open);
                        break;
                    }
                    this._goToState(eDoorState.eSwitchState_Closing);
                    break;
                }
                case eSwitchState_Closing: {
                    if (this.m_owner.Level().PuzzleMode()) {
                        if (!this._canOpen()) break;
                        this._goToState(eDoorState.eSwitchState_OpeningWarmPuzzle);
                        break;
                    }
                    if (this._canOpen()) {
                        this._goToState(eDoorState.eSwitchState_Opening);
                        break;
                    }
                    if (!this._spawnBlocksUpdate(false, true)) break;
                    this._goToState(eDoorState.eSwitchState_Close);
                    break;
                }
                case eSwitchState_OpeningWarm: {
                    this._blinkWarmUpdate();
                    if (this.m_numBlinkWarm <= NumBlinkWarmMax) break;
                    this._goToState(eDoorState.eSwitchState_Opening);
                    break;
                }
                case eSwitchState_ClosingWarm: {
                    this._blinkWarmUpdate();
                    if (this.m_numBlinkWarm <= NumBlinkWarmMax) break;
                    this._goToState(eDoorState.eSwitchState_Closing);
                    break;
                }
                case eSwitchState_OpeningWarmPuzzle: {
                    if (this.m_owner.Level().PuzzleMode()) {
                        if (this._canOpen()) {
                            this._blinkWarmPuzzleUpdate();
                            break;
                        }
                        this._goToState(eDoorState.eSwitchState_Closing);
                        break;
                    }
                    this._goToState(eDoorState.eSwitchState_OpeningWarm);
                    break;
                }
                case eSwitchState_ClosingWarmPuzzle: {
                    if (this.m_owner.Level().PuzzleMode()) {
                        this._blinkWarmPuzzleUpdate();
                        break;
                    }
                    this._goToState(eDoorState.eSwitchState_ClosingWarm);
                }
            }
        }
    }

    protected void _checkDoorBlocksColors() {
        if ((this.m_owner.Level().MainPlayerBehaviour().isModeNew(PlayerBehaviour.ePlayerMode.ePlayerMode_Bloc) || this.m_owner.Level().MainPlayerBehaviour().isModeNew(PlayerBehaviour.ePlayerMode.ePlayerMode_Move) && this.m_owner.Level().MainPlayerBehaviour().PlayModeOld() == PlayerBehaviour.ePlayerMode.ePlayerMode_Bloc) && this.m_spawnedBlocs != null) {
            int i = 0;
            while (i < this.m_spawnedBlocs.length) {
                if (this.m_spawnedBlocs[i] != null) {
                    this.m_spawnedBlocs[i].color(this.m_owner.color());
                }
                ++i;
            }
        }
    }

    protected void _blinkWarmUpdate() {
        this.m_elapsedBlinkTime += FlxG.elapsed;
        if (this.m_elapsedBlinkTime > BlinkTickWarm) {
            ++this.m_numBlinkWarm;
            this.m_elapsedBlinkTime = 0.0f;
            this._hudAnim(!this.m_bOpenAnim);
        }
    }

    protected void _blinkWarmPuzzleUpdate() {
        this.m_elapsedBlinkTime += FlxG.elapsed;
        if (this.m_elapsedBlinkTime > BlinkTickWarmPuzzle) {
            this.m_elapsedBlinkTime = 0.0f;
            this._hudAnim(!this.m_bOpenAnim);
        }
    }

    protected void _goToState(eDoorState _state) {
        this.m_elapsedBlinkTime = 0.0f;
        this.m_numBlinkWarm = 0;
        this.m_state = _state;
        switch (this.m_state) {
            case eSwitchState_Close: {
                this._hudAnim(false);
                break;
            }
            case eSwitchState_Open: {
                this._hudAnim(true);
                break;
            }
            case eSwitchState_Closing: {
                this._hudAnim(false);
                break;
            }
            case eSwitchState_Opening: {
                this._hudAnim(true);
                break;
            }
            case eSwitchState_ClosingWarm: {
                this.m_sndLockUnlock.play();
                this.m_elapsedBlinkTime = 0.0f;
                break;
            }
            case eSwitchState_OpeningWarm: {
                this.m_sndLockUnlock.play();
                this.m_elapsedBlinkTime = 0.0f;
                break;
            }
            case eSwitchState_ClosingWarmPuzzle: {
                this.m_sndLockUnlock.play();
                this.m_elapsedBlinkTime = 0.0f;
                break;
            }
            case eSwitchState_OpeningWarmPuzzle: {
                this.m_sndLockUnlock.play();
                this.m_elapsedBlinkTime = 0.0f;
            }
        }
    }

    @Override
    public void checkCollisions() {
    }

    @Override
    public void onOverlapsCallback(FlxSpriteCollisionEvent _event, int _callbackId) {
    }

    @Override
    public void onParamsChanged() {
    }

    @Override
    public void handleGenericMessage(Actor.eGenericMessage _message, Actor _sender) {
        switch (_message) {
            case eGenericMessage_PlayerHitByJump: {
                _sender.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_BlocStopJump, this.m_owner);
                break;
            }
            case eGenericMessage_SwitchCountIncrease: {
                if (!this.m_bIsDoorBase) break;
                ++this.m_waitingSwitchNum;
                break;
            }
            case eGenericMessage_Drill: {
                _sender.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_BlocRepulsion, this.m_owner);
                break;
            }
            case eGenericMessage_DoorBaseInit: {
                if (!this.m_bIsDoorBase) break;
                this._initBaseDoor();
                break;
            }
            case eGenericMessage_SwitchActivated: {
                if (!this.m_bIsDoorBase) break;
                ++this.m_switchActivated;
                break;
            }
            case eGenericMessage_SwitchDeactivated: {
                if (!this.m_bIsDoorBase) break;
                --this.m_switchActivated;
                break;
            }
            case eGenericMessage_DoorBlocShow: {
                if (this.m_bIsDoorBase || this.m_bRegisteredInBlocManager) break;
                this.m_owner.visible = true;
                this._registerInBlocManager();
                if (!Utility.IsActorsOverlappingFastWithScale(this.m_owner.Level().MainPlayer(), this.m_owner, 0.9f)) break;
                this.m_owner.Level().MainPlayerBehaviour().handleGenericMessage(Actor.eGenericMessage.eGenericMessage_TntBlow, this.m_owner);
                break;
            }
            case eGenericMessage_DoorBlocHide: {
                if (this.m_bIsDoorBase || !this.m_bRegisteredInBlocManager) break;
                this.m_owner.visible = false;
                this._unregisterInBlocManager();
            }
        }
    }

    protected void _destroy() {
        this._unregisterInBlocManager();
    }

    protected void _registerInBlocManager() {
        if (this.m_owner.Level().Mode() == Level.eLevelMode.eLevelMode_Play || this.m_owner.Level().Mode() == Level.eLevelMode.eLevelMode_Test) {
            this.m_bRegisteredInBlocManager = true;
            this.m_owner.Level().BlocManager().registerUnremovableBloc(this.m_owner);
        }
    }

    protected void _unregisterInBlocManager() {
        if (this.m_bRegisteredInBlocManager) {
            this.m_owner.Level().BlocManager().unregisterUnremovableBloc(this.m_owner);
            this.m_bRegisteredInBlocManager = false;
        }
    }

    @Override
    public void render(SpriteBatch spriteBatch) {
        if (this.m_hud != null) {
            this.m_hud.render(spriteBatch);
        }
    }

    public static enum eDoorState {
        eSwitchState_Close,
        eSwitchState_Open,
        eSwitchState_Opening,
        eSwitchState_Closing,
        eSwitchState_OpeningWarm,
        eSwitchState_ClosingWarm,
        eSwitchState_OpeningWarmPuzzle,
        eSwitchState_ClosingWarmPuzzle;

    }
}

