/*
 * Decompiled with CFR 0.152.
 */
package SSS.Behaviours.BTM;

import SSS.Actor;
import SSS.Behaviour;
import SSS.Behaviours.BTM.PlayerBehaviour;
import SSS.Managers.BTM.AchievementManager;
import SSS.Managers.BTM.BlocManager;
import SSS.Managers.BTM.BlocksSoundsManager;
import java.util.ArrayList;
import java.util.HashMap;
import org.flixel.FlxG;
import org.flixel.FlxSound;
import org.flixel.FlxSprite;
import org.flixel.event.FlxSpriteCollisionEvent;

public class EnnemyBehaviour
extends Behaviour {
    static final int CallbackId_BigSendDestroymessage = 0;
    static final int CallbackId_CollideEnnemy = 1;
    eConsistance m_consitance = eConsistance.eConsistance_jelly;
    protected static HashMap<String, eEnnemyType> KindEnumMatch = new HashMap<String, eEnnemyType>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("slime_little", eEnnemyType.eEnnemyType_littleSlim);
            this.put("slime_big", eEnnemyType.eEnnemyType_bigSlim);
        }
    };
    eEnnemyType m_type = eEnnemyType.eEnnemyType_unkown;
    eEnnemyDieStep m_dieStep = eEnnemyDieStep.eEnnemyDieStep_None;
    eEnnemyState m_state = eEnnemyState.eEnnemyState_MoveRight;
    eEnnemyState m_moveTypeBeforeNone = eEnnemyState.eEnnemyState_MoveRight;
    float WalkSpeed = 110.0f;
    float AccelerationY = 1000.0f;
    float DragDecelFactor = 8.0f;
    int JumpPower = 370;
    ArrayList<Actor> m_listActorToDestroy = null;
    boolean m_bSleeping = false;
    FlxSound m_sndAssociated = null;
    float m_fMinRadiusSqrSndAssociated = 0.0f;
    float m_fMaxRadiusSqrSndAssociated = 2000.0f;
    boolean m_bExploded = false;

    public eConsistance getConsistance() {
        return this.m_consitance;
    }

    public EnnemyBehaviour(String _id, Actor _owner, Actor.eActorMaterial _material) {
        super(_id, _owner, _material);
    }

    @Override
    protected void initOwnerFlixelProperties() {
        this._initFlixelProperties(true);
    }

    protected void _initFlixelProperties(boolean _allowMove) {
        if (_allowMove) {
            this.m_owner.fixed = false;
            this.m_owner.moves = true;
        } else {
            this.m_owner.fixed = true;
            this.m_owner.moves = false;
        }
    }

    @Override
    public void init() {
        if (this.m_owner.Level().PlayableMode()) {
            this.m_owner.Level().addEnnemyToCollide(this.m_owner);
            this._initVars();
            if (this.m_type == eEnnemyType.eEnnemyType_bigSlim) {
                this.m_listActorToDestroy = new ArrayList(30);
                this.m_owner.AlwaysVisible(true);
            } else if (this.isBurning()) {
                this.m_owner.Level().ParticleManager().reserveEmitterTrigger("SlimeExplodeFire");
            } else if (this.isEating()) {
                this.m_owner.Level().ParticleManager().reserveEmitterTrigger("SlimeExplodeChocolate");
            } else {
                this.m_owner.Level().ParticleManager().reserveEmitterTrigger("SlimeExplode");
            }
        }
    }

    protected void _initVars() {
        this.m_type = KindEnumMatch.get(this.getStringParameter("Kind"));
        int fireFlag = this.getIntParameter("InFire");
        switch (fireFlag) {
            case 1: {
                this.m_consitance = eConsistance.eConsistance_fire;
                break;
            }
            case 2: {
                this.m_consitance = eConsistance.eConsistance_black;
                break;
            }
            case 3: {
                this.m_consitance = eConsistance.eConsistance_brown;
                break;
            }
            case 4: {
                this.m_consitance = eConsistance.eConsistance_white;
                break;
            }
            case 5: {
                this.m_consitance = eConsistance.eConsistance_pink;
                break;
            }
            default: {
                this.m_consitance = eConsistance.eConsistance_jelly;
            }
        }
        this._initWalkParams();
        if (this.m_type == eEnnemyType.eEnnemyType_bigSlim) {
            this.m_sndAssociated = new FlxSound();
            this.m_sndAssociated.loadEmbedded(this.getStringParameter("SndAssociated"), true, true, false);
            this.m_fMinRadiusSqrSndAssociated = this.getFloatParameter("MinRadiusSndAssociated") * (float)FlxG.width;
            this.m_fMinRadiusSqrSndAssociated *= this.m_fMinRadiusSqrSndAssociated;
            this.m_fMaxRadiusSqrSndAssociated = this.getFloatParameter("MaxRadiusSndAssociated") * (float)FlxG.width;
            this.m_fMaxRadiusSqrSndAssociated *= this.m_fMaxRadiusSqrSndAssociated;
            this._updateSoundVolume(-1.0f);
            if (this.WalkSpeed > 0.0f) {
                this.m_sndAssociated.play();
            }
        }
        this._checkFacing();
    }

    protected void _initWalkParams() {
        this.AccelerationY = this.getFloatParameter("AccelY");
        this.WalkSpeed = this.getFloatParameter("WalkSpeed");
        this.DragDecelFactor = this.getFloatParameter("DragDecelFactor");
        this.m_owner.acceleration.Y = this.AccelerationY;
        this.m_owner.maxVelocity.X = this.WalkSpeed;
        this.m_owner.drag.X = this.m_owner.maxVelocity.X * this.DragDecelFactor;
        this.m_owner.maxVelocity.Y = this.JumpPower;
    }

    @Override
    public void deinit() {
        if (this.m_sndAssociated != null) {
            this.m_sndAssociated.stop();
            this.m_sndAssociated = null;
        }
        if (this.m_owner.Level().PlayableMode()) {
            this.m_owner.Level().removeEnnemyToCollide(this.m_owner);
        }
    }

    protected boolean isBurning() {
        return this.m_consitance == eConsistance.eConsistance_fire;
    }

    protected boolean isEating() {
        return this.m_consitance.ordinal() >= eConsistance.eConsistance_black.ordinal() && this.m_consitance.ordinal() <= eConsistance.eConsistance_pink.ordinal();
    }

    @Override
    public void update() {
        if (!this.m_owner.Level().PuzzleMode() && this.m_owner.Level().PlayableMode()) {
            switch (this.m_type) {
                case eEnnemyType_littleSlim: {
                    this._handlePathLittleSlim();
                    this._handleMovementLittleSlim();
                    if (this.m_state == eEnnemyState.eEnnemyState_Dying || this.m_state == eEnnemyState.eEnnemyState_Died || !this.m_owner.overlaps(this.m_owner.Level().MainPlayer())) break;
                    if (this.isBurning()) {
                        this.m_owner.Level().MainPlayer().handleGenericMessage(Actor.eGenericMessage.eGenericMessage_SlimeDropContact, this.m_owner);
                        break;
                    }
                    this.m_owner.Level().MainPlayer().handleGenericMessage(Actor.eGenericMessage.eGenericMessage_EnnemyHitPlayer, this.m_owner);
                    break;
                }
                case eEnnemyType_bigSlim: {
                    this._updateSoundVolume(-1.0f);
                    this._handlePathBigSlim();
                    this._handleMovementLittleSlim();
                }
            }
        }
        if (this.m_owner.Level().MainPlayerBehaviour().isModeNew(PlayerBehaviour.ePlayerMode.ePlayerMode_Move)) {
            this.m_owner.CanUpdateOwnerBase(true);
        } else if (this.m_owner.Level().MainPlayerBehaviour().isModeNew(PlayerBehaviour.ePlayerMode.ePlayerMode_Bloc)) {
            this.m_owner.CanUpdateOwnerBase(false);
            if (this.m_type == eEnnemyType.eEnnemyType_bigSlim) {
                this._updateSoundVolume(0.0f);
            }
        }
    }

    protected void _updateSoundVolume(float _forceVolumeOrNeg) {
        if (this.m_sndAssociated != null) {
            float volume = 1.0f;
            if (_forceVolumeOrNeg < 0.0f) {
                float dy;
                float dx = this.m_owner.getCenterX() - this.m_owner.Level().MainPlayer().getCenterX();
                float distSquared = dx * dx + (dy = this.m_owner.getCenterY() - this.m_owner.Level().MainPlayer().getCenterY()) * dy;
                if (distSquared > this.m_fMaxRadiusSqrSndAssociated) {
                    volume = 0.0f;
                } else if (distSquared < this.m_fMinRadiusSqrSndAssociated) {
                    volume = 1.0f;
                } else {
                    float factor = (distSquared - this.m_fMinRadiusSqrSndAssociated) / (this.m_fMaxRadiusSqrSndAssociated - this.m_fMinRadiusSqrSndAssociated);
                    volume = 1.0f - factor;
                }
            } else {
                volume = _forceVolumeOrNeg;
            }
            this.m_sndAssociated.volume(volume);
        }
    }

    @Override
    public void checkCollisions() {
    }

    @Override
    public void onOverlapsCallback(FlxSpriteCollisionEvent _event, int _callbackId) {
        switch (_callbackId) {
            case 0: {
                Actor act = (Actor)_event.Object1();
                if (act == null || act.Dying() || !(act.getCenterY() < this.m_owner.getBottom())) break;
                this.m_listActorToDestroy.add(act);
                act.addFlag(Actor.eSpecialFlag.eSpecialFlag_GroundToBeRemoved);
                break;
            }
            case 1: {
                if (this.m_state == eEnnemyState.eEnnemyState_Dying) break;
                eEnnemyState nextMove = this.m_state;
                this.m_state = _event.Object1().x < this.m_owner.x ? eEnnemyState.eEnnemyState_MoveRight : eEnnemyState.eEnnemyState_MoveLeft;
                if (this.m_state != eEnnemyState.eEnnemyState_None) break;
                this.m_state = this.m_moveTypeBeforeNone;
            }
        }
    }

    protected void _handlePathLittleSlim() {
        block22: {
            block23: {
                int idCol;
                int idLine;
                block24: {
                    block21: {
                        if (this.m_state == eEnnemyState.eEnnemyState_Dying || this.m_state == eEnnemyState.eEnnemyState_Died) {
                            return;
                        }
                        if (this.m_state != eEnnemyState.eEnnemyState_None) break block21;
                        if (this.m_bSleeping || this.m_owner.velocity.Y != 0.0f) break block22;
                        this.m_state = this.m_moveTypeBeforeNone;
                        if (this.m_state != eEnnemyState.eEnnemyState_None) break block22;
                        this.m_state = eEnnemyState.eEnnemyState_MoveLeft;
                        break block22;
                    }
                    if (this.m_state != eEnnemyState.eEnnemyState_WaitingBetweenTwoBloc) break block23;
                    this.m_owner.Level().BlocManager().getActorGridLocation(this.m_owner, BlocManager.idCol, BlocManager.idLine);
                    idLine = BlocManager.idLine.get();
                    idCol = BlocManager.idCol.get();
                    if (!this.m_owner.Level().BlocManager().isBlocSlotOccupied(idLine, idCol - 1)) {
                        this.m_state = eEnnemyState.eEnnemyState_MoveLeft;
                    } else if (!this.m_owner.Level().BlocManager().isBlocSlotOccupied(idLine, idCol + 1)) {
                        this.m_state = eEnnemyState.eEnnemyState_MoveRight;
                    }
                    if (this.m_state != eEnnemyState.eEnnemyState_WaitingBetweenTwoBloc) break block22;
                    if (!this.isBurning()) break block24;
                    this.m_owner.Level().BlocManager().sendMessageToBlocId(idLine, idCol - 1, Actor.eGenericMessage.eGenericMessage_BurningBlocContact, this.m_owner);
                    this.m_owner.Level().BlocManager().sendMessageToBlocId(idLine, idCol + 1, Actor.eGenericMessage.eGenericMessage_BurningBlocContact, this.m_owner);
                    break block22;
                }
                if (!this.isEating()) break block22;
                this.m_owner.Level().BlocManager().sendMessageToBlocId(idLine, idCol - 1, Actor.eGenericMessage.eGenericMessage_EatingBlocContact, this.m_owner);
                this.m_owner.Level().BlocManager().sendMessageToBlocId(idLine, idCol + 1, Actor.eGenericMessage.eGenericMessage_EatingBlocContact, this.m_owner);
                break block22;
            }
            if (this.m_owner.velocity.Y != 0.0f) {
                this.m_moveTypeBeforeNone = this.m_state;
                this.m_state = eEnnemyState.eEnnemyState_None;
            } else {
                boolean bMoveLeft;
                float pointx2;
                float pointx;
                float pointy = this.m_owner.y + this.m_owner.height * 0.5f;
                if (this.m_state == eEnnemyState.eEnnemyState_MoveLeft) {
                    pointx = this.m_owner.x + 1.0f;
                    pointx2 = this.m_owner.x + this.m_owner.width - 1.0f;
                } else {
                    pointx = this.m_owner.x + this.m_owner.width - 1.0f;
                    pointx2 = this.m_owner.x + 1.0f;
                }
                this.m_owner.Level().BlocManager().getPointGridLocation(pointx, pointy, BlocManager.idCol, BlocManager.idLine);
                int idLine = BlocManager.idLine.get();
                int idCol = BlocManager.idCol.get();
                this.m_owner.Level().BlocManager().getPointGridLocation(pointx2, pointy, BlocManager.idCol2, BlocManager.idLine2);
                int idLine2 = BlocManager.idLine2.get();
                int idCol2 = BlocManager.idCol2.get();
                boolean bl = bMoveLeft = this.m_state == eEnnemyState.eEnnemyState_MoveLeft;
                if (this.m_state != eEnnemyState.eEnnemyState_None && !this.m_owner.Level().BlocManager().isBlocSlotOccupied(idLine - 1, idCol)) {
                    this._handleReverse();
                } else {
                    if (this.m_owner.velocity.X == 0.0f && this.m_owner.Level().BlocManager().isBlocSlotOccupied(idLine, bMoveLeft ? idCol - 1 : idCol + 1)) {
                        if (this.isBurning()) {
                            this.m_owner.Level().BlocManager().sendMessageToBlocId(idLine, bMoveLeft ? idCol - 1 : idCol + 1, Actor.eGenericMessage.eGenericMessage_BurningBlocContact, this.m_owner);
                        } else if (this.isEating()) {
                            this.m_owner.Level().BlocManager().sendMessageToBlocId(idLine, bMoveLeft ? idCol - 1 : idCol + 1, Actor.eGenericMessage.eGenericMessage_EatingBlocContact, this.m_owner);
                        }
                        if (this.m_state != eEnnemyState.eEnnemyState_Dying) {
                            if (this.m_owner.Level().BlocManager().isBlocSlotOccupied(idLine, bMoveLeft ? idCol + 1 : idCol - 1)) {
                                this.m_state = eEnnemyState.eEnnemyState_WaitingBetweenTwoBloc;
                            } else {
                                this._handleReverse();
                            }
                        }
                    }
                    this.m_owner.Level().overlapActorWithEnnemies(this.m_owner, this, 1);
                }
                int startId = idCol > idCol2 ? idCol2 : idCol;
                int endId = idCol > idCol2 ? idCol : idCol2;
                Actor.eGenericMessage message = Actor.eGenericMessage.eGenericMessage_EnnemyWalkContact;
                if (this.isBurning()) {
                    message = Actor.eGenericMessage.eGenericMessage_BurningBlocContact;
                } else if (this.isEating()) {
                    message = Actor.eGenericMessage.eGenericMessage_EatingBlocContact;
                }
                int iCol = startId;
                while (iCol <= endId) {
                    this.m_owner.Level().BlocManager().sendMessageToBlocId(idLine - 1, iCol, message, this.m_owner);
                    ++iCol;
                }
            }
        }
    }

    protected void _handleReverse() {
        this.m_state = this.m_state == eEnnemyState.eEnnemyState_MoveLeft ? eEnnemyState.eEnnemyState_MoveRight : eEnnemyState.eEnnemyState_MoveLeft;
    }

    protected void _handlePathBigSlim() {
        Actor actor = null;
        this.m_owner.Level().BlocManager().overlapFastWithScale(this.m_owner, this, 1.05f, 0);
        if (this.m_listActorToDestroy.size() > 0) {
            boolean autoAnimFound = false;
            float minx = this.m_listActorToDestroy.get((int)0).x;
            float maxx = minx + this.m_listActorToDestroy.get((int)0).width;
            float maxy = this.m_listActorToDestroy.get((int)0).y;
            int i = 0;
            while (i < this.m_listActorToDestroy.size()) {
                actor = this.m_listActorToDestroy.get(i);
                actor.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_BigSlimeDestroy, this.m_owner);
                if (actor.Material() == Actor.eActorMaterial.eActorMaterial_UnbreakableAutoAnim) {
                    float curMinx = actor.x;
                    float curMaxx = curMinx + actor.width;
                    float curMaxy = actor.y;
                    if (curMinx < minx) {
                        minx = curMinx;
                    }
                    if (curMaxx < maxx) {
                        maxx = curMaxx;
                    }
                    if (curMaxy > maxy) {
                        maxy = curMaxy;
                    }
                    autoAnimFound = true;
                }
                ++i;
            }
            if (autoAnimFound) {
                actor = null;
                ArrayList list = this.m_owner.Level().LayerBackGround().get((int)1).members;
                int i2 = 0;
                while (i2 < list.size()) {
                    actor = (Actor)list.get(i2);
                    if (actor != null && actor.visible && actor.Material() == Actor.eActorMaterial.eActorMaterial_AnimNoiser && actor.x >= minx && actor.x < maxx && actor.y < maxy) {
                        actor.visible = false;
                    }
                    ++i2;
                }
            }
            if (this.m_owner.Level().MainPlayerBehaviour().PlayMode() != PlayerBehaviour.ePlayerMode.ePlayerMode_ShowLevelResultPAR && this.m_owner.Level().MainPlayerBehaviour().PlayMode() != PlayerBehaviour.ePlayerMode.ePlayerMode_ShowLevelResultBTM) {
                FlxG.quake.start(0.01f, 0.25f);
            }
            this.m_listActorToDestroy.clear();
        }
        if (this.m_owner.Level().MainPlayer().overlaps(this.m_owner)) {
            this.m_owner.Level().MainPlayer().handleGenericMessage(Actor.eGenericMessage.eGenericMessage_TntBlow, this.m_owner);
        }
    }

    protected void _handleMovementLittleSlim() {
        this.m_owner.acceleration.X = 0.0f;
        if (!this.m_owner.Level().AllowEnnemiesMove()) {
            return;
        }
        switch (this.m_state) {
            case eEnnemyState_MoveLeft: {
                this.m_owner.facing(FlxSprite.Flx2DFacing.Left);
                this.m_owner.acceleration.X -= this.m_owner.drag.X;
                break;
            }
            case eEnnemyState_MoveRight: {
                this.m_owner.facing(FlxSprite.Flx2DFacing.Right);
                this.m_owner.acceleration.X += this.m_owner.drag.X;
                break;
            }
            case eEnnemyState_None: {
                this.m_owner.drag.X = this.WalkSpeed * this.DragDecelFactor;
                break;
            }
            case eEnnemyState_MoveSleeping: {
                this.m_owner.drag.X = this.WalkSpeed * this.DragDecelFactor;
                break;
            }
            case eEnnemyState_Dying: {
                this.m_owner.Level().removeActorsToPhysic(this.m_owner);
                this.m_state = eEnnemyState.eEnnemyState_Died;
            }
        }
    }

    @Override
    public void handleGenericMessage(Actor.eGenericMessage _message, Actor _sender) {
        switch (_message) {
            case eGenericMessage_BlocCrush: {
                this._handleCrush(_sender);
                break;
            }
            case eGenericMessage_FreezeEnnemy: {
                this._initFlixelProperties(false);
                break;
            }
            case eGenericMessage_UnFreezeEnnemy: {
                this._initFlixelProperties(true);
                break;
            }
            case eGenericMessage_PutToSleep: {
                this._putToSleep();
                break;
            }
            case eGenericMessage_TntBlow: {
                if (this.m_type != eEnnemyType.eEnnemyType_littleSlim || this.m_bExploded) break;
                this.m_bExploded = true;
                this._emitParticlesAndSound();
                this.m_state = eEnnemyState.eEnnemyState_Dying;
                this.m_owner.Dying(true);
                AchievementManager.Instance().incrementRaster("RAS_SLIME_DIED", 1);
                break;
            }
            case eGenericMessage_Kaboom: {
                this.m_owner.Level().removeActorsToPhysic(this.m_owner);
            }
        }
    }

    protected void _handleCrush(Actor _sender) {
        if (this.m_state != eEnnemyState.eEnnemyState_Dying) {
            if (this.isBurning() && _sender != null && _sender.Material() == Actor.eActorMaterial.eActorMaterial_Ice) {
                _sender.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_BurningBlocContact, this.m_owner);
                return;
            }
            this._emitParticlesAndSound();
            if (_sender != null && _sender.getBottom() < this.m_owner.getCenterY()) {
                AchievementManager.Instance().unlockAchievement("ACH_SQUASH_SLIME");
            }
            this.m_state = eEnnemyState.eEnnemyState_Dying;
            this.m_owner.Dying(true);
        }
    }

    protected void _emitParticlesAndSound() {
        if (this.isBurning()) {
            this.m_owner.Level().ParticleManager().emitterTrigger("SlimeExplodeFire", this.m_owner.getCenterX(), this.m_owner.getCenterY());
        } else if (this.isEating()) {
            Actor.eActorMaterial material = Actor.eActorMaterial.eActorMaterial_Ennemy;
            switch (this.m_consitance) {
                case eConsistance_black: {
                    material = Actor.eActorMaterial.eActorMaterial_BlackChocolate;
                    break;
                }
                case eConsistance_brown: {
                    material = Actor.eActorMaterial.eActorMaterial_BrownChocolate;
                    break;
                }
                case eConsistance_pink: {
                    material = Actor.eActorMaterial.eActorMaterial_PinkChocolate;
                    break;
                }
                case eConsistance_white: {
                    material = Actor.eActorMaterial.eActorMaterial_WhiteChocolate;
                }
            }
            this.m_owner.Level().ParticleManager().emitterTrigger("SlimeExplodeChocolate", this.m_owner.getCenterX(), this.m_owner.getCenterY(), Actor.MaterialEnumParticleColorDictionnary.get((Object)material));
        } else {
            this.m_owner.Level().ParticleManager().emitterTrigger("SlimeExplode", this.m_owner.getCenterX(), this.m_owner.getCenterY());
        }
        this.m_owner.Level().BlocSoundManager().triggerBlocSoundEvent(BlocksSoundsManager.eBlocSoundEvent.eBlocSoundEvent_LittleSlimeCrush, this.m_owner);
    }

    protected void _putToSleep() {
        if (!this.m_bSleeping) {
            this.m_state = eEnnemyState.eEnnemyState_MoveSleeping;
            this.m_bSleeping = true;
        }
    }

    @Override
    public void onParamsChanged() {
        this._initWalkParams();
        this._checkFacing();
    }

    protected void _checkFacing() {
        int facing;
        if (this.m_type == eEnnemyType.eEnnemyType_littleSlim && ((facing = this.getIntParameter("StarMoveToLeft")) == 1 && this.m_state == eEnnemyState.eEnnemyState_MoveRight || facing == 0 && this.m_state == eEnnemyState.eEnnemyState_MoveLeft)) {
            this._handleReverse();
        }
    }

    public static enum eConsistance {
        eConsistance_jelly,
        eConsistance_fire,
        eConsistance_black,
        eConsistance_brown,
        eConsistance_white,
        eConsistance_pink;

    }

    public static enum eEnnemyDieStep {
        eEnnemyDieStep_None,
        eEnnemyDieStep_Crushing,
        eEnnemyDieStep_Splashing;

    }

    public static enum eEnnemyState {
        eEnnemyState_None,
        eEnnemyState_MoveLeft,
        eEnnemyState_MoveRight,
        eEnnemyState_WaitingBetweenTwoBloc,
        eEnnemyState_MoveSleeping,
        eEnnemyState_Dying,
        eEnnemyState_Died;

    }

    public static enum eEnnemyType {
        eEnnemyType_unkown,
        eEnnemyType_littleSlim,
        eEnnemyType_bigSlim;

    }
}

