/*
 * Decompiled with CFR 0.152.
 */
package SSS.Behaviours.BTM;

import Java.Tricks.ref;
import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.GamerServices.Guide;
import Microsoft.Xna.Framework.Graphics.SpriteBatch;
import Microsoft.Xna.Framework.Input.Buttons;
import Microsoft.Xna.Framework.Input.Keys;
import Microsoft.Xna.Framework.MathHelper;
import Microsoft.Xna.Framework.Vector2;
import Microsoft.Xna.Framework.Vector3;
import SSS.Actor;
import SSS.BTM.CollectedMaterialHud;
import SSS.BTM.GameMode;
import SSS.BTM.GameVars;
import SSS.BTM.HologramPuzzleZone;
import SSS.BTM.PlayState;
import SSS.BTM.PuzzleBlocSpawner;
import SSS.Behaviour;
import SSS.Events.CallbackSimple;
import SSS.Level;
import SSS.Managers.BTM.AchievementManager;
import SSS.Managers.BTM.BlocManager;
import SSS.Managers.BTM.LevelDataBase;
import SSS.Managers.BTM.LevelGroup;
import SSS.Managers.BTM.LevelInfo;
import SSS.Managers.BTM.Particle.KaboomParticleEffect;
import SSS.States.BTM.CinematicReplayState;
import SSS.States.BTM.LauncherState;
import SSS.States.BTM.LevelSelectionState;
import SSS.States.BTM.MenuMainState;
import SSS.Tween.TweenManager;
import SSS.Util.Debug;
import SSS.Util.InputManager;
import SSS.Util.Utility;
import java.util.Arrays;
import org.flixel.FlxEmitter;
import org.flixel.FlxFadeListener;
import org.flixel.FlxG;
import org.flixel.FlxSound;
import org.flixel.FlxSoundManager;
import org.flixel.FlxSprite;
import org.flixel.data.SssAnchorAnimation;
import org.flixel.event.FlxSpriteCollisionEvent;
import precompiler.MACRO;

public class PlayerBehaviour
extends Behaviour {
    final int CallbackId_PlayerCollide = 0;
    protected eJumpType m_jumpType = eJumpType.eJumpType_MarioBros;
    float m_timeSinceJustReleasedRunButton = 0.0f;
    float TimeRunButtonDelay = 0.2f;
    protected eAnimState m_animStateOld = eAnimState.eAnimState_Unknow;
    protected eAnimState m_animState = eAnimState.eAnimState_Unknow;
    protected eAnimEyeState m_eyeAnimState = eAnimEyeState.eAnimEyeState_idle;
    eDammageState m_dammageState = eDammageState.eDammageState_None;
    boolean m_bInstantKillOnEveryThing = false;
    boolean m_bFirstDammage = true;
    boolean m_bDammageThisFrame = false;
    float m_timeElapsedDamage = 0.0f;
    float m_timeInvincibleElectric = 2.0f;
    float m_timeVulnerableElectric = 2.0f;
    float m_blinkTick = 0.02f;
    float m_blinkElapsed = 0.0f;
    float[] m_blinkArrayAlpha = new float[]{1.0f, 0.0f};
    int m_blinkAlphaIndex = 0;
    FlxSprite m_eye = null;
    FlxSprite m_eyeUpgrade = null;
    int m_eyeUpdgradeLevel = 0;
    FlxSprite m_eyeHurt = null;
    FlxSprite m_electricity = null;
    float m_eyeDrillTurnIdleFactor = 3.0f;
    SssAnchorAnimation m_eyeAnchor = null;
    FlxSprite m_moveTarget = null;
    float MoveTargetSpeed = 500.0f;
    float MoveTargetIncreaseSpeedFactor = 2.0f;
    float m_targetSaveCx;
    float m_targetSaveCy;
    float m_cameraMoveLerp = 2.5f;
    float m_cameraMoveAdjustX = 0.5f;
    float m_cameraMoveAdjustY = 0.0f;
    Actor m_elementToShow = null;
    boolean m_bCanBeHurt = true;
    boolean m_bLimitingY = false;
    float m_limitY = 0.0f;
    boolean m_bPortalControl = false;
    boolean m_bDebugGrabMove = false;
    int JumpPower = 370;
    float AccelerationY = 1000.0f;
    float DragDecelFactor = 8.0f;
    float RunSpeed = 110.0f;
    float WalkSpeed = 110.0f;
    float TimePressRetry = 2.5f;
    float QuakeIntensityRetryMin = 0.0f;
    float QuakeIntensityRetryMax = 0.05f;
    float m_timePressedRetry = 0.0f;
    boolean m_bResetInitiated = false;
    boolean m_bFadeLaunched = false;
    boolean m_bDrillOnlyOnContact = false;
    boolean m_bDrillContact = false;
    float m_drillLoopToDrillNoContactLoopDelay = 0.0f;
    float m_timeElapsedDrillNoContact = 0.0f;
    boolean m_bBTM_found = false;
    boolean m_bPAR_newRecord = false;
    int m_bPAR_requiredNum = 0;
    int m_customParCommunity = 0;
    FlxSound m_sndJump = null;
    FlxSound m_sndBlocModeOn = null;
    FlxSound m_sndBlocModeOff = null;
    boolean m_bPlayDrillStartStop = true;
    boolean m_bPlayAleaOnDrillStartStop = false;
    FlxSound m_sndDrillStart = null;
    FlxSound m_sndDrillLoop = null;
    FlxSound m_sndDrillLoopInactive = null;
    FlxSound m_sndDrillEnd = null;
    FlxSound m_sndStepGeneric = null;
    FlxSound[] m_sndStepByMat = null;
    FlxSound m_sndReceptionGeneric = null;
    FlxSound[] m_sndReceptionByMat = null;
    FlxSound m_sndHitWithHeadGeneric = null;
    FlxSound[] m_sndHitWithHeadByMat = null;
    FlxSound m_sndHit = null;
    FlxSound m_sndDrillRepulse = null;
    FlxSound m_sndAlea = null;
    FlxSound m_sndShift = null;
    FlxSound m_sndBreakLevel01 = null;
    FlxSound m_sndBreakLevel02 = null;
    FlxSound m_sndBreakLevel03 = null;
    int m_sndBreakLevel01_Counter = 0;
    int m_sndBreakLevel02_Counter = 0;
    int m_sndBreakLevel03_Counter = 0;
    FlxSound m_sndDrillLevel01 = null;
    FlxSound m_sndDrillLevel02 = null;
    FlxSound m_sndDrillLevel03 = null;
    FlxSound m_sndRestartLevel = null;
    FlxSound m_sndDammage = null;
    FlxSound m_sndDie = null;
    FlxSound m_sndElecArc = null;
    FlxSound m_sndElecArcEnd = null;
    int[] m_stepWalkSndTrigger;
    int[] m_stepRunSndTrigger;
    Integer m_stepWalkLastAnimFrameIdTriggered = -1;
    Integer m_stepRunLastAnimFrameIdTriggered = -1;
    ref<Integer> m_stepWalkLastAnimFrameIdTriggeredRef = new ref<Integer>(this.m_stepWalkLastAnimFrameIdTriggered);
    ref<Integer> m_stepRunLastAnimFrameIdTriggeredRef = new ref<Integer>(this.m_stepRunLastAnimFrameIdTriggered);
    Integer m_stepWalkLastAnimFrameId = -1;
    Integer m_stepRunLastAnimFrameId = -1;
    ref<Integer> m_stepWalkLastAnimFrameIdRef = new ref<Integer>(this.m_stepWalkLastAnimFrameId);
    ref<Integer> m_stepRunLastAnimFrameIdRef = new ref<Integer>(this.m_stepRunLastAnimFrameId);
    boolean m_bPlaySndStepInRunForTheLoul = false;
    boolean m_bPlayHitSoundOnUnbreakable = true;
    boolean m_bPlayAleaSoundOnDrillRepulse = false;
    Actor.eActorMaterial m_landingMaterial = Actor.eActorMaterial.eActorMaterial_Unknown;
    boolean m_bRepulsion = false;
    public float EditModeMoveStep = 5.0f;
    public float EditModeMoveAccelFactor = 4.0f;
    boolean m_bUpdateHud = false;
    boolean m_bCanDrillForFake = false;
    boolean m_powerUpdgradeDoneDuringLevel = false;
    int m_savePowerAttribCanDoLine = 0;
    int m_savePowerAttribCanDoPuzzle = 0;
    int m_savePowerAttribMaxDrillableMatId = 0;
    PuzzleBlocSpawner m_blocSpawner;
    boolean m_bLineScanLeaveRequested = false;
    int[] m_collectableCounters = null;
    int[] m_collectableNeededCounters = null;
    int m_numCollectable = 0;
    int m_maxCollectableItemIndex = -1;
    int m_selectedIndex = 0;
    boolean m_bLeftOrRightDown = false;
    boolean m_bDrilling = false;
    boolean m_bRunning = false;
    boolean m_bBlocStopingJump = false;
    boolean m_bBlocStopingJumpHard = false;
    boolean m_bBlocStopingJumpBreakable = false;
    ePlayerMode m_playModeSave = ePlayerMode.ePlayerMode_Unknown;
    ePlayerMode m_playModeOld = ePlayerMode.ePlayerMode_Unknown;
    ePlayerMode m_playMode = ePlayerMode.ePlayerMode_Unknown;
    CollectedMaterialHud m_materialHub = null;
    FlxSprite m_fullscreenPuzzleModeFilter = null;
    HologramPuzzleZone m_hologramPuzzleZone;
    FlxEmitter m_drillEmitter = null;
    FlxEmitter m_drillRepulseEmitter = null;
    boolean m_bCheckBiggestFallAch = false;
    float m_fallBeginY = 0.0f;
    float m_fallEndY = 0.0f;
    CallbackSimple m_levelModeChanged = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            PlayerBehaviour.this._levelModeChanged(_sender, _args);
        }
    };
    CallbackSimple m_onGoToElementToShowDone = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            PlayerBehaviour.this._onGoToElementToShowDone(_sender, _args);
        }
    };
    CallbackSimple m_onGoToElementToShowBackDone = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            PlayerBehaviour.this._onGoToElementToShowBackDone(_sender, _args);
        }
    };
    FlxFadeListener m_onRestartFadeComplete = new FlxFadeListener(){

        @Override
        public void fadeComplete(Object _sender, Object _e) {
            PlayerBehaviour.this._onRestartFadeComplete(_sender, _e);
        }
    };
    CallbackSimple m_onBlocSpawnerleave = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            PlayerBehaviour.this.onBlocSpawnerleave(_sender, _args);
        }
    };
    CallbackSimple m_onBlocSpawnerCursorMove = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            PlayerBehaviour.this.onBlocSpawnerCursorMove(_sender, _args);
        }
    };
    CallbackSimple m_onBlocSpawnerScanLineLaunched = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            PlayerBehaviour.this.onBlocSpawnerScanLineLaunched(_sender, _args);
        }
    };
    CallbackSimple m_onBlocSpawnerScanLineDone = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            PlayerBehaviour.this.onBlocSpawnerScanLineDone(_sender, _args);
        }
    };
    CallbackSimple m_onBlocSpawnerDestroyLineLaunched = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            PlayerBehaviour.this.onBlocSpawnerDestroyLineLaunched(_sender, _args);
        }
    };
    CallbackSimple m_onBlocSpawnerDestroyLineDone = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            PlayerBehaviour.this.onBlocSpawnerDestroyLineDone(_sender, _args);
        }
    };

    public String getBlocActorId(int _slot) {
        Actor.eActorMaterial material = Actor.IntToeActorMaterial[_slot + Actor.FirstCollectableMatIdHACK()];
        return String.valueOf(Actor.MaterialEnumNameDictionnary.get((Object)material)) + "Bloc";
    }

    public boolean DebugGrabMove() {
        return this.m_bDebugGrabMove;
    }

    public boolean BTM_Found() {
        return this.m_bBTM_found;
    }

    public boolean PAR_NewRecord() {
        return this.m_bPAR_newRecord;
    }

    public int PAR_RequiredNum() {
        return this.m_bPAR_requiredNum;
    }

    public PuzzleBlocSpawner BlocSpawner() {
        return this.m_blocSpawner;
    }

    public int NumCollectableLeft() {
        return this.m_numCollectable;
    }

    public ePlayerMode PlayModeOld() {
        return this.m_playModeOld;
    }

    public ePlayerMode PlayMode() {
        return this.m_playMode;
    }

    public CollectedMaterialHud MaterialHub() {
        return this.m_materialHub;
    }

    public PlayerBehaviour(String _id, Actor _owner, Actor.eActorMaterial _material) {
        super(_id, _owner, _material);
        this.m_owner.NeedRoundedSorting(true);
        this.m_owner.facing(FlxSprite.Flx2DFacing.Right);
        this.m_moveTarget = new FlxSprite();
        this.m_moveTarget.createGraphic(20, 20, Color.Yellow());
        GameVars.CameraPercOffsetXY(new Vector2(GameVars.CameraPercOffsetXYinit()));
    }

    public boolean canGoToPuzzleMode() {
        return !(GameVars.PlayerCanDoPuzzle() <= 0 || this.m_numCollectable < GameVars.BlocCountToFormPiece() && !this.m_blocSpawner.UseLineScan() || this.m_animState != eAnimState.eAnimState_Idle && this.m_animState != eAnimState.eAnimState_Walk && this.m_animState != eAnimState.eAnimState_Run);
    }

    public boolean isAnimState(eAnimState _state) {
        return this.m_animState == _state;
    }

    public boolean endLevelDisplayDone() {
        return this.m_materialHub.DisplayResultBTMDone();
    }

    @Override
    protected void initOwnerFlixelProperties() {
        if (this.m_playMode == ePlayerMode.ePlayerMode_Bloc) {
            this.m_owner.fixed = true;
            this.m_owner.moves = false;
        } else {
            this.m_owner.fixed = false;
            this.m_owner.moves = true;
        }
    }

    protected void _levelModeChanged(Object sender, Object e) {
        this._initVariables(this.m_owner.Level().Mode() == Level.eLevelMode.eLevelMode_Edit);
    }

    protected void _initVariables(boolean _editMode) {
        if (!_editMode) {
            this.m_owner.acceleration.Y = this.AccelerationY;
            this.m_owner.maxVelocity.X = this.m_bRunning ? this.RunSpeed : this.WalkSpeed;
            this.m_owner.drag.X = this.m_owner.maxVelocity.X * this.DragDecelFactor;
            this.m_owner.maxVelocity.Y = this.JumpPower;
        } else {
            this.m_owner.drag.X = 0.0f;
            this.m_owner.acceleration.Y = 0.0f;
            this.m_owner.maxVelocity.X = 0.0f;
            this.m_owner.maxVelocity.Y = 0.0f;
        }
    }

    @Override
    public void init() {
        this.m_playMode = ePlayerMode.ePlayerMode_Move;
        this._buildCollectableCounters();
        this._reteiveParams();
        this._levelModeChanged(null, null);
        this.m_owner.Level().addLevelModeChanged(this.m_levelModeChanged);
        this.m_blocSpawner = new PuzzleBlocSpawner(this, this.m_owner.Level().LayerIso(), this.m_owner.Level().LayerBlocDelimiter());
        this.m_blocSpawner.addPuzzleBlocSpawnerJustLeave(this.m_onBlocSpawnerleave);
        this.m_blocSpawner.addCursorMoved(this.m_onBlocSpawnerCursorMove);
        this.m_blocSpawner.addScanLineLaunched(this.m_onBlocSpawnerScanLineLaunched);
        this.m_blocSpawner.addScanLineDone(this.m_onBlocSpawnerScanLineDone);
        this.m_blocSpawner.addDestroyLineLaunched(this.m_onBlocSpawnerDestroyLineLaunched);
        this.m_blocSpawner.addDestroyLineDone(this.m_onBlocSpawnerDestroyLineDone);
        this.m_materialHub = new CollectedMaterialHud(this, this.m_owner.Level().LayerHud());
        if (this.m_owner.Level().Mode() == Level.eLevelMode.eLevelMode_Play || this.m_owner.Level().Mode() == Level.eLevelMode.eLevelMode_Test) {
            this.m_materialHub.show();
            this._syncCollectableHud();
        }
        this._initFullscreenQuad();
        this.m_owner.addRendererBehaviour(this);
        this._buildEye();
        this._buildElectricArc();
        this._moveFollowInit();
        if (this.m_owner.Level().PlayableMode()) {
            this._initSounds();
            this._doLevelBeginingPowerSave();
        }
        if (this.m_owner.Level().PlayableMode() && this.m_owner.Level().ParticleManager() != null) {
            this.m_drillEmitter = this.m_owner.Level().ParticleManager().emitterUseBegin("Drill");
            this.m_drillRepulseEmitter = this.m_owner.Level().ParticleManager().emitterUseBegin("NotDrillable");
        }
        AchievementManager.Instance().resetAchievementDeferred();
        this.m_bCheckBiggestFallAch = GameVars.GameMode() == GameMode.GameMode_Main && !AchievementManager.Instance().isAchievementUnlocked("ACH_AAAAAA");
    }

    public void reinitPlayerPower() {
        this._doLevelBeginingPowerSave();
        this._updateDrillLevel();
    }

    protected void _doLevelBeginingPowerSave() {
        this.m_savePowerAttribCanDoLine = GameVars.PlayerCanDoLines();
        this.m_savePowerAttribCanDoPuzzle = GameVars.PlayerCanDoPuzzle();
        this.m_savePowerAttribMaxDrillableMatId = GameVars.MaxDrillableMatId();
    }

    protected void _checkUndoPowerUnlockedDuringLevel() {
        if (this.m_owner.Level().PlayableMode() && this.m_powerUpdgradeDoneDuringLevel) {
            GameVars.PlayerCanDoLines(this.m_savePowerAttribCanDoLine);
            GameVars.PlayerCanDoPuzzle(this.m_savePowerAttribCanDoPuzzle);
            GameVars.MaxDrillableMatId(this.m_savePowerAttribMaxDrillableMatId);
            this._updateDrillLevel();
        }
    }

    protected void _initSounds() {
        this.m_sndJump = new FlxSound();
        this.m_sndJump.loadEmbedded(this.getStringParameter("SndJumpId"), false, true, true);
        this.m_sndBlocModeOn = new FlxSound();
        this.m_sndBlocModeOn.loadEmbedded(this.getStringParameter("SndPuzzleModeOnId"), false, true, true);
        this.m_sndBlocModeOff = new FlxSound();
        this.m_sndBlocModeOff.loadEmbedded(this.getStringParameter("SndPuzzleModeOffId"), false, true, true);
        this.m_sndDrillLoop = new FlxSound();
        this.m_sndDrillLoop.loadEmbedded(this.getStringParameter("SndDrillLoop"), true, true, false);
        this.m_sndDrillLoopInactive = new FlxSound();
        this.m_sndDrillLoopInactive.loadEmbedded(this.getStringParameter("SndDrillLoopInactive"), true, true, false);
        this.m_sndDrillStart = new FlxSound();
        this.m_sndDrillStart.loadEmbedded(this.getStringParameter("SndDrillStart"), true, true, false);
        this.m_sndDrillEnd = new FlxSound();
        this.m_sndDrillEnd.loadEmbedded(this.getStringParameter("SndDrillEnd"), true, true, false);
        this.m_sndStepGeneric = new FlxSound();
        this.m_sndStepGeneric.loadEmbedded(this.getStringParameter("SndStepGeneric"), false, true, true);
        this.m_sndStepByMat = new FlxSound[Actor.eActorMaterial.eActorMaterial_COUNT.ordinal()];
        Arrays.fill(this.m_sndStepByMat, null);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_Wood.ordinal(), this.m_sndStepByMat, this.getStringParameter("SndStepWood"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_Sand.ordinal(), this.m_sndStepByMat, this.getStringParameter("SndStepSand"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_Stone.ordinal(), this.m_sndStepByMat, this.getStringParameter("SndStepStone"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_Iron.ordinal(), this.m_sndStepByMat, this.getStringParameter("SndStepIron"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_Gold.ordinal(), this.m_sndStepByMat, this.getStringParameter("SndStepGold"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_Diamond.ordinal(), this.m_sndStepByMat, this.getStringParameter("SndStepDiamond"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_Ruby.ordinal(), this.m_sndStepByMat, this.getStringParameter("SndStepRuby"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_Jade.ordinal(), this.m_sndStepByMat, this.getStringParameter("SndStepJade"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_IronOre.ordinal(), this.m_sndStepByMat, this.getStringParameter("SndStepIronOre"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_GoldOre.ordinal(), this.m_sndStepByMat, this.getStringParameter("SndStepGoldOre"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_DiamondOre.ordinal(), this.m_sndStepByMat, this.getStringParameter("SndStepDiamondOre"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_RubyOre.ordinal(), this.m_sndStepByMat, this.getStringParameter("SndStepRubyOre"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_JadeOre.ordinal(), this.m_sndStepByMat, this.getStringParameter("SndStepJadeOre"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_Ice.ordinal(), this.m_sndStepByMat, this.getStringParameter("SndStepIce"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_Tnt.ordinal(), this.m_sndStepByMat, this.getStringParameter("SndStepTnt"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_Chest.ordinal(), this.m_sndStepByMat, this.getStringParameter("SndStepChest"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_Workshop.ordinal(), this.m_sndStepByMat, this.getStringParameter("SndStepUpdgrade"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_ChestBTM.ordinal(), this.m_sndStepByMat, this.getStringParameter("SndStepChestBTM"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_Switch.ordinal(), this.m_sndStepByMat, this.getStringParameter("SndStepSwitch"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_Lava.ordinal(), this.m_sndStepByMat, this.getStringParameter("SndStepLava"), false, true, true);
        this.m_sndReceptionGeneric = new FlxSound();
        this.m_sndReceptionGeneric.loadEmbedded(this.getStringParameter("SndReceptGeneric"), false, true, true);
        this.m_sndReceptionByMat = new FlxSound[Actor.eActorMaterial.eActorMaterial_COUNT.ordinal()];
        Arrays.fill(this.m_sndReceptionByMat, null);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_Wood.ordinal(), this.m_sndReceptionByMat, this.getStringParameter("SndReceptWood"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_Sand.ordinal(), this.m_sndReceptionByMat, this.getStringParameter("SndReceptSand"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_Stone.ordinal(), this.m_sndReceptionByMat, this.getStringParameter("SndReceptStone"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_Iron.ordinal(), this.m_sndReceptionByMat, this.getStringParameter("SndReceptIron"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_Gold.ordinal(), this.m_sndReceptionByMat, this.getStringParameter("SndReceptGold"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_Diamond.ordinal(), this.m_sndReceptionByMat, this.getStringParameter("SndReceptDiamond"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_Ruby.ordinal(), this.m_sndReceptionByMat, this.getStringParameter("SndReceptRuby"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_Jade.ordinal(), this.m_sndReceptionByMat, this.getStringParameter("SndReceptJade"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_IronOre.ordinal(), this.m_sndReceptionByMat, this.getStringParameter("SndReceptIronOre"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_GoldOre.ordinal(), this.m_sndReceptionByMat, this.getStringParameter("SndReceptGoldOre"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_DiamondOre.ordinal(), this.m_sndReceptionByMat, this.getStringParameter("SndReceptDiamondOre"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_RubyOre.ordinal(), this.m_sndReceptionByMat, this.getStringParameter("SndReceptRubyOre"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_JadeOre.ordinal(), this.m_sndReceptionByMat, this.getStringParameter("SndReceptJadeOre"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_Ice.ordinal(), this.m_sndReceptionByMat, this.getStringParameter("SndReceptIce"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_Tnt.ordinal(), this.m_sndReceptionByMat, this.getStringParameter("SndReceptTnt"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_Chest.ordinal(), this.m_sndReceptionByMat, this.getStringParameter("SndReceptChest"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_Workshop.ordinal(), this.m_sndReceptionByMat, this.getStringParameter("SndReceptUpdgrade"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_ChestBTM.ordinal(), this.m_sndReceptionByMat, this.getStringParameter("SndReceptChestBTM"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_Switch.ordinal(), this.m_sndReceptionByMat, this.getStringParameter("SndReceptSwitch"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_Lava.ordinal(), this.m_sndReceptionByMat, this.getStringParameter("SndReceptLava"), false, true, true);
        this.m_sndHitWithHeadGeneric = new FlxSound();
        this.m_sndHitWithHeadGeneric.loadEmbedded(this.getStringParameter("SndHeadHitGeneric"), false, true, true);
        this.m_sndHitWithHeadByMat = new FlxSound[Actor.eActorMaterial.eActorMaterial_COUNT.ordinal()];
        Arrays.fill(this.m_sndHitWithHeadByMat, null);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_Wood.ordinal(), this.m_sndHitWithHeadByMat, this.getStringParameter("SndHeadHitWood"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_Sand.ordinal(), this.m_sndHitWithHeadByMat, this.getStringParameter("SndHeadHitSand"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_Stone.ordinal(), this.m_sndHitWithHeadByMat, this.getStringParameter("SndHeadHitStone"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_Iron.ordinal(), this.m_sndHitWithHeadByMat, this.getStringParameter("SndHeadHitIron"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_Gold.ordinal(), this.m_sndHitWithHeadByMat, this.getStringParameter("SndHeadHitGold"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_Diamond.ordinal(), this.m_sndHitWithHeadByMat, this.getStringParameter("SndHeadHitDiamond"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_Ruby.ordinal(), this.m_sndHitWithHeadByMat, this.getStringParameter("SndHeadHitRuby"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_Jade.ordinal(), this.m_sndHitWithHeadByMat, this.getStringParameter("SndHeadHitJade"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_IronOre.ordinal(), this.m_sndHitWithHeadByMat, this.getStringParameter("SndHeadHitIronOre"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_GoldOre.ordinal(), this.m_sndHitWithHeadByMat, this.getStringParameter("SndHeadHitGoldOre"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_DiamondOre.ordinal(), this.m_sndHitWithHeadByMat, this.getStringParameter("SndHeadHitDiamondOre"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_RubyOre.ordinal(), this.m_sndHitWithHeadByMat, this.getStringParameter("SndHeadHitRubyOre"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_JadeOre.ordinal(), this.m_sndHitWithHeadByMat, this.getStringParameter("SndHeadHitJadeOre"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_Ice.ordinal(), this.m_sndHitWithHeadByMat, this.getStringParameter("SndHeadHitIce"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_Tnt.ordinal(), this.m_sndHitWithHeadByMat, this.getStringParameter("SndHeadHitTnt"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_Chest.ordinal(), this.m_sndHitWithHeadByMat, this.getStringParameter("SndHeadHitChest"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_Workshop.ordinal(), this.m_sndHitWithHeadByMat, this.getStringParameter("SndHeadHitUpdgrade"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_ChestBTM.ordinal(), this.m_sndHitWithHeadByMat, this.getStringParameter("SndHeadHitChestBTM"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_Switch.ordinal(), this.m_sndHitWithHeadByMat, this.getStringParameter("SndHeadHitSwitch"), false, true, true);
        this._initSoundSlot(Actor.eActorMaterial.eActorMaterial_Lava.ordinal(), this.m_sndHitWithHeadByMat, this.getStringParameter("SndHeadHitLava"), false, true, true);
        this.m_sndHit = new FlxSound();
        this.m_sndHit.loadEmbedded(this.getStringParameter("SndHit"), false, true, true);
        this.m_sndDrillRepulse = new FlxSound();
        this.m_sndDrillRepulse.loadEmbedded(this.getStringParameter("SndDrillUnbreakable"), false, true, true);
        this.m_sndAlea = new FlxSound();
        this.m_sndAlea.loadEmbedded(this.getStringParameter("SndAleabot"), false, true, true);
        this.m_sndShift = new FlxSound();
        this.m_sndShift.loadEmbedded(this.getStringParameter("SndShift"), false, true, true);
        this.m_sndBreakLevel01 = new FlxSound();
        this.m_sndBreakLevel01.loadEmbedded(this.getStringParameter("SndBreakLvl01"), false, true, true);
        this.m_sndBreakLevel02 = new FlxSound();
        this.m_sndBreakLevel02.loadEmbedded(this.getStringParameter("SndBreakLvl02"), false, true, true);
        this.m_sndBreakLevel03 = new FlxSound();
        this.m_sndBreakLevel03.loadEmbedded(this.getStringParameter("SndBreakLvl03"), false, true, true);
        this.m_sndDrillLevel01 = new FlxSound();
        this.m_sndDrillLevel01.loadEmbedded(this.getStringParameter("SndDrillLvl01"), false, true, true);
        this.m_sndDrillLevel02 = new FlxSound();
        this.m_sndDrillLevel02.loadEmbedded(this.getStringParameter("SndDrillLvl02"), false, true, true);
        this.m_sndDrillLevel03 = new FlxSound();
        this.m_sndDrillLevel03.loadEmbedded(this.getStringParameter("SndDrillLvl03"), false, true, true);
        this.m_sndRestartLevel = new FlxSound();
        this.m_sndRestartLevel.loadEmbedded(this.getStringParameter("SndResetLevel"), false, true, false);
        this.m_sndDammage = new FlxSound();
        this.m_sndDammage.loadEmbedded(this.getStringParameter("SndDamage"), false, true, true);
        this.m_sndDie = new FlxSound();
        this.m_sndDie.loadEmbedded(this.getStringParameter("SndDie"), false, true, true);
        this.m_sndElecArc = new FlxSound();
        this.m_sndElecArc.loadEmbedded(this.getStringParameter("SndElecArc"), true, true, false);
        this.m_sndElecArcEnd = new FlxSound();
        this.m_sndElecArcEnd.loadEmbedded(this.getStringParameter("SndElecArcEnd"), true, true, false);
        this.m_bPlayHitSoundOnUnbreakable = this.getIntParameter("PlayHitSoundOnUnbreakable") > 0;
        this.m_bPlayAleaSoundOnDrillRepulse = this.getIntParameter("PlayAleaSoundOnDrillRepulse") > 0;
    }

    protected void _initSoundSlot(int _slot, FlxSound[] _array, String _soundId, boolean _bLooped, boolean _bCue, boolean _bAllowMultiplePlay) {
        if (_soundId.length() > 0) {
            FlxSound snd = new FlxSound();
            snd.loadEmbedded(_soundId, _bLooped, _bCue, _bAllowMultiplePlay);
            _array[_slot] = snd;
        } else {
            _array[_slot] = null;
        }
    }

    protected void _portalFollowInit(Actor _portalActor) {
        this.m_moveTarget.x = _portalActor.x + _portalActor.width * 0.5f - this.m_moveTarget.width * 0.5f;
        this.m_moveTarget.y = _portalActor.y + _portalActor.height * 0.5f - this.m_moveTarget.height * 0.5f;
        this.m_moveTarget.velocity = Vector2.Zero();
        this.m_moveTarget.drag = Vector2.Zero();
        FlxG.follow(this.m_moveTarget, 2.5f);
        FlxG.followAdjust(0.5f, 0.0f);
        this._cameraBoundsInit();
    }

    protected void _moveFollowInit() {
        this._updateMoveTargetPosition();
        FlxG.follow(this.m_moveTarget, this.m_cameraMoveLerp);
        FlxG.followAdjust(this.m_cameraMoveAdjustX, this.m_cameraMoveAdjustY);
        this._cameraBoundsInit();
    }

    protected void _puzzleFollowInit() {
        this.m_owner.acceleration.X = 0.0f;
        int tmpx = (int)(this.m_owner.getCenterX() / (float)GameVars.TileStep());
        this.m_owner.x = (float)(tmpx * GameVars.TileStep()) + 10.0f;
        this._updateMoveTargetPosition();
        FlxG.follow(this.m_moveTarget, 10.0f);
        FlxG.followAdjust(0.0f, 0.0f);
        this._cameraBoundsInit();
        FlxG.doFollow();
    }

    protected void _updateMoveTargetPosition() {
        if (this.m_bPortalControl) {
            this.m_moveTarget.velocity.Y = 0.0f;
            this.m_moveTarget.velocity.X = 0.0f;
            this.m_moveTarget.drag.Y = 0.0f;
            this.m_moveTarget.drag.X = 0.0f;
        } else {
            if (this.m_playMode != ePlayerMode.ePlayerMode_Camera && this.m_playMode != ePlayerMode.ePlayerMode_ShowElement) {
                if (this.m_owner.Level().PlayableMode()) {
                    this.m_moveTarget.x = this.m_owner.x + this.m_owner.width * 0.5f - this.m_moveTarget.width * 0.5f + GameVars.CameraPercOffsetXY().X * (float)FlxG.width * (this.m_owner.facing() == FlxSprite.Flx2DFacing.Left ? -1.0f : 1.0f);
                    this.m_moveTarget.y = this.m_owner.y + this.m_owner.height * 0.5f - this.m_moveTarget.height * 0.5f - GameVars.CameraPercOffsetXY().Y * (float)FlxG.height;
                } else {
                    this.m_moveTarget.x = this.m_owner.x + this.m_owner.width * 0.5f - this.m_moveTarget.width * 0.5f;
                    this.m_moveTarget.y = this.m_owner.y + this.m_owner.height * 0.5f - this.m_moveTarget.height * 0.5f;
                }
            }
            if (this.m_playMode == ePlayerMode.ePlayerMode_Move) {
                this.m_moveTarget.velocity.copy(this.m_owner.velocity);
                this.m_moveTarget.drag.copy(this.m_owner.drag);
            } else {
                this.m_moveTarget.velocity.Y = 0.0f;
                this.m_moveTarget.velocity.X = 0.0f;
                this.m_moveTarget.drag.Y = 0.0f;
                this.m_moveTarget.drag.X = 0.0f;
            }
        }
    }

    protected void _puzzleOutFollowInit() {
        this._moveFollowInit();
    }

    protected void _cameraFollowInit() {
        this.m_owner.acceleration.X = 0.0f;
        this._updateMoveTargetPosition();
        FlxG.follow(this.m_moveTarget, 10.0f);
        FlxG.followAdjust(0.0f, 0.0f);
        this._cameraBoundsInit();
    }

    protected void _elementFollowInit(Actor _elementToShow) {
        this.m_targetSaveCx = this.m_moveTarget.x + this.m_moveTarget.width * 0.5f;
        this.m_targetSaveCy = this.m_moveTarget.y + this.m_moveTarget.height * 0.5f;
        this.m_elementToShow = _elementToShow;
        this.m_owner.Level().TweenManager().ToPosition(this.m_moveTarget, new Vector2(_elementToShow.getCenterX(), _elementToShow.getCenterY()), 2.0f, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, this.m_onGoToElementToShowDone);
        this.m_owner.Level().AllowEnnemiesMove(false);
    }

    protected void _onGoToElementToShowDone(Object _sender, Object _e) {
        this.m_elementToShow.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_LookAtCallback, this.m_owner);
        this.m_elementToShow = null;
    }

    protected void _elementFollowBackInit() {
        this.m_owner.Level().TweenManager().ToPosition(this.m_moveTarget, new Vector2(this.m_targetSaveCx, this.m_targetSaveCy), 2.0f, TweenManager.EaseType.EASE_INOUTSIN, 0.0f, this.m_onGoToElementToShowBackDone);
    }

    protected void _onGoToElementToShowBackDone(Object _sender, Object _e) {
        this._setMode(ePlayerMode.ePlayerMode_Move);
        this.m_owner.Level().AllowEnnemiesMove(true);
    }

    protected void _cameraOutFollowInit() {
        this._moveFollowInit();
    }

    protected void _cameraBoundsInit() {
        if (this.m_owner.Level().Mode() == Level.eLevelMode.eLevelMode_Edit) {
            FlxG.followBounds(-1073741824, -1073741824, 0x3FFFFFFF, 0x3FFFFFFF);
        } else {
            FlxG.followBounds((int)(this.m_owner.Level().LeftBottom().X + GameVars.CameraBoundMarginsTBLR().Z), (int)(this.m_owner.Level().RightTop().Y + GameVars.CameraBoundMarginsTBLR().X), (int)(this.m_owner.Level().RightTop().X + GameVars.CameraBoundMarginsTBLR().W), (int)(this.m_owner.Level().LeftBottom().Y + GameVars.CameraBoundMarginsTBLR().Y));
        }
    }

    protected void _initFullscreenQuad() {
        this.m_fullscreenPuzzleModeFilter = new FlxSprite();
        this.m_fullscreenPuzzleModeFilter.createGraphic(FlxG.width, FlxG.height, Color.BlueViolet());
        this.m_fullscreenPuzzleModeFilter.alpha(0.2f);
        this.m_fullscreenPuzzleModeFilter.scrollFactor = Vector2.Zero();
        this.m_fullscreenPuzzleModeFilter.visible = false;
        this.m_hologramPuzzleZone = new HologramPuzzleZone(this.m_owner.Level().LayerPostProcess(), this.m_owner.Level(), this.m_moveTarget);
        this.m_owner.Level().LayerPostProcess().add(this.m_fullscreenPuzzleModeFilter);
    }

    protected void _showFullscreenQuad() {
        this.m_fullscreenPuzzleModeFilter.visible = true;
    }

    protected void _hideFullscreenQuad() {
        this.m_fullscreenPuzzleModeFilter.visible = false;
    }

    protected void _buildCollectableCounters() {
        this.m_collectableCounters = new int[Actor.NumCollectableMat()];
        this.m_collectableNeededCounters = new int[Actor.NumCollectableMat()];
        this._resetCollectableCounters();
        this._resetCollectableNeededCounters();
        this.m_numCollectable = 0;
    }

    protected void _resetCollectableCounters() {
        int i = 0;
        while (i < this.m_collectableCounters.length) {
            this.m_collectableCounters[i] = 0;
            ++i;
        }
    }

    protected void _resetCollectableNeededCounter(Actor.eActorMaterial _materialId) {
        int id = _materialId.ordinal() - Actor.FirstCollectableMatIdHACK();
        this.m_collectableNeededCounters[id] = 0;
    }

    protected void _resetCollectableNeededCounters() {
        int i = 0;
        while (i < this.m_collectableNeededCounters.length) {
            this.m_collectableNeededCounters[i] = 0;
            ++i;
        }
    }

    protected void _syncCollectableHud() {
        this.m_materialHub.sync();
    }

    public int getCollectableAmount(int _itemId) {
        return this.m_collectableCounters[_itemId];
    }

    public int getCollectableNeededAmount(int _itemId) {
        return this.m_collectableNeededCounters[_itemId];
    }

    public int getCollectableAmount(Actor.eActorMaterial _materialId) {
        int id = _materialId.ordinal() - Actor.FirstCollectableMatIdHACK();
        return this.m_collectableCounters[id];
    }

    public void tresholdCollectableAmount(Actor.eActorMaterial _materialId, int _amount) {
        int id = _materialId.ordinal() - Actor.FirstCollectableMatIdHACK();
        this.m_collectableCounters[id] = _amount;
        this.m_materialHub.sync();
    }

    protected void _reteiveParams() {
        this.m_bInstantKillOnEveryThing = this.getIntParameter("InstantKillOnEveryThing") > 0;
        this.JumpPower = this.getIntParameter("JumpPower");
        this.AccelerationY = this.getFloatParameter("AccelY");
        this.DragDecelFactor = this.getFloatParameter("DragDecelFactor");
        this.RunSpeed = this.getFloatParameter("RunSpeed");
        this.WalkSpeed = this.getFloatParameter("WalkSpeed");
        this.TimePressRetry = this.getFloatParameter("TimePressRetry");
        this.m_blinkTick = this.getFloatParameter("BlinkTick");
        this.TimeRunButtonDelay = this.getFloatParameter("TimeRunButtonDelay");
        this.m_jumpType = this.getIntParameter("MeatBoyRunMode") > 0 ? eJumpType.eJumpType_SuperMeatBoy : eJumpType.eJumpType_MarioBros;
        this.m_eyeDrillTurnIdleFactor = this.getFloatParameter("noContactDrillRotationSpeed");
        if (this.m_eyeDrillTurnIdleFactor <= 0.0f) {
            this.m_eyeDrillTurnIdleFactor = Float.MAX_VALUE;
        }
        this._updateDrillLevel();
        this.m_bDrillOnlyOnContact = this.getIntParameter("DrillOnlyOnContact") > 0;
        this.m_drillLoopToDrillNoContactLoopDelay = this.getFloatParameter("DrillLoopToDrillNoContactLoopDelay");
        String[] frames = this.getStringParameter("frameWalkTriggerSndStep").split(",");
        this.m_stepWalkSndTrigger = new int[frames.length];
        int i = 0;
        while (i < frames.length) {
            this.m_stepWalkSndTrigger[i] = Integer.parseInt(frames[i]);
            ++i;
        }
        frames = this.getStringParameter("frameRunTriggerSndStep").split(",");
        this.m_stepRunSndTrigger = new int[frames.length];
        i = 0;
        while (i < frames.length) {
            this.m_stepRunSndTrigger[i] = Integer.parseInt(frames[i]);
            ++i;
        }
        this.m_bPlaySndStepInRunForTheLoul = this.getIntParameter("playSndStepInRunForTheLoul") > 0;
        this.m_bPlayDrillStartStop = this.getIntParameter("playDrillStartStop") > 0;
        boolean bl = this.m_bPlayAleaOnDrillStartStop = this.getIntParameter("playAleaOnDrillStartStop") > 0;
        if (GameVars.GameCommunityMode()) {
            float cameraOffsetx = this.getFloatParameter("CameraPercOffsetX");
            float cameraOffsety = this.getFloatParameter("CameraPercOffsetY");
            GameVars.CameraPercOffsetXY(new Vector2(cameraOffsetx, cameraOffsety));
            this.m_cameraMoveLerp = this.getFloatParameter("CameraLerp");
            this.m_cameraMoveAdjustX = this.getFloatParameter("CameraAdjustX");
            this.m_cameraMoveAdjustY = this.getFloatParameter("CameraAdjustY");
        }
    }

    public void unlockAllPower() {
        GameVars.PlayerCanDoPuzzle(1);
        GameVars.MaxDrillableMatId(Actor.UpdateDrillStep03.ordinal());
        this._updateDrillLevel();
    }

    protected void _updateDrillLevel() {
        if (GameVars.MaxDrillableMatId() >= Actor.UpdateDrillStep01.ordinal() - 1 && GameVars.MaxDrillableMatId() <= Actor.UpdateDrillStep01.ordinal() + 1) {
            GameVars.MaxDrillableMatId(Actor.UpdateDrillStep01.ordinal());
        } else if (GameVars.MaxDrillableMatId() >= Actor.UpdateDrillStep02.ordinal() - 1 && GameVars.MaxDrillableMatId() <= Actor.UpdateDrillStep02.ordinal() + 1) {
            GameVars.MaxDrillableMatId(Actor.UpdateDrillStep02.ordinal());
        } else if (GameVars.MaxDrillableMatId() >= Actor.UpdateDrillStep03.ordinal() - 1 && GameVars.MaxDrillableMatId() <= Actor.UpdateDrillStep03.ordinal() + 1) {
            GameVars.MaxDrillableMatId(Actor.UpdateDrillStep03.ordinal());
        }
        if (GameVars.MaxDrillableMatId() < 0) {
            Actor.SetCanBeDrilled(Actor.NothingToDrillStep, false);
        } else {
            Actor.SetCanBeDrilled(Actor.IntToeActorMaterial[GameVars.MaxDrillableMatId()], true);
        }
    }

    @Override
    public void deinit() {
        this._checkUndoPowerUnlockedDuringLevel();
        this._destroyLoopSounds(false);
    }

    protected void _destroyLoopSounds(boolean _onlyStop) {
        this._deinitSound(this.m_sndDrillLoop, _onlyStop);
        this._deinitSound(this.m_sndDrillLoopInactive, _onlyStop);
        this._deinitSound(this.m_sndElecArc, _onlyStop);
    }

    protected void _deinitSound(FlxSound _snd, boolean _onlyStop) {
        if (_snd != null) {
            _snd.stop();
            if (!_onlyStop) {
                _snd = null;
            }
        }
    }

    public boolean isModeNew(ePlayerMode _mode) {
        return this.m_playModeOld != _mode && this.m_playMode == _mode;
    }

    protected void _updateLeftOrRightDownFlag() {
        this.m_bLeftOrRightDown = InputManager.IsButtonDown(Buttons.LeftThumbstickLeft) || InputManager.IsButtonDown(Buttons.LeftThumbstickRight) || InputManager.IsButtonDown(Buttons.DPadLeft) || InputManager.IsButtonDown(Buttons.DPadRight);
    }

    @Override
    public void update() {
        this._updateLeftOrRightDownFlag();
        if (!this.m_owner.visible) {
            if (this.m_bPortalControl) {
                this.m_owner.acceleration.X = 0.0f;
                this.m_owner.velocity.Y = 0.0f;
            }
            this._updateMoveTargetPosition();
            this._handleDebugInput();
            this.m_materialHub.update();
            return;
        }
        if (this.m_owner.Level().PlayableMode() && (GameVars.CheatCanFly() && this.m_owner.Level().Mode() == Level.eLevelMode.eLevelMode_Test || MACRO.DEBUG)) {
            if (InputManager.IsNewButtonPress(Buttons.RightStick)) {
                boolean bl = this.m_bDebugGrabMove = !this.m_bDebugGrabMove;
                if (!this.m_bDebugGrabMove) {
                    this._initVariables(false);
                }
            }
            if (this.m_bDebugGrabMove) {
                this._handleGrabMovement();
                this._updateMoveTargetPosition();
                return;
            }
        }
        this.m_playModeOld = this.m_playMode;
        this._checkMode();
        this._handleDebugInput();
        this._handleMovement();
        if (this.m_playMode == ePlayerMode.ePlayerMode_Bloc) {
            this.m_blocSpawner.update();
        }
        if (this.m_bUpdateHud) {
            this._syncCollectableHud();
            this.m_bUpdateHud = false;
        }
        this._updateAnimState();
        this._updateEye();
        if (this.m_owner.Level().PlayableMode()) {
            this.m_materialHub.update();
        }
        this._updateDrilling();
        if (this.m_playMode == ePlayerMode.ePlayerMode_Move && this.m_owner.Level().PlayableMode()) {
            this._updateMoveSounds();
            this._updateWarpBounds();
        }
        this._updateMoveTargetPosition();
        this._updateDammageState();
        if (this.m_bLimitingY && this.m_owner.velocity.Y > 0.0f) {
            this.m_owner.y = this.m_limitY - this.m_owner.height;
        }
        if (this.m_bCheckBiggestFallAch) {
            this._checkBiggestFallAch();
        }
    }

    protected void _checkBiggestFallAch() {
        if (this.m_animStateOld != eAnimState.eAnimState_Fall && this.m_animState == eAnimState.eAnimState_Fall) {
            this.m_fallBeginY = this.m_owner.y;
            this.m_fallEndY = this.m_owner.y;
        } else if (this.m_animStateOld == eAnimState.eAnimState_Fall && this.m_animState != eAnimState.eAnimState_Fall) {
            this.m_fallEndY = this.m_owner.y;
            if (this.m_fallEndY - this.m_fallBeginY > 2550.0f) {
                AchievementManager.Instance().unlockAchievement("ACH_AAAAAA");
                this.m_bCheckBiggestFallAch = false;
            }
        }
    }

    protected void _updateEye() {
        this.m_eye.update();
        if (this.m_eyeUpdgradeLevel != 0 && GameVars.MaxDrillableMatId() == -1) {
            this.m_eyeUpdgradeLevel = 0;
            this.m_eyeUpgrade.play("updgrade1");
            this.m_eyeUpgrade.visible = false;
        } else if (this.m_eyeUpdgradeLevel == 0 && GameVars.MaxDrillableMatId() >= Actor.UpdateDrillStep02.ordinal() - 1 && GameVars.MaxDrillableMatId() < Actor.UpdateDrillStep03.ordinal()) {
            this.m_eyeUpgrade.play("updgrade1");
            this.m_eyeUpgrade.visible = true;
            this.m_eyeUpdgradeLevel = 2;
        } else if ((this.m_eyeUpdgradeLevel == 0 || this.m_eyeUpdgradeLevel == 2) && GameVars.MaxDrillableMatId() >= Actor.UpdateDrillStep03.ordinal()) {
            this.m_eyeUpgrade.play("updgrade2");
            this.m_eyeUpgrade.visible = true;
            this.m_eyeUpdgradeLevel = 3;
        }
    }

    protected void _updateDammageState() {
        switch (this.m_dammageState) {
            case eDammageState_None: {
                if (!this.m_bDammageThisFrame) break;
                if (this.m_bFirstDammage) {
                    this.m_bFirstDammage = false;
                    this.m_eyeHurt.visible = true;
                    this.m_sndDammage.play();
                    this.m_electricity.play("idle", true);
                    if (this.m_sndElecArc.playing()) {
                        this.m_sndElecArc.stop();
                    }
                    this.m_sndElecArc.play();
                    this.m_timeElapsedDamage = 0.0f;
                    this.m_blinkElapsed = 0.0f;
                    this.m_blinkAlphaIndex = 0;
                    this.m_dammageState = eDammageState.eDammageState_BlinkingElectric;
                    break;
                }
                this.m_sndDammage.play();
                this._goToExplode();
                break;
            }
            case eDammageState_BlinkingElectric: {
                this.m_electricity.update();
                this.m_timeElapsedDamage += FlxG.elapsed;
                this._updateBlink();
                if (!(this.m_timeElapsedDamage > this.m_timeInvincibleElectric)) break;
                this.m_timeElapsedDamage = 0.0f;
                this.m_owner.alpha(1.0f);
                this.m_dammageState = eDammageState.eDammageState_Electric;
                break;
            }
            case eDammageState_Electric: {
                this.m_electricity.update();
                this.m_timeElapsedDamage += FlxG.elapsed;
                if (this.m_bDammageThisFrame) {
                    this.m_sndDammage.play();
                    this._goToExplode();
                    break;
                }
                if (!(this.m_timeElapsedDamage > this.m_timeVulnerableElectric)) break;
                this.m_timeElapsedDamage = 0.0f;
                this.m_dammageState = eDammageState.eDammageState_None;
                this.m_sndElecArc.stop();
                this.m_sndElecArcEnd.play();
                break;
            }
            case eDammageState_Exploding: {
                if (!(this.m_owner.alpha() <= 0.0f)) break;
                this.m_timeElapsedDamage += FlxG.elapsed;
                if (!(this.m_timeElapsedDamage > 1.0f)) break;
                this.m_owner.Level().restart();
                this.m_dammageState = eDammageState.eDammageState_Exploded;
            }
        }
        this.m_bDammageThisFrame = false;
    }

    protected void _goToExplode() {
        if (!this.m_bFadeLaunched) {
            this.m_bFadeLaunched = true;
            if (!this.m_bPortalControl) {
                this.m_dammageState = eDammageState.eDammageState_Exploding;
                this.m_owner.Level().ParticleManager().startKaboomEmitter(this.m_owner.getCenterX(), this.m_owner.getCenterY(), this.m_owner, KaboomParticleEffect.Dark());
                this.m_timeElapsedDamage = 0.0f;
            }
        }
        AchievementManager.Instance().resetAchievementDeferred();
    }

    protected void _onExplode() {
        this.m_owner.alpha(0.0f);
        this.m_bPortalControl = true;
        this.m_sndDie.play();
        this._destroyLoopSounds(true);
        FlxG.quake.start(0.02f, 0.35f);
    }

    protected void _updateBlink() {
        this.m_blinkElapsed += FlxG.elapsed;
        if (this.m_blinkElapsed > this.m_blinkTick) {
            this.m_blinkElapsed = 0.0f;
            this.m_owner.alpha(this.m_blinkArrayAlpha[this.m_blinkAlphaIndex]);
            ++this.m_blinkAlphaIndex;
            if (this.m_blinkAlphaIndex >= this.m_blinkArrayAlpha.length) {
                this.m_blinkAlphaIndex = 0;
            }
        }
    }

    protected void _updateWarpBounds() {
        if (this.m_owner.Level().RightTop().X < this.m_owner.x + this.m_owner.width) {
            this.m_owner.x = this.m_owner.Level().RightTop().X - this.m_owner.width;
        } else if (this.m_owner.x < 0.0f) {
            this.m_owner.x = 0.0f;
        }
    }

    protected void _updateMoveSounds() {
        if (this.m_animState == eAnimState.eAnimState_Walk) {
            this.m_stepWalkLastAnimFrameIdRef.set(this.m_stepWalkLastAnimFrameId);
            this.m_stepWalkLastAnimFrameIdTriggeredRef.set(this.m_stepWalkLastAnimFrameIdTriggered);
            this._playSoundStepIfNeeded(this.m_owner.CurFrame(), this.m_stepWalkSndTrigger, this.m_stepWalkLastAnimFrameIdRef, this.m_stepWalkLastAnimFrameIdTriggeredRef);
            this.m_stepWalkLastAnimFrameId = this.m_stepWalkLastAnimFrameIdRef.get();
            this.m_stepWalkLastAnimFrameIdTriggered = this.m_stepWalkLastAnimFrameIdTriggeredRef.get();
        } else if (this.m_animState == eAnimState.eAnimState_Run && this.m_bPlaySndStepInRunForTheLoul) {
            this.m_stepRunLastAnimFrameIdRef.set(this.m_stepRunLastAnimFrameId);
            this.m_stepRunLastAnimFrameIdTriggeredRef.set(this.m_stepRunLastAnimFrameIdTriggered);
            this._playSoundStepIfNeeded(this.m_owner.CurFrame(), this.m_stepRunSndTrigger, this.m_stepRunLastAnimFrameIdRef, this.m_stepRunLastAnimFrameIdTriggeredRef);
            this.m_stepRunLastAnimFrameId = this.m_stepRunLastAnimFrameIdRef.get();
            this.m_stepRunLastAnimFrameIdTriggered = this.m_stepRunLastAnimFrameIdTriggeredRef.get();
        }
        if (this.m_landingMaterial != null && this.m_animStateOld == eAnimState.eAnimState_Fall && this.m_animState != eAnimState.eAnimState_Fall) {
            this._playSoundByMat(this.m_sndReceptionByMat[this.m_landingMaterial.ordinal()], this.m_sndReceptionGeneric);
        }
    }

    protected void _playSoundByMat(FlxSound _sndByMat, FlxSound _sndGeneric) {
        if (_sndByMat != null) {
            _sndByMat.play();
        } else {
            _sndGeneric.play();
        }
    }

    protected void _playSoundStepIfNeeded(int _curAnimId, int[] _frameIdArray, ref<Integer> _idLastFrameRef, ref<Integer> _idLastPlayedRef) {
        int _idLastFrame = _idLastFrameRef.get();
        int _idLastPlayed = _idLastPlayedRef.get();
        int count = _frameIdArray.length;
        if (count > 0 && _curAnimId != _idLastFrame) {
            int max;
            int min;
            if (_idLastFrame <= _curAnimId) {
                min = _idLastFrame;
                max = _curAnimId;
            } else {
                min = 0;
                max = _curAnimId;
            }
            int i = 0;
            while (i < _frameIdArray.length) {
                int id = _frameIdArray[i];
                if ((_idLastPlayed != id || count == 1) && min <= id && id <= max) {
                    this._playSoundByMat(this.m_sndStepByMat[this.m_landingMaterial.ordinal()], this.m_sndStepGeneric);
                    _idLastPlayed = id;
                    break;
                }
                ++i;
            }
            _idLastFrame = _curAnimId;
        }
        _idLastFrameRef.set(_idLastFrame);
        _idLastPlayedRef.set(_idLastPlayed);
    }

    @Override
    public void handleGenericMessage(Actor.eGenericMessage _message, Actor _sender) {
        switch (_message) {
            case eGenericMessage_SlimeDropContact: {
                if (this.m_dammageState != eDammageState.eDammageState_Exploding && _sender != null && _sender.Material() == Actor.eActorMaterial.eActorMaterial_Ennemy) {
                    AchievementManager.Instance().unlockAchievement("ACH_KISS_A_SLIME");
                }
                this._goToExplode();
                break;
            }
            case eGenericMessage_TntBlow: {
                this._goToExplode();
                break;
            }
            case eGenericMessage_UpdateUpgrade: {
                this.m_powerUpdgradeDoneDuringLevel = true;
                this._updateDrillLevel();
                break;
            }
            case eGenericMessage_ValidateUpgrade: {
                this.m_powerUpdgradeDoneDuringLevel = false;
                break;
            }
            case eGenericMessage_Kaboom: {
                this._onExplode();
                break;
            }
            case eGenericMessage_DrillBreakStep1: {
                if (this.m_animState != eAnimState.eAnimState_Jump && this.m_animState != eAnimState.eAnimState_Fall) {
                    this.m_sndDrillLevel01.play();
                    break;
                }
                if (this.m_bDrillContact) break;
                ++this.m_sndBreakLevel01_Counter;
                break;
            }
            case eGenericMessage_DrillBreakStep2: {
                if (this.m_animState != eAnimState.eAnimState_Jump && this.m_animState != eAnimState.eAnimState_Fall) {
                    this.m_sndDrillLevel02.play();
                    break;
                }
                if (this.m_bDrillContact) break;
                ++this.m_sndBreakLevel02_Counter;
                break;
            }
            case eGenericMessage_DrillBreakStep3: {
                if (this.m_animState != eAnimState.eAnimState_Jump && this.m_animState != eAnimState.eAnimState_Fall) {
                    this.m_sndDrillLevel03.play();
                    break;
                }
                if (this.m_bDrillContact) break;
                ++this.m_sndBreakLevel03_Counter;
                break;
            }
            case eGenericMessage_BTMGrabed: {
                this.m_bBTM_found = true;
                this._requireUpdateHud();
                break;
            }
            case eGenericMessage_UpdateLevelStats: {
                this._updateLevelStats();
                break;
            }
            case eGenericMessage_RestartLevel: {
                this._restartLevel();
                break;
            }
            case eGenericMessage_GoToNextLevelInUniverse: {
                this._nextLevelUniverse();
                break;
            }
            case eGenericMessage_GoToNextLevelGeneric: {
                this._nextLevelDeferred();
                break;
            }
            case eGenericMessage_GoToPreviousLevelInUniverse: {
                this._previousLevelUniverse();
                break;
            }
            case eGenericMessage_RequestLookAtWithCallback: {
                this._setMode(ePlayerMode.ePlayerMode_ShowElement);
                this._elementFollowInit(_sender);
                break;
            }
            case eGenericMessage_LookAtGiveBack: {
                this._elementFollowBackInit();
                break;
            }
            case eGenericMessage_WorkshopShowOpeningEnd: {
                break;
            }
            case eGenericMessage_DialogControlPlayerBegin: {
                this.m_playModeSave = this.m_playMode;
                this._setMode(ePlayerMode.ePlayerMode_Dialog);
                this.m_owner.acceleration.X = 0.0f;
                this._leaveMoveMode();
                break;
            }
            case eGenericMessage_DialogControlPlayerEnd: {
                this._setMode(this.m_playModeSave);
                break;
            }
            case eGenericMessage_PortalControlPlayerBegin: {
                this.m_bPortalControl = true;
                this._portalFollowInit(_sender);
                break;
            }
            case eGenericMessage_BigJump: {
                this.m_owner.velocity.Y = (float)(-this.JumpPower) * 2.0f;
                this.m_bLimitingY = true;
                this.m_limitY = _sender.y;
                break;
            }
            case eGenericMessage_DisplayLevelResults: {
                this._setMode(ePlayerMode.ePlayerMode_ShowLevelResultPAR);
                break;
            }
            case eGenericMessage_PortalControlPlayerEnd: {
                this.m_bPortalControl = false;
                this._moveFollowInit();
                break;
            }
            case eGenericMessage_EnnemyHitPlayer: {
                if (!this.m_bCanBeHurt) break;
                if (this.m_bInstantKillOnEveryThing) {
                    this._goToExplode();
                    break;
                }
                this.m_bDammageThisFrame = true;
                if (this.m_bFirstDammage || this.m_dammageState != eDammageState.eDammageState_None && this.m_dammageState != eDammageState.eDammageState_Electric) break;
                AchievementManager.Instance().unlockAchievement("ACH_KISS_A_SLIME");
                break;
            }
            case eGenericMessage_ResetCollectableNeededCounters: {
                this._resetCollectableNeededCounter(_sender.Material());
                this._requireUpdateHud();
                break;
            }
            case eGenericMessage_IncrementMaterialStockNeeded: {
                int idCollectable = _sender.Material().ordinal() - Actor.FirstCollectableMatIdHACK();
                this._increaseDecreaseCollectableNeededIndex(idCollectable, true);
                break;
            }
            case eGenericMessage_IncrementMaterialStock: {
                int idCollectable = _sender.Material().ordinal() - Actor.FirstCollectableMatIdHACK();
                this._increaseDecreaseCollectableIndex(idCollectable, true);
                break;
            }
            case eGenericMessage_DecrementMaterialStock: {
                int idCollectable = _sender.Material().ordinal() - Actor.FirstCollectableMatIdHACK();
                this._increaseDecreaseCollectableIndex(idCollectable, false);
                break;
            }
            case eGenericMessage_BlocStopJump: {
                this.m_bBlocStopingJump = true;
                if (Actor.IsConsirededAsGround(_sender.Material()) || !Actor.CanBeDrilled(_sender.Material())) {
                    this.m_bBlocStopingJumpHard = true;
                    break;
                }
                this.m_bBlocStopingJumpBreakable = true;
                break;
            }
            case eGenericMessage_BlocRepulsionForced: {
                this._repulsion(_sender, true);
                break;
            }
            case eGenericMessage_BlocRepulsion: {
                if (this.m_bRepulsion) break;
                this._repulsion(_sender, false);
            }
        }
    }

    protected void _requireUpdateHud() {
        this.m_bUpdateHud = true;
    }

    protected void _repulsion(Actor _sender, boolean _bForce) {
        float dist;
        float f = dist = this.m_owner.facing() == FlxSprite.Flx2DFacing.Right ? this.m_owner.getRight() - _sender.x : this.m_owner.x - _sender.getRight();
        if (_bForce || dist * dist < 25.0f) {
            float repulsey = (float)(-this.JumpPower) / 10.0f;
            float repulsex = 0.0f;
            this.m_owner.velocity.X = 0.0f;
            repulsex = _sender.x > this.m_owner.x ? (float)(-this.JumpPower) : (float)this.JumpPower;
            this.m_owner.velocity.X += repulsex;
            this.m_owner.velocity.Y += repulsey;
            this.m_bRepulsion = true;
            if (this.m_bPlayAleaSoundOnDrillRepulse) {
                this.m_sndAlea.play();
            } else {
                this.m_sndDrillRepulse.play();
            }
            this._positionnateAndStartEmitter(this.m_drillRepulseEmitter, _sender, false);
        }
    }

    @Override
    public void render(SpriteBatch spriteBatch) {
        this._updateEyeForRendering();
        this.m_eyeUpgrade.alpha(this.m_owner.alpha());
        this.m_eyeHurt.alpha(this.m_owner.alpha());
        this.m_eye.alpha(this.m_owner.alpha());
        if (this.m_eyeUpgrade.visible) {
            this.m_eyeUpgrade.render(spriteBatch);
        }
        if (this.m_eyeHurt.visible) {
            this.m_eyeHurt.render(spriteBatch);
        }
        this.m_eye.render(spriteBatch);
        if (this.m_dammageState == eDammageState.eDammageState_BlinkingElectric || this.m_dammageState == eDammageState.eDammageState_Electric) {
            this.m_electricity.x = this.m_owner.x + this.m_owner.width * 0.5f - this.m_electricity.width * 0.5f;
            this.m_electricity.y = this.m_owner.y + this.m_owner.height * 0.5f - this.m_electricity.height * 0.5f;
            this.m_electricity.render(spriteBatch);
        }
    }

    protected void _updateDrilling() {
        if (!this.m_owner.Level().PlayableMode()) {
            return;
        }
        this.m_bDrillContact = false;
        if (this.m_bDrilling && Actor.CanDrillAlmostOneThing()) {
            float drillx = this.m_owner.facing() == FlxSprite.Flx2DFacing.Right ? this.m_owner.getRight() + (float)GameVars.TileStep() * 0.5f : this.m_owner.getLeft() - (float)GameVars.TileStep() * 0.5f;
            float drilly = this.m_owner.y + this.m_owner.height * 0.5f;
            Actor otherActor = null;
            this.m_owner.Level().BlocManager().getPointGridLocationClamped(drillx, drilly, BlocManager.idCol, BlocManager.idLine);
            int idCol = BlocManager.idCol.get();
            int idLine = BlocManager.idLine.get();
            otherActor = this.m_owner.Level().BlocManager().getActorInBlocSlot(idLine, idCol, false);
            if (otherActor != null) {
                float dist;
                float f = dist = this.m_owner.facing() == FlxSprite.Flx2DFacing.Right ? this.m_owner.getRight() - otherActor.x : this.m_owner.x - otherActor.getRight();
                if (dist * dist < 256.0f) {
                    if (this._isCompatibleStateForDrilling()) {
                        if (this.m_eyeAnimState == eAnimEyeState.eAnimEyeState_turn) {
                            otherActor.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_Drill, this.m_owner);
                            this.m_bDrillContact = true;
                            if (Actor.CanMakeDrillParticle(otherActor.Material()) && !this.m_drillEmitter.Started()) {
                                this._positionnateAndStartEmitter(this.m_drillEmitter, otherActor, true);
                            }
                        }
                    } else if (this.m_bCanDrillForFake) {
                        this.m_bUpdateHud = false;
                        if (this.m_eyeAnimState == eAnimEyeState.eAnimEyeState_turn) {
                            otherActor.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_DrillFake, this.m_owner);
                        }
                    }
                }
            }
        }
        if (this.m_bDrillContact) {
            this.m_timeElapsedDrillNoContact = 0.0f;
        } else {
            if (this.m_drillEmitter.Started()) {
                this.m_drillEmitter.stop();
            }
            this.m_timeElapsedDrillNoContact += FlxG.elapsed;
        }
    }

    protected void _positionnateAndStartEmitter(FlxEmitter _emitter, Actor _touchingActor, boolean _colorize) {
        _emitter.start();
        _emitter.y = _touchingActor.getCenterY() - _emitter.height * 0.5f;
        if (_colorize) {
            if (_touchingActor.Material() == Actor.eActorMaterial.eActorMaterial_Paint) {
                _emitter.particuleColor(_touchingActor.color());
            } else {
                _emitter.particuleColor(_touchingActor.getEmitterParticuleColor());
            }
        }
        if (this.m_owner.facing() == FlxSprite.Flx2DFacing.Right) {
            _emitter.x = _touchingActor.x;
            _emitter.MirroringV(true);
        } else {
            _emitter.x = _touchingActor.x + _touchingActor.width;
            _emitter.MirroringV(false);
        }
    }

    protected void _updateLevelStats() {
        if (GameVars.LevelSequence() != null && GameVars.LevelSequence().length() > 0) {
            return;
        }
        if (GameVars.GameCommunityMode()) {
            GameVars.LastCommunityPlayedLevelParValue(this.NumCollectableLeft());
            if (this.m_customParCommunity > 0 && this.NumCollectableLeft() >= this.m_customParCommunity) {
                this.m_bPAR_requiredNum = this.m_customParCommunity;
                this.m_bPAR_newRecord = true;
            }
            return;
        }
        LevelInfo myLvlInfo = LevelDataBase.Instance().getLevelInfo(this.m_owner.Level().Name(), this.m_owner.Level().Group());
        if (myLvlInfo != null) {
            int numCollectableLeft = this.NumCollectableLeft();
            if (numCollectableLeft >= myLvlInfo.ParToReachValue() && numCollectableLeft > myLvlInfo.ParBestValue()) {
                this.m_bPAR_requiredNum = myLvlInfo.ParToReachValue() > myLvlInfo.ParBestValue() ? myLvlInfo.ParToReachValue() : myLvlInfo.ParBestValue();
                this.m_bPAR_newRecord = true;
            }
            myLvlInfo.updateInfo(this.m_bBTM_found, numCollectableLeft, true, true);
        }
    }

    protected void _previousLevelDeferred() {
        if (GameVars.LevelSequence() != null && GameVars.LevelSequence().length() > 0) {
            this.m_owner.Level().launchPreviousLevelInSequenceDeferred(GameVars.LevelSequence());
        } else {
            this.m_owner.Level().launchPreviousLevelInUniverseDeffered();
        }
    }

    protected void _nextLevelDeferred() {
        if (GameVars.LevelSequence() != null && GameVars.LevelSequence().length() > 0) {
            this.m_owner.Level().launchNextLevelInSequenceDeffered(GameVars.LevelSequence());
        } else {
            this.m_owner.Level().launchNextLevelInUniverseDeffered();
        }
    }

    protected void _nextLevelUniverse() {
        LevelGroup lvlGroup = this.m_owner.Level().Group();
        if (lvlGroup != null && lvlGroup.Flag() == LevelGroup.eSpecialFlag.Bonuses) {
            FlxG.state(new LevelSelectionState(true, null, this.m_owner.Level().Name()));
        } else if (lvlGroup != null && lvlGroup.Flag() == LevelGroup.eSpecialFlag.Specials) {
            FlxG.state(new MenuMainState(true, false));
        } else {
            String nextLevelName;
            if (Guide.IsTrialMode()) {
                LevelInfo myLvlInfo = LevelDataBase.Instance().getLevelInfo(this.m_owner.Level().Name(), this.m_owner.Level().Group());
                int id = LevelDataBase.Instance().getLevelIndexInGroup(lvlGroup, myLvlInfo);
                if (id >= 10) {
                    FlxG.state(new LevelSelectionState(true, null, this.m_owner.Level().Name()));
                    return;
                }
            }
            if ((nextLevelName = LevelDataBase.Instance().getNextLevelName(this.m_owner.Level(), true)) != null) {
                LevelInfo lvlInfo = LevelDataBase.Instance().getLevelInfo(nextLevelName, this.m_owner.Level().Group());
                if (lvlInfo.Cinematic()) {
                    LevelInfo lvlInfoNextLevel = LevelDataBase.Instance().getNextLevelInfoOrNil(lvlInfo.TargetLevelFile(), this.m_owner.Level().Group());
                    FlxG.state(new CinematicReplayState(lvlInfo.TargetLevelFile(), lvlInfoNextLevel != null ? lvlInfoNextLevel.TargetLevelFile() : null, CinematicReplayState.eSpecialFlag.None, this.m_owner.Level().Group()));
                } else {
                    FlxG.state(new PlayState(LauncherState.PlayOnStart(), LauncherState.AllowEdit(), nextLevelName, this.m_owner.Level().Group()));
                }
            } else {
                FlxG.state(new LevelSelectionState(true, null, this.m_owner.Level().Name()));
            }
        }
    }

    protected void _previousLevelUniverse() {
        String previousLevelName = LevelDataBase.Instance().getPreviousLevelName(this.m_owner.Level(), true);
        if (previousLevelName != null) {
            LevelInfo lvlInfo = LevelDataBase.Instance().getLevelInfo(previousLevelName, this.m_owner.Level().Group());
            if (lvlInfo.Cinematic()) {
                LevelInfo lvlInfoPreviousLevel = LevelDataBase.Instance().getPreviousLevelInfoOrNil(lvlInfo.TargetLevelFile(), this.m_owner.Level().Group());
                FlxG.state(new CinematicReplayState(lvlInfo.TargetLevelFile(), lvlInfoPreviousLevel != null ? lvlInfoPreviousLevel.TargetLevelFile() : null, CinematicReplayState.eSpecialFlag.None, this.m_owner.Level().Group()));
            } else {
                FlxG.state(new PlayState(LauncherState.PlayOnStart(), LauncherState.AllowEdit(), previousLevelName, this.m_owner.Level().Group()));
            }
        } else {
            FlxG.state(new LevelSelectionState(true, null, this.m_owner.Level().Name()));
        }
    }

    protected void _restartLevel() {
        this.m_bPortalControl = true;
        FlxG.fade.start(Color.Black(), 1.0f, this.m_onRestartFadeComplete, true, true);
    }

    protected void _onRestartFadeComplete(Object sender, Object e) {
        FlxG.state(new PlayState(LauncherState.PlayOnStart(), LauncherState.AllowEdit(), this.m_owner.Level().Name(), this.m_owner.Level().Group()));
    }

    protected boolean _isCompatibleStateForDrilling() {
        return this.m_bRepulsion || this.m_animState == eAnimState.eAnimState_Walk || this.m_animState == eAnimState.eAnimState_Run || this.m_animState == eAnimState.eAnimState_Idle;
    }

    protected void _updateAnimState() {
        switch (this.m_animState) {
            case eAnimState_Unknow: {
                if (this._checkAnimState(eAnimState.eAnimState_Idle)) break;
                this._checkAnimState(eAnimState.eAnimState_Fall);
                break;
            }
            case eAnimState_Idle: {
                if (this._checkAnimState(eAnimState.eAnimState_Walk) || this._checkAnimState(eAnimState.eAnimState_Run) || this._checkAnimState(eAnimState.eAnimState_Jump)) break;
                this._checkAnimState(eAnimState.eAnimState_Fall);
                break;
            }
            case eAnimState_Jump: {
                if (this._checkAnimState(eAnimState.eAnimState_Fall)) break;
                this._checkAnimState(eAnimState.eAnimState_Idle);
                break;
            }
            case eAnimState_Fall: {
                if (this._checkAnimState(eAnimState.eAnimState_Walk) || this._checkAnimState(eAnimState.eAnimState_Run)) break;
                this._checkAnimState(eAnimState.eAnimState_Idle);
                break;
            }
            case eAnimState_Walk: {
                if (this._checkAnimState(eAnimState.eAnimState_Idle) || this._checkAnimState(eAnimState.eAnimState_Jump) || this._checkAnimState(eAnimState.eAnimState_Run)) break;
                this._checkAnimState(eAnimState.eAnimState_Fall);
                break;
            }
            case eAnimState_Run: {
                if (this._checkAnimState(eAnimState.eAnimState_Idle) || this._checkAnimState(eAnimState.eAnimState_Jump) || this._checkAnimState(eAnimState.eAnimState_Walk)) break;
                this._checkAnimState(eAnimState.eAnimState_Fall);
            }
        }
        if (this.m_bRepulsion && (this.m_animState == eAnimState.eAnimState_Idle || this.m_animState == eAnimState.eAnimState_Run || this.m_animState == eAnimState.eAnimState_Walk)) {
            this.m_bRepulsion = false;
        }
    }

    protected boolean _checkAnimState(eAnimState _testState) {
        boolean bMustRun = this.m_bLeftOrRightDown && this.m_bDrilling;
        this.m_animStateOld = this.m_animState;
        boolean bRes = false;
        switch (_testState) {
            case eAnimState_Idle: {
                if (this.m_owner.velocity.X != 0.0f || this.m_owner.velocity.Y != 0.0f || bMustRun) break;
                this.m_owner.play("idle");
                bRes = true;
                break;
            }
            case eAnimState_Jump: {
                if (!(this.m_owner.velocity.Y < 0.0f)) break;
                this.m_owner.play("jump");
                bRes = true;
                break;
            }
            case eAnimState_Run: {
                if ((!this.m_bRunning || this.m_owner.velocity.X == 0.0f || this.m_owner.velocity.Y != 0.0f) && !bMustRun) break;
                this.m_owner.play("run");
                bRes = true;
                break;
            }
            case eAnimState_Walk: {
                if (this.m_bRunning || this.m_owner.velocity.X == 0.0f || this.m_owner.velocity.Y != 0.0f) break;
                this.m_owner.play("walk");
                bRes = true;
                break;
            }
            case eAnimState_Fall: {
                if (!(this.m_owner.velocity.Y > 0.0f)) break;
                this.m_owner.play("fall");
                bRes = true;
            }
        }
        if (bRes) {
            this.m_animState = _testState;
        }
        return bRes;
    }

    protected void _buildEye() {
        this.m_eye = this.m_owner.Level().instanciateSprite("blocman_eye");
        this.m_eye.play("idle");
        this.m_eyeAnchor = this.m_owner.getAnchor("eye");
        Debug.Assert(this.m_eyeAnchor != null);
        this.m_eyeUpgrade = this.m_owner.Level().instanciateSprite("blocman_eye");
        this.m_eyeUpgrade.play("updgrade1");
        this.m_eyeUpgrade.visible = false;
        this.m_eyeHurt = this.m_owner.Level().instanciateSprite("blocman_eye");
        this.m_eyeHurt.play("hurt");
        this.m_eyeHurt.visible = false;
    }

    protected void _buildElectricArc() {
        this.m_electricity = this.m_owner.Level().instanciateSprite("electric_arc");
        this.m_electricity.play("idle");
    }

    protected void _updateEyeForRendering() {
        Vector3 xyr = this.m_owner.getAnchorSyncWithAnim(this.m_eyeAnchor);
        if (this.m_owner.facing() == FlxSprite.Flx2DFacing.Right) {
            this.m_eye.x = this.m_owner.x - (float)this.m_owner.offset.X + xyr.X;
            this.m_eye.y = this.m_owner.y - (float)this.m_owner.offset.Y + xyr.Y;
            this.m_eye.facing(this.m_owner.facing());
            this.m_eye.angle(xyr.Z);
        } else {
            this.m_eye.x = this.m_owner.x - (float)this.m_owner.offset.X - xyr.X;
            this.m_eye.y = this.m_owner.y - (float)this.m_owner.offset.Y + xyr.Y;
            this.m_eye.facing(this.m_owner.facing());
            this.m_eye.angle(-xyr.Z);
        }
        this.m_eyeUpgrade.x = this.m_eye.x;
        this.m_eyeUpgrade.y = this.m_eye.y;
        this.m_eyeUpgrade.angle(this.m_eye.angle());
        this.m_eyeUpgrade.facing(this.m_owner.facing());
        this.m_eyeHurt.x = this.m_eye.x;
        this.m_eyeHurt.y = this.m_eye.y;
        this.m_eyeHurt.angle(this.m_eye.angle());
        this.m_eyeHurt.facing(this.m_owner.facing());
    }

    protected void _increaseDecreaseCollectableNeededIndex(int _index, boolean _bIncrease) {
        int shift;
        int n = shift = _bIncrease ? 1 : -1;
        if (this.m_collectableNeededCounters[_index] + shift >= 0) {
            int n2 = _index;
            this.m_collectableNeededCounters[n2] = this.m_collectableNeededCounters[n2] + shift;
            this._requireUpdateHud();
        }
    }

    protected void _increaseDecreaseCollectableIndex(int _index, boolean _bIncrease) {
        int shift = _bIncrease ? 1 : -1;
        this.increaseDecreaseCollectableIndex(_index, _bIncrease, shift);
    }

    public void increaseDecreaseCollectableIndex(int _index, boolean _bIncrease, int shift) {
        boolean bCanPuzzle = this.canGoToPuzzleMode();
        if (this.m_collectableCounters[_index] + shift >= 0) {
            int n = _index;
            this.m_collectableCounters[n] = this.m_collectableCounters[n] + shift;
            this.m_numCollectable += shift;
            if (this.m_collectableCounters[this.m_selectedIndex] == 0) {
                this._selectNextCollectableIndex(true, false);
            }
            if (bCanPuzzle != this.canGoToPuzzleMode() && this.m_owner.Level().PlayableMode()) {
                this.m_materialHub.enterNewMode(this.m_playMode);
            }
            this._requireUpdateHud();
        }
    }

    @Override
    public void checkCollisions() {
        if (!this.m_bDebugGrabMove && this.m_playMode == ePlayerMode.ePlayerMode_Move) {
            if (this.m_bBlocStopingJump) {
                if (this.m_owner.velocity.Y < 0.0f) {
                    this.m_owner.velocity.Y = 0.0f;
                }
                this.m_bBlocStopingJump = false;
                if (this.m_bBlocStopingJumpBreakable) {
                    if (this.m_sndBreakLevel01_Counter > 0) {
                        this.m_sndBreakLevel01_Counter = 0;
                        this.m_sndBreakLevel01.play();
                    }
                    if (this.m_sndBreakLevel02_Counter > 0) {
                        this.m_sndBreakLevel02_Counter = 0;
                        this.m_sndBreakLevel02.play();
                    }
                    if (this.m_sndBreakLevel03_Counter > 0) {
                        this.m_sndBreakLevel03_Counter = 0;
                        this.m_sndBreakLevel03.play();
                    }
                } else if (this.m_bBlocStopingJumpHard) {
                    if (this.m_bPlayHitSoundOnUnbreakable) {
                        this.m_sndHit.play();
                    } else {
                        this.m_sndAlea.play();
                    }
                }
                this.m_bBlocStopingJumpHard = false;
                this.m_bBlocStopingJumpBreakable = false;
            }
            this.m_owner.Level().BlocManager().overlapFast(this.m_owner, this, 0);
            this.m_owner.Level().BlocManager().computeLandingMaterial(this.m_owner, BlocManager.m_landingMaterial);
            this.m_landingMaterial = BlocManager.m_landingMaterial.get();
        }
    }

    @Override
    public void onOverlapsCallback(FlxSpriteCollisionEvent _event, int _callbackId) {
        switch (_callbackId) {
            case 0: {
                Actor otherActor = (Actor)_event.Object1();
                this._playerCollide(otherActor);
            }
        }
    }

    protected void _playerCollide(Actor otherActor) {
        float top = this.m_owner.getTop();
        float bot = this.m_owner.getBottom();
        float otherTop = otherActor.getTop();
        float otherBot = otherActor.getBottom();
        float otherLeft = otherActor.getLeft();
        float centerx = this.m_owner.getCenterX();
        float centery = this.m_owner.getCenterY();
        float otherCenterx = otherActor.getCenterX();
        float left = this.m_owner.getLeft();
        float right = this.m_owner.getRight();
        if (Actor.IsBreakable(otherActor.Material())) {
            if (this.m_owner.velocity.Y < 0.0f && otherBot < centery && Utility.IsHorizontallyNearby(centerx, this.m_owner.width, otherCenterx, otherActor.width, 0.99f) && (!this.m_owner.Level().BlocManager().isBlocSlotBelowOccupied(otherActor, true) || otherActor.hasFlag(Actor.eSpecialFlag.eSpecialFlag_Falling) || otherActor.hasFlag(Actor.eSpecialFlag.eSpecialFlag_FallBlockedByPlayer)) && Utility.IsHorizontallyNearby(centerx, this.m_owner.width, otherCenterx, otherActor.width, 0.95f)) {
                otherActor.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_PlayerHitByJump, this.m_owner);
            }
            if (this.m_owner.velocity.Y >= 0.0f && centery < otherTop && (this.m_animState == eAnimState.eAnimState_Walk || this.m_animState == eAnimState.eAnimState_Run) && Utility.IsHorizontallyNearby(centerx, this.m_owner.width, otherCenterx, otherActor.width, 0.9f)) {
                otherActor.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_PlayerRun, this.m_owner);
            }
        } else if (this.m_animState == eAnimState.eAnimState_Jump && this.m_owner.velocity.Y < 0.0f && otherBot < centery && Utility.IsHorizontallyNearby(centerx, this.m_owner.width, otherCenterx, otherActor.width, 0.99f) && !this.m_owner.Level().BlocManager().isBlocSlotBelowOccupied(otherActor, true) && Utility.IsHorizontallyNearby(centerx, this.m_owner.width, otherCenterx, otherActor.width, 0.95f)) {
            otherActor.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_PlayerHitByJump, this.m_owner);
        }
    }

    protected void _handleDebugInput() {
        if (this.m_owner.Level().Mode() == Level.eLevelMode.eLevelMode_Edit && !this.m_owner.Level().isEditMenuVisible()) {
            float factor = 1.0f;
            if (InputManager.IsButtonDown(Buttons.RightTrigger)) {
                factor = this.EditModeMoveAccelFactor;
            }
            if (InputManager.IsButtonDown(Buttons.RightThumbstickUp, true) || InputManager.IsKeyDown(Keys.Up)) {
                this.m_owner.y -= this.EditModeMoveStep * factor;
            } else if (InputManager.IsButtonDown(Buttons.RightThumbstickDown, true) || InputManager.IsKeyDown(Keys.Down)) {
                this.m_owner.y += this.EditModeMoveStep * factor;
            }
            if (InputManager.IsButtonDown(Buttons.RightThumbstickLeft, true) || InputManager.IsKeyDown(Keys.Left)) {
                this.m_owner.x -= this.EditModeMoveStep * factor;
            } else if (InputManager.IsButtonDown(Buttons.RightThumbstickRight, true) || InputManager.IsKeyDown(Keys.Right)) {
                this.m_owner.x += this.EditModeMoveStep * factor;
            }
            if (InputManager.IsKeyDown(Keys.RightControl) || InputManager.IsKeyDown(Keys.LeftControl)) {
                float smx = InputManager.MouseSpriteX();
                float smy = InputManager.MouseSpriteY();
                boolean bInDeadZone = false;
                boolean bInstantMove = false;
                if (smx > (float)FlxG.width * 0.4f && smx < (float)FlxG.width * 0.6f && smy > (float)FlxG.height * 0.4f && smy < (float)FlxG.height * 0.6f) {
                    if (InputManager.IsNewKeyPress(Keys.RightControl) || InputManager.IsNewKeyPress(Keys.LeftControl)) {
                        bInDeadZone = false;
                        bInstantMove = true;
                    } else {
                        bInDeadZone = true;
                    }
                } else if (!InputManager.IsMouseJustMoved() && (InputManager.IsNewKeyPress(Keys.RightControl) || InputManager.IsNewKeyPress(Keys.LeftControl))) {
                    bInDeadZone = false;
                    bInstantMove = true;
                }
                if (!bInDeadZone) {
                    this.m_owner.x = this.m_owner.Level().Editor().getActorCursor().x;
                    this.m_owner.y = this.m_owner.Level().Editor().getActorCursor().y;
                    if (bInstantMove) {
                        FlxG.doInstantFollow();
                    }
                }
            }
        } else if (MACRO.DEBUG) {
            if (InputManager.IsNewKeyPress(Keys.F11)) {
                this._previousLevelDeferred();
            } else if (InputManager.IsNewKeyPress(Keys.F12)) {
                this._nextLevelDeferred();
            } else if (InputManager.IsNewKeyPress(Keys.F9)) {
                FlxG.showBounds = !FlxG.showBounds;
            } else if (InputManager.IsNewKeyPress(Keys.F10)) {
                FlxSoundManager.Mute();
            } else if (InputManager.IsNewKeyPress(Keys.F4)) {
                this.m_bCanBeHurt = !this.m_bCanBeHurt;
                FlxG.flash.start(this.m_bCanBeHurt ? Color.Red() : Color.Pink(), 0.4f);
            } else if (InputManager.IsNewKeyPress(Keys.F5)) {
                if (Actor.CanDrillAlmostOneThing()) {
                    Actor.SetCanBeDrilled(Actor.NothingToDrillStep, false);
                } else {
                    Actor.SetCanBeDrilled(Actor.UpdateDrillStep01, true);
                }
                FlxG.flash.start(Actor.CanBeDrilled(Actor.UpdateDrillStep01) ? Color.Pink() : Color.Red(), 0.4f);
            } else if (InputManager.IsNewKeyPress(Keys.F6)) {
                Actor.SetCanBeDrilled(Actor.UpdateDrillStep02, !Actor.CanBeDrilled(Actor.UpdateDrillStep02));
                FlxG.flash.start(Actor.CanBeDrilled(Actor.UpdateDrillStep02) ? Color.Pink() : Color.Red(), 0.4f);
            } else if (InputManager.IsNewKeyPress(Keys.F7)) {
                Actor.SetCanBeDrilled(Actor.UpdateDrillStep03, !Actor.CanBeDrilled(Actor.UpdateDrillStep03));
                FlxG.flash.start(Actor.CanBeDrilled(Actor.UpdateDrillStep03) ? Color.Pink() : Color.Red(), 0.4f);
            } else if (InputManager.IsNewKeyPress(Keys.F8)) {
                if (this.PlayMode() == ePlayerMode.ePlayerMode_Bloc) {
                    GameVars.PlayerCanDoLines(GameVars.PlayerCanDoLines() > 0 ? 0 : 1);
                    FlxG.flash.start(GameVars.PlayerCanDoLines() > 0 ? Color.Pink() : Color.Red(), 0.4f);
                } else {
                    GameVars.PlayerCanDoPuzzle(GameVars.PlayerCanDoPuzzle() > 0 ? 0 : 1);
                    FlxG.flash.start(GameVars.PlayerCanDoPuzzle() > 0 ? Color.Pink() : Color.Red(), 0.4f);
                }
                this.m_materialHub.sync();
            }
        }
    }

    protected void _handleGrabMovement() {
        if (this.m_bDebugGrabMove) {
            this.m_owner.acceleration = Vector2.Zero();
            this.m_owner.velocity = Vector2.Zero();
            boolean bAllowEdit = LauncherState.AllowEdit();
            if (InputManager.IsButtonDown(Buttons.LeftThumbstickLeft) || !bAllowEdit && InputManager.IsButtonDown(Buttons.DPadLeft)) {
                this.m_owner.x -= FlxG.elapsed * this.MoveTargetSpeed;
            } else if (InputManager.IsButtonDown(Buttons.LeftThumbstickRight) || !bAllowEdit && InputManager.IsButtonDown(Buttons.DPadRight)) {
                this.m_owner.x += FlxG.elapsed * this.MoveTargetSpeed;
            }
            if (InputManager.IsButtonDown(Buttons.LeftThumbstickUp) || !bAllowEdit && InputManager.IsButtonDown(Buttons.DPadUp)) {
                this.m_owner.y -= FlxG.elapsed * this.MoveTargetSpeed;
            } else if (InputManager.IsButtonDown(Buttons.LeftThumbstickDown) || !bAllowEdit && InputManager.IsButtonDown(Buttons.DPadDown)) {
                this.m_owner.y += FlxG.elapsed * this.MoveTargetSpeed;
            }
        }
    }

    protected boolean _leftDown() {
        return InputManager.IsButtonDown(Buttons.LeftThumbstickLeft) || !LauncherState.AllowEdit() && InputManager.IsButtonDown(Buttons.DPadLeft);
    }

    protected boolean _rightDown() {
        return InputManager.IsButtonDown(Buttons.LeftThumbstickRight) || !LauncherState.AllowEdit() && InputManager.IsButtonDown(Buttons.DPadRight);
    }

    protected boolean _upDown() {
        return InputManager.IsButtonDown(Buttons.LeftThumbstickUp) || !LauncherState.AllowEdit() && InputManager.IsButtonDown(Buttons.DPadUp);
    }

    protected boolean _downDown() {
        return InputManager.IsButtonDown(Buttons.LeftThumbstickDown) || !LauncherState.AllowEdit() && InputManager.IsButtonDown(Buttons.DPadDown);
    }

    void _handleMovement() {
        if (!this.m_owner.Level().AllowMaincharacterMove() || this.m_bPortalControl) {
            this.m_owner.acceleration.X = 0.0f;
            this.m_owner.velocity.Y = 0.0f;
            return;
        }
        if (this.m_owner.Level().PlayableMode() && this.m_playMode == ePlayerMode.ePlayerMode_Move && InputManager.IsButtonDown(Buttons.LeftTrigger) && GameVars.CanGoCameraMode()) {
            this._setMode(ePlayerMode.ePlayerMode_Camera);
            if (!this.m_blocSpawner.UseLineScan() && GameVars.UseHologramZone()) {
                this._makeHologramAppear();
            }
            this._cameraFollowInit();
        }
        if (this.m_playMode == ePlayerMode.ePlayerMode_Dialog) {
            this.m_bDrilling = false;
            this.m_bRunning = false;
            this._checkEyeAnim();
        } else if (this.m_playMode == ePlayerMode.ePlayerMode_Camera) {
            this.m_bDrilling = false;
            this.m_bRunning = false;
            this._checkEyeAnim();
            float factorSpeed = 1.0f;
            if (InputManager.IsButtonDown(Buttons.X) || InputManager.IsButtonDown(Buttons.RightTrigger)) {
                factorSpeed = this.MoveTargetIncreaseSpeedFactor;
            }
            if (this._leftDown()) {
                this.m_moveTarget.x -= FlxG.elapsed * this.MoveTargetSpeed * factorSpeed;
            } else if (this._rightDown()) {
                this.m_moveTarget.x += FlxG.elapsed * this.MoveTargetSpeed * factorSpeed;
            }
            if (this._upDown()) {
                this.m_moveTarget.y -= FlxG.elapsed * this.MoveTargetSpeed * factorSpeed;
            } else if (this._downDown()) {
                this.m_moveTarget.y += FlxG.elapsed * this.MoveTargetSpeed * factorSpeed;
            }
            this._checkMoveTargetCameraBounds();
            if (!this.m_blocSpawner.UseLineScan() && GameVars.UseHologramZone()) {
                this.m_hologramPuzzleZone.update();
                if (InputManager.IsNewButtonPress(Buttons.A)) {
                    this.m_hologramPuzzleZone.validateCurrentPosition();
                }
                this._positionnateHologramInMiddleScreen();
            }
            if (!InputManager.IsButtonDown(Buttons.LeftTrigger) && GameVars.CanGoCameraMode()) {
                this._setMode(ePlayerMode.ePlayerMode_Move);
            }
        } else if (this.m_playMode == ePlayerMode.ePlayerMode_ShowElement) {
            this._checkMoveTargetCameraBounds();
        } else if (this.m_playMode == ePlayerMode.ePlayerMode_Move) {
            if (this.m_owner.Level().Mode() == Level.eLevelMode.eLevelMode_Test || this.m_owner.Level().Mode() == Level.eLevelMode.eLevelMode_Play) {
                this.m_owner.acceleration.X = 0.0f;
                if (this._leftDown()) {
                    this._changeFacing(FlxSprite.Flx2DFacing.Left);
                    this.m_owner.acceleration.X -= this.m_owner.drag.X;
                } else if (this._rightDown()) {
                    this._changeFacing(FlxSprite.Flx2DFacing.Right);
                    this.m_owner.acceleration.X += this.m_owner.drag.X;
                } else {
                    this.m_owner.drag.X = this.RunSpeed * this.DragDecelFactor;
                }
                if ((InputManager.IsNewButtonPress(Buttons.A) || InputManager.IsNewKeyPress(Keys.Up)) && this.m_owner.velocity.Y == 0.0f) {
                    this.m_sndJump.play();
                    this.m_owner.velocity.Y = -this.JumpPower;
                }
                if (InputManager.IsNewButtonPress(Buttons.B)) {
                    this.m_sndRestartLevel.play();
                    this.m_bResetInitiated = true;
                } else if (this.m_bResetInitiated && InputManager.IsButtonDown(Buttons.B)) {
                    if (this.m_timePressedRetry <= 0.0f) {
                        FlxG.quake.start(this.QuakeIntensityRetryMin, this.TimePressRetry);
                    } else {
                        FlxG.quake.changeIntensity(MathHelper.Lerp(this.QuakeIntensityRetryMin, this.QuakeIntensityRetryMax, this.m_timePressedRetry / this.TimePressRetry));
                    }
                    this.m_timePressedRetry += FlxG.elapsed;
                    if (this.m_timePressedRetry > this.TimePressRetry) {
                        this.m_timePressedRetry = 0.0f;
                        this._goToExplode();
                        AchievementManager.Instance().unlockAchievement("ACH_NANORESET");
                    }
                } else if (this.m_bResetInitiated) {
                    this.m_bResetInitiated = false;
                    this.m_timePressedRetry = 0.0f;
                    FlxG.quake.stop();
                    this.m_sndRestartLevel.stop();
                }
                if (InputManager.IsNewButtonPress(Buttons.Y)) {
                    if (this.canGoToPuzzleMode()) {
                        this.m_sndBlocModeOn.play();
                        this._enterBlocMode();
                    } else {
                        GameVars.PlayerCanDoPuzzle();
                    }
                }
                if (this.m_playMode == ePlayerMode.ePlayerMode_Move && (InputManager.IsButtonDown(Buttons.X) || InputManager.IsButtonDown(Buttons.RightTrigger)) && (this.m_bCanDrillForFake || this._isCompatibleStateForDrilling())) {
                    if (!this.m_bDrilling) {
                        this.m_bDrilling = true;
                    }
                } else if (this.m_bDrilling) {
                    this.m_bDrilling = false;
                }
                this._checkRunningMode();
                this._checkEyeAnim();
                if (MACRO.DEBUG) {
                    this._checkDebugTweakCollectable();
                }
            }
        } else if (this.m_playMode == ePlayerMode.ePlayerMode_Bloc) {
            if (InputManager.IsNewButtonPress(Buttons.Y) || this.m_bLineScanLeaveRequested) {
                if (this.m_blocSpawner.canLeave()) {
                    this.m_blocSpawner.leave(false);
                    this.m_bLineScanLeaveRequested = false;
                } else {
                    this.m_bLineScanLeaveRequested = true;
                }
            } else if (InputManager.IsNewButtonPress(Buttons.X) || InputManager.IsNewButtonPress(Buttons.RightTrigger)) {
                if (this.m_blocSpawner.canLeave() && GameVars.PlayerCanDoLines() > 0) {
                    this.m_blocSpawner.leave(true);
                }
            } else if (InputManager.IsNewButtonPress(Buttons.RightShoulder)) {
                this._selectNextMaterial(true, false);
            } else if (InputManager.IsNewButtonPress(Buttons.LeftShoulder)) {
                this._selectNextMaterial(false, false);
            }
        }
    }

    protected void _leaveCameraMode() {
        this.m_hologramPuzzleZone.endMoveMode();
        this._cameraOutFollowInit();
        if (FlxG.isFollowNotMove(0.001f)) {
            this._moveFollowInit();
        }
    }

    protected void _checkMoveTargetCameraBounds() {
        float bound = this.m_owner.Level().LeftBottom().X + GameVars.CameraBoundMarginsTBLR().Z + (float)FlxG.width * 0.5f - this.m_moveTarget.width * 0.5f;
        if (this.m_moveTarget.x < bound) {
            this.m_moveTarget.x = bound;
        } else {
            bound = this.m_owner.Level().RightTop().X - GameVars.CameraBoundMarginsTBLR().W - (float)FlxG.width * 0.5f + this.m_moveTarget.width * 0.5f;
            if (this.m_moveTarget.x > bound) {
                this.m_moveTarget.x = bound;
            }
        }
        bound = this.m_owner.Level().LeftBottom().Y - GameVars.CameraBoundMarginsTBLR().Y - (float)FlxG.height * 0.5f + this.m_moveTarget.height * 0.5f;
        if (this.m_moveTarget.y > bound) {
            this.m_moveTarget.y = bound;
        } else {
            bound = this.m_owner.Level().RightTop().Y + GameVars.CameraBoundMarginsTBLR().X + (float)FlxG.height * 0.5f - this.m_moveTarget.height * 0.5f;
            if (this.m_moveTarget.y < bound) {
                this.m_moveTarget.y = bound;
            }
        }
    }

    protected void onBlocSpawnerleave(Object sender, Object e) {
        this.m_sndBlocModeOff.play();
        this.m_owner.Level().colorizeForBlocMode(Color.White(), false);
        this._enterMoveMode();
    }

    protected void onBlocSpawnerCursorMove(Object sender, Object e) {
        this.m_materialHub.onPuzzleCursorMove();
    }

    protected void onBlocSpawnerScanLineLaunched(Object sender, Object e) {
    }

    protected void onBlocSpawnerScanLineDone(Object sender, Object e) {
        this.m_materialHub.onLineScanDone();
    }

    protected void onBlocSpawnerDestroyLineLaunched(Object sender, Object e) {
    }

    protected void onBlocSpawnerDestroyLineDone(Object sender, Object e) {
    }

    protected void _changeFacing(FlxSprite.Flx2DFacing _newFacing) {
        if (this.m_owner.facing() != _newFacing) {
            this.m_owner.facing(_newFacing);
            if (this.m_jumpType == eJumpType.eJumpType_MarioBros && (this.m_animState == eAnimState.eAnimState_Jump || this.m_animState == eAnimState.eAnimState_Fall)) {
                this._setRunningFlag(false);
            }
        }
    }

    protected void _fadeComplete(Object sender, Object e) {
        this.m_timePressedRetry = 0.0f;
        FlxG.quake.stop();
        this.m_bResetInitiated = false;
        this.m_owner.Level().restart();
        this.m_bFadeLaunched = false;
    }

    protected void _playDrillEnd() {
        if (this.m_bPlayDrillStartStop) {
            if (this.m_sndDrillEnd.playing()) {
                this.m_sndDrillEnd.stop();
            }
            if (this.m_animState != eAnimState.eAnimState_Jump) {
                this.m_sndDrillEnd.play();
            }
        }
    }

    protected void _checkEyeAnim() {
        boolean bDrilling = this.m_bDrilling && Actor.CanDrillAlmostOneThing();
        switch (this.m_eyeAnimState) {
            case eAnimEyeState_idle: {
                if (!bDrilling) break;
                this.m_eye.play("goOut");
                this.m_eyeAnimState = eAnimEyeState.eAnimEyeState_goOut;
                if (this.m_bPlayDrillStartStop) {
                    if (this.m_sndDrillStart.playing()) {
                        this.m_sndDrillStart.stop();
                    }
                    if (this.m_animStateOld != eAnimState.eAnimState_Fall) {
                        this.m_sndDrillStart.play();
                    }
                }
                if (!this.m_bPlayAleaOnDrillStartStop) break;
                this.m_sndAlea.play();
                break;
            }
            case eAnimEyeState_goOut: {
                if (bDrilling) {
                    if (!this.m_eye.finished) break;
                    this.m_eye.play("turn");
                    if (this.m_bDrillOnlyOnContact) {
                        this.m_eye.CurAnim().changeDelay(this.m_eyeDrillTurnIdleFactor);
                    }
                    this.m_eyeAnimState = eAnimEyeState.eAnimEyeState_turn;
                    break;
                }
                this.m_eye.play("goIn", false, this.m_eye.CurAnim().frames.length - this.m_eye.CurFrame() - 1);
                this.m_eyeAnimState = eAnimEyeState.eAnimEyeState_goIn;
                if (this.m_sndDrillLoop.playing()) {
                    this.m_sndDrillLoop.stop();
                }
                if (this.m_sndDrillLoopInactive.playing()) {
                    this.m_sndDrillLoopInactive.stop();
                }
                this._playDrillEnd();
                if (!this.m_bPlayAleaOnDrillStartStop) break;
                this.m_sndAlea.play();
                break;
            }
            case eAnimEyeState_goIn: {
                if (bDrilling) {
                    this.m_eye.play("goOut", false, this.m_eye.CurAnim().frames.length - this.m_eye.CurFrame() - 1);
                    this.m_eyeAnimState = eAnimEyeState.eAnimEyeState_goOut;
                    break;
                }
                if (!this.m_eye.finished) break;
                this.m_eyeAnimState = eAnimEyeState.eAnimEyeState_idle;
                break;
            }
            case eAnimEyeState_turn: {
                if (bDrilling) {
                    if (!this.m_bDrillOnlyOnContact || this.m_bDrillOnlyOnContact && this.m_bDrillContact) {
                        if (this.m_bDrillContact) {
                            if (this.m_sndDrillLoop.playing()) break;
                            if (this.m_sndDrillLoopInactive.playing()) {
                                this.m_sndDrillLoopInactive.stop();
                            }
                            this.m_sndDrillLoop.play();
                            if (!this.m_bDrillOnlyOnContact) break;
                            this.m_eye.CurAnim().restaureOriginalDelay();
                            break;
                        }
                        if (this.m_sndDrillLoopInactive.playing() || !(this.m_timeElapsedDrillNoContact >= this.m_drillLoopToDrillNoContactLoopDelay)) break;
                        if (this.m_sndDrillLoop.playing()) {
                            this.m_sndDrillLoop.stop();
                        }
                        this.m_sndDrillLoopInactive.play();
                        break;
                    }
                    if (!this.m_bDrillOnlyOnContact || this.m_bDrillContact) break;
                    if (this.m_sndDrillLoop.playing()) {
                        this.m_sndDrillLoop.stop();
                        this.m_eye.CurAnim().changeDelay(this.m_eyeDrillTurnIdleFactor);
                    }
                    if (!this.m_sndDrillLoopInactive.playing()) break;
                    this.m_sndDrillLoopInactive.stop();
                    break;
                }
                this.m_eye.play("goIn");
                this.m_eyeAnimState = eAnimEyeState.eAnimEyeState_goIn;
                if (this.m_sndDrillLoop.playing()) {
                    this.m_sndDrillLoop.stop();
                }
                if (this.m_sndDrillLoopInactive.playing()) {
                    this.m_sndDrillLoopInactive.stop();
                }
                this._playDrillEnd();
                if (!this.m_bPlayAleaOnDrillStartStop) break;
                this.m_sndAlea.play();
            }
        }
    }

    protected void _checkDebugTweakCollectable() {
        if (LauncherState.AllowEdit()) {
            if (InputManager.IsNewButtonPress(Buttons.DPadRight)) {
                if (MACRO.ALLOW_SAVE_LEVEL_ON_DISK) {
                    this._selectNextMaterial(true, true);
                }
            } else if (InputManager.IsNewButtonPress(Buttons.DPadLeft)) {
                if (MACRO.ALLOW_SAVE_LEVEL_ON_DISK) {
                    this._selectNextMaterial(false, true);
                }
            } else if (InputManager.IsNewButtonPress(Buttons.DPadDown)) {
                this._increaseDecreaseCollectableIndex(this.m_selectedIndex, false);
                this.m_materialHub.sync();
            } else if (InputManager.IsNewButtonPress(Buttons.DPadUp)) {
                this._increaseDecreaseCollectableIndex(this.m_selectedIndex, true);
                this.m_materialHub.sync();
            }
        }
    }

    protected void _checkRunningMode() {
        boolean bGoodDelay = false;
        if (this.m_playMode == ePlayerMode.ePlayerMode_Move) {
            boolean bStickLeftRight;
            boolean runButtonDown = InputManager.IsButtonDown(Buttons.X) || InputManager.IsButtonDown(Buttons.RightTrigger);
            boolean bl = bStickLeftRight = this._leftDown() || this._rightDown();
            if (!bStickLeftRight) {
                runButtonDown = false;
            }
            if (this.m_jumpType == eJumpType.eJumpType_MarioBros && bStickLeftRight) {
                if (runButtonDown) {
                    this.m_timeSinceJustReleasedRunButton = 0.0f;
                } else {
                    this.m_timeSinceJustReleasedRunButton += FlxG.elapsed;
                    if (this.m_animState == eAnimState.eAnimState_Jump && this.m_timeSinceJustReleasedRunButton < this.TimeRunButtonDelay) {
                        runButtonDown = true;
                        bGoodDelay = true;
                    }
                }
            }
            if (this.m_bRunning && !runButtonDown) {
                boolean bCanWalk = true;
                if (this.m_jumpType == eJumpType.eJumpType_MarioBros && bStickLeftRight && (this.m_animState == eAnimState.eAnimState_Jump || this.m_animState == eAnimState.eAnimState_Fall)) {
                    bCanWalk = false;
                }
                if (bCanWalk) {
                    this._setRunningFlag(false);
                }
            } else if (!this.m_bRunning && runButtonDown) {
                boolean bCanRun = true;
                if (this.m_jumpType == eJumpType.eJumpType_MarioBros && (this.m_animState == eAnimState.eAnimState_Jump || this.m_animState == eAnimState.eAnimState_Fall) && bGoodDelay) {
                    bCanRun = false;
                }
                if (bCanRun) {
                    this._setRunningFlag(true);
                }
            }
        }
    }

    protected void _setRunningFlag(boolean _bRunning) {
        this.m_bRunning = _bRunning;
        this._initVariables(false);
    }

    protected boolean _selectNextMaterial(boolean _toTheRight, boolean _bCanSelectNull) {
        if (this._selectNextCollectableIndex(_toTheRight, _bCanSelectNull)) {
            if (this.m_playMode == ePlayerMode.ePlayerMode_Bloc) {
                this.m_blocSpawner.syncMaterial();
                this.m_sndShift.play();
            }
            this.m_materialHub.sync();
            return true;
        }
        return false;
    }

    protected void _setMode(ePlayerMode _mode) {
        this.m_playModeOld = this.m_playMode;
        if (this.m_playMode != _mode) {
            this._leaveOldMode();
            this.m_playMode = _mode;
            this.initOwnerFlixelProperties();
            if (this.m_owner.Level().PlayableMode()) {
                this.m_materialHub.enterNewMode(this.m_playMode);
            }
        }
    }

    protected void _leaveOldMode() {
        switch (this.m_playModeOld) {
            case ePlayerMode_Camera: {
                this._leaveCameraMode();
                break;
            }
            case ePlayerMode_Move: {
                this._leaveMoveMode();
            }
        }
    }

    protected void _leaveMoveMode() {
        this.m_bDrilling = false;
        this.m_bRunning = false;
        this.m_owner.acceleration.X = 0.0f;
        this._checkRunningMode();
        this._checkEyeAnim();
        this._initVariables(false);
    }

    protected void _enterMoveMode() {
        if (this.m_playMode != ePlayerMode.ePlayerMode_Move) {
            FlxG.flash.start(Color.White(), 0.5f);
            this._hideFullscreenQuad();
            this._setMode(ePlayerMode.ePlayerMode_Move);
            this.m_owner.Level().PuzzleMode(false);
            this.m_blocSpawner.endActivation();
            if (this.m_blocSpawner.UseLineScan()) {
                this._puzzleOutFollowInit();
            }
            this._syncCollectableHud();
        }
    }

    protected void _enterBlocMode() {
        if (this.m_playMode != ePlayerMode.ePlayerMode_Bloc) {
            FlxG.flash.start(Color.DarkGreen(), 0.5f);
            this.m_owner.Level().colorizeForBlocMode(GameVars.PuzzleColorStain(), true);
            this._showFullscreenQuad();
            this._setMode(ePlayerMode.ePlayerMode_Bloc);
            this.m_owner.Level().PuzzleMode(true);
            this.m_owner.velocity = Vector2.Zero();
            if (this.m_blocSpawner.UseLineScan()) {
                this._puzzleFollowInit();
            }
            this.m_blocSpawner.beginActivation();
            this._syncCollectableHud();
        }
    }

    protected void _checkMode() {
        if (this.m_owner.Level().Mode() == Level.eLevelMode.eLevelMode_Edit) {
            this._enterMoveMode();
        }
    }

    public int getCollectableSelectedIndex() {
        return this.m_selectedIndex;
    }

    public void checkCollectableSelectedIndex() {
        if (this.m_collectableCounters[this.m_selectedIndex] == 0) {
            int correctIndex = -1;
            int i = 0;
            while (i < this.m_collectableCounters.length) {
                if (this.m_collectableCounters[i] > 0) {
                    correctIndex = i;
                    break;
                }
                ++i;
            }
            if (correctIndex > -1 && correctIndex < this.m_collectableCounters.length) {
                this.m_selectedIndex = correctIndex;
            }
        }
    }

    protected boolean _selectNextCollectableIndex(boolean _toTheRight, boolean _bCanSelectNull) {
        int oldIndex = this.m_selectedIndex;
        int step = _toTheRight ? 1 : -1;
        int cur = this.m_selectedIndex;
        boolean bFound = false;
        do {
            if ((cur += step) < 0) {
                cur = this.m_collectableCounters.length - 1;
            } else if (cur >= this.m_collectableCounters.length) {
                cur = 0;
            }
            if (this.m_collectableCounters[cur] <= 0 && !_bCanSelectNull) continue;
            this.m_selectedIndex = cur;
            bFound = true;
        } while (cur != oldIndex && !bFound);
        return this.m_selectedIndex != oldIndex;
    }

    public void decreaseCurrentCollectableStock() {
        if (this.m_collectableCounters[this.m_selectedIndex] > 0) {
            this._increaseDecreaseCollectableIndex(this.m_selectedIndex, false);
            if (this.m_collectableCounters[this.m_selectedIndex] == 0) {
                this._selectNextMaterial(true, false);
            }
        }
        this.m_materialHub.sync();
    }

    public boolean decreaseCollectableStock() {
        boolean doable = false;
        int i = 0;
        while (i < this.m_collectableCounters.length) {
            if (this.m_collectableCounters[i] > 0) {
                this._increaseDecreaseCollectableIndex(i, false);
                doable = true;
                break;
            }
            ++i;
        }
        if (doable) {
            this.m_materialHub.syncDigits();
        }
        return doable;
    }

    public void increaseCollectableStock(Actor.eActorMaterial _mat) {
        int matIndex = _mat.ordinal();
        if (matIndex >= Actor.FirstCollectableMatIdHACK() && matIndex <= Actor.LastCollectableMatIdHACK()) {
            this._increaseDecreaseCollectableIndex(matIndex -= Actor.FirstCollectableMatIdHACK(), true);
        }
    }

    public void changeCollectableIndex(Actor.eActorMaterial _mat) {
        int matIndex = _mat.ordinal();
        if (matIndex >= Actor.FirstCollectableMatIdHACK() && matIndex <= Actor.LastCollectableMatIdHACK() && this.m_selectedIndex != (matIndex -= Actor.FirstCollectableMatIdHACK()) && this.m_collectableCounters[matIndex] > 0) {
            this.m_selectedIndex = matIndex;
            this.m_blocSpawner.syncMaterial();
            this.m_materialHub.sync();
        }
    }

    protected void _makeHologramAppear() {
        this.m_hologramPuzzleZone.show();
    }

    protected void _positionnateHologramInMiddleScreen() {
        this.m_hologramPuzzleZone.updateMiddleScreenPosition(false);
    }

    public void initCustomPar(int _communityPar) {
        this.m_customParCommunity = _communityPar;
        if (this.m_materialHub != null) {
            this.m_materialHub.initializeCustomPar(_communityPar);
            this._requireUpdateHud();
        }
    }

    protected static enum eAnimEyeState {
        eAnimEyeState_idle,
        eAnimEyeState_goOut,
        eAnimEyeState_goIn,
        eAnimEyeState_turn;

    }

    public static enum eAnimState {
        eAnimState_Unknow,
        eAnimState_Idle,
        eAnimState_Walk,
        eAnimState_Run,
        eAnimState_Jump,
        eAnimState_Fall;

    }

    protected static enum eDammageState {
        eDammageState_None,
        eDammageState_BlinkingElectric,
        eDammageState_Electric,
        eDammageState_Exploding,
        eDammageState_Exploded;

    }

    protected static enum eJumpType {
        eJumpType_SuperMeatBoy,
        eJumpType_MarioBros;

    }

    public static enum ePlayerMode {
        ePlayerMode_Unknown,
        ePlayerMode_Bloc,
        ePlayerMode_Move,
        ePlayerMode_Camera,
        ePlayerMode_Dialog,
        ePlayerMode_ShowElement,
        ePlayerMode_ShowLevelResultPAR,
        ePlayerMode_ShowLevelResultBTM;

    }
}

