/*
 * Decompiled with CFR 0.152.
 */
package SSS.Behaviours.BTM;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Graphics.SpriteBatch;
import SSS.Actor;
import SSS.BTM.GameMode;
import SSS.BTM.GameVars;
import SSS.Behaviour;
import SSS.Behaviours.BTM.PlayerBehaviour;
import SSS.Events.CallbackSimple;
import SSS.Managers.BTM.AchievementManager;
import SSS.Managers.BTM.LevelDataBase;
import SSS.Managers.BTM.LevelGroup;
import SSS.Managers.BTM.SaveManager;
import SSS.States.BTM.OnlineLevelBrowsingState;
import SSS.Util.InputManager;
import SSS.Util.Utility;
import System.IAsyncResult;
import org.flixel.FlxFadeListener;
import org.flixel.FlxG;
import org.flixel.FlxSound;
import org.flixel.event.FlxSpriteCollisionEvent;

public class PortalBehaviour
extends Behaviour {
    eSpecialFlag m_specialFlag = eSpecialFlag.eSpecialFlag_None;
    String m_specialArgs;
    ePortalState m_portalState = ePortalState.ePortalState_Born;
    boolean m_bMarketPlaceShown = false;
    ePortalPlayerState m_portalPlayerState = ePortalPlayerState.ePortalPlayerState_Appeared;
    boolean m_bFadeComplete = false;
    boolean m_bEntrancePortal = false;
    float[] m_angles = new float[3];
    float[] m_anglesSpeed = new float[3];
    String[] m_animName = new String[3];
    float m_fadeDuration = 1.0f;
    float m_flashDuration = 0.2f;
    Actor m_mainCharacter;
    boolean m_bAutosaveDone = false;
    float m_timeElapsed = 0.0f;
    float m_timeOpenClose = 1.0f;
    boolean m_bAnimate = true;
    FlxSound m_sndPortal = null;
    boolean m_bSoundPlayed = false;
    float m_previousPlayerX;
    float m_previousPlayerY;
    int m_communityPar = 0;
    FlxFadeListener m_onQuitGame = new FlxFadeListener(){

        @Override
        public void fadeComplete(Object _sender, Object _e) {
            PortalBehaviour.this._onQuitGame(_sender, _e);
        }
    };
    FlxFadeListener m_onThanks = new FlxFadeListener(){

        @Override
        public void fadeComplete(Object _sender, Object _e) {
            PortalBehaviour.this._onThanks(_sender, _e);
        }
    };
    FlxFadeListener m_onMainMenu = new FlxFadeListener(){

        @Override
        public void fadeComplete(Object _sender, Object _e) {
            PortalBehaviour.this._onMainMenu(_sender, _e);
        }
    };
    FlxFadeListener m_beginFadeComplete = new FlxFadeListener(){

        @Override
        public void fadeComplete(Object _sender, Object _args) {
            PortalBehaviour.this._beginFadeComplete(_sender, _args);
        }
    };
    FlxFadeListener m_endFadeComplete = new FlxFadeListener(){

        @Override
        public void fadeComplete(Object _sender, Object _e) {
            PortalBehaviour.this._endFadeComplete(_sender, _e);
        }
    };
    CallbackSimple m_autoSaveComplete = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            PortalBehaviour.this._autoSaveComplete(_sender, _args);
        }
    };

    public PortalBehaviour(String _id, Actor _owner, Actor.eActorMaterial _material) {
        super(_id, _owner, _material);
    }

    @Override
    protected void initOwnerFlixelProperties() {
        this.m_owner.fixed = true;
        this.m_owner.moves = true;
    }

    @Override
    public void init() {
        this.m_bEntrancePortal = this.getIntParameter("EntrancePortal") > 0;
        this.m_animName[0] = this.getStringParameter("AnimIdBack");
        this.m_animName[1] = this.getStringParameter("AnimIdMiddle");
        this.m_animName[2] = this.getStringParameter("AnimIdFront");
        this.m_anglesSpeed[0] = this.getFloatParameter("RotSpeedBack");
        this.m_anglesSpeed[1] = this.getFloatParameter("RotSpeedMiddle");
        this.m_anglesSpeed[2] = this.getFloatParameter("RotSpeedFront");
        this.m_timeOpenClose = this.getFloatParameter("OpeningClosingDuration");
        this.m_fadeDuration = this.getFloatParameter("FadeDuration");
        this.m_flashDuration = this.getFloatParameter("FlashDuration");
        this.m_owner.addRendererBehaviour(this);
        int i = 0;
        while (i < 3) {
            this.m_angles[i] = 0.0f;
            ++i;
        }
        this.m_mainCharacter = this.m_owner.Level().MainPlayer();
        if (this.m_bEntrancePortal) {
            this.m_mainCharacter.visible = false;
            this.m_mainCharacter.x = this.m_owner.x + this.m_owner.width * 0.5f - this.m_mainCharacter.width * 0.5f;
            this.m_mainCharacter.y = this.m_owner.y + this.m_owner.height * 0.5f - this.m_mainCharacter.height * 0.5f;
            this.m_owner.scale(0.0f);
            if (this.m_owner.Level().PlayableMode()) {
                this.m_sndPortal = new FlxSound();
                this.m_sndPortal.loadEmbedded(this.m_owner.Level().MainPlayerBehaviour().getStringParameter("SndPortalBegin"), false, true, true);
            }
        } else if (this.m_owner.Level().PlayableMode()) {
            this.m_sndPortal = new FlxSound();
            this.m_sndPortal.loadEmbedded(this.m_owner.Level().MainPlayerBehaviour().getStringParameter("SndPortalEnd"), false, true, true);
        }
        this._initSpecialFlag();
        if (GameVars.GameCommunityMode()) {
            String nextLevel;
            this.m_communityPar = this.getIntParameter("Par");
            if (this.m_communityPar > 0) {
                this.m_owner.Level().MainPlayerBehaviour().initCustomPar(this.m_communityPar);
            }
            if ((nextLevel = this.getStringParameter("NextLevel")) != null && nextLevel.length() > 0) {
                GameVars.NextCommunityAutoplayLevelName(nextLevel);
            } else {
                GameVars.NextCommunityAutoplayLevelName(null);
            }
        }
        this.update();
    }

    protected void _initSpecialFlag() {
        String specialFlag = this.getStringParameter("SpecialFlag");
        this.m_specialFlag = eSpecialFlag.eSpecialFlag_None;
        if (specialFlag.length() > 0) {
            if (this.m_bEntrancePortal) {
                if (specialFlag.equals("invisibleEntrance")) {
                    this.m_specialFlag = eSpecialFlag.eSpecialFlag_InvisibleStart;
                }
            } else if (specialFlag.equals("door_open")) {
                this.m_owner.scale(0.0f);
                this.m_specialFlag = eSpecialFlag.eSpecialFlag_InvisibleWaitForAllDoorOpened;
            } else if (specialFlag.equals("buyGame")) {
                this.m_specialFlag = eSpecialFlag.eSpecialFlag_BuyGame;
            } else if (specialFlag.equals("mainMenu")) {
                this.m_specialFlag = eSpecialFlag.eSpecialFlag_MainMenu;
            } else if (specialFlag.equals("quitGame")) {
                this.m_specialFlag = eSpecialFlag.eSpecialFlag_QuitGame;
            } else if (specialFlag.equals("invisible_hori")) {
                this.m_owner.scale(0.0f);
                this.m_specialFlag = eSpecialFlag.eSpecialFlag_InvisibleHorizontalEnd;
                this.m_previousPlayerX = this.m_owner.Level().MainPlayer().getCenterX();
                this.m_previousPlayerY = this.m_owner.Level().MainPlayer().getCenterY();
            } else if (specialFlag.equals("invisible")) {
                this.m_owner.scale(0.0f);
                this.m_specialFlag = eSpecialFlag.eSpecialFlag_Invisible;
            } else if (specialFlag.startsWith("goto ")) {
                this.m_specialFlag = eSpecialFlag.eSpecialFlag_GoToLevel;
                this.m_specialArgs = specialFlag.substring(5, specialFlag.length() - 1);
            }
        }
    }

    @Override
    public void deinit() {
    }

    @Override
    public void checkCollisions() {
    }

    @Override
    public void onOverlapsCallback(FlxSpriteCollisionEvent _event, int _callbackId) {
    }

    @Override
    public void update() {
        if (this.m_owner.Level().MainPlayerBehaviour().isModeNew(PlayerBehaviour.ePlayerMode.ePlayerMode_Move)) {
            this.m_bAnimate = true;
            this.m_owner.color(Color.White());
        } else if (this.m_owner.Level().MainPlayerBehaviour().isModeNew(PlayerBehaviour.ePlayerMode.ePlayerMode_Bloc)) {
            this.m_bAnimate = false;
            this.m_owner.color(GameVars.PuzzleColorStain());
        }
        if (!this.m_bAnimate) {
            return;
        }
        int i = 0;
        while (i < 3) {
            int n = i;
            this.m_angles[n] = this.m_angles[n] + FlxG.elapsed * this.m_anglesSpeed[i];
            ++i;
        }
        switch (this.m_portalState) {
            case ePortalState_InvisibleStarted: {
                break;
            }
            case ePortalState_Born: {
                if (this.m_bEntrancePortal) {
                    this.m_portalState = ePortalState.ePortalState_Opening;
                    this.m_timeElapsed = 0.0f;
                    this.m_owner.scale(0.0f);
                    if (this.m_specialFlag == eSpecialFlag.eSpecialFlag_InvisibleStart) {
                        this.m_portalState = ePortalState.ePortalState_InvisibleStarted;
                        this.m_mainCharacter.visible = true;
                    } else {
                        this.m_portalPlayerState = ePortalPlayerState.ePortalPlayerState_Hidden;
                        this.m_mainCharacter.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_PortalControlPlayerBegin, this.m_owner);
                    }
                    LevelDataBase.Instance().markLevelAsOpened(this.m_owner.Level());
                    this.m_bFadeComplete = false;
                    FlxG.fade.start(Color.Black(), this.m_fadeDuration, this.m_beginFadeComplete, true, false);
                    break;
                }
                if (this.m_specialFlag == eSpecialFlag.eSpecialFlag_InvisibleWaitForAllDoorOpened) {
                    this.m_portalState = ePortalState.ePortalState_WaitingForAllDoorOpen;
                    break;
                }
                if (this.m_specialFlag == eSpecialFlag.eSpecialFlag_InvisibleHorizontalEnd) {
                    this.m_portalState = ePortalState.ePortalState_WaitingForPassThroughHorizontal;
                    break;
                }
                this.m_portalState = ePortalState.ePortalState_Opened;
                break;
            }
            case ePortalState_Opening: {
                if (!this.m_bEntrancePortal || !this.m_bFadeComplete) break;
                this.m_timeElapsed += FlxG.elapsed;
                this.m_owner.scale(this.m_timeElapsed / this.m_timeOpenClose);
                if (this.m_owner.scale() > 0.1f) {
                    this._playSound();
                }
                if (!(this.m_owner.scale() > 1.0f)) break;
                this.m_timeElapsed = 0.0f;
                this.m_owner.scale(1.0f);
                this.m_portalState = ePortalState.ePortalState_Opened;
                this.m_portalPlayerState = ePortalPlayerState.ePortalPlayerState_MakeAppear;
                break;
            }
            case ePortalState_Attracting: {
                if (this.m_bEntrancePortal) break;
                if (Utility.IsActorsPhysicsOverlappingFast(this.m_owner, this.m_mainCharacter)) {
                    float threshold;
                    float dx = this.m_owner.getCenterX() - this.m_mainCharacter.getCenterX();
                    float dy = this.m_owner.getCenterY() - this.m_mainCharacter.getCenterY();
                    if (!(dy * dy <= (threshold = (float)GameVars.TileStep() * 3.8f)) || !(dx * dx < threshold)) break;
                    if (this.m_specialFlag == eSpecialFlag.eSpecialFlag_Invisible) {
                        this._updateLevelstatsAndSave();
                        this.m_mainCharacter.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_DisplayLevelResults, this.m_owner);
                        this.m_portalState = ePortalState.ePortalState_DisplayingResults;
                    } else {
                        FlxG.flash.start(Color.White(), this.m_flashDuration);
                        this.m_portalState = ePortalState.ePortalState_Closing;
                        this._playSound();
                    }
                    this.m_mainCharacter.visible = false;
                    this.m_timeElapsed = 0.0f;
                    this.m_owner.Level().GuidePauseAllowed(false);
                    this.m_mainCharacter.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_PortalControlPlayerBegin, this.m_owner);
                    this.m_mainCharacter.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_ValidateUpgrade, this.m_owner);
                    break;
                }
                this.m_portalState = ePortalState.ePortalState_Opened;
                break;
            }
            case ePortalState_Opened: {
                if (this.m_bEntrancePortal) {
                    if (!this.m_mainCharacter.visible) break;
                    this.m_timeElapsed = 0.0f;
                    this.m_portalState = ePortalState.ePortalState_Closing;
                    break;
                }
                if (!Utility.IsActorsPhysicsOverlappingFast(this.m_owner, this.m_mainCharacter)) break;
                this.m_portalState = ePortalState.ePortalState_Attracting;
                break;
            }
            case ePortalState_WaitingForPassThroughHorizontal: {
                float dyOld = this.m_previousPlayerY - this.m_owner.getCenterY();
                float dy = this.m_owner.Level().MainPlayer().getCenterY() - this.m_owner.getCenterY();
                if (!(dyOld * dy <= 0.0f)) break;
                this.m_mainCharacter.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_BigJump, this.m_owner);
                this._updateLevelstatsAndSave();
                this.m_mainCharacter.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_DisplayLevelResults, this.m_owner);
                this.m_portalState = ePortalState.ePortalState_DisplayingResults;
                break;
            }
            case ePortalState_WaitingForAllDoorOpen: {
                if (this.m_bEntrancePortal || !this.m_owner.Level().SwitchObserver().allDoorOpen()) break;
                this.m_mainCharacter.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_DialogControlPlayerBegin, this.m_owner);
                this._updateLevelstatsAndSave();
                this.m_mainCharacter.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_DisplayLevelResults, this.m_owner);
                this.m_portalState = ePortalState.ePortalState_DisplayingResults;
                break;
            }
            case ePortalState_Closing: {
                this.m_timeElapsed += FlxG.elapsed;
                this.m_owner.scale(1.0f - this.m_timeElapsed / this.m_timeOpenClose);
                if (!(this.m_owner.scale() < 0.0f)) break;
                this.m_timeElapsed = 0.0f;
                this.m_owner.scale(0.0f);
                if (!this.m_bEntrancePortal) {
                    if (this.m_specialFlag == eSpecialFlag.eSpecialFlag_None) {
                        this._updateLevelstatsAndSave();
                        this.m_mainCharacter.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_DisplayLevelResults, this.m_owner);
                        this.m_portalState = ePortalState.ePortalState_DisplayingResults;
                        break;
                    }
                    switch (this.m_specialFlag) {
                        case eSpecialFlag_QuitGame: {
                            this.m_bFadeComplete = false;
                            FlxG.fade.start(Color.Black(), 1.0f, this.m_onQuitGame, true, true);
                            this.m_portalState = ePortalState.ePortalState_Closed;
                            break;
                        }
                        case eSpecialFlag_BuyGame: {
                            this.m_portalState = ePortalState.ePortalState_BuyCheckProfile;
                            this.m_portalState = ePortalState.ePortalState_CheckGuideVisible;
                            break;
                        }
                        case eSpecialFlag_MainMenu: {
                            FlxG.fade.start(Color.Black(), 1.0f, this.m_onMainMenu, true, true);
                            this.m_portalState = ePortalState.ePortalState_Closed;
                        }
                    }
                    break;
                }
                this.m_portalState = ePortalState.ePortalState_Closed;
                break;
            }
            case ePortalState_BuyCheckProfile: {
                if (InputManager.IsMainControllerLoggedIn() && InputManager.IsMainControllerCanGoToMarketPlace()) {
                    if (Utility.GuideIsVisible()) break;
                    boolean error = false;
                    try {
                        this.m_bMarketPlaceShown = true;
                    }
                    catch (Exception e) {
                        error = true;
                    }
                    if (error || !this.m_bMarketPlaceShown || !InputManager.IsMainControllerLoggedIn()) break;
                    this.m_portalState = ePortalState.ePortalState_CheckGuideVisible;
                    break;
                }
                if (!InputManager.IsMainControllerLoggedIn()) {
                    if (Utility.GuideIsVisible()) break;
                    try {
                        this.m_portalState = ePortalState.ePortalState_BuyWaitForAnswerSigninDialog;
                    }
                    catch (Exception e) {
                        this.m_owner.Level().returnToMainMenu(false);
                    }
                    break;
                }
                if (InputManager.IsMainControllerCanGoToMarketPlace() || Utility.GuideIsVisible()) break;
                try {
                    this.m_portalState = ePortalState.ePortalState_BuyWaitForAnswerChangeAccountDialog;
                }
                catch (Exception e) {
                    this.m_owner.Level().returnToMainMenu(false);
                }
                break;
            }
            case ePortalState_BuyWaitForAnswerSigninDialog: {
                break;
            }
            case ePortalState_BuyWaitForAnswerChangeAccountDialog: {
                break;
            }
            case ePortalState_BuyShowLogin: {
                if (Utility.GuideIsVisible()) break;
                this.m_portalState = ePortalState.ePortalState_CheckBuySignedOnce;
                Utility.ShowSignInGuideNotBlocking();
                break;
            }
            case ePortalState_CheckBuySignedOnce: {
                if (Utility.GuideIsVisible()) break;
                if (InputManager.IsMainControllerLoggedIn()) {
                    this.m_portalState = ePortalState.ePortalState_BuyCheckProfile;
                    break;
                }
                this.m_portalState = ePortalState.ePortalState_BuyCheckProfile;
                break;
            }
            case ePortalState_CheckGuideVisible: {
                if (Utility.GuideIsVisible()) {
                    this.m_portalState = ePortalState.ePortalState_CheckBuyed;
                }
                this.m_portalState = ePortalState.ePortalState_CheckBuyed;
                break;
            }
            case ePortalState_CheckBuyed: {
                if (Utility.GuideIsVisible()) break;
                this.m_bFadeComplete = false;
                FlxG.fade.start(Color.Black(), 1.0f, this.m_onThanks, true, true);
                this.m_portalState = ePortalState.ePortalState_CheckBuyTerminated;
                break;
            }
            case ePortalState_DisplayingResults: {
                if (!this.m_bEntrancePortal) {
                    AchievementManager.Instance().gatherAchievementDeferred(this.m_owner.Level());
                }
                if (!this.m_owner.Level().MainPlayerBehaviour().endLevelDisplayDone() || this.m_bEntrancePortal) break;
                FlxG.fade.start(Color.Black(), this.m_fadeDuration, this.m_endFadeComplete, true, true);
                this.m_portalState = ePortalState.ePortalState_Closed;
                break;
            }
            case ePortalState_Closed: {
                if (this.m_bEntrancePortal || !this.m_bAutosaveDone || !this.m_bFadeComplete) break;
                this.m_mainCharacter.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_GoToNextLevelGeneric, this.m_owner);
            }
        }
        switch (this.m_portalPlayerState) {
            case ePortalPlayerState_MakeAppear: {
                FlxG.flash.start(Color.White(), this.m_flashDuration);
                this.m_mainCharacter.visible = true;
                this.m_mainCharacter.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_PortalControlPlayerEnd, this.m_owner);
                this.m_portalPlayerState = ePortalPlayerState.ePortalPlayerState_Appeared;
            }
        }
    }

    protected void onSigninQuestion(IAsyncResult result) {
    }

    protected void onChangeSigninQuestion(IAsyncResult result) {
    }

    protected void _onQuitGame(Object _sender, Object _e) {
        if (!this.m_bFadeComplete) {
            this.m_bFadeComplete = true;
            FlxG.Game.Exit();
        }
    }

    protected void _onThanks(Object _sender, Object _e) {
        if (!this.m_bFadeComplete) {
            this.m_bFadeComplete = true;
            this.m_owner.Level().goToTanksLevel();
        }
    }

    protected void _onMainMenu(Object _sender, Object _e) {
        if (!this.m_bFadeComplete) {
            this.m_bFadeComplete = true;
            this.m_owner.Level().returnToMainMenu(false);
        }
    }

    protected void _updateLevelstatsAndSave() {
        if (GameVars.GameMode() == GameMode.GameMode_LocalLevelEditor) {
            this.m_mainCharacter.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_UpdateLevelStats, this.m_owner);
        } else if (GameVars.GameMode() == GameMode.GameMode_OnlineContent) {
            this.m_mainCharacter.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_UpdateLevelStats, this.m_owner);
        } else {
            boolean bUnlockNextLevel = true;
            LevelGroup lg = this.m_owner.Level().Group();
            if (lg != null && lg.Flag() == LevelGroup.eSpecialFlag.Bonuses) {
                bUnlockNextLevel = false;
            }
            this.m_mainCharacter.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_UpdateLevelStats, this.m_owner);
            LevelDataBase.Instance().markLevelAsDone(this.m_mainCharacter.Level());
            LevelDataBase.Instance().getNextLevelName(this.m_mainCharacter.Level(), bUnlockNextLevel);
            SaveManager.Instance().saveGameDataThreaded(this.m_autoSaveComplete);
        }
    }

    protected void _playSound() {
        if (!this.m_bSoundPlayed) {
            this.m_sndPortal.play();
            this.m_bSoundPlayed = true;
        }
    }

    protected void _beginFadeComplete(Object sender, Object e) {
        if (!this.m_bFadeComplete) {
            this.m_bFadeComplete = true;
            FlxG.fade.stop();
        }
    }

    protected void _endFadeComplete(Object sender, Object e) {
        if (!this.m_bFadeComplete) {
            this.m_bFadeComplete = true;
            if (GameVars.GameMode() == GameMode.GameMode_LocalLevelEditor || GameVars.GameMode() == GameMode.GameMode_OnlineContent) {
                if (this.m_specialFlag == eSpecialFlag.eSpecialFlag_GoToLevel && this.m_specialArgs != null) {
                    OnlineLevelBrowsingState.NextStartAction(OnlineLevelBrowsingState.eLoadAction.AutoLaunchLevel, this.m_specialArgs);
                } else {
                    if (GameVars.GameMode() == GameMode.GameMode_LocalLevelEditor) {
                        OnlineLevelBrowsingState.NextStartAction(OnlineLevelBrowsingState.eLoadAction.SaveFinishedLevelContentDat);
                    } else {
                        OnlineLevelBrowsingState.NextStartAction(OnlineLevelBrowsingState.eLoadAction.CommunityLevelDone);
                    }
                    this.m_owner.Level().returnToLevelHub();
                }
            }
        }
    }

    protected void _autoSaveComplete(Object sender, Object e) {
        this.m_bAutosaveDone = true;
    }

    @Override
    public void onParamsChanged() {
    }

    @Override
    public void render(SpriteBatch spriteBatch) {
        int i = 1;
        while (i < 3) {
            this.m_owner.angle(this.m_angles[i]);
            this.m_owner.play(this.m_animName[i]);
            this.m_owner.renderBase(spriteBatch);
            ++i;
        }
        this.m_owner.angle(this.m_angles[0]);
        this.m_owner.play(this.m_animName[0]);
    }

    static enum ePortalPlayerState {
        ePortalPlayerState_Hidden,
        ePortalPlayerState_MakeAppear,
        ePortalPlayerState_Appeared,
        ePortalPlayerState_Disappeared;

    }

    static enum ePortalState {
        ePortalState_Born,
        ePortalState_Opening,
        ePortalState_Attracting,
        ePortalState_Opened,
        ePortalState_CheckBuyed,
        ePortalState_CheckGuideVisible,
        ePortalState_BuyWaitForAnswerSigninDialog,
        ePortalState_BuyWaitForAnswerChangeAccountDialog,
        ePortalState_BuyShowLogin,
        ePortalState_CheckBuySignedOnce,
        ePortalState_GuideVisible,
        ePortalState_CheckBuyTerminated,
        ePortalState_Closing,
        ePortalState_BuyCheckProfile,
        ePortalState_Buy,
        ePortalState_DisplayingResults,
        ePortalState_Closed,
        ePortalState_InvisibleStarted,
        ePortalState_WaitingForAllDoorOpen,
        ePortalState_WaitingForPassThroughHorizontal;

    }

    static enum eSpecialFlag {
        eSpecialFlag_None,
        eSpecialFlag_InvisibleStart,
        eSpecialFlag_InvisibleWaitForAllDoorOpened,
        eSpecialFlag_BuyGame,
        eSpecialFlag_QuitGame,
        eSpecialFlag_InvisibleHorizontalEnd,
        eSpecialFlag_Invisible,
        eSpecialFlag_GoToLevel,
        eSpecialFlag_MainMenu;

    }
}

