/*
 * Decompiled with CFR 0.152.
 */
package SSS.Behaviours.BTM;

import SSS.Actor;
import SSS.Behaviour;
import SSS.Managers.BTM.BlocksSoundsManager;
import SSS.Util.Utility;
import org.flixel.FlxG;
import org.flixel.event.FlxSpriteCollisionEvent;

public class SlimeDropBehaviour
extends Behaviour {
    static final int CallbackId_EnnemiesOverlap = 0;
    Actor m_spawnOwner = null;
    protected eSlimeDropState m_slimeState = eSlimeDropState.eSlimeDropState_Falling;
    protected Actor m_collapseActor = null;
    float SlimeDropSpeed = 1.0f;
    boolean m_bPaused = false;

    public SlimeDropBehaviour(String _id, Actor _owner, Actor.eActorMaterial _material) {
        super(_id, _owner, _material);
    }

    @Override
    protected void initOwnerFlixelProperties() {
        this.m_owner.fixed = true;
        this.m_owner.moves = true;
    }

    @Override
    public void init() {
        this._goToState(eSlimeDropState.eSlimeDropState_Falling);
        this.SlimeDropSpeed = this.getFloatParameter("SlimeDropSpeed");
    }

    @Override
    public void deinit() {
    }

    @Override
    public void update() {
        block12: {
            block13: {
                if (!this.m_owner.Level().PlayableMode()) break block12;
                if (this.m_owner.Level().PuzzleMode()) break block13;
                if (this.m_bPaused) {
                    this.m_bPaused = false;
                    this.m_owner.CurAnim().restaureOriginalDelay();
                    if (this.m_spawnOwner != null) {
                        this.m_owner.color(this.m_spawnOwner.color());
                    }
                }
                switch (SlimeDropBehaviour.$SWITCH_TABLE$SSS$Behaviours$BTM$SlimeDropBehaviour$eSlimeDropState()[this.m_slimeState.ordinal()]) {
                    case 2: {
                        this.m_collapseActor = this.m_owner.Level().BlocManager().isCollidingWithBlocBelow(this.m_owner, 2.0f);
                        if (this.m_collapseActor != null) {
                            this._goToState(eSlimeDropState.eSlimeDropState_Splashing);
                            break;
                        }
                        this._checkPlayerEnnemiesCollisions();
                        this.m_owner.y += FlxG.elapsed * this.SlimeDropSpeed;
                        break;
                    }
                    case 3: {
                        this._goToState(eSlimeDropState.eSlimeDropState_Destroying);
                        break;
                    }
                    case 4: {
                        if (!this.m_owner.finished) break block12;
                        this._goToState(eSlimeDropState.eSlimeDropState_Dead);
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block12;
            }
            if (!this.m_bPaused) {
                this.m_bPaused = true;
                this.m_owner.CurAnim().changeDelay(0.0f);
                if (this.m_spawnOwner != null) {
                    this.m_owner.color(this.m_spawnOwner.color());
                }
            }
        }
    }

    protected void _goToState(eSlimeDropState _state) {
        switch (_state) {
            case eSlimeDropState_Falling: {
                this.m_owner.play("loop");
                break;
            }
            case eSlimeDropState_Splashing: {
                if (this.m_collapseActor != null) {
                    this.m_owner.y = this.m_collapseActor.y - this.m_owner.height;
                    this.m_collapseActor.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_SlimeDropContact, this.m_owner);
                }
                this.m_owner.play("splash");
                break;
            }
            case eSlimeDropState_Dead: {
                this.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_SlimeDropDie, this.m_owner);
                break;
            }
        }
        this.m_slimeState = _state;
    }

    @Override
    public void checkCollisions() {
    }

    @Override
    public void onOverlapsCallback(FlxSpriteCollisionEvent _event, int _callbackId) {
        switch (_callbackId) {
            case 0: {
                this._sendTouchEventToActor((Actor)_event.Object1());
            }
        }
    }

    @Override
    public void handleGenericMessage(Actor.eGenericMessage _message, Actor _sender) {
        switch (_message) {
            case eGenericMessage_SlimeDropBorn: {
                this.m_owner.x = _sender.x + _sender.width * 0.5f - this.m_owner.width * 0.5f;
                this.m_owner.y = _sender.y + _sender.height;
                this.m_owner.visible = true;
                this.m_spawnOwner = _sender;
                this.m_collapseActor = null;
                this.m_owner.Level().BlocSoundManager().triggerBlocSoundEvent(BlocksSoundsManager.eBlocSoundEvent.eBlocSoundEvent_FireDropBorn, this.m_owner);
                this._goToState(eSlimeDropState.eSlimeDropState_Falling);
                break;
            }
            case eGenericMessage_SlimeDropDie: {
                this.m_owner.Level().BlocSoundManager().triggerBlocSoundEvent(BlocksSoundsManager.eBlocSoundEvent.eBlocSoundEvent_FireDropSplash, this.m_owner);
                this.m_spawnOwner.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_SlimeDropDie, this.m_owner);
                this.m_owner.visible = false;
            }
        }
    }

    @Override
    public void onParamsChanged() {
        this.init();
    }

    protected void _checkPlayerEnnemiesCollisions() {
        if (Utility.IsActorsPhysicsOverlappingFast(this.m_owner.Level().MainPlayer(), this.m_owner)) {
            this._sendTouchEventToActor(this.m_owner.Level().MainPlayer());
        }
    }

    protected void _sendTouchEventToActor(Actor _actor) {
        if (this.m_collapseActor == null) {
            this.m_collapseActor = _actor;
            this._goToState(eSlimeDropState.eSlimeDropState_Splashing);
        }
    }

    public static enum eSlimeDropState {
        eSlimeDropState_Borning,
        eSlimeDropState_Falling,
        eSlimeDropState_Splashing,
        eSlimeDropState_Destroying,
        eSlimeDropState_Dead;

    }
}

