/*
 * Decompiled with CFR 0.152.
 */
package SSS.Behaviours.BTM;

import Microsoft.Xna.Framework.Graphics.SpriteBatch;
import SSS.Actor;
import SSS.Behaviour;
import java.util.ArrayList;
import java.util.Random;
import java.util.Stack;
import org.flixel.FlxG;
import org.flixel.FlxSprite;
import org.flixel.event.FlxSpriteCollisionEvent;

public class SpawnSlimeDropBehaviour
extends Behaviour {
    FlxSprite m_effect = null;
    static Random Rnd = new Random();
    float InitialDelay = 0.0f;
    float FreqDrop = 1.0f;
    float SpeedDrop = 1.0f;
    String DropActorName = "slimedrop";
    float m_timeLeftBeforeFirstSpawn = 0.0f;
    Stack<Actor> m_poolDrop = new Stack();
    ArrayList<Actor> m_livingDrops = new ArrayList(10);
    float m_timeLeftUntilDrop = 0.0f;

    public SpawnSlimeDropBehaviour(String _id, Actor _owner, Actor.eActorMaterial _material) {
        super(_id, _owner, _material);
    }

    @Override
    protected void initOwnerFlixelProperties() {
    }

    @Override
    public void init() {
        this.m_effect = this.m_owner.Level().instanciateSprite("slime_drop_source");
        this.m_effect.play("idle");
        this.m_effect.x = this.m_owner.x + this.m_owner.width * 0.5f - this.m_effect.width * 0.5f;
        this.m_effect.y = this.m_owner.y + this.m_owner.height * 0.5f - this.m_effect.height * 0.5f;
        this.InitialDelay = this.getFloatParameter("InitialDelay");
        this.FreqDrop = this.getFloatParameter("FreqDrop");
        this.SpeedDrop = this.getFloatParameter("DropSpeed");
        this.DropActorName = this.getStringParameter("DropActorName");
        this.m_timeLeftBeforeFirstSpawn = this.InitialDelay;
        int i = 0;
        while (i < 10) {
            this._pushNewDrop();
            ++i;
        }
        this.m_timeLeftUntilDrop = 0.0f;
        this.m_owner.CanUpdateBehaviour(true);
        this._registerRendererBehaviour();
    }

    protected void _pushNewDrop() {
        Actor slimeDrop = this.m_owner.Level().instanciateActor(this.DropActorName);
        slimeDrop.createComponents(this.m_owner.Level(), false);
        slimeDrop.getBehaviour(0).setFloatParameter("SlimeDropSpeed", this.SpeedDrop);
        slimeDrop.notifyBehavioursParameterChanges();
        slimeDrop.visible = false;
        this.m_owner.Level().addActorToLayer(this.m_owner.Level().LayerIso(), slimeDrop);
        this.m_poolDrop.push(slimeDrop);
    }

    @Override
    public void deinit() {
    }

    protected void _spawnDropSlime() {
        Actor drop = null;
        if (this.m_poolDrop.size() == 0) {
            this._pushNewDrop();
        }
        drop = this.m_poolDrop.pop();
        drop.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_SlimeDropBorn, this.m_owner);
        this.m_livingDrops.add(drop);
    }

    @Override
    public void update() {
        if (!this.m_owner.Level().PuzzleMode()) {
            if (this.m_owner.Level().PlayableMode()) {
                this.m_timeLeftBeforeFirstSpawn -= FlxG.elapsed;
                if (this.m_timeLeftBeforeFirstSpawn <= 0.0f) {
                    this.m_timeLeftBeforeFirstSpawn = 0.0f;
                    this.m_timeLeftUntilDrop -= FlxG.elapsed;
                    if (this.m_timeLeftUntilDrop <= 0.0f) {
                        this._spawnDropSlime();
                        this.m_timeLeftUntilDrop = this.FreqDrop + this.m_timeLeftUntilDrop;
                    }
                }
            } else {
                this.m_effect.x = this.m_owner.x + this.m_owner.width * 0.5f - this.m_effect.width * 0.5f;
                this.m_effect.y = this.m_owner.y + this.m_owner.height * 0.5f - this.m_effect.height * 0.5f;
            }
            this.m_effect.update();
        }
    }

    @Override
    public void checkCollisions() {
    }

    @Override
    public void onOverlapsCallback(FlxSpriteCollisionEvent _event, int _callbackId) {
    }

    @Override
    public void handleGenericMessage(Actor.eGenericMessage _message, Actor _sender) {
        switch (_message) {
            case eGenericMessage_SlimeDropDie: {
                this.m_poolDrop.push(_sender);
                this.m_livingDrops.remove(_sender);
                break;
            }
            case eGenericMessage_PlayerHitByJump: {
                _sender.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_SlimeDropContact, this.m_owner);
            }
        }
    }

    @Override
    public void render(SpriteBatch spriteBatch) {
        this.m_effect.color(this.m_owner.color());
        this.m_effect.render(spriteBatch);
    }
}

