/*
 * Decompiled with CFR 0.152.
 */
package SSS.Behaviours.BTM;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Graphics.SpriteBatch;
import SSS.Actor;
import SSS.BTM.GameVars;
import SSS.Behaviour;
import SSS.Managers.BTM.TextDataBase;
import org.flixel.FlxText;
import org.flixel.event.FlxSpriteCollisionEvent;

public class SpawnText
extends Behaviour {
    FlxText m_text = null;

    public SpawnText(String _id, Actor _owner, Actor.eActorMaterial _material) {
        super(_id, _owner, _material);
    }

    @Override
    protected void initOwnerFlixelProperties() {
    }

    @Override
    public void init() {
        String textId = this.getStringParameter("TextIdOrNil");
        if (textId != null && textId.length() > 0) {
            String text;
            this.m_text = GameVars.GameCommunityMode() ? new FlxText(0.0f, 0.0f, 500.0f, (text = TextDataBase.Instance().getTextSafe(textId)) != null ? text : textId) : new FlxText(0.0f, 0.0f, 500.0f, TextDataBase.Instance().getText(textId));
            this.m_text.alignment = FlxText.FlxJustification.Center;
            this.m_text.scale(this.getFloatParameter("Scale"));
            this.m_text.scrollFactor = this.m_owner.scrollFactor;
            String[] color = this.getStringParameter("Color").split(";");
            try {
                this.m_text.color(new Color(Float.parseFloat(color[0]), Float.parseFloat(color[1]), Float.parseFloat(color[2])));
                this.m_text.alpha(Float.parseFloat(color[3]));
            }
            catch (Exception e) {
                this.m_text.color(new Color(0.0f, 0.0f, 0.0f));
                this.m_text.alpha(1.0f);
            }
            float shadowOffset = this.getFloatParameter("ShadowOffset");
            if (shadowOffset > 0.0f) {
                color = this.getStringParameter("ShadowColor").split(";");
                this.m_text.shadow(new Color(Float.parseFloat(color[0]), Float.parseFloat(color[1]), Float.parseFloat(color[2]), Float.parseFloat(color[3])));
                this.m_text.UseShadow(true);
            } else {
                this.m_text.UseShadow(false);
            }
        }
        if (this.m_text != null) {
            this._registerRendererBehaviour();
            this.m_owner.AlwaysVisible(true);
        }
        if (this.m_owner.Level().PlayableMode()) {
            this.m_owner.alpha(0.0f);
        } else {
            this.m_owner.alpha(0.5f);
        }
    }

    @Override
    public void deinit() {
    }

    @Override
    public void update() {
    }

    @Override
    public void checkCollisions() {
    }

    @Override
    public void onOverlapsCallback(FlxSpriteCollisionEvent _event, int _callbackId) {
    }

    @Override
    public void render(SpriteBatch spriteBatch) {
        if (this.m_text != null) {
            this.m_text.x = this.m_owner.x + this.m_owner.width * 0.5f - this.m_text.width * 0.5f;
            this.m_text.y = this.m_owner.y + this.m_owner.height * 0.5f - this.m_text.height * 0.5f;
            this.m_text.render(spriteBatch);
        }
    }

    @Override
    public void onParamsChanged() {
        this.init();
    }
}

