/*
 * Decompiled with CFR 0.152.
 */
package SSS.Behaviours.BTM;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Point;
import SSS.Actor;
import SSS.BTM.GameMode;
import SSS.BTM.GameVars;
import SSS.Behaviour;
import SSS.BehaviourParameter;
import SSS.Behaviours.BTM.PlayerBehaviour;
import SSS.Events.CallbackSimple;
import SSS.Managers.BTM.AchievementManager;
import SSS.Managers.BTM.BlocksSoundsManager;
import java.util.Map;
import org.flixel.FlxG;
import org.flixel.FlxSound;
import org.flixel.event.FlxSpriteCollisionEvent;

public class SpawnWorkshopBehaviour
extends Behaviour {
    eWorkshopState m_state = eWorkshopState.eWorkshopState_Closed;
    eUpgradingState m_upgradeState = eUpgradingState.eUpgradingState_WaitingIdle;
    float m_upgradeElapsed = 0.0f;
    int m_upgradeCounter = 0;
    eLighAnim m_lightAnim = eLighAnim.eLighAnim_None;
    boolean m_bflashing = false;
    boolean m_bUpdgradeDone = false;
    boolean m_bNeedShowOpeningOnCam = false;
    boolean m_bHaveCamFocus = false;
    float m_timeFocus = 0.0f;
    static float TimeFocusMax = 1.0f;
    Actor.eActorMaterial m_matUpgradeOrUnknown = Actor.eActorMaterial.eActorMaterial_Unknown;
    boolean m_bUnlockPuzzle = false;
    boolean m_bUnlockLine = false;
    boolean m_bNeedDeferredInit = false;
    String m_dialogUIEnd = null;
    FlxSound m_sndUpgraded = null;
    FlxSound m_sndUpgrading = null;
    FlxSound m_sndOpen = null;
    FlxSound m_sndClose = null;
    Actor m_fakeActor = new Actor();
    Actor[] m_groundsActors = null;
    static Point[] m_groundsActorsOffsets = new Point[]{new Point(0, 0), new Point(0, 1), new Point(0, 2), new Point(1, 2), new Point(2, 2), new Point(2, 1), new Point(2, 0)};
    Actor[] m_lightActors = null;
    static Point[] m_lightActorsOffsets = new Point[]{new Point(0, 0), new Point(0, 1), new Point(0, 2), new Point(1, 2), new Point(2, 2), new Point(2, 1), new Point(2, 0), new Point(1, 0)};
    static boolean[][] LightAnim;
    static int LightAnimLength;
    Actor[] m_centralCaches;
    static Point[] m_centralCachesOffsets;
    Actor[] m_inivibleCollisions;
    Actor m_hatch;
    Actor m_plusSign;
    CallbackSimple m_onFlashEnd = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            SpawnWorkshopBehaviour.this._onFlashEnd(_sender, _args);
        }
    };

    static {
        boolean[][] blArrayArray = new boolean[9][];
        boolean[] blArray = new boolean[8];
        blArray[0] = true;
        blArrayArray[0] = blArray;
        boolean[] blArray2 = new boolean[8];
        blArray2[1] = true;
        blArrayArray[1] = blArray2;
        boolean[] blArray3 = new boolean[8];
        blArray3[2] = true;
        blArrayArray[2] = blArray3;
        boolean[] blArray4 = new boolean[8];
        blArray4[3] = true;
        blArrayArray[3] = blArray4;
        boolean[] blArray5 = new boolean[8];
        blArray5[4] = true;
        blArrayArray[4] = blArray5;
        boolean[] blArray6 = new boolean[8];
        blArray6[5] = true;
        blArrayArray[5] = blArray6;
        boolean[] blArray7 = new boolean[8];
        blArray7[6] = true;
        blArrayArray[6] = blArray7;
        boolean[] blArray8 = new boolean[8];
        blArray8[7] = true;
        blArrayArray[7] = blArray8;
        blArrayArray[8] = new boolean[8];
        LightAnim = blArrayArray;
        LightAnimLength = LightAnim.length * LightAnim[0].length;
        m_centralCachesOffsets = new Point[]{new Point(1, 0), new Point(1, 1)};
    }

    public SpawnWorkshopBehaviour(String _id, Actor _owner, Actor.eActorMaterial _material) {
        super(_id, _owner, _material);
    }

    @Override
    protected void initOwnerFlixelProperties() {
    }

    protected boolean unlockStuffIdContained(String[] unlockStuffId, String idSearched) {
        int i = 0;
        while (i < unlockStuffId.length) {
            if (idSearched.equals(unlockStuffId[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected Actor.eActorMaterial getFirstMaterialOrUnknown(String[] unlockStuffId) {
        int i = 0;
        while (i < unlockStuffId.length) {
            if (Actor.DoesFriendlyMaterialNamesContain(unlockStuffId[i])) {
                return Actor.MaterialNameEnumDictionnary.get(unlockStuffId[i]);
            }
            ++i;
        }
        return Actor.eActorMaterial.eActorMaterial_Unknown;
    }

    @Override
    public void init() {
        if (GameVars.GameCommunityMode()) {
            this.m_bNeedDeferredInit = true;
            if (this.m_owner.Level().PlayableMode()) {
                this.m_owner.alpha(0.0f);
            }
        } else {
            this.m_bNeedDeferredInit = false;
            this._init();
        }
    }

    protected void _init() {
        if (this.m_owner.Level().PlayableMode()) {
            boolean bNeedUpgrade = false;
            String test = this.getStringParameter("unlockableStuffId");
            String[] unlockStuffId = test.split(",");
            this.m_bUnlockPuzzle = this.unlockStuffIdContained(unlockStuffId, "puzzle");
            if (this.m_bUnlockPuzzle && GameVars.PlayerCanDoPuzzle() == 0) {
                bNeedUpgrade = true;
            }
            this.m_bUnlockLine = this.unlockStuffIdContained(unlockStuffId, "line");
            if (this.m_bUnlockLine && GameVars.PlayerCanDoLines() == 0) {
                bNeedUpgrade = true;
            }
            this.m_matUpgradeOrUnknown = this.getFirstMaterialOrUnknown(unlockStuffId);
            if (this.m_matUpgradeOrUnknown != Actor.eActorMaterial.eActorMaterial_Unknown && GameVars.MaxDrillableMatId() < this.m_matUpgradeOrUnknown.ordinal()) {
                bNeedUpgrade = true;
            }
            this.m_dialogUIEnd = this.getStringParameter("dialogUpgradeIdOrNil");
            this.m_owner.alpha(0.0f);
            this._buildActors();
            if (!bNeedUpgrade) {
                this.m_bUpdgradeDone = true;
                this._goTo(eWorkshopState.eWorkshopState_IdleDone);
            } else {
                this.m_plusSign.play("li_plus_on");
                this.m_bNeedShowOpeningOnCam = true;
                this.m_bUpdgradeDone = false;
                this._goTo(eWorkshopState.eWorkshopState_ShowItSelf);
            }
            this.m_sndUpgraded = new FlxSound();
            this.m_sndUpgraded.loadEmbedded(this.getStringParameter("SndUpgraded"), false, true, true);
            this.m_sndOpen = new FlxSound();
            this.m_sndOpen.loadEmbedded(this.getStringParameter("SndOpen"), false, true, true);
            this.m_sndClose = new FlxSound();
            this.m_sndClose.loadEmbedded(this.getStringParameter("SndClose"), false, true, true);
            this.m_sndUpgrading = new FlxSound();
            this.m_sndUpgrading.loadEmbedded(this.getStringParameter("SndUpgrading"), true, true, false);
        }
    }

    protected void _buildActors() {
        Actor actor = null;
        this.m_groundsActors = new Actor[m_groundsActorsOffsets.length];
        int specialId = this.m_groundsActors.length - 1;
        int i = 0;
        while (i < this.m_groundsActors.length) {
            if (i == specialId) {
                actor = this.m_owner.Level().instanciateActor("workshopElementsBloc");
                actor.play("hack");
            } else {
                actor = this.m_owner.Level().instanciateActor("workshopBloc");
            }
            actor.x = this.m_owner.x + (float)(SpawnWorkshopBehaviour.m_groundsActorsOffsets[i].X * GameVars.TileStep());
            actor.y = this.m_owner.y + (float)(SpawnWorkshopBehaviour.m_groundsActorsOffsets[i].Y * GameVars.TileStep());
            actor.fixed = true;
            actor.moves = true;
            if (i == specialId) {
                this.m_owner.Level().BlocManager().registerUnremovableBloc(actor);
            } else {
                actor.createComponents(this.m_owner.Level(), false);
            }
            this.m_owner.Level().addActorToLayer(this.m_owner.Level().LayerPhysics(), actor);
            this.m_groundsActors[i] = actor;
            ++i;
        }
        this.m_inivibleCollisions = new Actor[m_centralCachesOffsets.length];
        i = 0;
        while (i < this.m_inivibleCollisions.length) {
            actor = this.m_owner.Level().instanciateActor("workshopBloc");
            actor.x = this.m_owner.x + (float)(SpawnWorkshopBehaviour.m_centralCachesOffsets[i].X * GameVars.TileStep());
            actor.y = this.m_owner.y + (float)(SpawnWorkshopBehaviour.m_centralCachesOffsets[i].Y * GameVars.TileStep());
            actor.fixed = true;
            actor.moves = true;
            actor.alpha(0.0f);
            actor.createComponents(this.m_owner.Level(), false);
            this.m_owner.Level().addActorToLayer(this.m_owner.Level().LayerPhysics(), actor);
            this.m_inivibleCollisions[i] = actor;
            ++i;
        }
        this.m_centralCaches = new Actor[m_centralCachesOffsets.length];
        i = 0;
        while (i < this.m_centralCaches.length) {
            actor = this.m_owner.Level().instanciateActor("workshopElementsBloc");
            actor.x = this.m_owner.x + (float)(SpawnWorkshopBehaviour.m_centralCachesOffsets[i].X * GameVars.TileStep());
            actor.y = this.m_owner.y + (float)(SpawnWorkshopBehaviour.m_centralCachesOffsets[i].Y * GameVars.TileStep());
            actor.play("front");
            this.m_centralCaches[i] = actor;
            this.m_owner.Level().LayerForeGround().get(0).add(actor);
            ++i;
        }
        this.m_lightActors = new Actor[m_lightActorsOffsets.length];
        i = 0;
        while (i < m_lightActorsOffsets.length) {
            actor = this.m_owner.Level().instanciateActor("workshopElementsBloc");
            actor.x = this.m_owner.x + (float)(SpawnWorkshopBehaviour.m_lightActorsOffsets[i].X * GameVars.TileStep());
            actor.y = this.m_owner.y + (float)(SpawnWorkshopBehaviour.m_lightActorsOffsets[i].Y * GameVars.TileStep());
            actor.play("li_sq_off");
            this.m_lightActors[i] = actor;
            this.m_owner.Level().LayerForeGround().get(1).add(actor);
            ++i;
        }
        this.m_plusSign = this.m_owner.Level().instanciateActor("workshopElementsBloc");
        this.m_plusSign.x = this.m_owner.x + (float)(SpawnWorkshopBehaviour.m_centralCachesOffsets[1].X * GameVars.TileStep());
        this.m_plusSign.y = this.m_owner.y + (float)(SpawnWorkshopBehaviour.m_centralCachesOffsets[1].Y * GameVars.TileStep());
        this.m_plusSign.play("li_plus_off");
        this.m_owner.Level().LayerForeGround().get(1).add(this.m_plusSign);
        this.m_hatch = this.m_owner.Level().instanciateActor("workshopElementsBloc");
        this.m_hatch.x = this.m_owner.x + (float)(SpawnWorkshopBehaviour.m_centralCachesOffsets[0].X * GameVars.TileStep());
        this.m_hatch.y = this.m_owner.y + (float)(SpawnWorkshopBehaviour.m_centralCachesOffsets[0].Y * GameVars.TileStep());
        this.m_hatch.play("close");
        this.m_owner.Level().LayerBackGround().get(0).add(this.m_hatch);
    }

    @Override
    public void deinit() {
        if (this.m_sndUpgrading != null && this.m_sndUpgrading.playing()) {
            this.m_sndUpgrading.stop();
        }
    }

    @Override
    public void update() {
        if (this.m_bNeedDeferredInit) {
            this._init();
            this.m_bNeedDeferredInit = false;
        }
        if (!this.m_owner.Level().PlayableMode() || this.m_owner.Level().PuzzleMode()) {
            return;
        }
        switch (this.m_state) {
            case eWorkshopState_ShowItSelf: {
                this._indicateMaterialNeeded();
                this._goTo(eWorkshopState.eWorkshopState_Closed);
                break;
            }
            case eWorkshopState_Closed: {
                if (!this._canOpen()) break;
                this.m_owner.Level().BlocSoundManager().triggerBlocSoundEvent(BlocksSoundsManager.eBlocSoundEvent.eBlocSoundEvent_AllOreGathered, this.m_owner);
                this._goTo(eWorkshopState.eWorkshopState_Opening);
                break;
            }
            case eWorkshopState_Closing: {
                if (!this.m_hatch.finished) break;
                this._goTo(eWorkshopState.eWorkshopState_Closed);
                break;
            }
            case eWorkshopState_Opened: {
                if (this.m_bHaveCamFocus) {
                    this.m_timeFocus += FlxG.elapsed;
                    if (!(this.m_timeFocus > TimeFocusMax)) break;
                    this.m_bHaveCamFocus = false;
                    this.m_owner.Level().MainPlayer().handleGenericMessage(Actor.eGenericMessage.eGenericMessage_LookAtGiveBack, this.m_owner);
                    break;
                }
                if (!this._canOpen()) {
                    this._goTo(eWorkshopState.eWorkshopState_Closing);
                    break;
                }
                if (!this.m_owner.Level().MainPlayerBehaviour().isAnimState(PlayerBehaviour.eAnimState.eAnimState_Fall) || !this.m_owner.Level().MainPlayer().overlaps(this.m_inivibleCollisions[0])) break;
                this._goTo(eWorkshopState.eWorkshopState_Upgrading);
                break;
            }
            case eWorkshopState_AttractingCam: {
                if (!this.m_bHaveCamFocus) break;
                this._goTo(eWorkshopState.eWorkshopState_Opening);
                break;
            }
            case eWorkshopState_Opening: {
                if (!this.m_hatch.finished) break;
                this._goTo(eWorkshopState.eWorkshopState_Opened);
                break;
            }
            case eWorkshopState_Upgrading: {
                if (!this._updateUpgrading()) break;
                this._goTo(eWorkshopState.eWorkshopState_UpgradingDone);
                break;
            }
            case eWorkshopState_UpgradingDone: {
                if (this.m_bflashing) break;
                if (this.m_dialogUIEnd != null && this.m_dialogUIEnd.length() > 0) {
                    this.m_owner.Level().DialogManager().startDialog(this.m_dialogUIEnd, null, null, null);
                }
                this._goTo(eWorkshopState.eWorkshopState_IdleDone);
                break;
            }
        }
        this._updateLightAnim();
    }

    protected void _updateLightAnim() {
    }

    protected void _consumePlayerMaterial() {
        int amount = 0;
        for (Map.Entry<String, BehaviourParameter<Integer>> matAmount : this.IntParamsDictionary().entrySet()) {
            amount = matAmount.getValue().getValue();
            if (amount <= 0) continue;
            this.m_fakeActor.Material(Actor.MaterialNameEnumDictionnary.get(matAmount.getKey()));
            int i = 0;
            while (i < amount) {
                this.m_owner.Level().MainPlayerBehaviour().handleGenericMessage(Actor.eGenericMessage.eGenericMessage_DecrementMaterialStock, this.m_fakeActor);
                ++i;
            }
            this.m_owner.Level().MainPlayerBehaviour().handleGenericMessage(Actor.eGenericMessage.eGenericMessage_ResetCollectableNeededCounters, this.m_fakeActor);
        }
    }

    protected void _indicateMaterialNeeded() {
        int amount = 0;
        for (Map.Entry<String, BehaviourParameter<Integer>> matAmount : this.IntParamsDictionary().entrySet()) {
            amount = matAmount.getValue().getValue();
            if (amount <= 0) continue;
            this.m_fakeActor.Material(Actor.MaterialNameEnumDictionnary.get(matAmount.getKey()));
            int i = 0;
            while (i < amount) {
                this.m_owner.Level().MainPlayerBehaviour().handleGenericMessage(Actor.eGenericMessage.eGenericMessage_IncrementMaterialStockNeeded, this.m_fakeActor);
                ++i;
            }
        }
    }

    protected boolean _updateUpgrading() {
        boolean bDone = false;
        switch (this.m_upgradeState) {
            case eUpgradingState_WaitingIdle: {
                if (!this.m_owner.Level().MainPlayerBehaviour().isAnimState(PlayerBehaviour.eAnimState.eAnimState_Idle)) break;
                this._closeDoor();
                this.m_upgradeState = eUpgradingState.eUpgradingState_CloseDoor;
                break;
            }
            case eUpgradingState_CloseDoor: {
                if (!this.m_hatch.finished) break;
                this._hatchCloseInit();
                this.m_sndUpgrading.play();
                this.m_upgradeState = eUpgradingState.eUpgradingState_BlinkStep1;
                break;
            }
            case eUpgradingState_BlinkStep1: {
                this.m_upgradeElapsed += FlxG.elapsed;
                if (!(this.m_upgradeElapsed > 0.5f)) break;
                this.m_upgradeElapsed = 0.0f;
                ++this.m_upgradeCounter;
                if (this.m_upgradeCounter < LightAnimLength / this.m_lightActors.length) {
                    int i = 0;
                    while (i < this.m_lightActors.length) {
                        if (LightAnim[this.m_upgradeCounter][i]) {
                            this.m_lightActors[i].play("li_sq_on");
                        } else {
                            this.m_lightActors[i].play("li_sq_off");
                        }
                        ++i;
                    }
                    break;
                }
                this.m_sndUpgrading.stop();
                this.m_upgradeState = eUpgradingState.eUpgradingState_PutOnTop;
                break;
            }
            case eUpgradingState_PutOnTop: {
                this.m_bflashing = true;
                FlxG.flash.start(Color.White(), 0.8f, this.m_onFlashEnd, true);
                this._makeUpgrade();
                this.m_owner.Level().MainPlayer().y = this.m_inivibleCollisions[0].y - this.m_owner.Level().MainPlayer().height;
                this.m_upgradeState = eUpgradingState.eUpgradingState_Done;
                bDone = true;
                this._validateAchievements();
            }
        }
        return bDone;
    }

    protected void _validateAchievements() {
        if (GameVars.GameMode() == GameMode.GameMode_Main) {
            if (this.m_bUnlockLine) {
                AchievementManager.Instance().unlockAchievementDeferred("ACH_TETROBOT_1_0");
            } else if (!this.m_bUnlockPuzzle && this.m_matUpgradeOrUnknown != Actor.eActorMaterial.eActorMaterial_Unknown) {
                if (this.m_matUpgradeOrUnknown.ordinal() >= Actor.eActorMaterial.eActorMaterial_Jade.ordinal()) {
                    AchievementManager.Instance().unlockAchievementDeferred("ACH_TETROBOT_1_2");
                } else if (this.m_matUpgradeOrUnknown.ordinal() >= Actor.eActorMaterial.eActorMaterial_Iron.ordinal()) {
                    AchievementManager.Instance().unlockAchievementDeferred("ACH_TETROBOT_1_1");
                }
            }
        }
    }

    protected void _onFlashEnd(Object sender, Object e) {
        this.m_bflashing = false;
    }

    protected void _makeUpgrade() {
        if (!this.m_bUpdgradeDone) {
            if (this.m_bUnlockLine) {
                GameVars.PlayerCanDoLines(1);
            }
            if (this.m_bUnlockPuzzle) {
                GameVars.PlayerCanDoPuzzle(1);
            }
            if (this.m_matUpgradeOrUnknown != Actor.eActorMaterial.eActorMaterial_Unknown && GameVars.MaxDrillableMatId() < this.m_matUpgradeOrUnknown.ordinal()) {
                GameVars.MaxDrillableMatId(this.m_matUpgradeOrUnknown.ordinal());
            }
            this.m_owner.Level().MainPlayerBehaviour().handleGenericMessage(Actor.eGenericMessage.eGenericMessage_UpdateUpgrade, this.m_owner);
            this.m_bUpdgradeDone = true;
            this.m_sndUpgraded.play();
            this._consumePlayerMaterial();
        }
    }

    protected void _closeDoor() {
        this.m_sndClose.play();
        this.m_hatch.play("close", true);
    }

    protected void _goTo(eWorkshopState _state) {
        switch (_state) {
            case eWorkshopState_ShowItSelf: {
                this._hatchCloseInit();
                break;
            }
            case eWorkshopState_Closed: {
                this._hatchCloseInit();
                break;
            }
            case eWorkshopState_Closing: {
                this._closeDoor();
                break;
            }
            case eWorkshopState_Opened: {
                int i = 0;
                while (i < this.m_inivibleCollisions.length) {
                    this.m_inivibleCollisions[i].addFlag(Actor.eSpecialFlag.eSpecialFlag_NoCollidePhysic);
                    ++i;
                }
                break;
            }
            case eWorkshopState_Opening: {
                if (this.m_bNeedShowOpeningOnCam) {
                    this.m_bNeedShowOpeningOnCam = false;
                    this._goTo(eWorkshopState.eWorkshopState_AttractingCam);
                    return;
                }
                this.m_sndOpen.play();
                this.m_hatch.play("open", true);
                break;
            }
            case eWorkshopState_AttractingCam: {
                this.m_owner.Level().MainPlayer().handleGenericMessage(Actor.eGenericMessage.eGenericMessage_RequestLookAtWithCallback, this.m_owner);
                break;
            }
            case eWorkshopState_Upgrading: {
                this.m_owner.Level().MainPlayerBehaviour().handleGenericMessage(Actor.eGenericMessage.eGenericMessage_DialogControlPlayerBegin, this.m_owner);
                break;
            }
            case eWorkshopState_UpgradingDone: {
                this.m_plusSign.play("li_plus_off");
                this.m_owner.Level().MainPlayerBehaviour().handleGenericMessage(Actor.eGenericMessage.eGenericMessage_DialogControlPlayerEnd, this.m_owner);
                break;
            }
        }
        this.m_state = _state;
    }

    protected void _hatchCloseInit() {
        int i = 0;
        while (i < this.m_inivibleCollisions.length) {
            this.m_inivibleCollisions[i].removeFlag(Actor.eSpecialFlag.eSpecialFlag_NoCollidePhysic);
            ++i;
        }
        this.m_hatch.play("closed");
    }

    protected boolean _canOpen() {
        boolean bRes = true;
        int amount = 0;
        PlayerBehaviour playerBehaviour = this.m_owner.Level().MainPlayerBehaviour();
        for (Map.Entry<String, BehaviourParameter<Integer>> matAmount : this.IntParamsDictionary().entrySet()) {
            Actor.eActorMaterial material;
            amount = matAmount.getValue().getValue();
            if (amount <= 0 || playerBehaviour.getCollectableAmount(material = Actor.MaterialNameEnumDictionnary.get(matAmount.getKey())) >= amount) continue;
            bRes = false;
        }
        return bRes;
    }

    @Override
    public void checkCollisions() {
    }

    @Override
    public void onOverlapsCallback(FlxSpriteCollisionEvent _event, int _callbackId) {
    }

    @Override
    public void handleGenericMessage(Actor.eGenericMessage _message, Actor _sender) {
        switch (_message) {
            case eGenericMessage_LookAtCallback: {
                this.m_bHaveCamFocus = true;
            }
        }
    }

    public static enum eLighAnim {
        eLighAnim_None,
        eLighAnim_Sequence,
        eLighAnim_SequenceReverse,
        eLighAnim_AllBlink;

    }

    public static enum eUpgradingState {
        eUpgradingState_WaitingIdle,
        eUpgradingState_CloseDoor,
        eUpgradingState_BlinkStep1,
        eUpgradingState_PutOnTop,
        eUpgradingState_Done;

    }

    public static enum eWorkshopState {
        eWorkshopState_ShowItSelf,
        eWorkshopState_Closed,
        eWorkshopState_Opened,
        eWorkshopState_Closing,
        eWorkshopState_Opening,
        eWorkshopState_AttractingCam,
        eWorkshopState_AttractingCamDone,
        eWorkshopState_Upgrading,
        eWorkshopState_UpgradingDone,
        eWorkshopState_IdleDone;

    }
}

