/*
 * Decompiled with CFR 0.152.
 */
package SSS.Behaviours.BTM;

import SSS.Actor;
import SSS.BTM.GameVars;
import SSS.Behaviour;
import SSS.Level;
import SSS.Managers.BTM.LevelGroup;
import java.util.HashMap;
import org.flixel.FlxSprite;
import org.flixel.event.FlxSpriteCollisionEvent;

public class SpawnpointBehaviour
extends Behaviour {
    protected eSpawnPointType m_spawnType = eSpawnPointType.eSpawnPointType_Undefined;
    protected static HashMap<String, eSpawnPointType> KindEnumMatch = new HashMap<String, eSpawnPointType>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("player", eSpawnPointType.eSpawnPointType_Player);
            this.put("slime_little", eSpawnPointType.eSpawnPointType_Slime);
            this.put("slime_big", eSpawnPointType.eSpawnPointType_SlimeBig);
            this.put("player_exit", eSpawnPointType.eSpawnPointType_Player_Exit);
        }
    };

    public SpawnpointBehaviour(String _id, Actor _owner, Actor.eActorMaterial _material) {
        super(_id, _owner, _material);
    }

    @Override
    protected void initOwnerFlixelProperties() {
    }

    @Override
    public void init() {
        this._determineType();
        this._initDependingType();
        this.onParamsChanged();
    }

    @Override
    public void initEdit() {
        this._determineType();
        this.onParamsChanged();
    }

    protected void _determineType() {
        this.m_spawnType = KindEnumMatch.get(this.getStringParameter("Kind"));
    }

    protected void _initDependingType() {
        switch (this.m_spawnType) {
            case eSpawnPointType_Player: {
                this.m_owner.Level().setPlayerSpawnPoint(this.m_owner);
                if (!this.m_owner.Level().PlayableMode()) break;
                this.m_owner.visible = false;
                if (this.m_owner.Level().Mode() != Level.eLevelMode.eLevelMode_Play) break;
                this.m_owner.visible = false;
                this._addPortal(true);
                this._checkPower();
                break;
            }
            case eSpawnPointType_SlimeBig: {
                if (!this.m_owner.Level().PlayableMode()) break;
                Actor slime = this.m_owner.Level().instanciateActor(this.getStringParameter("ActorSpawned"));
                slime.x = this.m_owner.x;
                slime.y = this.m_owner.y + this.m_owner.height - slime.height;
                this.m_owner.Level().addActorToLayer(this.m_owner.Level().LayerPlayer(), slime);
                slime.createComponents(this.m_owner.Level(), false);
                if (this.getIntParameter("StartSleeping") > 0) {
                    slime.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_PutToSleep, this.m_owner);
                } else {
                    slime.getBehaviour(0).setFloatParameter("WalkSpeed", this.getFloatParameter("WalkSpeed"));
                    slime.notifyBehavioursParameterChanges();
                }
                this.m_owner.visible = false;
                break;
            }
            case eSpawnPointType_Slime: {
                if (!this.m_owner.Level().PlayableMode()) break;
                Actor slime = this.m_owner.Level().instanciateActor(this.getStringParameter("ActorSpawned"));
                slime.x = this.m_owner.x;
                slime.y = this.m_owner.y + this.m_owner.height - slime.height;
                this.m_owner.Level().addActorToLayer(this.m_owner.Level().LayerPlayer(), slime);
                slime.createComponents(this.m_owner.Level(), false);
                int facing = this.getIntParameter("StarMoveToLeft");
                if (facing == 1) {
                    slime.getBehaviour(0).setIntParameter("StarMoveToLeft", facing);
                    slime.notifyBehavioursParameterChanges();
                }
                this.m_owner.visible = false;
                break;
            }
            case eSpawnPointType_Player_Exit: {
                if (!this.m_owner.Level().PlayableMode()) break;
                this.m_owner.visible = false;
                if (this.m_owner.Level().Mode() != Level.eLevelMode.eLevelMode_Play) break;
                this._addPortal(false);
            }
        }
    }

    @Override
    public void onParamsChanged() {
        switch (this.m_spawnType) {
            case eSpawnPointType_Slime: {
                boolean facingRight;
                boolean bl = facingRight = this.getIntParameter("StarMoveToLeft") == 0;
                if (facingRight) {
                    this.m_owner.facing(FlxSprite.Flx2DFacing.Right);
                    break;
                }
                this.m_owner.facing(FlxSprite.Flx2DFacing.Left);
            }
        }
    }

    protected void _checkPower() {
        if (GameVars.GameCommunityMode() || this.m_owner.Level().Group() != null && this.m_owner.Level().Group().Flag() == LevelGroup.eSpecialFlag.FeaturesLevels) {
            int drillPower = this.getIntParameter("DrillPower");
            int puzzleMode = this.getIntParameter("PuzzleMode");
            try {
                int canGoCameraMode = this.getIntParameter("CameraMode");
                GameVars.CanGoCameraMode(canGoCameraMode == 0);
            }
            catch (Exception e) {
                GameVars.CanGoCameraMode(true);
            }
            if (drillPower >= 0) {
                switch (drillPower) {
                    case 0: {
                        GameVars.MaxDrillableMatId(2);
                        break;
                    }
                    case 1: {
                        GameVars.MaxDrillableMatId(-1);
                        break;
                    }
                    case 2: {
                        GameVars.MaxDrillableMatId(Actor.UpdateDrillStep01.ordinal());
                        break;
                    }
                    case 3: {
                        GameVars.MaxDrillableMatId(Actor.UpdateDrillStep02.ordinal());
                        break;
                    }
                    case 4: {
                        GameVars.MaxDrillableMatId(Actor.UpdateDrillStep03.ordinal());
                    }
                }
            }
            if (puzzleMode >= 0) {
                switch (puzzleMode) {
                    case 0: {
                        GameVars.PlayerCanDoPuzzle(1);
                        GameVars.PlayerCanDoLines(1);
                        break;
                    }
                    case 1: {
                        GameVars.PlayerCanDoPuzzle(0);
                        GameVars.PlayerCanDoLines(0);
                        break;
                    }
                    case 2: {
                        GameVars.PlayerCanDoPuzzle(1);
                        GameVars.PlayerCanDoLines(0);
                        break;
                    }
                    case 3: {
                        GameVars.PlayerCanDoPuzzle(1);
                        GameVars.PlayerCanDoLines(1);
                    }
                }
            }
            if (this.m_owner.Level() != null && this.m_owner.Level().MainPlayerBehaviour() != null) {
                this.m_owner.Level().MainPlayerBehaviour().reinitPlayerPower();
            }
        } else {
            GameVars.CanGoCameraMode(true);
        }
    }

    protected void _addPortal(boolean _bEntrancePortal) {
        Actor portal = this.m_owner.Level().instanciateActor("portal");
        portal.x = this.m_owner.x + this.m_owner.width * 0.5f - portal.width * 0.5f;
        portal.y = this.m_owner.y + this.m_owner.height * 0.5f - portal.height * 0.5f;
        Behaviour behaviour = portal.getBehaviour("portal");
        behaviour.setIntParameter("EntrancePortal", _bEntrancePortal ? 1 : 0);
        if (_bEntrancePortal) {
            boolean visible;
            boolean bl = visible = this.getIntParameter("PortalVisible") > 0;
            if (!visible) {
                behaviour.setStringParameter("SpecialFlag", "invisibleEntrance");
            }
        } else {
            String specialFlag = this.getStringParameter("ExitPortalFlag");
            if (specialFlag.length() > 0) {
                behaviour.setStringParameter("SpecialFlag", specialFlag);
            }
            if (GameVars.GameCommunityMode()) {
                int par = this.getIntParameter("Par");
                behaviour.setIntParameter("Par", par);
                String nextLevel = this.getStringParameter("NextLevel");
                if (nextLevel != null && nextLevel.length() > 0) {
                    behaviour.setStringParameter("NextLevel", nextLevel);
                }
            }
        }
        portal.createComponents(this.m_owner.Level(), false);
        this.m_owner.Level().LayerPortal().add(portal);
    }

    @Override
    public void deinit() {
    }

    @Override
    public void update() {
    }

    @Override
    public void checkCollisions() {
    }

    @Override
    public void onOverlapsCallback(FlxSpriteCollisionEvent _event, int _callbackId) {
    }

    public static enum eSpawnPointType {
        eSpawnPointType_Undefined,
        eSpawnPointType_Player,
        eSpawnPointType_Player_Exit,
        eSpawnPointType_Slime,
        eSpawnPointType_SlimeBig;

    }
}

