/*
 * Decompiled with CFR 0.152.
 */
package SSS.Behaviours.BTM;

import SSS.Actor;
import SSS.BTM.GameMode;
import SSS.BTM.GameVars;
import SSS.Behaviour;
import SSS.Behaviours.BTM.PlayerBehaviour;
import SSS.Managers.MusicManager;
import org.flixel.FlxG;
import org.flixel.FlxSound;
import org.flixel.event.FlxSpriteCollisionEvent;

public class SpawnsoundBehaviour
extends Behaviour {
    String m_baseTrackSoundIdOrNil = null;
    String m_addTrackSoundIdOrNil = null;
    float m_fadeInTime = 1.0f;
    float m_fadeOutTime = 1.0f;
    boolean m_bNoFadeFirstTime = false;
    PlayerBehaviour m_playerBehaviour;

    public SpawnsoundBehaviour(String _id, Actor _owner, Actor.eActorMaterial _material) {
        super(_id, _owner, _material);
    }

    @Override
    protected void initOwnerFlixelProperties() {
    }

    @Override
    public void init() {
        boolean bl = this.m_owner.visible = !this.m_owner.Level().PlayableMode();
        if (this.m_owner.Level().PlayableMode()) {
            this.m_owner.Level().incrementSoundSpawnerCount();
            this.m_fadeInTime = this.getFloatParameter("FadeInTime");
            this.m_fadeOutTime = this.getFloatParameter("FadeOutTime");
            this.m_bNoFadeFirstTime = this.getIntParameter("NoFadeFirstPlay") > 0;
            boolean bForce = false;
            if (GameVars.GameMode() == GameMode.GameMode_LocalLevelEditor) {
                bForce = true;
            }
            MusicManager.Instance().playTracks(this.getStringParameter("BaseOrNil"), this.getStringParameter("AddOrNil"), this.m_fadeInTime, bForce);
            this.m_playerBehaviour = (PlayerBehaviour)this.m_owner.Level().MainPlayer().getBehaviour("player");
        }
    }

    protected void _unstopableSound(FlxSound _snd, boolean _bUnstopable) {
        if (_snd != null) {
            _snd.Unstopable(_bUnstopable);
        }
    }

    protected void _playSound(FlxSound _snd) {
        if (_snd != null) {
            _snd.play();
        }
    }

    protected void _setSoundVolume(FlxSound _snd, float _volume) {
        if (_snd != null) {
            _snd.volume(_volume);
        }
    }

    protected void _fade(boolean _fadeIn, FlxSound _snd) {
        if (_snd != null) {
            if (_fadeIn && !_snd.IsFadingIn()) {
                _snd.volume(1.0f);
                _snd.fadeIn(this.m_fadeInTime);
            } else if (!_snd.IsFadingOut()) {
                _snd.volume(1.0f);
                _snd.fadeOut(this.m_fadeOutTime);
            }
        }
    }

    protected FlxSound _initSound(String _id, float _volume) {
        FlxSound snd = null;
        if (_id.length() > 0) {
            snd = FlxG.play(_id, _volume, true, true);
        }
        return snd;
    }

    @Override
    public void deinit() {
    }

    @Override
    public void update() {
        if (this.m_owner.Level().PlayableMode()) {
            if (this.m_playerBehaviour.isModeNew(PlayerBehaviour.ePlayerMode.ePlayerMode_Bloc)) {
                MusicManager.Instance().fade(MusicManager.eTrack.TrackAdditionnal, MusicManager.eFade.FadeOut, this.m_fadeOutTime);
            } else if (this.m_playerBehaviour.isModeNew(PlayerBehaviour.ePlayerMode.ePlayerMode_Camera)) {
                if (this.m_playerBehaviour.PlayModeOld() == PlayerBehaviour.ePlayerMode.ePlayerMode_Bloc) {
                    MusicManager.Instance().fade(MusicManager.eTrack.TrackAdditionnal, MusicManager.eFade.FadeIn, this.m_fadeInTime);
                }
            } else if (this.m_playerBehaviour.isModeNew(PlayerBehaviour.ePlayerMode.ePlayerMode_Move) && this.m_playerBehaviour.PlayModeOld() == PlayerBehaviour.ePlayerMode.ePlayerMode_Bloc) {
                MusicManager.Instance().fade(MusicManager.eTrack.TrackAdditionnal, MusicManager.eFade.FadeIn, this.m_fadeInTime);
            }
        }
    }

    @Override
    public void checkCollisions() {
    }

    @Override
    public void onOverlapsCallback(FlxSpriteCollisionEvent _event, int _callbackId) {
    }
}

