/*
 * Decompiled with CFR 0.152.
 */
package SSS.Behaviours.BTM;

import Microsoft.Xna.Framework.Color;
import SSS.Actor;
import SSS.Behaviour;
import SSS.BehaviourParameter;
import SSS.Behaviours.BTM.PlayerBehaviour;
import java.util.Map;
import org.flixel.FlxG;
import org.flixel.event.FlxSpriteCollisionEvent;

public class ThresholdBehaviour
extends Behaviour {
    boolean m_bOverlapWithPlayerOld = false;
    boolean m_bOverlapWithPlayer = false;

    public ThresholdBehaviour(String _id, Actor _owner, Actor.eActorMaterial _material) {
        super(_id, _owner, _material);
        this.m_owner.alpha(0.5f);
    }

    @Override
    protected void initOwnerFlixelProperties() {
        this.m_owner.fixed = true;
        this.m_owner.moves = false;
    }

    @Override
    public void init() {
    }

    @Override
    public void deinit() {
    }

    @Override
    public void update() {
        if (this.m_owner.Level().PlayableMode()) {
            this.m_bOverlapWithPlayer = this.m_owner.Level().MainPlayer().overlaps(this.m_owner);
            if (!this.m_bOverlapWithPlayerOld && this.m_bOverlapWithPlayer) {
                PlayerBehaviour playerBehaviour = (PlayerBehaviour)this.m_owner.Level().MainPlayer().getBehaviour("player");
                boolean bFlash = false;
                for (Map.Entry<String, BehaviourParameter<Integer>> matAmount : this.IntParamsDictionary().entrySet()) {
                    int amount = matAmount.getValue().getValue();
                    Actor.eActorMaterial material = Actor.MaterialNameEnumDictionnary.get(matAmount.getKey());
                    if (!Actor.IsInCollectableRangeHACK(material) || playerBehaviour.getCollectableAmount(material) <= amount) continue;
                    playerBehaviour.tresholdCollectableAmount(material, amount);
                    bFlash = true;
                }
                if (bFlash) {
                    FlxG.flash.start(Color.White());
                }
            }
            this.m_bOverlapWithPlayerOld = this.m_bOverlapWithPlayer;
        }
    }

    @Override
    public void checkCollisions() {
    }

    @Override
    public void onOverlapsCallback(FlxSpriteCollisionEvent _event, int _callbackId) {
    }
}

