/*
 * Decompiled with CFR 0.152.
 */
package SSS.Behaviours.BTM;

import Microsoft.Xna.Framework.Graphics.SpriteBatch;
import SSS.Actor;
import SSS.BTM.GameVars;
import SSS.Behaviour;
import SSS.Behaviours.BTM.PlayerBehaviour;
import SSS.Managers.BTM.DialogManager;
import SSS.Managers.BTM.LevelDataBase;
import SSS.Managers.BTM.LevelInfo;
import org.flixel.FlxSound;
import org.flixel.event.FlxSpriteCollisionEvent;

public class TriggerDialogBehaviour
extends Behaviour {
    protected eFlag m_flag = eFlag.None;
    boolean m_bDeferedTriggering = false;
    eTriggerDialogState m_dialogState = eTriggerDialogState.eTriggerDialogState_NotTriggered;
    String m_dialogId = "";
    FlxSound m_sndValid = null;
    FlxSound m_sndAppear = null;
    FlxSound m_sndDisappear = null;
    boolean m_bCheckTriggerVertically = false;
    boolean m_bCheckTriggerHorizontally = false;
    int m_triggerRange = 0;
    boolean m_bCheckTriggerOnBoxCollision = false;
    float m_lastPlayerX;
    float m_lastPlayerY;

    public TriggerDialogBehaviour(String _id, Actor _owner, Actor.eActorMaterial _material) {
        super(_id, _owner, _material);
    }

    @Override
    protected void initOwnerFlixelProperties() {
        this.m_owner.fixed = true;
        this.m_owner.moves = false;
    }

    @Override
    public void init() {
        if (this.m_owner.Level().PlayableMode()) {
            this.m_owner.alpha(0.0f);
            LevelInfo lvlInfo = LevelDataBase.Instance().getLevelInfo(this.m_owner.Level());
            if (lvlInfo == null || !lvlInfo.Done()) {
                this.m_dialogId = this.getStringParameter("dialogId");
                this.m_bCheckTriggerVertically = this.getIntParameter("triggerV") > 0;
                this.m_bCheckTriggerHorizontally = this.getIntParameter("triggerH") > 0;
                this.m_bCheckTriggerOnBoxCollision = this.getIntParameter("triggerBox") > 0;
                this.m_triggerRange = this.getIntParameter("triggerRange");
                this.m_lastPlayerX = this.m_owner.Level().PlayerSpawnX();
                this.m_lastPlayerY = this.m_owner.Level().PlayerSpawnY();
                this.m_sndAppear = new FlxSound();
                this.m_sndAppear.loadEmbedded(this.getStringParameter("SndIncomming"), false, true, true);
                this.m_sndDisappear = new FlxSound();
                this.m_sndDisappear.loadEmbedded(this.getStringParameter("SndOutgoing"), false, true, true);
                this.m_sndValid = new FlxSound();
                this.m_sndValid.loadEmbedded(this.getStringParameter("SndDisplayText"), false, true, true);
                String flag = this.getStringParameter("Flag");
                if (flag != null && flag.length() > 0 && flag.equals("puzzle_mode")) {
                    this.m_bDeferedTriggering = true;
                    this.m_flag = eFlag.PuzzleModeEnterTrigger;
                }
            } else if (!DialogManager.ForceDisplayDialogs) {
                this._goToTriggered();
            }
        }
    }

    @Override
    public void deinit() {
    }

    @Override
    public void update() {
        switch (this.m_dialogState) {
            case eTriggerDialogState_NotTriggered: {
                float cx = this.m_owner.getCenterX();
                float cy = this.m_owner.getCenterY();
                float px = this.m_owner.Level().MainPlayer().getCenterX();
                float py = this.m_owner.Level().MainPlayer().getCenterY();
                if (this.m_bCheckTriggerVertically && (this.m_lastPlayerY <= cy && cy <= py || py <= cy && cy <= this.m_lastPlayerY)) {
                    this._trigger();
                }
                if (this.m_dialogState != eTriggerDialogState.eTriggerDialogState_Triggering && this.m_bCheckTriggerHorizontally && (this.m_lastPlayerX <= cx && cx <= px || px <= cx && cx <= this.m_lastPlayerX)) {
                    this._trigger();
                }
                if (this.m_dialogState != eTriggerDialogState.eTriggerDialogState_Triggering && this.m_bCheckTriggerOnBoxCollision && this.m_owner.overlaps(this.m_owner.Level().MainPlayer())) {
                    this._trigger();
                }
                this.m_lastPlayerX = px;
                this.m_lastPlayerY = py;
                break;
            }
            case eTriggerDialogState_CheckDeferredTriggering: {
                if (this.m_flag == eFlag.PuzzleModeEnterTrigger) {
                    if (this.m_owner.Level().MainPlayerBehaviour().PlayMode() != PlayerBehaviour.ePlayerMode.ePlayerMode_Bloc) break;
                    this.m_bDeferedTriggering = false;
                    this._trigger();
                    break;
                }
                this._trigger();
            }
        }
    }

    protected void _trigger() {
        if (this.m_dialogState != eTriggerDialogState.eTriggerDialogState_Triggered) {
            if (this.m_triggerRange > 0) {
                float dist = 0.0f;
                if (this.m_bCheckTriggerHorizontally) {
                    dist = (this.m_owner.getBottom() - this.m_owner.Level().MainPlayer().getCenterY()) / (1.0f * (float)GameVars.TileStep());
                } else if (this.m_bCheckTriggerVertically) {
                    dist = (this.m_owner.x - this.m_owner.Level().MainPlayer().x) / (1.0f * (float)GameVars.TileStep());
                }
                if (dist < 0.0f || dist > (float)this.m_triggerRange) {
                    return;
                }
            }
            if (!this.m_bDeferedTriggering) {
                this.m_owner.Level().DialogManager().startDialog(this.m_dialogId, this.m_sndAppear, this.m_sndDisappear, this.m_sndValid);
                this._goToTriggered();
            } else {
                this._goToDefferedTriggering();
            }
        }
    }

    protected void _goToTriggered() {
        this.m_dialogState = eTriggerDialogState.eTriggerDialogState_Triggered;
        this.m_owner.CanUpdateBehaviour(false);
    }

    protected void _goToDefferedTriggering() {
        this.m_dialogState = eTriggerDialogState.eTriggerDialogState_CheckDeferredTriggering;
        this.m_bDeferedTriggering = false;
    }

    @Override
    public void checkCollisions() {
    }

    @Override
    public void onOverlapsCallback(FlxSpriteCollisionEvent _event, int _callbackId) {
    }

    @Override
    public void render(SpriteBatch spriteBatch) {
    }

    protected static enum eFlag {
        None,
        PuzzleModeEnterTrigger;

    }

    public static enum eTriggerDialogState {
        eTriggerDialogState_NotTriggered,
        eTriggerDialogState_CheckDeferredTriggering,
        eTriggerDialogState_Triggering,
        eTriggerDialogState_Triggered;

    }
}

